/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:43 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: gilde.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/
#include "../gilde.h"

#include <properties.h>
#include <defines.h>
#include <moving.h>
#include <wizlevels.h>
#include <homes.h>
#include <uhr.h>

inherit GILDE("std/ab_gilde");

string list();

void create()
{
	::create();

	SetProp(P_INDOORS, 1);
	SetProp(P_LIGHT, 2);
	SetProp(P_INT_SHORT, "Die beruehmte Abenteurergilde");
	SetProp(P_INT_LONG,
		"Du hast soeben die beruehmte Abenteurergilde betreten. Sie dient den"
		" Abenteurern im Wunderland als Raststatt und Treffpunkt, um sich hier zwischen"
		" den Abenteuern auszuruhen und Freunde zu treffen. Man berichtet sich hier von"
		" den Kaempfen und Geschehnissen, die man auf seiner Reise durch das weite Land"
		" erlebte. An den Tischen sitzen haeufig Abenteurer und tauschen ihre Erfahrungen"
		" und ihr Wissen aus. Frueher trafen sich die Helden in dem alten"
		" Wohnwagen, mit dem Elli ins Wunderland gekommen war. Doch vor einiger Zeit"
		" haben die freundlichen Kaeuer aus Dankbarkeit den Abenteurern dieses kleine"
		" Haeuschen zur Verfuegung gestellt. In einer Ecke siehst Du eine grosse Uhr"
		" stehen, und einige Bilder sowie ein kleines rotes Schild zieren die Waende."
		" Nach Norden gelangst Du wieder auf die Hauptstrasse von Kogida, nach Sueden"
		" kommst Du in den Gildenladen.");

	AddDetail(({"raum", "gilde", "abenteurergilde", "haus", "gildenhaus","gildehaus"}),
		"Du stehst mitten in der Abenteurergilde. Hier trifft man sich und kann"
		" auch seine persoenlichen Werte verbessern.");
	AddDetail(({"treffpunkt", "raststatt", "freunde"}),
		"Die Abenteurer treffen sich hier, um sich auszuruhen und Freunde zu"
		" treffen.");
	AddDetail(({"kampf","kaempfe","geschehnisse","reise","reisen","dinge"}),
		"Auch Du wirst viele Kaempfe gegen boese Monster und Ungeheuer bestehen"
		" muessen, wenn Du alle Abenteuer des Wunderlandes bewaeltigen willst. Du"
		" wirst wundersame und unglaubliche Dinge entdecken.");
	AddDetail(({"abenteuer","quest","quests","liste"}),
		"Du kannst Dir eine Liste aller Abenteuer anschauen, indem Du einfach"
		" \"liste\"eingibst.");
	AddDetail(({"werte", "stats", "attribute"}),
		"Deine persoenlichen Werte sind Deine Stufe (Level), Deine Intelligenz,"
		" Deine Geschicklichkeit, Deine Staerke und Deine Ausdauer. Weiterhin kannst"
		" hier bestimmte Zaubersprueche und Faehigkeiten erlernen.");
	AddDetail(({"stufe","stufen","level","zaubersprueche","faehigkeiten","intelligenz",
		"geschicklichkeit","staerke","ausdauer"}),
		"Lies doch das Schild an der Wand. Da kannst Du alles erfahren.");
	AddDetail(({"tisch","tische","eichentische","eichentisch"}),
		"Ein paar gemuetliche Eichentische wurden hier aufgestellt.");
	AddDetail(({"tuer", "ausgang", "norden"}),
		"Der immer offenstehende Ausgang fuehrt hinaus auf die Hauptstrasse von"
		" Kogida. Waermendes Sonnenlicht dringt von draussen herein.",
		"Der immer offenstehende Ausgang fuehrt hinaus auf die Hauptstrasse von"
		" Kogida. Draussen ist es dunkel, nur einige Laternen erhellen die Nacht.");
	AddDetail(({"hauptstrasse","strasse","kogida","dorf"}),
		"Die Hauptstrasse von Kogida liegt im Norden. Schau Dir doch mal alles an.");
	AddDetail(({"kaeuer"}),
		"Die Kaeuer sind die Bewohner des blauen Landes. In Kogida wirst Du bestimmt"
		" welche finden.");
	AddDetail(({"bild", "bilder"}),
		"Jedes der Bilder berichtet von einem anderen wundersamen Abenteuer. Auf"
		" einem Bild siehst Du einen Mann aus Eisen, auf einem anderen ein zottiges,"
		" sechsfuessiges Ungetuem. Du erblickst eine wunderschoene Stadt, die im"
		" Glanz ihrer Smaragde erstrahlt. Inmitten der Bilder haengt eine rotes Schild.");
	AddDetail(({"tier","tiere","pflanze","pflanzen"}),
		"Du wirst Tiere und Pflanzen im Wunderland finden, wie Du sie noch nie"
		" gesehen hast. Doch sei vorsichtig, nicht alle sind Dir gut gesinnt...");
	AddDetail(({"funktion", "schild","rotes schild"}),
		"Du kannst es lesen.");
	AddDetail(({"wand", "waende"}),
		"Aus fein saeuberlich geschlagenen Steinen sind die Waende der Gilde"
		" zusammengesetzt. Viele interessante Bilder haengen daran. Durch ein Fenster"
		" kann man hinaus schauen.");
	AddDetail(({"stein","steine","sandstein","sandsteine"}),
		" Es sind sauber geschlagene Sandsteine.");
	AddDetail(({"fenster"}),
		"Die Sonne scheint und taucht das wundervolle Land in einen zarten goldenen"
		" Schimmer. Draussen siehst Du wunderbare Tiere und Pflanzen. Einige Kaeuer"
		" arbeiten auf den Feldern. Alles kommt Dir vor, wie in einem wunderbaren"
		" Traum. Vielleicht solltest Du mal hinausgehen... ",
		"Draussen ist es dunkel. Nur einige Laternen und der Mond lassen das Land in"
		" in einem seltsamen Licht erscheinen. Alles wirkt geheimnisvoll und Du"
		" spuerst den Drang in Dir aufsteigen hinauszugehen und das Land weiter zu"
		" erforschen...");
	AddDetail(({"feld","felder"}),
		"Die Kaeuer arbeiten fleissig auf ihren Feldern.",
		"Die Nacht ist hereingebrochen. Die Felder liegen verlassen da.");
	AddDetail(({"traum","traeume","welt"}),
		"Eine phantastische wunderbare Welt. Traumhaft...");
	AddDetail(({"decke"}),
		"Die Decke des Raumes wird von Holzbalken gehalten. In der Mitte haengt ein"
		" grosser Deckenleuchter.");
	AddDetail(({"deckenleuchter","leuchter","wagenrad","rad","lampe"}),
		"Der grosse Deckenleuchter wurde aus einem alten Wagenrad gefertigt, dass mit"
		" Ketten an der Decke befestigt ist. Auf seinem wachsverklebten Rand siehst Du"
		" jede Menge Kerzen.");
	AddDetail(({"kerzen","wachs","rand","wachskerzen","tropfen"}),
		"Die Kerzen sind aus Wachs und haben mit der Zeit den ganzen Rand des Rades"
		" vollgetropft. Die Kerzen sind aber im Moment aus, da genug Licht von draussen"
		" hereindringt.",
		"Die Kerzen sind aus Wachs und haben mit der Zeit den ganzen Rand des Rades"
		" vollgetropft. Die Kerzen verbreiten im Raum ein angenehmes gemuetliches"
		" Licht.");
	AddDetail(({"balken", "holzbalken", "deckenbalken"}),
		"Diese Balken halten das Obergeschoss des Gildenhauses, wohin nur Magier"
		" kommen und sind an manchen Stellen ganz schoen durchgebogen. Das grob"
		" geschnittene Holz ist teilweise von Schwertstreichen zernarbt.");
	AddDetail(({"boden", "fussboden", "dielen"}),
		"Die knarrenden Dielen der Gilde sind schon alt und abgeschabt. In den"
		" Ritzen zwischen ihnen ist viel Dreck von den Stiefeln der Abenteurer.");
	AddDetail(({"licht"}),
		"Warmes Sonnenlicht scheint durch den Ausgang zur Strasse herein und taucht"
		" ueberall alles in einen wunderbaren goldenen Schimmer.",
		"Der Mond und einige Laternen erhellen draussen ein wenig die Nacht. In der"
		" Gilde spendet der Deckenleuchter angenehm gemuetliches Licht.");
	AddDetail(({"laternen"}),
		"Von hier aus kannst Du sie nicht genau erkennen.");
	AddDetail(({"sonne","sonnenlicht"}),
		"Die hereinscheinende Sonne waermt Dich. Du fuehlst Dich geborgen.",
		"Es ist gerade Nacht. Du kannst die Sonne nicht sehen.");
	AddDetail(({"mond","mondlicht"}),
		"Es ist hellichter Tag. Der Mond ist nicht zu sehen.",
		"Draussen laesst das Licht des Mondes und alles geheimnisvoll und unwirklich"
		" erscheinen.");
	AddDetail(({"schimmer"}),
		"Ein faszinierender heller goldener Schimmer, wie Du ihn noch nie gesehen hast.",
		"Was meinst Du? Es ist draussen dunkle Nacht.");
	AddDetail(({"himmel"}),
		"Durch das Fenster siehst Du den freundlichen blauen Himmel.",
		"Draussen ist es dunkel. Du kannst den Himmel nicht sehen.");
	AddDetail(({"geschoss", "obergeschoss"}),
		"Ins obere Geschoss der Gilde kommen nur Magier, mittels eines besonderen"
		" Zauberspruchs, der die Decke durchlaessig fuer sie macht.");
	AddDetail(({"ritzen", "fugen"}),
		"In den Fugen zwischen den Dielen befindet sich eine Menge Schmutz und"
		" Dreck von den Besuchern der Gilde.");
	AddDetail(({"dreck", "schmutz"}),
		"Hast Du noch nie welchen gesehen?");
	AddDetail(({"holz"}),
		"Die Dielen und die Deckenbalken sind aus Holz.");
	AddDetail(({"stellen", "ecken", "stelle", "ecke"}),
		"Nichts sieht aus wie das andere, und die Ecken sind da keine Ausnahmen.");
	AddDetail(({"wissenschaften", "eigenschaften"}),
		"Das steht an dem roten Schild an der Wand.");
	AddDetail(({"narben","narbe","schwertstreich","schwertstreiche"}),
		"Die Narben in den Holzbalken sind schon recht alt. Es ist lange her, dass"
		" hier richtig gekaempft wurde.");
	AddDetail(({"abenteurer", "entdecker","helden"}),
		"Die Abenteurer sind die mutigen Entdecker des Wunderlandes. Schon lange vor"
		" den anderen Gilden haben sie das Land erforscht, gegen boese Monster"
		" gekaempft und Abenteuer bestanden.");
	AddDetail(({"wunderland","land"}),
		"Du stehst mittendrin im Wunderland. Schau Dich doch mal um.");
	AddDetail(({"hurrikap","erschaffer"}),
		"Hurrikap hat das Wunderland erschaffen.");
	AddDetail(({"elli","totoschka","huendchen"}),
		"Elli ist vor vielen Jahren mit ihrem Huendchen Totoschka ins Wunderland"
		" gekommen.");
	AddDetail(({"mann aus eisen","eisenmann","holzfaeller","eiserner holzfaeller"}),
		"Der sieht aus, wie ein Eiserner Holzfaeller...");
	AddDetail(({"smaragdenstadt","smaragde","glanz"}),
		"Die sagenhafte Smaragdenstadt.");
	AddDetail(({"magier","erzmagier","probleme","fragen"}),
		"Die Magier herrschen im Wunderland. Doch sie sind meistens sehr beschaeftigt"
		" und haben keine Zeit. Wenn Du jedoch Fragen und Probleme hast und auch"
		" die anderen Spieler nicht mehr weiterhelfen koennen, dann wende Dich ruhig"
		" an sie. Du kannst selbst Magier werden, wenn Du alle Abenteuer bestanden"
		" hast und Seher geworden bist.");
	AddDetail(({"spieler","spiel"}),
		"Denke immer daran, wenn Du Dich mal aergerst: DAS IST NUR EIN SPIEL!");
	AddDetail(({"seher"}),
		"Seher werden nur die besten und ausdauernsten Spieler. Du kannst Dir die"
		" Stufen anschauen mit \"hilfe abenteurer_stufen\".");
	AddDetail(({"zauberspruch","zaubersprueche"}),
		"Die Liste der erlernbaren Zaubersprueche kannst Du Dir mit:"
		" \"liste zaubersprueche\" ansehen.");
	AddDetail(({"gilden"}),
		"Es gibt im Wunderland verschiedene Gilden. Du kannst einer Gilde Deiner"
		" Wahl beitreten und dann deren besonderen Faehigkeiten und Zaubersprueche"
		" nutzen. Ein Liste aller angeschlossenen Gilden kannst Du Dir mit:"
		" \"liste gilden\" anschauen.");
	AddDetail(({"besucher","gruppe"}),
		"Viele waren schon vor Dir hier. Von Manchen hat man nie mehr was gehoert,"
		" von Anderen wird man noch in vielen Jahrhunderten sprechen. Zu welcher"
		" Gruppe willst Du gehoeren???");
	AddDetail(({"jahrhunderte"}),
		"Abenteurer kommen und gehen - das Wunderland bleibt...");
	AddDetail(({"monster","ungeheuer","ungetuem"}),
		"Davon gibt es sehr viele im Wunderland.");
	AddDetail(({"wahl"}),
		"Was meinst Du? Wenn Du waehlen willst untersuche die Wahlurne.");
	AddDetail(({"dankbarkeit","dank","verfuegung","gute taten","taten"}),
		"Frueher haben sich die Abenteurer immer im alten Wohnwagen von Elli"
		" getroffen, doch vor einiger Zeit haben die braven Kaeuer den Abenteurern"
		" dieses Haeuschen aus Dankbarkeit fuer die vielen guten Taten geschenkt.");
	AddDetail(({"nix","nichts"}),
		"Jo, von nix kommt nix... :)");
	AddDetail(({"laden", "shop", "gildenshop", "gildenladen"}),
		"Geh doch einfach nach Sueden, dann stehst du schon mittendrin.");
	AddDetail(({"sueden"}),
		"Da gehts in den Gildenladen.");

/*	AddExit("norden", HAUPTSTRASSE, 0, 
              ({"Du verlaesst die Gilde und trittst auf die Hauptstrasse.",
		"verlaesst die Gilde", "kommt aus der Gilde"}));
*/	AddExit("sueden", GROOM("shop_kogida"), 0, ({"Du betrittst den Gildenladen.",
 		"&Name betritt den Gildenladen.",
		"&Name kommt in den Laden."}));

	AddItem(WAHLURNE, REFRESH_REMOVE);
//	AddItem(GNPC("varilon"), REFRESH_DESTRUCT);

	AddCmd(({"treff", "oben"}), "GotoMagierTreff");
	AddCmd("zuende|entzuende&kerze|kerzen", "anzuenden", "WAS moechtest Du anzuenden?");
	AddCmd("loesche&kerze|kerzen", "loeschen", "WAS moechtest Du loeschen?");
}

string list()
{
	this_player()->GiveEP();

	return ::list();
}

int GotoMagierTreff()
{
	object player;

	player = this_player();

	if(IS_WIZARD(player))
	{
		tell_object(player, BS("Ein Zauberspruch zieht vor Deinem geistigen Auge vorbei und Du "
			"sprichst ihn nach.", BS_STDLEN));
		tell_room(this_object(), BS(capitalize(player->name(WER)) + " murmelt einen geheimen"
			" Zauberspruch und schwebt langsam zur Decke hinauf und verschwindet durch"
			" die Wand.", BS_STDLEN), ({player}));

		tell_object(player, BS("Du schwebst langsam zur Decke hinauf und als ob diese nicht da "
			"waere mitten hindurch in den Magiertreff.", BS_STDLEN));

		return (player->move(TREFFROOM, M_TPORT | M_SILENT ) >= 0);
	}

	tell_object(player, BS("Du springst zur Decke hinauf und nix passiert.", BS_STDLEN));

	return 1;
}

int anzuenden(string str)
{
	if(!UHR->IsNight())
	{
		tell_object(this_player(), BS("Du bist viel zu klein. Du kommst nicht bis"
			" an den Deckenleuchter heran. Du gibst enttaeuscht auf.", BS_STDLEN));
	}
	else tell_object(this_player(), BS("Die Kerzen sind doch schon an!", BS_STDLEN));

	return 1;
}

int loeschen(string str)
{
	if(!UHR->IsNight())
	{
		tell_object(this_player(), BS("Du bist viel zu klein. Du kommst nicht bis"
			" an den Deckenleuchter heran. Du gibst enttaeuscht auf.", BS_STDLEN));
	}
	else tell_object(this_player(), BS("Die Kerzen sind doch schon aus!", BS_STDLEN));

	return 1;
}

/***********************************************/
/* Ueberschriebene Funktionen aus /std/guild.c */
/*                                             */
/* Damit Varilon auf Stufenerhoehung und sowas */
/* reagieren kann, und man Spells/Skills nur   */
/* lernen kann, wenn Varilon anwesend ist.     */
/*                                             */
/* Elric@Wunderland (28.07.1998)               */
/***********************************************/

int join()
{
	string GildeVorher, GildeDanach;
	object Chef;
	
	GildeVorher = this_player()->QueryProp(P_GUILD);
	
	::join();
	
	GildeDanach = this_player()->QueryProp(P_GUILD);
	
	if ((GildeVorher != GildeDanach) && (GildeDanach == GILDENNAME))
	{
		if (Chef = present("\nvarilon"))
			Chef->catch_msg(({"soul", this_player(), Chef, "this_guild_join", ""}));
	}
	
	return 1;
}

int leave(string argument)
{
	string GildeVorher, GildeDanach;
	int    RetWert;
	object Chef;
	
	GildeVorher = this_player()->QueryProp(P_GUILD);
	
	RetWert = ::leave(argument);
	
	GildeDanach = this_player()->QueryProp(P_GUILD);
	
	if ((GildeVorher != GildeDanach) && (GildeDanach == "/std/guild"))
	{
		if (Chef = present("\nvarilon"))
			Chef->catch_msg(({"soul", this_player(), Chef, "this_guild_leave", ""}));
	}
	
	return RetWert;
}

int _advance_(string arg)
{
	int StufeVorher, StufeDanach, RetWert;
	object Chef;
	
	StufeVorher = this_player()->QueryProp(P_LEVEL);
	
	RetWert = ::_advance_(arg);
	
	StufeDanach = this_player()->QueryProp(P_LEVEL);
	
	if (StufeVorher < StufeDanach)
	{
		if (Chef = present("\nvarilon"))
			Chef->catch_msg(({"soul", this_player(), Chef, "this_guild_raise_level", ""}));
	}
	
	return RetWert;
}

int learn(string arg)
{
	notify_fail("Varilon ist leider grade nicht da. Momentan kannst Du deshalb nichts lernen.\n");

	if (!present("\nvarilon")) return 0;

	return ::learn(arg);
}
