/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:43 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: gilde_zwerge.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/
#include "../gilde.h"

inherit GILDE("std/ab_gilde");

#include <properties.h>
#include <wizlevels.h>
#include <defines.h>
#include <moving.h>

#define AUSGANG "/d/berge/indiana/zwerge/room/z24"

private static object *books;
create()
{
	::create();

	SetProp(P_LIGHT,1);
	SetProp(P_INDOORS,1);
	SetProp(P_INT_SHORT, "Die Abenteurergilde der Zwergenstadt");
	SetProp(P_INT_LONG,
		"Du bist in der Gilde der Abenteurer/innen "
		"angekommen. Hier starten die Laufbahnen der jungen "
		"Helden/Heldinnen, bevor sie in einer anderen Gilde in die Lehre "
		"gehen. Ein an die Wand geschlagenes Schild klaert Dich ueber die "
		"Moeglichkeiten, die Du hier hast, auf. Auf dem Boden aufgestellt "
		"sind eine Wahlurne und ein Buchautomat, der besonders "
		"Anfaengern/innen ans Herz gelegt wird.");

	AddDetail(({"boden"}),
		"Der Boden ist blitzsauber und aus massivem "
		"Stein. Eine Wahlurne und ein Buchautomat stehen auf dem Boden.");
	AddDetail(({"wand","waende"}),
		"An der Wand haengt ein Schild. Du solltest es einfach mal lesen.");
	AddDetail(({"decke"}),
		"Hartes und kaltes Gestein stellt die Decke dieses Raumes.");
	AddDetail(({"gilde","raum","kammer","abenteurergilde"}),
		QueryProp(P_INT_LONG));
	AddDetail(({"laufbahn","laufbahnen"}),
		"Es ist ein langer Weg, bis man hier Seher/in wird.");
	AddDetail(({"abenteurer","abenteurerin","abenteurerinnen"}),
		"Abenteurer/innen ziehen im Wunderland und in der Aussenwelt umher "
		"und erkunden neue Gegenden.");
	AddDetail(({"held","helden","heldin","heldinnen"}),
		"So etwas moechtest Du mal werden, aber es ist ein langer Weg dahin.");
	AddDetail(({"buchautomat","automat"}),
		"Nimm Dir doch einfach ein Buch.");
	AddDetail(({"seher","seherin"}),
		"Nur maechtige Abenteurer/innen koennen Seher/in werden.");
	AddDetail(({"wunderland","aussenwelt","kontinent","kontinente"}),
		"Das Wunderland ist im Inneren des Kontinents, die Aussenwelt - na "
		"wo wohl - drumherum.");
	AddDetail(({"spender","fackelspender"}),
		"Dieser Fackelspender ist halbintelligent und spendet daher "
		"nur eine Fackel zur Zeit. Auch spendet er nur Fackeln an "
		"Spieler, die noch nicht den Level 6 erreicht haben. Wenn Du "
		"eine Fackel haben willst, dann tippe \"will fackel\".");
	AddDetail(({"funktion", "schild","rotes schild"}),
		"Du kannst es lesen.\n");

//	AddExit("nordosten", AUSGANG);

	books = ({});

	AddItem("/obj/anfaengerbuch", REFRESH_NONE);
	AddItem("/obj/fackelautomat", REFRESH_REMOVE);
	AddItem(WAHLURNE, REFRESH_REMOVE);
}

void reset()
{
	::reset();

	books = ({});
}

void newbook()
{
	int i;
	mixed* x;

	if (present("/nhintbook"), ME) return;

	tell_room(ME, "Ein Anfaengerhandbuch erscheint auf magische Weise.\n");

	x = QueryProp(P_ITEMS);

	for (i = sizeof(x); i--;)
		if (x[i][RITEM_FILE] == "/obj/anfaengerbuch") x[i] = 0;

	x -= ({0});

	SetProp(P_ITEMS, x);

	AddItem("/obj/anfaengerbuch", REFRESH_NONE);
}

void NotifyHintbookGone()
{
	while (remove_call_out("newbook") != -1);

	call_out("newbook", 1);
}

int GetHintbook(object pl)
{
	if (member(books, pl) != -1) return -1;

	books += ({pl});
}
