/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:43 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: keller_kogida.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/
#include "../gilde.h"

#include <wizlevels.h>
#include <properties.h>
#include <moving.h>

inherit "std/room";

string missing_detail();

private static mapping players = ([]);
private static string* text    = ({"Detail 'gegenteil' not found.\n",
					"Trying similar words...\n",
					"No match.\n",
					"Connecting to global database...\n",
					"Connected. Logging in...\n",
					"Logged on to global database.\n",
					"Requesting detail 'gegenteil'...\n",
					"Searching...\n",
					"Searching...\n",
					"Searching...\n",
					"No match.\n",
					"Sowas kannst Du hier nicht finden.\n"});

void create()
{
	::create();

	SetProp(P_INT_SHORT, "Im Keller der Abenteurergilde");
	SetProp(P_INT_LONG, "Du befindest Dich hier im Keller der Gilde der Abenteurer."
		" Eigentlich hattest Du ja eher verstaubte Regale und angemoderte Kisten"
		" erwartet aber Du findest hier nichts dergleichen. Im Gegenteil. Der"
		" Raum blinkt vor Sauberkeit und scheint eher eine Art Trainingsraum"
		" als eine Abstellkammer zu sein. Und dann waere da noch so ein seltsamer Apparat.");
	SetProp(P_INDOORS, 1);
	SetProp(P_LIGHT, 1);
	SetProp(P_TRAINING, 1);
	SetProp(P_NO_TPORT, NO_TPORT);
	SetProp(P_TELEPORT_FORBIDDEN, 1);

	AddDetail(({"raum"}),
		"Naja, Boden, Decke und 4 Waende. Sonst noch Fragen?");
	AddDetail(({"boden", "fussboden", "steinfussboden"}),
		"Dieser Raum hat einen recht praktischen Steinfussboden.");
	AddDetail(({"stein"}),
		"Der Boden und die Waende sind aus Stein.");
	AddDetail(({"treppe"}),
		"Eine Treppe fuehrt nach oben.");
	AddDetail(({"stufe", "stufen", "treppenstufe", "treppenstufen"}),
		"Natuerlich hat die Treppe auch Treppenstufen.");
	AddDetail(({"decke"}),
		"Die Decke ist mit Holzvertaefelung abgedeckt.");
	AddDetail(({"holz", "vertaefelung", "holzvertaefelung"}),
		"Eine Holzvertaefelung bildet hier die Decke.");
	AddDetail(({"wand", "waende"}),
		"Feste, schmucklose Steinwaende umgeben den Raum.");
	AddDetail(({"fragen", "frage"}),
		"Bei Fragen ueber Risiken und Nebenwirkungen lesen Sie die"
		" Packungsbeilage oder fragen ihren Arzt oder Apotheker.");
	AddDetail(({"risiken", "risiko", "wirkung", "wirkungen", "nebenwirkung",
		"nebenwirkungen", "packung", "beilage", "packungsbeilage", "arzt", "aphoteker"}),
		"Also wirklich...");
	AddDetail(({"gilde", "abgilde", "abg", "abenteurergilde"}),
		"Dieser Raum befindet sich unter der eigentlichen Gilde.");
	AddDetail(({"keller", "kellerraum"}),
		"Klar ist das ein Kellerraum. Schliesslich befindest Du Dich hier"
		" unter der Erde.");
	AddDetail(({"erde"}),
		"Also Erde wirst Du wohl draussen leichter untersuchen koennen.");
	AddDetail(({"regal", "regale"}),
		"Keine zu sehen, hier unten werden wohl keine Waren aufbewahrt.");
	AddDetail(({"waren"}),
		"Genau! Hier unten werden keine Waren gelagert.");
	AddDetail(({"kisten", "kiste"}),
		"Kisten gibts hier auch keine. Allein schon deshalb, damit solch gierige"
		" Abenteurer wie Du sie nicht ausraeumen koennen.");
	AddDetail(({"gier"}),
		"Geld, Edelsteine, Schaetze ... sowas wollen doch alle Abenteurer.");
	AddDetail(({"geld", "edelstein", "edelsteine", "schatz", "schaetze"}),
		"Du haelst Dich wohl fuer besonders schlau, wie?");
	AddDetail(({"abenteurer"}),
		"Na sagen wir mal ... solche Kerle wie Du.");
	AddDetail(({"kerl", "kerle"}),
		"Hmmm, willst Du das wirklich?");
	AddDetail(({"gegenteil"}), #'missing_detail);
	AddDetail(({"sauberkeit"}),
		"Ohne Frage, hier scheint jemand regelmaessig sauber zu machen. Du kannst nicht"
		" das kleinste Staeubchen finden.");
	AddDetail(({"staub", "staeubchen"}),
		"Auch nach angestrengter Suche kannst Du keinen Staub entdecken. Hier war"
		" jemand wirklich gruendlich.");
	AddDetail(({"training", "trainigsraum"}),
		"Jep, das ist der Trainigsraum der Abenteurer. Insbesondere erlernen sie hier"
		" die Grundzuege der Waffenmeisterschaft.");
	AddDetail(({"grundzuege"}),
		"Wahre Meisterschaft kann man nicht lernen, man kann sie nur durch Uebung"
		" erreichen.");
	AddDetail(({"waffenmeisterschaft", "meisterschaft"}),
		"Nur wenige haben sie erreicht.");
	AddDetail(({"uebung", "meister"}),
		"Wie sagt man so schoen: Uebung macht den Meister.");
	AddDetail(({"kammer", "abstellkammer"}),
		"Also wie eine Abstellkammer sieht das hier nicht aus. Dazu fehlt einfach das"
		" Geruempel, die Spinnweben und der Staub.");
	AddDetail(({"geruempel"}),
		"Hier liegt kein Geruempel rum.");
	AddDetail(({"spinnen", "spinnweben"}),
		"Hier gibts weder Spinnen noch Spinnweben.");
	AddDetail(({"apparat"}),
		"Was, der Apparat ist nicht da?!? Wer klaut denn sowas?");

	AddExit("oben", GROOM("shop_kogida"), 0,({"Du verlaesst den Keller.",
		"&Name verlaesst den Keller.",
                "&Name kommt die Kellertreppe rauf."}));

//	AddItem(GNPC("apparat"), REFRESH_DESTRUCT);
}

void loop_detail()
{
	object* spieler;
	int welches, i;

	while (find_call_out("loop_detail") != -1) remove_call_out("loop_detail");

	spieler = m_indices(players);

	for (i = sizeof(spieler); i--;)
	{
		if (environment(spieler[i]) != this_object())
		{
			m_delete(players, spieler[i]);

			continue;
		}

		welches = players[spieler[i]];

		tell_object(spieler[i], text[welches]);

		if (++welches == sizeof(text))
		{
			m_delete(players, spieler[i]);

			spieler[i]->GiveEP();
		}
		else players[spieler[i]] = welches;
	}

	if (m_sizeof(players)) call_out("loop_detail", 3);
}

string missing_detail()
{
	if (member(players, this_player())) return "";

	players += ([this_player() : 0]);

	if (find_call_out("loop_detail") != -1) return "";

	call_out("loop_detail", 3);

	return "";
}

void Promote(object Player)
{
	object automat;

	automat = present("\n_elric_automat", this_object());

	if (!objectp(automat)) return;

	automat->peace(Player);

	tell_room(this_object(), break_string(sprintf("%s, Du *peng* hast alles gelernt,"
		" was *ratter* die Programmierung dieses *schab* Geraetes enthaelt."
		" *krach* Du darfst Dich ab sofort *quietsch* 'Waffenmeister%s' nennen.",
		capitalize(Player->name(WER)), (Player->QueryProp(P_GENDER) == FEMALE ? "in" : "")),
		BS_STDLEN, "Der Automat schnarrt: "));

	Player->GiveAbility("waffenmeister", 200);
}
