/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:43 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: shop_kogida.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/
// 08.07.99 Fiona  Prototyp fuer unt_dinge() fehlte

#include <wizlevels.h>
#include <properties.h>
#include <defines.h>
#include <laden.h>
#include <moving.h>
#include "../gilde.h"

inherit "std/laden";

string unt_dinge();

void create()
{
	::create();

	SetProp(P_INT_SHORT, "Der Gildenladen der Abenteurer");
	SetProp(P_INT_LONG,
		"Du stehst jetzt im Gildenladen der Abenteurer. Die Waende sind fast"
		" voellig von vollgepackten Holzregalen verdeckt. In diesem Raum herrscht"
		" ein ziemliches Durcheinander. Aber Gorm scheint sich hier recht wohl"
		" zu fuehlen. Eine kleine Treppe fuehrt nach unten. Scheinbar ist dort eine"
		" Art Keller. Ein ziemlicher Laerm dringt von dort herauf."
		" Eine kleine Tafel haengt an der Wand.");
	SetProp(P_STORAGE, GROOM("store_kogida"));
	SetProp(P_TRADER_NEEDED, 1);
	SetProp(P_USE_REAL_CASH, 1);
	SetProp(P_SEE_LIGHT, "Durch das Fenster kannst Du erkennen, dass es gerade && ist.\n");

	AddDetail(({"tafel", "befehle", "kommandos"}),
		"An der Wand haengt eine kleine Tafel. Du kannst sie lesen.");
	AddReadDetail(({"tafel", "befehle", "kommandos"}),
		"Auf der Tafel stehen die hier moeglichen Kommandos:\n\n"
		"        zeige                    kaufe <gegenstand> (oder nummer)\n"
		"        zeige rue(stungen)       verkaufe <gegenstand>\n"
		"        zeige waf(fen)           verkaufe alles\n"
		"        zeige ver(schiedenes)    schaetze <gegenstand>\n"
		"        teste <waffe> (oder nummer)\n\n");
	AddDetail(({"wand", "waende"}),
		"Die Waende bestehen aus den gleichen Steinen wie die Waende des Hauptraumes."
		" Bloss haengen hier keine Bilder oder aenhliches an der Wand, sondern ueberall"
		" sind Regale befestigt. Nur an der Suedwand hat man Platz fuer ein grosses"
		" Fenster gelassen.");
	AddDetail(({"stein","steine","sandstein","sandsteine"}),
		"Es sind genausolche Steine wie in der eigentlichen Gilde.");
	AddDetail(({"fenster", "suedwand", "draussen", "land", "grosses fenster"}),
		"Durch das grosse Fenster hast Du einen wunderbaren Blick ueber die Felder und"
		" den Wald hinweg zu den Weltumspannenden Bergen. Ein paar Kaeuerbauern arbeiten"
		" fleissig auf den Felder, und der Wind streicht sanft ueber das Land.",
		"Der Mondschein bestrahlt das Land mit seinem seltsam diffusen Licht. Still liegen"
		" die Felder der Kaeuer unter dem klaren Sternenhimmel, und auch in den Waeldern"
		" scheint alles still zu sein.");
	AddDetail(({"wind"}),
		"Ein sanfter, warmer Wind weht ueber das Land.",
		"Der kuehle Nachtwind faehrt durch das reife Korn.");
	AddDetail(({"wunderland"}),
		"Da stehst Du gerade mittendrin. Vielleicht solltest Du einfach losziehen, und es"
		" erforschen...");
	AddDetail(({"dorf", "kaeuerdorf", "kogida"}),
		"Das kleine Dorf, in dem sich die Abenteuregilde befindet nennt sich Kogida."
		" Bewohnt wird es von den Kaeuern. Geht doch einfach mal nach draussen, und"
		" schau es Dir an.");
	AddDetail(({"feld", "felder", "getreidefeld", "getreidefelder"}),
		"Die Kaeuer sind emsig dabei, ihre Felder zu bestellen. Das wird wohl eine reiche"
		" Ernte geben.",
		"Leblos liegen die Felder unter dem Nachthimmel. Nur der Wind streicht durch das"
		" reife Korn.");
	AddDetail(({"korn", "getreide"}),
		"Ja, das sind Getreidefelder, also sollte man annehmen, dass da dann auch Getreide"
		" drauf waechst.");
	AddDetail(({"kaeuer", "bauern", "kaeuerbauern"}),
		"Die Kaeuerbauern arbeiten auf den Feldern. Scheinbar sind sie gerade dabei,"
		" die Ernte einzubringen. Vielleicht solltest Du sie Dir mal aus der Naehe anschauen.",
		"Nachts scheinen die Kaeuer, wie jeder vernuenftige Mensch, zu schlafen. Nur Du musst"
		" natuerlich wieder irgendwelches Zeugs untersuchen wollen...");
	AddDetail(({"naehe"}),
		"Also da wirst Du wohl schon hinlaufen muessen...");
	AddDetail(({"ernte", "erntezeit"}),
		"Momentan ist Erntezeit, daher sind die Kaeuer den ganzen Tag auf den Feldern"
		" beschaeftigt.",
		"Auch wenn momentan Erntezeit ist, so halten es die Kaeuer wie alle rechtschaffenden"
		" Lebewesen und schlafen des Nachts. Nur solche verrueckten Abenteurer wie Du"
		" kaemen auf den Gedanken, mitten in der Nacht irgendwelche Dinge erforschen zu"
		" wollen.");
	AddDetail(({"wald", "waelder"}),
		"Hinter den Feldern kannst Du dichte Waelder erkennen. Was da wohl fuer Wesen"
		" leben moegen?",
		"Als dunklen Schatten kannst Du suedlich der Felder ein ausgedehntes Waldgebiet"
		" ausmachen.");
	AddDetail(({"wesen", "lebewesen"}),
		"Nun, von hier aus kannst Du sie nicht sehen, aber Du bist sicher, dass es dort"
		" irgendwelche fremdartigen Lebewesen geben muss. Schliesslich ist das hier das"
		" Wunderland.",
		"Hmmm, hier sind keine irgendwie seltsamen 'Wesen'.");
	AddDetail(({"berge", "berg"}),
		"Weit im Sueden begrenzen die Weltumspannenden Berge das Wunderland und schotten"
		" es von der Aussenwelt ab.",
		"Weit im Sueden kannst Du undeutlich die Silouette der Weltumspannenden Berge"
		" ausmachen.");
	AddDetail(({"decke", "zimmerdecke"}),
		"Die Decke des Raumes besteht ebefalls aus behauenen Steinen, die von kraeftigen"
		" Holzbalken gehalten werden.");
	AddDetail(({"balken", "holzbalken", "deckenbalken"}),
		"Die Holzbalken bestehen aus festem Eichenholz. Die werden wohl auch noch hier sein,"
		" wenn Deine Knochen laengst zu Staub zerfallen sind...");
	AddDetail(({"eiche", "eichenholz"}),
		"Die wunderlaendische Eiche ist ein wunderbares Bauholz. Beinahe unverwuestlich.");
	AddDetail(({"bauholz"}),
		"Naja ... eben Holz mit dem man etwas baut.");
	AddDetail(({"boden", "fussboden"}),
		"Die knarrenden Dielen hier sind ebenfalls schon recht alt, aber im Gegensatz zum"
		" Hauptraum der Gilde scheint hier oefter mal jemand den Boden zu reinigen.");
	AddDetail(({"dielen"}),
		"Die Dielen scheinen wirklich schon recht alt zu sein, aber wie alt sie nun"
		" genau sind kannst Du trotzdem nicht erkennen.");
	AddDetail(({"alter"}),
		"Das genaue Alter der Dielen kannst Du zwar nicht feststellen, aber Du bist Dir"
		" sicher, dass sie schon einiges erlebt haben...");
	AddDetail(({"knarren"}),
		"Lausch doch mal...");
	AddSoundDetail(({"boden", "fussboden", "diele", "dielen", "knarren", "knarren der dielen",
		"knarrende dielen"}),
		"*knarr* *knarr* *quietsch*");
	AddDetail(({"licht"}),
		"Durch das Fenster scheint das Sonnenlicht herein.",
		"Das silberne Leuchten des Mondes erhellt die Felder.");
	AddDetail(({"sonne","sonnenlicht"}),
		"Das Sonnenlicht scheint warm durch das Fenster. Die Welt da draussen sieht wirklich"
		" wie fuer ein Abenteuer geschaffen aus.",
		"Hmmm ... Sonnenlicht mitten in der Nacht ... also hier ist zwar das Wunderland, aber"
		" _so_ war das nicht gemeint...");
	AddDetail(({"mond","mondlicht"}),
		"Du kannst den Mond tagsueber nicht sehen.",
		"Der volle Mond steht hoch am Himmel. Irgendwie scheint durch das silberne Licht"
		" alles noch viel wundersamer als tagsueber.");
	AddDetail(({"himmel"}),
		"Strahlend blauer Himmel. Und weit und breit keine Wolke in Sicht.",
		"Tausende von Sternen funkeln am Nachthimmel um die Wette.");
	AddDetail(({"nachthimmel"}),
		"Jaja ... tagsueber den Nachthimmel untersuchen wollen. Typisch Spieler.",
		"Der tiefblaue Himmel ist von unendlich vielen Sternen uebersaeht.");
	AddDetail(({"sterne"}),
		"Hmmm ... also momentan siehst Du keine, oder hast Du etwa doch ein wenig"
		" zu viel getrunken?",
		"Das sind diese kleinen Lichtpunkte am Himmel. ;-)");
	AddDetail(({"lichtpunkte"}),
		"Hmmm ... also irgendwie hab ich das Gefuehl, Du willst mich veraeppeln...");
	AddDetail(({"punkt", "punkte"}),
		"Punkte sind mathematische Gebilde. Also frag deinen Matheprof danach ...");
	AddDetail(({"holz"}),
		"Die Dielen und die Deckenbalken sind aus Holz.");
	AddDetail(({"gilde", "hauptraum", "norden"}),
		"Nach Norden kommst Du wieder in die eigentliche Gilde.");
	AddDetail(({"regal", "regale"}),
		"Ueberall sind hier Regale an den Waenden befestigt. Dort lagert Gorm seine Waren.");
	AddDetail(({"ware", "waren"}),
		"Was glaubst Du, wird hier sonst angeboten?");
	AddDetail(({"laden", "gildenladen", "raum"}),
		"Da stehst Du gerade drinnen. Also untersuch doch einfach, was dich interessiert.");
	AddDetail(({"schatten"}),
		"Die Regale, und alles andere was sich hier befindet werfen scharf begrenzte Schatten.");
	AddDetail(({"grenze", "begrenzung"}),
		"Also Grenze heisst die Stelle, wo zwei verschiedene Dinge aufeinandertreffen.");
	AddDetail(({"ding", "dinge"}),
		#'unt_dinge);
	AddDetail(({"leuchten"}),
		"Leuchten??? Gibts die nicht beim Lampenmacher?",
		"Jup ... der Mond leuchtet, ist das jetzt ein besonderer Hinweis oder wie?");
	AddDetail(({"lampenmacher"}),
		"Der ist nicht hier.");
	AddDetail(({"ausgang", "ausgaenge"}),
		"Hier gibts nur zwei Ausgaenge. Einer fuehrt nach Norden in die Gilde zurueck,"
		" der andere die Treppe runter in den Keller."
		" Rein theoretisch koennte man natuerlich auch das Fenster als Ausgang nutzen,"
		" aber das wuerde Gorm bestimmt nicht so toll finden.");
	AddDetail(({"treppe", "stufe", "stufen", "treppenstufe", "treppenstufen"}),
		"Diese kleine Treppe fuehrt nach unten. Vermutlich gehst da in den Keller,"
		" denn zum Dachboden sollte es ja nach oben gehen, oder?");
	AddDetail(({"dachboden"}),
		"Dachboeden befinden sich im allgemeinen direkt unterm Dach, und das ist"
		" hier, wie in jedem vernueftigen Haus, oben. Da die Treppe nach unten fuehrt,"
		" und kein Weg nach oben erkennbar ist, wirds hier wohl keinen Dachboden geben.");
	AddDetail(({"dach"}),
		"Auch dieses Haus besitzt ein Dach, es befindet sich ueber Dir.");
	AddDetail(({"haus"}),
		"Tja, was denkst Du worin Du Dich gerade befindest?!?");
	AddDetail(({"keller"}),
		"Dieses Haus scheint einen Keller zu besitzen, fuer naehere Untersuchungen"
		" waere es recht praktisch, diesen doch einfach zu betreten, oder?");
	AddDetail(({"untersuchung", "untersuchungen"}),
		"Da eine Kugel rund ist, ist eine Kugel rund?");
	AddDetail(({"kugel"}),
		"Rund, was sonst.");
	AddDetail(({"durcheinander"}),
		"Hier liegen haufenweise irgendwelche Dinge ungeordnet rum. Sowas nennt man"
		" dann Unordnung.");
	AddDetail(({"unordnung"}),
		"Dieses Detail wurde voruebergehend deaktiviert. Bitte melden sie sich bei"
		" einem Erzmagier.");
	AddDetail(({"laerm", "arbeitsgeraeusche", "abreitsgeraeusch"}),
		"Da unten wird scheinbar heftigst gewerkelt. Jedenfalls kannst Du jede Menge"
		" Arbeitsgeraeusche hoeren.");
	AddSoundDetail(({"laerm", "arbeitsgeraeusche", "abreitsgeraeusch"}),
		"*haemmer* *saeg* *hobel*");

//	AddItem(MUELLSCHLUCKER, REFRESH_REMOVE);
//	AddItem(GNPC("gorm"), REFRESH_DESTRUCT);

	AddExit("norden", GROOM("gilde"), 0, ({"Du verlaesst den Gildenladen.",
		"verlaesst den Laden", "kommt aus dem Gildenladen"}));
	AddExit("unten", GROOM("keller_kogida"), 0, ({"Du betrittst den Keller.",
		"betritt den Keller", "kommt in den Keller"}));

	Money = 864 * 30;

	AddCmd("geldcheck", "output_money");
}

string unt_dinge()
{
	return "Also da haetten wir: " + PL->CountUp(map_array(all_inventory(
		load_object(QueryProp(P_STORAGE))), lambda(({'x}),
		({#'call_other, 'x, "name", WEN}))));
}

int output_money()
{
	object player;

	player = this_player();

	if (!IS_WIZARD(player)) return 0;

	tell_object(player, BS("Der alte Gorm besitzt noch " + cost_str(Money) + "."));

	return 1;
}

void reset()
{
	::reset();

	if (Money < (864 * 20)) Money += 864 * 5;
	if (Money < (864 * 20)) Money += 864 * 5;
}

PreventInsert(object ob)
{
	object schlucker;

	if (living(ob) || ob->IsMoney()) return;

	if (schlucker = present("\ngum_muellschlucker", this_object()))
		call_other(schlucker, "m", ob, this_player());
}

int get_buy_value(object ding)
{
	int value, stufe;
	object player;

	player = this_player();
	value  = ding->QueryProp(P_VALUE);

	if (player->QueryProp(P_GUILD) == GILDENNAME)
	{
		stufe = player->QueryProp(P_LEVEL) / 2;

		if (stufe < 10) stufe = 10;
		if (stufe > 20) stufe = 20;

		value = to_int(to_float(value) * (1 - (stufe / 100.0)));
	}
	else value = to_int(value * 1.1);

	return value;
}

int get_sell_value(object ding)
{
	int value, stufe;
	object player;

	player = this_player();
	value  = ding->QueryProp(P_VALUE);

	if (player->QueryProp(P_GUILD) == GILDENNAME)
	{
		stufe = player->QueryProp(P_LEVEL) / 2;

		if (stufe < 10) stufe = 10;
		if (stufe > 20) stufe = 20;

		value = to_int(to_float(value) * (1 + (stufe / 100.0)));
	}
	else value = to_int(value * 0.9);

	return value;
}

int clean_up(int arg)
{
	return 0;
}
