/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:43 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: ab_gilde.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/
inherit  "std/guild";

#include <properties.h>
#include <defines.h>
#include <guilds.h>
#include <moving.h>
#include <wizlevels.h>
#include <homes.h>
#include <living/skills.h>
#include "../gilde.h"

string list();

void create()
{
	::create();

	SetProp(P_INDOORS, 1);
	SetProp(P_LIGHT, 2);
	SetProp(P_INT_SHORT, "Die Standard-Abenteurergilde");
	SetProp(P_INT_LONG,
		"Du stehst in der Standard-Abenteurergilde. Irgendwie hat der "
		"zustaendige Magier wohl voellig die Raumbeschreibungen und Details "
		"vergessen. :(.\nEin Schild haengt an der Wand.");
	SetProp(P_TELEPORT_FORBIDDEN,1);

	AddReadDetail(({"schild","rotes schild"}), #'list);

	SetProp(P_GUILD_NAME, GILDENNAME);
	SetProp(P_MIN_LEVEL, 1);
	SetProp(P_MIN_STATS, ({1,1,1,1}));
	SetProp(P_GUILD_FACTOR, ({10,10,10,10}));
	SetProp(P_SKILLS_ID, "ABG");
	SetProp(P_JOIN_COST, 0);
	SetProp(P_GUILD_QUESTS, ({
		({"Die Folterkammer des Hexenmeisters", 28 }),
		({"Beende Schnicks Schreckensherrschaft", 32}) }) );
	SetProp(P_GUILD_SKILLS,
		({"pflege", "schaetz", "pfeil_schwach", "pfeil_stark", "ruestung", "identifiziere",
		"feuerball_schwach", "feuerball_stark",	"schleudere", "schnell", "waffenmeister"}));
	SetProp(P_GUILD_TITLES, ({ ({
		"der Tollpatsch",
		"der Streuner",
		"der Pilger",
		"der Tollkuehne",
		"der Vagabund",
		"der Recke",
		"der Faehrtensucher",
		"der Buerger",
		"der Bannloeser",
		"der Reisende",
		"der Kaempfer",
		"der Husar",
		"der Kleriker",
		"der Druide",
		"der Edelmann",
		"der Illusionist",
		"der Zauberkundige",
		"der Paladin",
		"der Priester",
		"der Seher" }), ({
		"die Anfaengerin",
		"die Streunerin",
		"die Pilgerin",
		"die Tollkuehne",
		"die Vagabundin",
		"die Abenteurerin",
		"die Faehrtensucherin",
		"die Buergerin",
		"die Bannloeserin",
		"die Reisende",
		"die Kaempferin",
		"die Husarin",
		"die Heilerin",
		"die Druidin",
		"das Edelfraeulein",
		"die Illusionistin",
		"die Zauberkundige",
		"die Hexe",
		"die Fee",
		"die Heilige"}) }) );
	SetProp(P_GUILD_EXP, ({
		0,        1014,      1522,      2283,      3425,
		5138,     7707,      11561,     17341,     26012,
		39018,    58527,     77791,     97791,     131687,
		197530,   296296,    444444,    666666,    1000000,
		1500000,  2250000,   3375000,   5062500,   7600000,
		11400000, 17100000,  25600000,  38500000,  57500000,
		86250000, 129375000, 194062500, 291093750, 436640625}));

	AddCmd("heim", "homen");
}

int learn(string arg)
{
	int ret, oldp, oldf;

	notify_fail("WAS willst Du denn lernen?\n");

	if(!arg || !strlen(arg)) return 0;

	if(PL->QueryProp(P_GUILD) != QueryProp(P_GUILD_NAME))
	{
		tell_object(PL, break_string("Um hier Zaubersprueche zu lernen, musst Du Mitglied dieser "
			"Gilde werden.", BS_STDLEN));

		return 1;
	}

	if(strstr(arg, "waffenmeister", 0) != -1)
	{
		tell_object(PL, "Dazu musst Du schon Varilon fragen!\n");

		return 1;
	}

	return ::learn(arg);
}

int homen(string str)
{
	notify_fail("Argumente werden nicht unterstuetzt.\n");
	if(str) return 0;

	if(PL->QueryProp(P_GUILD) != GILDENNAME)
	{
		tell_object(PL, "Du bist doch gar nicht Mitglied dieser Gilde.\n");

		return 1;
	}

	PL->SetProp(P_START_HOME, explode(file_name(ME),"#")[0]);

	tell_object(PL, "Ab sofort wirst Du immer hier starten.\n");

	return 1;
}

string list()
{
	return
		"+-------------------------------------------------------+\n"
		"| Moegliche Befehle sind:                               |\n"
		"|             erhoehe (stufe|intelligenz|kraft|         |\n"
		"|                      geschicklichkeit|ausdauer)       |\n"
		"|             kosten                                    |\n"
		"|             liste (abenteuer|gilden|gildenabenteuer|  |\n"
		"|                    zaubersprueche|faehigkeiten|       |\n"
		"|                    aufnahmebedingungen|               |\n"
		"|                    eigenschaften|austritt|erhoehen)   |\n"
		"|             zauberei <name>                           |\n"
		"|             heim                                      |\n"
		"|             beitreten                                 |\n"
		"|             verlasse                                  |\n"
		"+-------------------------------------------------------+\n";
}

int join()
{
	string GildeVorher, GildeDanach;
	object Chef;
	
	GildeVorher = this_player()->QueryProp(P_GUILD);
	
	::join();
	
	GildeDanach = this_player()->QueryProp(P_GUILD);
	
	if (GildeDanach == GILDENNAME)
	{
		if (!present("\nabg_kristall", PL))
		{
			clone_object(GOBJ("kristall"))->move(PL, M_NOCHECK | M_SILENT);

			tell_object(PL, BS("Ein seltsamer Kristall erscheint ploetzlich"
				" vor Dir. Du verspuerst einen unwiderstehlichen Zwang,"
				" den Kristall zu beruehren. Du weisst, dieser Kristall"
				" ist an Dich gebunden, solange Du der Gilde der Abenteurer"
				" angehoerst.", BS_STDLEN));
			tell_room(ME, BS(capitalize(PL->name(WER)) + " erhaelt einen magischen"
				" Kristall.", BS_STDLEN), ({PL}));
		}
	}
	
	return 1;
}

int leave(string argument)
{
	string GildeVorher, GildeDanach;
	int    RetWert;
	object kristall;
	
	GildeVorher = this_player()->QueryProp(P_GUILD);
	
	RetWert = ::leave(argument);
	
	GildeDanach = this_player()->QueryProp(P_GUILD);
	
	if ((GildeVorher != GildeDanach) && (GildeDanach == "/std/guild"))
	{
		if (kristall = present("\nabg_kristall", PL))
		{
			kristall->remove();

			if (kristall) destruct(kristall);

			tell_object(PL, BS("Dein Kristall beginnt ploetzlich aufzugluehen."
				" Fuer kurze Zeit schliesst Du geblendet die Augen. Als Du sie"
				" wieder oeffnest, ist der Kristall verschwunden.", BS_STDLEN));
			tell_room(ME, BS(capitalize(PL->name(WESSEN)) + " Kristall zerfaellt"
				" mit einem grellen Aufleuchten zu Staub.", BS_STDLEN), ({PL}));
		}

		PLAYER_HANDLER->RemovePlayer(PL);
	}
	
	return RetWert;
}

void init()
{
	::init();

	if (PL && interactive(PL) && (PL->QueryProp(P_GUILD) == GILDENNAME))
	{
		int oldp, oldf;

		oldp = PL->GetProbability("pfeil");
		oldf = PL->GetProbability("feuerball");

		oldp = oldp <= 950 ? oldp : 950;
		oldf = oldf <= 950 ? oldf : 950;

		if (PL->GetProbability("pfeil_schwach") < 0)
		{
			if (oldp > -1) PL->GiveAbility("pfeil_schwach", oldp);

			oldp = PLAYER_HANDLER->GetSkill(PL, "pfeil0");

			if (oldp > -1) PL->GiveAbility("pfeil_schwach", oldp);
		}
			
		oldp = PL->GetProbability("pfeil");
		oldp = oldp <= 950 ? oldp : 950;

		if (PL->GetProbability("pfeil_stark") < 0)
		{
			oldp = PLAYER_HANDLER->GetSkill(PL, "pfeil1");

			if (oldp > 0) PL->GiveAbility("pfeil_stark", oldp);
		}

		if (PL->GetProbability("feuerball_schwach") < 0)
		{
			if (oldf > -1) PL->GiveAbility("feuerball_schwach", oldf);

			oldf = PLAYER_HANDLER->GetSkill(PL, "feuerball0");

			if (oldf > 0) PL->GiveAbility("feuerball_schwach", oldf);
		}

		oldf = PL->GetProbability("feuerball");
		oldf = oldf <= 950 ? oldf : 950;
			
		if (PL->GetProbability("feuerball_stark") < 0)
		{
			if (oldf > -1) PL->GiveAbility("feuerball_stark", oldf);

			oldf = PLAYER_HANDLER->GetSkill(PL, "feuerball1");

			if (oldf > 0) PL->GiveAbility("feuerball_stark", oldf);
		}

		PL->GiveAbility("pfeil", -2);
		PL->GiveAbility("feuerball", -2);

		PLAYER_HANDLER->RemovePlayer(PL);

		if (PL->QueryProp(P_LEVEL) < 16)
		{
			PL->GiveAbility("feuerball_stark", -2);
			PL->GiveAbility("pfeil_stark", -2);
		}
	}
}
