/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:43 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: ab_gilde_mit_gildenstufen.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/
#pragma strong_types

inherit  "std/guild";

#include <properties.h>
#include <defines.h>
#include <guilds.h>
#include <moving.h>
#include <wizlevels.h>
#include <homes.h>
#include <living/skills.h>
#include "../gilde.h"

string list();

// Mindestens 100 verschiedene Kerben (gesamt 5000)
// Player muss bereits Titan und Qwi getoetet haben
mixed CheckForGuildLevel8(object wer)
{
	string real;

	if (!objectp(wer) || !interactive(wer)) return "Diese Gildenstufe kann nur"
		" von Spielern erreicht werden.";

	real = getuid(wer);

	if (KERBHOLZMASTER->AnzahlKerben(real) < 5000) return "Fuer diese Gildenstufe"
		" musst Du insgesamt 5000 Kerben vorweisen koennen.";

	if (KERBHOLZMASTER->AnzahlVerschiedene(real) < 100) return "Fuer diese Gildenstufe"
		" musst Du Kerben von 100 verschiedenen Wesen vorweisen koennen.";

	if (!KERBHOLZMASTER->AnzahlKerben(real, "Titan")) return "Fuer diese Gildenstufe"
		" musst Du den Titan im Kampf besiegt haben.";

	if (!KERBHOLZMASTER->AnzahlKerben(real, "Qwi")) return "Fuer diese Gildenstufe"
		" musst Du den Qwi von dieser Ebene verbannt haben.";

	return 0;
}

// Mindestens 200 verschiedene Kerben (gesamt 15000)
// Player muss bereits Ymmu M'Kurasa und Schnack
// getoetet haben
mixed CheckForGuildLevel9(object wer)
{
	string real;

	if (!objectp(wer) || !interactive(wer)) return "Diese Gildenstufe kann nur"
		" von Spielern erreicht werden.";

	real = getuid(wer);

	if (KERBHOLZMASTER->AnzahlKerben(real) < 15000) return "Fuer diese Gildenstufe"
		" musst Du insgesamt 15000 Kerben vorweisen koennen.";

	if (KERBHOLZMASTER->AnzahlVerschiedene(real) < 200) return "Fuer diese Gildenstufe"
		" musst Du Kerben von 200 verschiedenen Wesen vorweisen koennen.";

	if (!KERBHOLZMASTER->AnzahlKerben(real, "Ymmu M'Kursa")) return "Fuer diese Gildenstufe"
		" musst das Wesen namens Ymmu M'Kursa im Kampf besiegt haben.";

	if (!KERBHOLZMASTER->AnzahlKerben(real, "Schnack")) return "Fuer diese Gildenstufe"
		" musst Du Schnack im Kampf besiegt haben.";

	return 0;
}

void create()
{
	::create();

	SetProp(P_INDOORS, 1);
	SetProp(P_LIGHT, 2);
	SetProp(P_INT_SHORT, "Die Standard-Abenteurergilde");
	SetProp(P_INT_LONG,
		"Du stehst in der Standard-Abenteurergilde. Irgendwie hat der "
		"zustaendige Magier wohl voellig die Raumbeschreibungen und Details "
		"vergessen. :(.\nEin Schild haengt an der Wand.");
	SetProp(P_TELEPORT_FORBIDDEN,1);

	AddReadDetail(({"schild","rotes schild"}), #'list);

	SetProp(P_GUILD_NAME, GILDENNAME);
	SetProp(P_GUILD_FACTOR, ({10,10,10,10}));
	SetProp(P_SKILLS_ID, "ABG");

	SetProp(P_GUILD_LEVELS, ([
		1 : ([]),
		2 : ([
			P_QUESTS   : ({"Operation gelungen, Patient tot"}),
			P_EXPLORED : 1]),
		3 : ([
			P_QUESTS    : ({"Das verlassene Hotel"}),
			R_ABILITIES : (["schaetz" : 400]),
			P_EXPLORED  : 5]),
		4 : ([
			P_QP        : 100,
			R_ABILITIES : (["pfeil_schwach" : 400, "feuerball_schwach" : 400]),
			A_INT       : 5,
			A_DEX       : 5,
			A_CON       : 5,
			A_STR       : 5,
			P_EXPLORED  : 10]),
		5 : ([
			P_QP        : 150,
			R_ABILITIES : (["identifiziere" : 600]),
			P_EXPLORED  : 15]),
		6 : ([
			P_QP       : 250
			A_INT      : 8,
			A_DEX      : 8,
			A_CON      : 8,
			A_STR      : 8,
			P_EXPLORED : 20]),
		7 : ([
			P_QP        : 350,
			R_ABILITIES : (["pfeil_stark" : 400, "feuerball_stark" : 400]),
			P_EXPLORED  : 35]),
		8 : ([
			P_EXPLORED : 50,
			P_SEER     : 1,
			R_FUN      : "CheckForGuildLevel8"]),
		9 : ([
			P_QUESTS    : ({"Beende Schnicks Schreckensherrschaft"}),
			P_EXPLORED  : 65,
			R_ABILITIES : (["waffenmeister" : 600]),
			R_FUN       : "CheckForGuildLevel9"]) ]));

	SetProp(P_GUILD_SKILLS, ([
		"pflege"            : ([P_GUILD_LEVEL : 2]),
		"schaetz"           : ([P_GUILD_LEVEL : 2]),
		"pfeil_schwach"     : ([P_GUILD_LEVEL : 3]),
		"feuerball_schwach" : ([P_GUILD_LEVEL : 3]),
		"identifiziere"     : ([P_GUILD_LEVEL : 4]),
		"ruestung"          : ([P_GUILD_LEVEL : 4]),
		"schleudere"        : ([P_GUILD_LEVEL : 5]),
		"pfeil_stark"       : ([P_GUILD_LEVEL : 6]),
		"feuerball_stark"   : ([P_GUILD_LEVEL : 6]),
		"schnell"           : ([P_GUILD_LEVEL : 7]),
		"waffenmeister"     : ([P_GUILD_LEVEL : 8]) ]));

	SetProp(P_GUILD_TITLES, ({ ({
		"ist ein Abenteurer"
		"der unerfahrene Wanderer",
		"der wagemutige Forscher",
		"der bekannte Abenteurer",
		"der Entdecker",
		"der Held",
		"der Ruhmreiche",
		"der Legendaere",
		"der Veteran" }), ({
		"ist eine Abenteurerin",
		"die unerfahrene Wandersfrau",
		"die wagemutige Forscherin",
		"die bekannte Abenteurerin",
		"die Entdeckerin",
		"die Heldin",
		"die Ruhmreiche",
		"die Legendaere",
		"die Veteranin" }) }) );

	AddCmd("heim", "homen");
}

int learn(string arg)
{
	notify_fail("WAS willst Du denn lernen?\n");

	if (!stringp(arg) || !strlen(arg)) return 0;

	if (this_player()->QueryProp(P_GUILD) != QueryProp(P_GUILD_NAME))
	{
		tell_object(this_player(), "Um hier Zaubersprueche zu lernen, musst"
			" Du Mitglied dieser Gilde werden.\n");

		return 1;
	}

	if (strstr(arg, "waffenmeister", 0) != -1)
	{
		tell_object(this_player(), "Dazu musst Du schon Varilon fragen!\n");

		return 1;
	}

	return ::learn(arg);
}

int homen(string str)
{
	notify_fail("Argumente werden nicht unterstuetzt.\n");

	if (stringp(str) && strlen(str)) return 0;

	if (this_player()->QueryProp(P_GUILD) != GILDENNAME)
	{
		tell_object(this_player(), "Du bist doch gar nicht Mitglied dieser Gilde.\n");

		return 1;
	}

	this_player()->SetProp(P_START_HOME, explode(file_name(this_object()),"#")[0]);

	tell_object(this_player(), "Ab sofort wirst Du immer hier starten.\n");

	return 1;
}

string list()
{
	return
		"+-------------------------------------------------------+\n"
		"| Moegliche Befehle sind:                               |\n"
		"|             erhoehe (stufe|intelligenz|kraft|         |\n"
		"|                      geschicklichkeit|ausdauer)       |\n"
		"|             kosten                                    |\n"
		"|             liste (abenteuer|gilden|gildenabenteuer|  |\n"
		"|                    zaubersprueche|faehigkeiten|       |\n"
		"|                    aufnahmebedingungen|               |\n"
		"|                    eigenschaften|austritt|erhoehen)   |\n"
		"|             zauberei <name>                           |\n"
		"|             heim                                      |\n"
		"|             beitreten                                 |\n"
		"|             verlasse                                  |\n"
		"+-------------------------------------------------------+\n";
}

int join()
{
	string GildeVorher, GildeDanach;
	object Chef;
	
	GildeVorher = this_player()->QueryProp(P_GUILD);
	
	::join();
	
	GildeDanach = this_player()->QueryProp(P_GUILD);
	
	if (GildeDanach == GILDENNAME)
	{
		if (!present("\nabg_kristall", this_player()))
		{
			clone_object(GOBJ("kristall"))->move(this_player(), M_NOCHECK | M_SILENT);

			tell_object(this_player(), BS("Ein seltsamer Kristall erscheint ploetzlich"
				" vor Dir. Du verspuerst einen unwiderstehlichen Zwang,"
				" den Kristall zu beruehren. Du weisst, dieser Kristall"
				" ist an Dich gebunden, solange Du der Gilde der Abenteurer"
				" angehoerst.", BS_STDLEN));
			tell_room(this_object(), BS(capitalize(this_player()->name(WER)) + " erhaelt einen magischen"
				" Kristall.", BS_STDLEN), ({this_player()}));
		}
	}
	
	return 1;
}

int leave(string argument)
{
	string GildeVorher, GildeDanach;
	int    RetWert;
	object kristall;
	
	GildeVorher = this_player()->QueryProp(P_GUILD);
	
	RetWert = ::leave(argument);
	
	GildeDanach = this_player()->QueryProp(P_GUILD);
	
	if ((GildeVorher != GildeDanach) && (GildeDanach == "/std/guild"))
	{
		if (kristall = present("\nabg_kristall", this_player()))
		{
			kristall->remove();

			if (kristall) destruct(kristall);

			tell_object(this_player(), break_string("Dein Kristall beginnt"
				" ploetzlich aufzugluehen. Fuer kurze Zeit schliesst Du"
				" geblendet die Augen. Als Du sie wieder oeffnest, ist"
				" der Kristall verschwunden."));
			tell_room(this_object(), break_string(capitalize(
				this_player()->name(WESSEN)) + " Kristall zerfaellt"
				" mit einem grellen Aufleuchten zu Staub."),
				({this_player()}));
		}
	}
	
	return RetWert;
}

void init()
{
	::init();

	if (this_player() && interactive(this_player()) && (this_player()->QueryProp(P_GUILD) == GILDENNAME))
	{
		int oldp, oldf;

		oldp = this_player()->GetProbability("pfeil");
		oldf = this_player()->GetProbability("feuerball");

		oldp = oldp <= 950 ? oldp : 950;
		oldf = oldf <= 950 ? oldf : 950;

		if (this_player()->GetProbability("pfeil_schwach") < 0)
		{
			if (oldp > -1) this_player()->GiveAbility("pfeil_schwach", oldp);

			oldp = PLAYER_HANDLER->GetSkill(this_player(), "pfeil0");

			if (oldp > -1) this_player()->GiveAbility("pfeil_schwach", oldp);
		}
			
		oldp = this_player()->GetProbability("pfeil");
		oldp = oldp <= 950 ? oldp : 950;

		if (this_player()->GetProbability("pfeil_stark") < 0)
		{
			oldp = PLAYER_HANDLER->GetSkill(this_player(), "pfeil1");

			if (oldp > 0) this_player()->GiveAbility("pfeil_stark", oldp);
		}

		if (this_player()->GetProbability("feuerball_schwach") < 0)
		{
			if (oldf > -1) this_player()->GiveAbility("feuerball_schwach", oldf);

			oldf = PLAYER_HANDLER->GetSkill(this_player(), "feuerball0");

			if (oldf > 0) this_player()->GiveAbility("feuerball_schwach", oldf);
		}

		oldf = this_player()->GetProbability("feuerball");
		oldf = oldf <= 950 ? oldf : 950;
			
		if (this_player()->GetProbability("feuerball_stark") < 0)
		{
			if (oldf > -1) this_player()->GiveAbility("feuerball_stark", oldf);

			oldf = PLAYER_HANDLER->GetSkill(this_player(), "feuerball1");

			if (oldf > 0) this_player()->GiveAbility("feuerball_stark", oldf);
		}

		this_player()->GiveAbility("pfeil", -2);
		this_player()->GiveAbility("feuerball", -2);

		PLAYER_HANDLER->RemovePlayer(this_player());

		if (this_player()->QueryProp(P_LEVEL) < 16)
		{
			this_player()->GiveAbility("feuerball_stark", -2);
			this_player()->GiveAbility("pfeil_stark", -2);
		}
	}
}

