/*******************
** Eldarea MUDLib **
********************
**
** global/daemon/channeld.c - channel daemon
**
** CVS DATA
** $Date: 2000/12/01 15:23:40 $
** $Revision: 1.4 $
**
** Based on MG Mudlib
** Channeld by Hate
**
** CVS History
**
** $Log: channeld.c,v $
** Revision 1.4  2000/12/01 15:23:40  elatar
** uptime and user statistics revised
**
** Revision 1.3  2000/01/17 14:56:58  elatar
** MasteR requests debugged
**
** Revision 1.2  1999/11/19 10:29:26  elatar
** New channeld from md
**
**
*/

#pragma strong_types

#include "/std/sys_debug.h"
#include <lpctypes.h>
#include <wizlevels.h>
#include <properties.h>
#include <daemon.h>
#include <player/channel.h>

#define NEED_PROTOTYPES

#define CMNAME  "<MasteR>"
#define CHANNEL_SAVE    "/global/daemon/save/channeld"

// Nach welcher Zeit werden gecachte Channels removed?
#define CACHED_TIMEOUT  to_int(86400*1.5)
// Nach welcher Zeit ohne Nutzung werden dynamische Channels removed?
#define DYNAMIC_TIMEOUT (2)

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),"DEBUG "+x)

// channels - contains the simple channel information
//            ([ channelname : ({ I_MEMBER, I_ACCESS, I_INFO, I_MASTER })...])
private static mapping channels;
// stores channel history ([ channelname : ({message1, message 2, ...})])
// each message has the format: ({ I_NAME
//                                ,"Name des Senders" bzw "/(Name des Senders)$Jemand" bei unsichtbaren
//                                ,msg+" <"+dtime(time())[<8..]+">"
//                                ,type })
private static mapping channelH;
// channeld statistics
private static mapping stats;
// channel cache
private mapping channelC;
private mapping channelB;

// BEGIN OF THE CHANNEL MASTER ADMINISTRATIVE PART

#define RECV    0
#define SEND    1
#define FLAG    2

#define F_WIZARD 1

private static mapping admin = allocate_mapping(0, 3);

varargs int send(string ch, object pl, string msg, int type);
varargs int new(string ch, object pl, mixed info);
mixed remove(string ch, object pl);

int check(string ch, object pl, string cmd)
{
  int level;

  if((admin[ch, FLAG] & F_WIZARD) && query_wiz_level(pl) < SEER_LVL) return 0;
  level = (admin[ch, FLAG] & F_WIZARD
           ? query_wiz_level(pl)
           : pl->QueryProp(P_LEVEL));

  switch(cmd)
  {
  case C_FIND:
  case C_LIST:
  case C_JOIN:
    if(admin[ch, RECV] == -1) return 0;
    if(admin[ch, RECV] <= level) return 1;
    break;
  case C_SEND:
    if(admin[ch, SEND] == -1) return 0;
    if(admin[ch, SEND] <= level) return 1;
    break;
  case C_LEAVE:
    return 1;
  default: break;
  }
}

private int CountUser(mapping l)
{
  mapping n;
  n = ([]);
  walk_mapping(l, lambda(({'i/*'*/, 'a/*'*/, 'n/*'*/}),
                         ({#'+=/*'*/, 'n/*'*/,
                              ({#'mkmapping/*'*/,
                                   ({#'[/*'*/, 'a/*'*/, 0})})})),
               &n);
  return m_sizeof(n);
}

private static void banned(string n, mixed cmds, string res)
{
  res += sprintf("%s [%s], ", capitalize(n), implode(cmds, ","));
}

void ChannelMessage(mixed msg)
{
  string ret, mesg;
  mixed lag;
  int max, rekord, u, urekord, t;
  string tmp;

  if(msg[1] == this_object() || !stringp(msg[2]) ||
     msg[0] != CMNAME || previous_object() != this_object()) return;
  mesg = lower_case(msg[2]);
  if(!strstr("hilfe", mesg) && strlen(mesg) <= 5)
    ret = "Folgende Kommandos gibt es: hilfe, lag, up[time], statistik, bann";
  else
  if(!strstr("lag", mesg) && strlen(mesg) <= 3)
  {
//    lag = "/p/service/kirk/obj/lag-o-daemon"->read_lag_data();
//    ret = sprintf("Lag: %.1f%%/60, %.1f%%/15, %.1f%%/1",
//                  lag[0], lag[1], lag[2]);
    call_out(#'send/*'*/, 2, CMNAME, this_object(), ret);
    ret = query_load_average();
  } else
  if(!strstr("uptime", mesg) && strlen(mesg) <= 6)
  {
    if(file_size("/log/statistics/maxusers") <= 0) 
      call_other("/secure/service","update_maxusers");
    sscanf(read_file("/log/statistics/maxusers.today"), "%d %s", max, tmp);
    sscanf(read_file("/log/statistics/maxusers"), "%d %s", rekord, tmp);

    call_other("/secure/service","update_maxuptime");
    sscanf(read_file("/log/statistics/uptime"), 
      "uptime: %d\nuptime record %d at %d\n"
      ,u , urekord, t);
    
    ret = sprintf(
      "Uptime: %s (Rekord %s)\n"
      "Spieler: %d, max heute %d (Rekord %d)\n",
      uptime(), 
      time2string("%d Tage, %h Stunden, %m Minuten, %s Sekunden",urekord),
      sizeof(users()), max, rekord);
  } else
  if(!strstr("statistik", mesg) && strlen(mesg) <= 9)
  {
    ret = sprintf(
    "Im Moment sind insgesamt %d Ebenen mit %d Teilnehmern aktiv.\n"
    "Der %s wurde das letzte mal am %s von %s neu gestartet.\n"
    "Seitdem wurden %d Ebenen neu erzeugt und %d zerstoert.\n",
    m_sizeof(channels), CountUser(channels), CMNAME,
    dtime(stats["time"]), stats["boot"], stats["new"], stats["dispose"]);
  } else
  if(!strstr(mesg, "bann"))
  {
    string pl, cmd;
    if(mesg == "bann")
      if(m_sizeof(channelB))
      {
  ret = "";
  walk_mapping(channelB, #'banned/*'*/, &ret);
  ret = "Fuer folgende Spieler besteht ein Bann: " + ret;
      } else ret = "Zur Zeit ist kein Bann aktiv.";
    else
    if(sscanf(mesg, "bann %s %s", pl, cmd) == 2 &&
       IS_ARCH(msg[1]))
    {
#     define CMDS ({C_FIND, C_LIST, C_JOIN, C_LEAVE, C_SEND, C_NEW})
      pl = lower_case(pl); cmd = lower_case(cmd);
      if(member(CMDS, cmd) != -1)
      {
  if(!pointerp(channelB[pl])) channelB[pl] = ({});
  if(member(channelB[pl], cmd) != -1)
    channelB[pl] -= ({ cmd });
  else
    channelB[pl] += ({ cmd });
  ret = "Fuer '"+capitalize(pl)+"' besteht "
      + (sizeof(channelB[pl]) ?
         "folgender Bann: "+implode(channelB[pl], ", ") :
         "kein Bann mehr.");
  if(!sizeof(channelB[pl])) channelB = m_delete(channelB, pl);
  save_object(CHANNEL_SAVE);
      }
      else ret = "Das Kommando '"+cmd+"' ist unbekannt. Erlaubte Kommandos: "
         + implode(CMDS, ", ");
    }
    else
      if(!IS_ARCH(msg[1])) return;
      else ret = "Syntax: bann <name> <kommando>";
  }
  else return;
  call_out(#'send/*'*/, 2, CMNAME, this_object(), ret);
}

// setup() -- set up a channel and register it
//            arguments are stored in the following order:
//            ({ channel name,
//               receive level, send level,
//               flags,
//               description,
//               master obj
//            })
private void setup(mixed c)
{
  closure cl;
  object m;
  string d;
  d = "- Keine Beschreibung -";
  m = this_object();
  if(sizeof(c) && strlen(c[0]) > 1 && c[0][0] == '\\')
    c[0] = c[0][1..];

  switch(sizeof(c))
  {
  case 6:
    if(!(m = (catch(c[5]->LOADME()), find_object(c[5]))))
      m = this_object();
  case 5: d = stringp(c[4]) || closurep(c[4]) ? c[4] : d;
  case 4: admin[c[0], FLAG] = to_int(c[3]);
  case 3: admin[c[0], SEND] = to_int(c[2]);
  case 2: admin[c[0], RECV] = to_int(c[1]);
    break;
  case 0:
  default:
    return;
  }
  switch(new(c[0], m, d))
  {
  case E_ACCESS_DENIED:
    log_file("CHANNEL", sprintf("[%s] %s: %O: error, access denied\n",
                           dtime(time()), c[0], m));
    break;
  default:
    break;
  }
  return;
}

void initialize()
{
  mixed tmp;
  tmp = read_file(CHANNELDINIT);
  tmp = regexp(explode(tmp, "\n"), "^[^#]");
  tmp = map_array(tmp, #'regexplode/*'*/, "[^:][^:]*$|[ \\t]*:[ \\t]*");
  tmp = map_array(tmp, #'regexp/*'*/, "^[^: \\t]");
  map_array(tmp, #'setup/*'*/);
}

// BEGIN OF THE CHANNEL MASTER IMPLEMENTATION

#define MAX_HIST_SIZE   40
#define MAX_CHANNELS    50

void create()
{
  seteuid(getuid());
  restore_object(CHANNEL_SAVE);
  if(!channelC) channelC = ([]);
  if(!channelB) channelB = ([]);
  channels = ([]);
  channelH = ([]);
  stats = (["time": time(),
            "boot": capitalize(getuid(previous_object())||"<Unbekannt>")]);
  new(CMNAME, this_object(), "Zentrale Informationen zu den Ebenen");
  initialize();
  map_objects(efun::users(), "RegisterChannels");
  this_object()->send(CMNAME, this_object(),
                      sprintf("%d Ebenen mit %d Teilnehmern initialisiert.",
                              m_sizeof(channels),
                              CountUser(channels)));
}

private int channel_to(string key, mapping m)
{
  if ( !objectp(m[key][I_MASTER]) 
    || !interactive(m[key][I_MASTER]) 
    || m[key][I_TIMEOUT] + DYNAMIC_TIMEOUT < time()) 
    return 0;
  else
  {
    this_object()->send(key, this_object(),
      sprintf("Die Ebene wurde seit %s nicht mehr genutzt und loest sich "
              "somit auf.",
              time2string("%h %H",DYNAMIC_TIMEOUT)));
    this_object()->send(CMNAME, this_object(),
      sprintf("Die Ebene %s wurde seit %s nicht mehr genutzt und loest sich "
              "somit auf.",
              m[key][I_NAME],time2string("%h %H",DYNAMIC_TIMEOUT)));
    return 1;
  }
}

// reset() and cache_to() - Cache Timeout, remove timed out cached channels
// SEE: new, send
private int cache_to(string key, mapping m)
{
  if(!pointerp(m[key]) || ((m[key][2] + CACHED_TIMEOUT) > time())) return 1;
}
varargs void reset(int nonstd)
{
  map_array(m_indices(filter_mapping(channels, #'channel_to/*'*/, channels)),
            #'remove/*'*/,this_object());
  channelC = filter_mapping(channelC, #'cache_to/*'*/, channelC);
}

// query_prevent_shadow() -- no shadowing!
// SEE: /secure/master
int query_prevent_shadow(object po) { return 1; }

// name() - define the name of this object.
string name() { return "<MasteR>"; }

// access() - check access by looking for the right argument types and
//            calling access closures respectively
// SEE: new, join, leave, send, list, users
varargs private int access(mixed ch, object pl, string cmd, string txt)
{
  mixed co, m;
  if(!stringp(ch) || !strlen(ch = lower_case(ch)) || !channels[ch])
    return 0;
  if((stringp(channels[ch][I_MASTER]) &&
      previous_object() == find_object(channels[ch][I_MASTER])) ||
     !channels[ch][I_ACCESS] ||
     (!extern_call() && previous_object() == this_object()) ||
     ((string)previous_object()) == "/secure/master")
    return 2;
  if(!objectp(pl) || 
     (previous_object() != pl && !(previous_object() == this_object()))) 
     return 0;
  if(pointerp(channelB[getuid(pl)]) &&
     member(channelB[getuid(pl)], cmd) != -1)
    return 0;
  if(stringp(channels[ch][I_MASTER]) &&
     (!(m = find_object(channels[ch][I_MASTER])) ||
      (!to_object(channels[ch][I_ACCESS]) ||
       get_type_info(channels[ch][I_ACCESS])[1])))
  {
    string err;
    if(!objectp(m)) err = catch(call_other(channels[ch][I_MASTER], "?"));
    if(!err &&
       ((!to_object(channels[ch][I_ACCESS]) ||
         get_type_info(channels[ch][I_ACCESS])[1]) &&
        !closurep(channels[ch][I_ACCESS] =
                  symbol_function("check",
                                  find_object(channels[ch][I_MASTER])))))
    {
      log_file("CHANNEL", sprintf("[%s] %O -> %O\n",
                                  dtime(time()), channels[ch][I_MASTER],
                                  err));
      channels = m_delete(channels, ch);
      return 0;
    }
    this_object()->join(ch, find_object(channels[ch][I_MASTER]));
  }
  if(closurep(channels[ch][I_ACCESS]))
      return funcall(channels[ch][I_ACCESS],
                     channels[ch][I_NAME], pl, cmd, &txt, 
                     channels[ch][I_INVITED]);
  return 1;
}

// new() - create a new channel
//         a channel with name 'ch' is created, the player is the master
//         info may contain a string which describes the channel or a closure
//         to display up-to-date information, check may contain a closure
//         called when a join/leave/send/list/users message is received
// SEE: access

#define IGNORE  "^/xx"

varargs int new(string ch, object pl, mixed info)
{
  mixed pls;
  int timeout;
  string * invited;

  if(!objectp(pl) || !stringp(ch) || !strlen(ch) || channels[lower_case(ch)] ||
     (pl == this_object() && extern_call()) ||
     m_sizeof(channels) >= MAX_CHANNELS ||
     sizeof(regexp(({ file_name(pl) }), IGNORE)) ||
     (pointerp(channelB[getuid(pl)]) &&
      member(channelB[getuid(pl)], C_NEW) != -1))
    return E_ACCESS_DENIED;
  if(!info)
    if(channelC[lower_case(ch)]) 
    {
      ch = channelC[lower_case(ch)][0];
      info = channelC[lower_case(ch)][1];
      timeout = channelC[lower_case(ch)][3];
      invited = channelC[lower_case(ch)][4];
    }
    else return E_ACCESS_DENIED;
  else channelC[lower_case(ch)] = ({ ch, info, time(), time(), 0});

  if(ch[0]=='#') {
    IRCD->join(ch);
    if(pl == find_object(IRCD)) pls = ({ pl });
    else pls = ({ pl, pl = find_object(IRCD) });
  } else pls = ({ pl });

  channels[lower_case(ch)] = ({ pls
                               ,symbol_function("check", pl) ||
                                #'check/*'*/
                               ,info
                               ,(!living(pl) &&
                                 !clonep(pl) &&
                                 pl != this_object()
                                 ? file_name(pl)
                                 : pl)
                               ,ch
                               ,timeout
                               ,invited
                             });
  channelH[lower_case(ch)] = ({});
  if(pl != this_object())
    log_file("CHANNEL.new", sprintf("[%s] %O: %O %O\n",
                                    dtime(time()), ch, pl, info));
  this_object()->send(CMNAME, pl,
                      "laesst die Ebene '"+ch+"' entstehen.", MSG_EMOTE);
  stats["new"]++;
  save_object(CHANNEL_SAVE);
}

// join() - join a channel
//          this function checks whether the player 'pl' is allowed to join
//          the channel 'ch' and add if successful, one cannot join a channel
//          twice
// SEE: leave, access
int join(string ch, object pl)
{
  if(!access(&ch, pl, C_JOIN)) return E_ACCESS_DENIED;
  if(member(channels[ch][I_MEMBER], pl) != -1) return E_ALREADY_JOINED;
  channels[ch][I_MEMBER] += ({ pl });
}

// leave() - leave a channel
//           the access check in this function is just there for completeness
//           one should always be allowed to leave a channel.
//           if there are no players left on the channel it will vanish, unless
//           its master is this object.
// SEE: join, access
int leave(string ch, mixed pl)
{
  int pos;
  if(!access(&ch, pl, C_LEAVE)) return E_ACCESS_DENIED;
  if((pos = member(channels[ch][I_MEMBER], pl)) == -1) return E_NOT_MEMBER;
  if(pl == channels[ch][I_MASTER] && sizeof(channels[ch][I_MEMBER]) > 1)
  {
    channels[ch][I_MASTER] = channels[ch][I_MEMBER][1];
    this_object()->send(ch, pl, "uebergibt die Ebene an "
             +channels[ch][I_MASTER]->name()+".", MSG_EMOTE);
  }
  channels[ch][I_MEMBER][pos..pos] = ({ });
  if(!sizeof(channels[ch][I_MEMBER]-({find_player("patryn"),find_object(IRCD)})))
    channels[ch][I_MEMBER] = ({});
  if(!sizeof(channels[ch][I_MEMBER]) &&
     (!stringp(channels[ch][I_MASTER]) ||
      channels[ch][I_MASTER] == "/secure/udp/irc"))
  {
    if(ch[0] == '#') IRCD->leave(ch);
    // delete the channel that has no members
    this_object()->send(CMNAME, pl,
                        "verlaesst als "
                        +(pl->QueryProp(P_GENDER) == 1 ? "Letzter" :
                          "Letzte")
                        +" die Ebene '"
                        +channels[ch][I_NAME]
                        +"', worauf diese sich in einem Blitz oktarinen "
                        +"Lichts aufloest.", MSG_EMOTE);
    channelC[lower_case(ch)] = ({ channels[ch][I_NAME],
                                  channels[ch][I_INFO], 
                                  time(), 
                                  channels[ch][I_TIMEOUT],
                                  channels[ch][I_INVITED] });
    channels = m_delete(channels, lower_case(ch));
    stats["dispose"]++;
    save_object(CHANNEL_SAVE);
  }
}

// send() - send a message to all recipients of the specified channel 'ch'
//          checks if 'pl' is allowed to send a message and sends if success-
//          ful a message with type 'type'
// SEE: access, ch.h
varargs int send(string ch, object pl, string msg, int type)
{
  int a;

  ch = lower_case(ch);
  if(!(a = access(&ch, pl, C_SEND, &msg))) return E_ACCESS_DENIED;
  if(a < 2 && member(channels[ch][I_MEMBER], pl) == -1) return E_NOT_MEMBER;
  if(!msg || !stringp(msg) || !strlen(msg)) return E_EMPTY_MESSAGE;
  map_objects(channels[ch][I_MEMBER] -= ({0}),
              "ChannelMessage", ({ channels[ch][I_NAME], pl, msg, type }));
  if(sizeof(channelH[ch]) > MAX_HIST_SIZE)
    channelH[ch] = channelH[ch][1..];
  channelH[ch] += ({ ({ channels[ch][I_NAME],
                         (stringp(pl)
                          ? pl
                          : (pl->QueryProp(P_INVIS)
                             ? "/("+capitalize(getuid(pl))+")$" : "")
                          + (pl->name() || "<Unbekannt>")),
                          msg+" <"+dtime(time())[<8..]+">",
                          type }) });
  channels[ch][I_TIMEOUT] = time();                          
}

// list() - list all channels, that are at least receivable by 'pl'
//          returns a mapping,
// SEE: access, channels
private void clean(string n, mixed a) { a[0] -= ({ 0 }); }
mixed list(object pl)
{
  mapping chs;

  chs = filter_mapping(channels, #'access/*'*/, pl, C_LIST);
  walk_mapping(chs, #'clean/*'*/);
  if(!sizeof(chs)) return E_ACCESS_DENIED;
  return copy_mapping(chs);
}

// find() - find a channel by its name (may be partial)
//          returns an array for multiple results and 0 for no matching name
// SEE: access
mixed find(string ch, object pl)
{
  mixed chs, s;
  if(stringp(ch)) ch = lower_case(ch);
  if(!sizeof(chs = regexp(m_indices(channels), "^"+ch+"$")))
    chs = regexp(m_indices(channels), "^"+ch);
  if((s = sizeof(chs)) > 1)
    if(sizeof(chs = filter_array(chs, #'access/*'*/, pl, C_FIND)) == 1)
      return channels[chs[0]][I_NAME];
    else return chs;
  return ((s && access(chs[0], pl, C_FIND)) ? channels[chs[0]][I_NAME] : 0);
}

// history() - get the history of a channel
// SEE: access
mixed history(string ch, object pl)
{
  if(!access(&ch, pl, C_JOIN))
    return E_ACCESS_DENIED;
  return channelH[ch] + ({});
}

// remove - remove a channel
// SEE: new
mixed remove(string ch, object pl)
{
  mixed members;
  if(previous_object() != this_object())
    if(!stringp(ch) ||
       pl != this_player() || this_player() != this_interactive() ||
       this_interactive() != previous_object() ||
       !IS_ARCH(this_interactive()))
      return E_ACCESS_DENIED;
  if(channels[lower_case(ch)]) {
    channels[lower_case(ch)][I_MEMBER] =
        filter_objects(channels[lower_case(ch)][I_MEMBER],
                       "QueryProp", P_CHANNELS);
    map_array(channels[lower_case(ch)][I_MEMBER],
        lambda(({'u/*'*/}), ({#'call_other/*'*/, 'u, /*'*/
                                   "SetProp", P_CHANNELS,
                                   ({#'-/*'*/,
                                          ({#'call_other/*'*/, 'u, /*'*/
                                                 "QueryProp", P_CHANNELS}),
                                          '({ lower_case(ch) })/*'*/,})
                                   })));
    channels = m_delete(channels, lower_case(ch));
    stats["dispose"]++;
  }
  if(!channelC[lower_case(ch)])
    return E_ACCESS_DENIED;
  channelC = m_delete(channelC, lower_case(ch));
  save_object(CHANNEL_SAVE);
}

//NEW: invite channels
int invite(string ch, object pl, object inviter, mixed who)
{
  int a, flag;
  string ret;

  ch = lower_case(ch);
  if(!(a = access(&ch, pl, C_JOIN))) return E_ACCESS_DENIED;
  if(a < 2 && member(channels[ch][I_MEMBER], pl) == -1) return E_NOT_MEMBER;
  if( ( !objectp(who) 
     && !objectp(who=find_player(who)) ) 
   || !interactive(who) ) return E_UNKNOWN_USER;

  if (!pointerp(channels[ch][I_INVITED]))
  {
    if (channels[ch][I_MASTER]!=inviter) return E_ACCESS_DENIED;
    
    channels[ch][I_INVITED] = ({map_array(channels[ch][I_MEMBER],"getuid")});
    flag = MSG_EMOTE;
    if (who != pl)
    {
      channels[ch][I_INVITED] += ({getuid(who)});
      ret = "macht die Ebene Invite-Only und laedt "+who->name(WEN)+
            " ein, die Ebene zu betreten.";
    }
    else
    {
      ret = "macht die Ebene Invite-Only";
    }
  }
  else
  {
    if (-1!=member(channels[ch][I_INVITED],getuid(who)))
    {
      ret = who->Name()+" ist bereits eingeladen, die Ebene zu betreten.";
    }
    else
    {
      channels[ch][I_INVITED] += ({getuid(who)});
      ret = inviter->Name()+" laedt "+who->name(WEN)+" ein, die Ebene zu betreten.";
    }
  }
  channelC[lower_case(ch)] = ({ channels[ch][I_NAME],
                                channels[ch][I_INFO], 
                                time(), 
                                channels[ch][I_TIMEOUT],
                                channels[ch][I_INVITED] });
  save_object(CHANNEL_SAVE);
    
  call_out(#'send/*'*/, 2, ch, pl, ret, flag);
}

int uninvite(string ch, object pl, object inviter, object who)
{
  int a;
  string ret;

  ch = lower_case(ch);
  if(!(a = access(&ch, pl, C_JOIN))) return E_ACCESS_DENIED;
  if(a < 2 && member(channels[ch][I_MEMBER], pl) == -1) return E_NOT_MEMBER;
  if( ( !objectp(who) 
     && !objectp(who=find_player(who)) ) 
   || !interactive(who) ) return E_UNKNOWN_USER;

  if (!pointerp(channels[ch][I_INVITED]))
  {
    ret = "Die Ebene ist gar nicht Invite-Only.";
  }
  else
  {
    if (-1==member(channels[ch][I_INVITED],getuid(who)))
    {
      ret = who->Name()+" ist gar nicht eingeladen, die Ebene zu betreten.";
    }
    else if (who==pl)
    {
      ret = "Ich habe das Sagen auf dieser Ebene.";
    }
    else if (-1!=member(channels[ch][I_MEMBER], who))
    {
      ret = who->Name()+" hat die Ebene betreten.";
    }
    else
    {
      ret = inviter->Name()+ " verweigert "+who->name()+", die Ebene zu betreten.";
      channels[ch][I_INVITED]-=({getuid(who)});
    }
  }
  channelC[lower_case(ch)] = ({ channels[ch][I_NAME],
                                channels[ch][I_INFO], 
                                time(), 
                                channels[ch][I_TIMEOUT],
                                channels[ch][I_INVITED] });
  save_object(CHANNEL_SAVE);
    
  call_out(#'send/*'*/, 2, ch, pl, ret);
}

mapping tellme(){return channels;}