/*******************
** Eldarea MUDLib **
********************
**
** global/daemon/debug - Debug Channel Manager
**
** CVS DATA
** $Date: 2001/01/03 16:15:14 $
** $Revision: 1.1 $
**
** Adapted from Silberland
**
** CVS History
**
** $Log: debug.c,v $
** Revision 1.1  2001/01/03 16:15:14  elatar
** added
**
**
*/

#include <daemon.h>

#define DEBUG_FILE "/"+__HOST_NAME__+".debug.log"

int eof, oldeof;

void create()
{
  if(clonep(this_object())) 
    return;
  eof = oldeof = file_size(DEBUG_FILE);
}

int check(string ch, object pl, string cmd, string txt)
{
  if(ch != "Debug") 
    return 0;
  if(objectp(pl) && query_once_interactive(pl) && query_wiz_level(pl) > 1)
  {
    switch(cmd)
    {
      case C_FIND:
      case C_LIST:
      case C_JOIN:
      case C_LEAVE:
        return 1;
      case C_SEND:
        switch(lower_case(txt))
        {
          case "help":
          case "hilfe":
	          pl->Message(
	            "[Debug:] Hilfe...\n"
		          "[Debug:] Folgende Kommandos stehen zur Verfuegung:\n"
		          "[Debug:] 'backtrace' -- sendet den Backtrace zum Fehler\n"
		          "[Debug:] 'hilfe'     -- sendet diese Hilfeseite\n");
	          break;
          case "backtrace":
          {
	          string bt;
	          
	          if(oldeof >= eof) 
	            bt = "[Debug:] Kein Backtrace verfuegbar!\n";
	          else
	            bt = "[Debug:] -- BACKTRACE BEGIN --\n"
	               + read_bytes(DEBUG_FILE, oldeof, eof - oldeof)
	               + "[Debug:] -- BACKTRACE END --\n";
	          call_out(symbol_function("Message", pl), 0, bt);
	          break;
          }
        }
    }
  }
  return 0;
}

string name() { return "<DebugMasteR>"; }

void ChannelMessage(mixed a)
{
  if(file_size(DEBUG_FILE) > eof)
  {
    oldeof = eof;
    eof = file_size(DEBUG_FILE);
  }
}

  
