/*******************
** Eldarea MUDLib **
********************
**
** global/daemon/intermud3.c - intermud3 daemon
**
** CVS DATA
** $Date: 2001/02/07 10:10:22 $
** $Revision: 1.3 $
**
** This is an intermud 3 daemon designed for Amylaar 3.2.1 muds.  It was
** created by Skylight and friends.  This requires the use of the Timewarp
** erq daemon, preferably version 1.3 or newer.
**
** CVS History
**
** $Log: intermud3.c,v $
** Revision 1.3  2001/02/07 10:10:22  elatar
** implemented SetRouterAddress()
**
** Revision 1.2  2001/02/06 08:59:46  elatar
** applied strong_types requirements
**
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/

#include <erq.h>
#include <defines.h>
#include <properties.h>
#include <daemon/intermud3.h>
#include <wizlevels.h>

// Hier kann man Remote-Services ein/ausschalten (kommentieren)
#define SERVICE_CHANNEL
//#define SERVICE_UCACHE   // Ohne Channels kein Ucache!
#define SERVICE_TELL
#define SERVICE_WHO
#define SERVICE_FINGER
//#define SERVICE_LOCATE
//#define SERVICE_EMOTETO
//#define SERVICE_AUTH
//#define SERVICE_MAIL
//#define SERVICE_FILE
//#define PORT_FTP
//#define PORT_HTTP
//#define PORT_RCP

// Zum Saven
mapping banned, muds, channels;
mixed routers;
int password, mudlist_id, channellist_id;

static mapping mud_names;
static int *ticket, data_pos;
static mixed buffer, data_size;
static string incoming_data;
static status sending;

static mixed *socket_ticket, *tickets, *buffers, *data_sizes;
static string *incoming_datas, *originator_muds, *target_muds;
static status *sendings;
static int *data_poss;
static mapping oob_queue;

// Mudlisten-Cache
static string mudlist_text;
static int    mudlist_update;

static object debugger;
#define DEBUG(x) if(objectp(debugger)) \
                   tell_object(debugger, sprintf("IMUD3: %O\n",x))

void create() {
  int i;
  string *names;

  seteuid(getuid());

  if(clonep(ME))
    raise_error("Arbeite lieber Dein Repfile ab!\n");

  banned = ([]);
  muds = ([]);
  channels = ([]);
  mud_names = ([]);
  oob_queue = ([]);
  mudlist_id = channellist_id = -1;
  buffer = ({});

  efun::restore_object(SAVE_INTERMUD);

  password=0;

  i = sizeof(names = m_indices(muds));
  while(i--)
    mud_names[implode(efun::explode(lower_case(names[i])," "),".")] = names[i];

  if(this_player())
    set_me_up();                // beim neuladen sofort
  else
    call_out("set_me_up",1800); // beim preload nach 3 Minuten
}

int SetRouterAddress(string address)
{
  if ( getuid(previous_object())!=getuid(this_interactive())
    || !IS_ARCH(this_interactive()))  
    return 0;

  routers = ({ ({ "*gjs", address }) });
  efun::save_object(SAVE_INTERMUD);
  // routers = ({ ({ "*gjs", "198.144.203.194 9000" }) });
  // routers = ({ ({ "*gjs", "208.192.43.105 9000" }) });
  // routers = ({ ({ "*gjs", "216.98.238.194 9000" }) });
  // routers = ({ ({ "*gjs", "206.151.209.131 9000" }) });  
}

static void set_me_up() {
  connect();
  listen();
}

// For a better unterstanding (Holger)
void ___debug(int on) {
  if(on) { debugger=this_player(); DEBUG("Ok. I obey to YOU!"); }
  else   { DEBUG("Ok. Have I nice day!"); debugger=0; }
}

string to_mudmode(mixed data) {
  return (string)IMUD3_BASE"intermud3/mudmode_d"->to_mudmode(data);
}

mixed from_mudmode(string data) {
  return (mixed)IMUD3_BASE"intermud3/mudmode_d"->from_mudmode(data);
}

void connect() {
  int a, b, c, d, port;
  DEBUG("Try to connect...");
  if (sscanf(routers[0][1], "%d.%d.%d.%d %d", a, b, c, d, port) != 5)
    raise_error("Bad router address.\n");
  send_erq(ERQ_OPEN_TCP, ({ a, b, c, d, port / 0x100, port & 0xFF }),
    #'read_callback);
}
 
void read_callback(mixed *data, int size) {
  string text, error;
  mixed lpc_data;
  int i, pos, tmp;

  DEBUG("read_callback:");
  DEBUG(data[0]);

  switch(data[0]) {
    case ERQ_OK:
      ticket = data[1..];
      buffer = ({ to_mudmode(
        ({ "startup-req-3", 5, MUDNAME, 0, routers[0][0], 0,
          password, mudlist_id, channellist_id, query_mud_port(),
          PORT_OOB, PORT_UDP, MUDLIB + " " + MUDLIB_VERSION, MUDLIB +
          " " + MUDLIB_VERSION, MUD_DRIVER + " " __VERSION__,
          MUD_DRIVER, MUD_STATUS, ADMIN_EMAIL, get_services(), ([]) })
          ) }) + buffer;
      data_pos = 0;
      incoming_data = 0;
      data_size = 0;
      sending = 0;
      flush();
      return;
        case ERQ_STDOUT:
            data = data[1..];
            while(sizeof(data))
             {
              if(!data_size || !intp(data_size)) // Still incomplete
               {  
                data_size = data_size || ({ });
                tmp = sizeof(data); 
                if(tmp > 4) tmp = 4;
                tmp -= sizeof(data_size);
                data_size += data[0..(tmp-1)];
                data = data[tmp..];
                if(sizeof(data_size) == 4)
                 {
                  data_size = (data_size[0] & 0xFF) * 0x1000000 +
                              (data_size[1] & 0xFF) * 0x10000 +
                              (data_size[2] & 0xFF) * 0x100 +
                              (data_size[3] & 0xFF);
                 }
               } else {
                tmp = sizeof(data);
                if(tmp > data_size) tmp = data_size;
                if(!incoming_data) incoming_data = "";
                incoming_data += to_string(data[0..(tmp-1)]);
                data = data[tmp..];
                data_size -= tmp;
                if(!data_size)
                 {
                  if (error = catch(lpc_data = from_mudmode
                   (incoming_data)))
                    log_file("INTERMUD3_PACKET", error + incoming_data +
                      "\n");
                   else {
                    if(error = catch(handle_data(lpc_data)))
                    log_file("INTERMUD3_PACKET", error + incoming_data +
                      "\n");
                   }
                  incoming_data = 0;
                  data_size = 0;
                 }
               }
             }
            return; 
    case ERQ_EXITED:
      ticket = 0;
      call_out("connect", 2);
      return;
    case ERQ_E_UNKNOWN: /* failed to connect */
      if(!ticket)
        call_out("connect", 2);
      return;
    default:
      raise_error("read_callback: unerwartete ERQ-Antwort! ("+
        to_string(data[0])+")\n");
  }
}
 
void handle_data(mixed *lpc_data) {
    string *indices;
    mixed *values;
    int i;
    DEBUG("handle_data:");
    DEBUG(lpc_data[0]);
    switch(lpc_data[0]) {
	case "startup-reply":
	    if (sizeof(lpc_data) != 8) return;
	    if (!sizeof(lpc_data[6])) return;
	    if (lpc_data[6][0][0] == routers[0][0]) {
		routers = lpc_data[6];
		password = lpc_data[7];
		efun::save_object(SAVE_INTERMUD);
	    }
	    return;
	case "mudlist":
	    if (sizeof(lpc_data) != 8) return;
            if (lpc_data[2] != routers[0][0]) return;
	    indices = m_indices(lpc_data[7]);
	    values = m_values(lpc_data[7]);
	    i = sizeof(indices);
	    while (i--) {
		if(values[i]) {
		  muds[indices[i]] = values[i];
		  mud_names[implode(efun::explode(lower_case(indices[i])," "),".")] =
                    indices[i];
		}
		else
                  if(muds[indices[i]]) {
		    m_delete(muds, indices[i]);
		    m_delete(mud_names,
                    implode(efun::explode(lower_case(indices[i]), " "), "."));
		  }
	    }
	    efun::save_object(SAVE_INTERMUD);
            mudlist_update=1; // mudlist_text muss erneuert werden
	    return;
#ifdef SERVICE_CHANNEL
	case "channel-m":
	    IMUD3_TOOLS"channel"->receive_channel_message(lpc_data);
	    return;
	case "channel-e":
	    IMUD3_TOOLS"channel"->receive_channel_emote(lpc_data);
	    return;
	case "channel-t":
	    IMUD3_TOOLS"channel"->receive_channel_target_emote(lpc_data);
	    return;
        case "chan-who-req":
            IMUD3_TOOLS"channel"->receive_channel_who_request(lpc_data);
            return;
        case "chan-who-reply":
            IMUD3_TOOLS"channel"->receive_channel_who_reply(lpc_data);
            return;
        case "chan-user-req":
            IMUD3_TOOLS"channel"->receive_channel_user_request(lpc_data);
            return;
        case "chan-user-reply":
            IMUD3_TOOLS"channel"->receive_channel_user_reply(lpc_data);
            return;
	case "chanlist-reply":
	    if (lpc_data[2] != routers[0][0]) return;
	    channellist_id = lpc_data[6];
	    indices = lpc_data[7];
	    values = m_values(lpc_data[7]);
	    channels += lpc_data[7];
	    i = sizeof(indices);
	        while (i--)
		    if (!values[i])
			efun::m_delete(channels, indices[i]);
	    efun::save_object(SAVE_INTERMUD);
	    return;
#  ifdef SERVICE_UCACHE
        case "ucache-update":
            IMUD3_TOOLS"channel"->receive_ucache_update(lpc_data);
            return;
#  endif
#endif
#ifdef SERVICE_TELL   
	case "tell":
	    IMUD3_TOOLS"tell"->receive_tell(lpc_data);
	    return;
#endif
#ifdef SERVICE_WHO
	case "who-req":
            IMUD3_TOOLS"who"->receive_who_request(lpc_data);
	    return;
	case "who-reply":
            IMUD3_TOOLS"who"->receive_who_reply(lpc_data);
	    return;
#endif
#ifdef SERVICE_FINGER
	case "finger-reply":
	    IMUD3_TOOLS"finger"->receive_finger_reply(lpc_data);
	    return;
	case "finger-req":
	    IMUD3_TOOLS"finger"->receive_finger_request(lpc_data);
	    return;
#endif
#ifdef SERVICE_LOCATE
	case "locate-req":
	    receive_locate_request(lpc_data);
	    return;
	case "locate-reply":
	    receive_locate_reply(lpc_data);
	    return;
#endif
#ifdef SERVICE_EMOTETO
	case "emoteto":
	    receive_emoteto(lpc_data);
	    return;
#endif
	case "auth-mud-req":
	    receive_auth_mud_request(lpc_data);
	    return;
	case "auth-mud-reply":
	    receive_auth_mud_reply(lpc_data);
	    return;
	case "error":
	    receive_error(lpc_data);
	    return;
	default:
	    send_tcp(({ "error", 5, MUDNAME, 0, lpc_data[2], 0, "unk-type",
	      "type '" + lpc_data[0] + "' is unrecognized", lpc_data }));
    }
}
 
void write_callback(mixed *data, int size) {
    DEBUG("write_callback:");
    DEBUG(data[0]);
    sending = 0;
    switch(data[0]) {
	case ERQ_OK:
	    if (!data_pos) data_pos = -4;
	    data_pos += MAX_SEND - sizeof(ticket);
	    if (data_pos > strlen(buffer[0]))
	    {
		data_pos = 0;
		buffer = buffer[1..];
	    }
	    flush();
	    return;
	case ERQ_E_WOULDBLOCK:
	    call_out("flush", 0);
	    return;
    }
}
 
void send_tcp(mixed arg) {
  string tmp;
  DEBUG("send_tcp:");
  tmp = to_mudmode(arg);
  buffer += ({ tmp });
  flush();
}

int remove() {
    DEBUG("Ich beende das Intermud3-Protokoll! (5 Sekunden)");
    efun::save_object(SAVE_INTERMUD);
    
    send_tcp( ({
                 "shutdown",
                 5,
                 MUDNAME,
                 0,
                 routers[0][0],
                 0,
                 0   // Restart? Weiss man nie...
              }) );
    if (ticket)
	send_erq(ERQ_KILL, ticket, 0); /* assume the response will be ERQ_OK */
    if (socket_ticket)
	send_erq(ERQ_KILL, socket_ticket, 0); /* assume again */
    // Gimme some time please, because erq is too slow...
    destruct(ME);
    return 1;
}

void flush() {
    DEBUG("flush()");
    if (find_call_out("flush") != -1 || sending || !ticket)
	return;
    if (sizeof(buffer)) {
        string tmp;   
        int *tmp_arr;   
        int size, num;  
        DEBUG("FLUSHING");
	tmp = buffer[0];
	size = strlen(tmp) + 1;
	if (data_pos)
	    tmp_arr = to_array(tmp[data_pos..data_pos + (num = MAX_SEND -
	      sizeof(ticket) - 1)]);
	else
	    tmp_arr = ({ 0, (size & 0xFFFFFF) / 0x10000, (size & 0xFFFF) /
	      0x100, size & 0xFF }) + to_array(tmp[data_pos..data_pos +
	      (num = MAX_SEND - sizeof(ticket) - 5)]);
	if (num + data_pos < strlen(tmp))
	    tmp_arr = tmp_arr[0..<2];
	send_erq(ERQ_SEND, ticket + tmp_arr, #'write_callback);
        sending = 1;
    }
}
 
mapping query_muds() {
  return deep_copy(muds);
}

string query_mudlist() {
  int i;
  mixed idx;
  if(mudlist_update || !stringp(mudlist_text)) {
    mudlist_update=0; // Update wird gemacht
    idx=sort_array(m_indices(muds), #'<);
    mudlist_text="Komplette Intermud3 MUDs-Liste ("+
      to_string((i=sizeof(idx)))+" angeschlossen):\n"
      "====================================================\n";
    for(;i--;)
      mudlist_text+=sprintf("%-34s %-15s  %:4d %s\n",
        idx[i], muds[idx[i]][1], muds[idx[i]][2], 
        (muds[idx[i]][0]<0?"OFFEN":"GESCHLOSSEN"));
  }
  return mudlist_text;
}
 
mapping query_channels() {
  return deep_copy(channels);
}
 
string get_mud_name(string str) {
  return mud_names[implode(efun::explode(lower_case(str), " "), ".")];
}

mixed * query_mud_info(string str) {
    mixed *ret;
    if (ret = muds[str]) return ret + ({});
}

#include IMUD3_TOOLS"auth.c"

static void receive_auth_mud_reply(mixed *data) {
    auth_tokens[data[2]] = data[6];
    if(member_array(data[2], originator_muds) == -1 &&
        member_array(data[2], target_muds) == -1)
      INTERMUD3->oob_connect(data[2]);
}

void listen() {
    DEBUG("Listen to network...");
    send_erq(ERQ_LISTEN, ({ PORT_OOB / 0x100, PORT_OOB & 0xFF }),
      #'listen_callback);
}

void listen_callback(mixed *data, int size) {
    int fd;
    DEBUG("listen_callback");
    DEBUG(data[0]);
    switch (data[0]) {
	case ERQ_OK:
	    socket_ticket = data[1..];
	    tickets = allocate(MAX_CONNECTIONS);
	    incoming_datas = allocate(MAX_CONNECTIONS);
	    buffers = allocate(MAX_CONNECTIONS);
	    data_poss = allocate(MAX_CONNECTIONS);
	    data_sizes = allocate(MAX_CONNECTIONS);
	    sendings = allocate(MAX_CONNECTIONS);
	    originator_muds = allocate(MAX_CONNECTIONS);
	    target_muds = allocate(MAX_CONNECTIONS);
	    return;
	case ERQ_STDOUT:
	    fd = member_array(0, tickets);
	    if (fd == -1) return; /* none left */
	    tickets[fd] = 1;
	    send_erq(ERQ_ACCEPT, socket_ticket, lambda(({ 'x, 'y }),
	      ({ #'oob_read_callback, fd, 'x, 'y })));
	    return;
    }
}

void oob_connect(string where) {
    mapping tmp;
    int a, b, c, d, new_fd;
    DEBUG("oob_connect:");
    if ((new_fd = member_array(0, tickets)) == -1) return;
    tmp = muds[where];
    sscanf(tmp[1], "%d.%d.%d.%d", a, b, c, d);
    tickets[new_fd] = 1;
    target_muds[new_fd] = where;
    send_erq(ERQ_OPEN_TCP, ({ a, b, c, d, tmp[3] / 0x100, tmp[3] & 0xFF }),
      lambda(({ 'x, 'y }), ({ #'oob_read_callback, new_fd, 'x, 'y })));
}

void oob_read_callback(mixed fd, mixed *data, int size) {
    int tmp;
    mixed lpc_data;
    string error;

    DEBUG("oob_read_callback:");
    DEBUG(data[0]);
    switch(data[0]) {
	case ERQ_OK:
	    if (target_muds[fd]) tickets[fd] = data[1..];
	    else tickets[fd] = data[7..];
	    incoming_datas[fd] = 0;
	    data_poss[fd] = 0;
	    data_sizes[fd] = 0;
	    sendings[fd] = 0;
	    if (target_muds[fd])
		buffers[fd] = ({ to_mudmode(({ "oob-begin", MUDNAME,
		  !!(tmp = auth_tokens[target_muds[fd]]), tmp })) });
	    else buffers[fd] = ({});
	    oob_flush(fd);
	    return;
	case ERQ_STDOUT:
	    data = data[1..];
	    while (sizeof(data))
	    {
		if (data_sizes[fd])
		{
		    if (pointerp(data_sizes[fd]))
		    {
			tmp = 3 - sizeof(data_sizes[fd]);
			data_sizes[fd] += data[0..tmp];
			data_sizes[fd] = (data_sizes[fd][0] & 0xFF) *
			  0x1000000 + (data_sizes[fd][1] & 0xFF) * 0x10000 +
			  (data_sizes[fd][2] & 0xFF) * 0x100 +
			  (data_sizes[fd][3] & 0xFF);
			incoming_datas[fd] = "";
			data = data[tmp + 1..];
			continue;
		    }
		    tmp = data_sizes[fd] - strlen(incoming_datas[fd]);
		    incoming_datas[fd] += to_string(data[0..tmp - 1]);
		    if (strlen(incoming_datas[fd]) + 1 >= data_sizes[fd])
		    {
			if (error = catch(lpc_data = from_mudmode(incoming_datas[fd])))
			    log_file("INTERMUD3_PACKET", error +
			      incoming_datas[fd] + "\n");
			else
			    catch(handle_oob_data(fd, lpc_data));
			incoming_datas[fd] = 0;
			data_sizes[fd] = 0;
		    }
		    data = data[tmp..];
		    continue;
		}
		data_sizes[fd] = data[0..3];
		data = data[4..];
		if (sizeof(data_sizes[fd]) == 4)
		{
		    data_sizes[fd] = (data_sizes[fd][0] & 0xFF) * 1000000 +
		      (data_sizes[fd][1] & 0xFF) * 0x10000 + (data_sizes[fd][2]
		      & 0xFF) * 0x100 + (data_sizes[fd][3] & 0xFF);
		      incoming_datas[fd] = "";
		}
	    }
	    return;
	    return;
	case ERQ_EXITED:
	    tickets[fd] = 0;
	    originator_muds[fd] = 0;
	    target_muds[fd] = 0;
	    return;
	case ERQ_E_UNKNOWN:
	    if (!pointerp(tickets[fd]))
	    {
		tickets[fd] = 0;
		originator_muds[fd] = 0;
		if (target_muds[fd])
		{
		    efun::m_delete(auth_tokens, target_muds[fd]);
		    target_muds[fd] = 0;
		}
	    }
	    return;
    }
}

void oob_flush(mixed fd) {
    DEBUG("oob_flush:");
    if (sendings[fd] || !tickets[fd]) return;
    if (sizeof(buffers[fd])) {
	string tmp;
	int *tmp_arr;
	int size, num;
	tmp = buffers[fd][0];
	size = strlen(tmp) + 1;
	if (data_poss[fd])
	    tmp_arr = to_array(tmp[data_poss[fd]..data_poss[fd] + (num = MAX_SEND
	      - sizeof(tickets[fd]) - 1)]);
	else
	    tmp_arr = ({ 0, (size & 0xFFFFFF) / 0x10000, (size & 0xFFFF) /
	      0x100, size & 0xFF }) + to_array(tmp[data_poss[fd]..data_poss[fd]
	      + (num = MAX_SEND - sizeof(tickets[fd]) - 5)]);
	if (num + data_poss[fd] < strlen(tmp))
	    tmp_arr = tmp_arr[0..<2];
	send_erq(ERQ_SEND, tickets[fd] + tmp_arr, lambda(({ 'x, 'y }),
	  ({ #'oob_write_callback, fd, 'x, 'y })));
	sendings[fd] = 1;
    }
}

void oob_write_callback(mixed fd, mixed *data, int size) {
    DEBUG("oob_write_call_back:");
    DEBUG(data[0]);
    sendings[fd] = 0;
    switch(data[0]) {
	case ERQ_OK:
	    if (!data_poss[fd]) data_poss[fd] = -4;
	    data_poss[fd] += MAX_SEND - sizeof(tickets[fd]);
	    if (data_poss[fd] > strlen(buffers[fd][0]))
	    {
		data_poss[fd] = 0;
		buffers[fd] = buffers[fd][1..];
	    }
	    oob_flush(fd);
	    return;
	case ERQ_E_WOULDBLOCK:
	    call_out("oob_flush", 0, fd);
	    return;
    }
}

void send_oob_tcp(string where, mixed arg) {
    DEBUG("send_oob_tcp:");
    if (oob_queue[where]) oob_queue[where] += ({ to_mudmode(arg) });
    else oob_queue[where] = ({ to_mudmode(arg) });
    if (member_array(where, originator_muds) == -1 && member_array(where,
      target_muds))
    {
	if (muds[where][11]["auth"])
	    send_tcp(({ "auth-mud-req", 5, MUDNAME, 0, where, 0 }));
	else
	{
	    send_tcp(({ "oob-req", 5, MUDNAME, 0, where, 0 }));
	    call_out("oob_connect", where, 2);
	}
    }
}

void handle_oob_data(mixed fd, mixed *lpc_data) {
    mapping tmp;
    DEBUG("handle_oob_data:");
    switch(lpc_data[0]) {
	case "oob-begin":
	    if (target_muds[fd]) {
//		mapping tmp;
		if (tmp = oob_queue[target_muds[fd]])
		{
		    buffers[fd] += tmp;
		    efun::m_delete(oob_queue, target_muds[fd]);
		}
		buffers[fd] += ({ to_mudmode(({ "oob-end", MUDNAME })) });
		oob_flush(fd);
	    }
	    else
	    {
#ifdef SERVICE_AUTH
		string originator;
		if (originator = our_auth_tokens[lpc_data[3]])
		    originator_muds[fd] = originator;
		else
		    return send_erq(ERQ_KILL, tickets[fd], 0);
#else
		originator_muds[fd] = lpc_data[1];
#endif
		buffers[fd] += ({ to_mudmode(({ "oob-begin", MUDNAME, 0, 0 }))
		  });
		oob_flush(fd);
	    }
	    return;
	case "oob-end":
	    if (target_muds[fd])
	    {
		if (tmp = oob_queue[target_muds[fd]])
		{
		    buffers[fd] += tmp + ({ to_mudmode(({ "oob-end", MUDNAME })) });
		    efun::m_delete(oob_queue, target_muds[fd]);
		    oob_flush(fd);
		}
		else
		{
		    send_erq(ERQ_KILL, tickets[fd], 0);
		    return;
		}
	    }
	    else if (originator_muds[fd])
	    {
		if (tmp = oob_queue[originator_muds[fd]])
		{
		    buffers[fd] += tmp;
		    efun::m_delete(oob_queue, originator_muds[fd]);
		}
		buffers[fd] += ({ to_mudmode(({ "oob-end", MUDNAME })) });
		oob_flush(fd);
	    }
	    return;
	default:
	    if (!originator_muds[fd] && !target_muds[fd]) return;
    }
    switch(lpc_data[0])
    {
	case "mail":
	    receive_mail(lpc_data, originator_muds[fd] || target_muds[fd]);
	    return;
	case "mail-ack":
	    receive_mail_acknowledge(lpc_data, originator_muds[fd] ||
	      target_muds[fd]);
	    return;
	case "file-list-req":
	    receive_file_list_request(lpc_data);
	    return;
	case "file-list-reply":
	    receive_file_list_reply(lpc_data);
	    return;
	case "file-put":
	    receive_file_put_request(lpc_data);
	    return;
	case "file-put-ack":
	    receive_file_put_acknowledge(lpc_data, originator_muds[fd] ||
	      target_muds[fd]);
	    return;
	case "file-get-req":
	    receive_file_get_request(lpc_data);
	    return;
	case "file-get-reply":
	    receive_file_get_reply(lpc_data, originator_muds[fd] ||
	      target_muds[fd]);
	    return;
	default:
    }
}

#include IMUD3_BASE"intermud3/error.c"
#include IMUD3_BASE"intermud3/mail.c"
#include IMUD3_BASE"intermud3/file.c"

mapping get_services() {
    return ([
#ifdef SERVICE_CHANNEL
	"channel" : 1,
#endif
#ifdef SERVICE_TELL
	"tell" : 1,
#endif
#ifdef SERVICE_WHO
	"who" : 1,
#endif
#ifdef SERVICE_FINGER
	"finger" : 1,
#endif
#ifdef SERVICE_LOCATE
	"locate" : 1,
#endif
#ifdef SERVICE_EMOTETO
	"emoteto" : 1,
#endif
#ifdef SERVICE_UCACHE
	"ucache" : 1,
#endif
#ifdef SERVICE_AUTH
	"auth" : 1,
#endif
#ifdef SERVICE_MAIL
	"mail" : 1,
#endif
#ifdef SERVICE_FILE
	"file" : 1,
#endif
#ifdef PORT_FTP
	"ftp" : PORT_FTP,
#endif
#ifdef PORT_HTTP
	"http" : PORT_HTTP,
#endif
#ifdef PORT_RCP
	"rcp" : PORT_RCP,
#endif
    ]);
}
