/*******************
** Eldarea MUDLib **
********************
**
** global/daemon/intermud3/channel.c - channel service
**
** CVS DATA
** $Date: 2001/02/06 08:59:00 $
** $Revision: 1.2 $
**
** created by Skylight and friends.
**
** CVS History
**
** $Log: channel.c,v $
** Revision 1.2  2001/02/06 08:59:00  elatar
** applied strong_types requirements
**
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/

#include <daemon/intermud3.h>

private static string *local_channels, *global_channels;
private static mapping ucache;

void create() {
  local_channels = ({ "intergossip", "intercode" }),
  global_channels = ({ "imud_gossip", "imud_code" });
  ucache = ([]);
}

void local_channel_name(string arg) {
    int p;
    if ((p = member_array(arg, global_channels)) == -1)
	return arg;
    return local_channels[p];
}

void global_channel_name(string arg) {
    int p;
    if ((p = member_array(arg, local_channels)) == -1)
	return arg;
    return global_channels[p];
}

string receive_channel_message(mixed *data) {
    string tmp;
    tmp = local_channel_name(data[6]);
    if (data[2] == MUDNAME) return;
    filter_objects(users(), "receive_channel", tmp, sprintf("[%s] %s@%s: %s\n",
      capitalize(tmp), data[7], data[2], data[8]));
}

void send_channel_message(string name, string chan, string msg) {
    filter_objects(users(), "receive_channel", chan, sprintf("[%s] %s: %s\n",
      capitalize(chan), name, msg));
    INTERMUD3->send_tcp(({ "channel-m", 5, MUDNAME, lower_case(name), 0, 0,
      global_channel_name(chan), name, msg }));
}

void write_emote(string name, string chan, string msg) {
    string *broken;
    if (sizeof(broken = explode(" " + msg + " ", "$N")) > 1)
	msg = implode(broken, name)[1..<2];
    else
	msg = name + " " + msg;
    filter_objects(users(), "receive_channel", chan, "[" + capitalize(chan) +
      "] " + msg + "\n");
}

void receive_channel_emote(mixed *data) {
    if (data[2] == MUDNAME) return;
    write_emote(data[7] + "@" + data[2], local_channel_name(data[6]), data[8]);
}

void send_channel_emote(string name, string chan, string msg) {
    write_emote(name, chan, msg);
    INTERMUD3->send_tcp(({ "channel-e", 5, MUDNAME, lower_case(name), 0, 0,
      global_channel_name(chan), name, msg }));
}

void receive_channel_target_emote(mixed *data) {
    string tmp, name;
    if (data[2] == MUDNAME) return;
    tmp = local_channel_name(data[6]);
    name = data[11] + "@" + data[2];
    if (data[7] == MUDNAME) {
	object ob;
	if (ob = find_player(data[8]))
	    ob -> receive_channel(tmp, implode(explode(sprintf("[%s] %s\n",
	      capitalize(tmp), data[10]), "$N"), name));
	    INTERMUD3->send_tcp(({ "error", 5, MUDNAME, 0, data[2], data[3], "unk-user",
	      "No player with that name.", data }));
	filter_objects(users() - ({ ob }), "receive_channel", tmp,
	  implode(explode(implode(explode(sprintf("[%s] %s\n", capitalize(tmp),
	  data[9]), "$N"), name), "$O"), data[12]));
    }
    filter_objects(users(), "receive_channel", tmp, implode(explode(implode
      (explode(sprintf("[%s] %s\n", capitalize(tmp), data[9]), "$N"),
      name), "$O"), data[12] + "@" + data[7]));
}

void receive_channel_who_reply(mixed *data) {
    object ob;
    if (ob = find_player(data[5])) {
	string str;
	str = local_channel_name(data[6]);
	if (sizeof(data[7]))
	    tell_object(ob, "Listening to " + str + " at " + data[2] + ": " +
	      implode(data[7], " ") + ".\n");
	else
	    tell_object(ob, "Nobody is listening to " + str + " at " +
	      data[2] + ".\n");
    }
}

void receive_channel_who_request(mixed *data) {
#if 0
    INTERMUD3->send_tcp(({ "chan-who-reply", 5, MUDNAME, 0, data[2], data[3], data[6],
      map_objects(filter_objects(filter_objects(users(), "receive_channel",
	local_channel_name(data[6]), ""), "short"), "query_name") }));
#endif
}

void send_channel_who_request(string chan, mixed where) {
    INTERMUD3->send_tcp(({ "chan-who-req", 5, MUDNAME, this_player() -> query_real_name(),
      where, 0, global_channel_name(chan) }));
}

static void receive_channel_user_request(mixed *data) {
#if 0
    object ob;
    if (ob = find_player(data[6]))
	INTERMUD3->send_tcp(({ "chan-user-reply", 5, MUDNAME, 0, data[2], 0, data[6],
	  ob -> query_name(), ob -> query_gender() }));
    else
	INTERMUD3->send_tcp(({ "error", 5, MUDNAME, 0, data[2], 0, "unk-user",
	  "No player with that name.", data }));
#endif
}

void receive_channel_user_reply(mixed *data) {
    ucache[data[6] + "@" + data[2]] = ({ data[7], data[8] });
}

#ifdef SERVICE_UCACHE

void receive_ucache_update(mixed *data) {
    receive_channel_user_reply(data);
}

void send_ucache_update(object ob) {
    INTERMUD3->send_tcp(({ "ucache-update", 5, MUDNAME, 0, 0, 0, ob -> query_real_name(),
      ob -> query_name(), ob -> query_gender() }));
}

#endif
