/*******************
** Eldarea MUDLib **
********************
**
** global/daemon/intermud3/file.c - file service
**
** CVS DATA
** $Date: 2001/02/06 08:59:00 $
** $Revision: 1.2 $
**
** created by Skylight and friends.
**
** CVS History
**
** $Log: file.c,v $
** Revision 1.2  2001/02/06 08:59:00  elatar
** applied strong_types requirements
**
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/

// #define SERVICE_FILE       // Neee. Das wolln mer net! (Holger)

static void receive_file_list_request(mixed *data) {
    tell_object(find_player("hanzou"), "1");
    send_oob_tcp(data[1], ({ "file-list-reply", data[2], get_dir("/ftp/" +
      data[3] + "/.", 7) }));
    tell_object(find_player("hanzou"), "2");
}

/* most of the following code is copied from the ls() simul efun */
static void receive_file_list_reply(mixed *data) {
    object ob;
    int max, i, len, tmp;
    status trunc_flag;
    mixed *dir;
    ob = find_player(data[1]);
    if (!ob) return;
    dir = data[2];
    if (!dir) {
	tell_object(ob, "No such directory.\n");
	return;
    }
    if (sizeof(dir) > 999)
    {
	dir = dir[0..998];
	trunc_flag = 1;
    }
    for(i = sizeof(dir); i-- && i--; ) {
	if(dir[i--] == -2)
	    dir[i]+="/";
	len = strlen(dir[i]);
	if (len > max)
	    max = len;
    }
    ++max;
    if (max > 79)
	max = 79;
    for (i=0; i < sizeof(dir); i+=3) {
	string name;
	name = dir[i];
	tmp = strlen(name);
	if (len + tmp > 79) {
	    len = 0;
	    tell_object(ob, "\n");
	}
	tell_object(ob, name);
	if (len + max > 79) {
	    tell_object(ob, "\n");
	    len = 0;
	} else {
	    tell_object(ob, extract(
"                                                                                ",
		80-max+tmp));
	    len += max;
	}
    }
    tell_object(ob, "\n");
    if (trunc_flag) tell_object(ob, "***TRUNCATED***\n");
}

void send_file_list_request(mixed where, string arg)
{
    send_oob_tcp(where, ({ "file-list-req", MUDNAME, this_player() ->
      query_real_name(), arg }));
}

static void receive_file_put_request(mixed *data)
{
    string fname;
    int success;
    fname = __MASTER_OBJECT__ -> valid_write("/ftp/" + data[4], 0,
      "write_file", this_object());
    if (fname)
    {
	if (catch(success = write_file("/" + fname, data[5])))
	    success = -1;
    }
    else
	success = -3;
    send_oob_tcp(data[2], ({ "file-put-ack", data[1], success }));
}

static mapping file_put_id = ([]);

static void receive_file_put_acknowledge(mixed *data, string mud)
{
    object ob;
    mixed *x;
    string msg;
    if (!(x = file_put_id[data[1]])) return;
    if (!(ob = x[0])) return;
    msg = sprintf("%s to %s@%s: ", x[2], x[1], mud);
    switch (data[2])
    {
	case  1: msg += "Ok.\n"; break;
	case -3: msg += "Write permission denied.\n"; break;
	case -1: msg += "File path error.\n"; break;
	default: msg += "Unknown error.\n";
    }
    tell_object(ob, msg);
    efun::m_delete(file_put_id, data[1]);
}

void send_file_put_request(mixed where, string remote_fname, mixed contents, string local_fname)
{
    int new_id;
    new_id = time();
    while (file_put_id[new_id]) ++new_id;
    file_put_id[new_id] = ({ this_player(), remote_fname, local_fname });
    send_oob_tcp(where, ({ "file-put", new_id, MUDNAME, this_player() ->
      query_real_name(), remote_fname, contents }));
}

static void receive_file_get_request(mixed *data)
{
    string fname, contents;
    int success;
    fname = __MASTER_OBJECT__ -> valid_read("/ftp/" + data[4], 0, "read_file",
      this_object());
    if (fname)
    if (fname)
    {
	if (contents = read_file("/" + fname))
	    success = 1;
	else
	    success = -1;
    }
    else
	success = -2;
    send_oob_tcp(data[2], ({ "file-get-reply", data[1], success, contents }));
}

static mapping file_get_id = ([]);

static void receive_file_get_reply(mixed *data, string mud)
{
    object ob;
    mixed *x;
    string msg;
    if (!(x = file_get_id[data[1]])) return;
    if (!(ob = x[0])) return;
    msg = sprintf("%s@%s to /ftp/%s: ", x[1], mud, x[2]);
    switch (data[2])
    {
	case  1:
	    if (write_file("/ftp/" + x[2], data[3]))
		msg += "Ok.\n";
	    else msg += "Write permission denied.\n";
	    break;
	case -2: msg += "Read permission denied.\n"; break;
	case -1: msg += "File path error.\n"; break;
	default: msg += "Unknown error.\n";
    }
    tell_object(ob, msg);
    efun::m_delete(file_get_id, data[1]);
}

void send_file_get_request(mixed where, string remote_fname, string local_fname)
{
    int new_id;
    new_id = time();
    while (file_get_id[new_id]) ++new_id;
    file_get_id[new_id] = ({ this_player(), remote_fname, local_fname });
    send_oob_tcp(where, ({ "file-get-req", new_id, MUDNAME, this_player() ->
      query_real_name(), remote_fname }));
}
