/*******************
** Eldarea MUDLib **
********************
**
** global/daemon/intermud3/finger.c - finger service
**
** CVS DATA
** $Date: 2001/02/06 08:59:00 $
** $Revision: 1.3 $
**
** created by Skylight and friends.
**
** CVS History
**
** $Log: finger.c,v $
** Revision 1.3  2001/02/06 08:59:00  elatar
** applied strong_types requirements
**
** Revision 1.2  2000/12/01 15:24:31  elatar
** debug message implemented
**
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/

#include <properties.h>
#include <wizlevels.h>
#include <daemon/intermud3.h>

// Datum der Eintragung des ersten Logins ("Sun Aug 1 00:00:00 1999")
#define LOGINDATE 933458400

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")

private mixed finger(string str) {
  object ob;
  int idle, i;
  string nam, title, called_from_ip, level, logintime, plan;
  
  if((ob=find_player(str)) && !(ob->QueryProp(P_INVIS))) {
    title          = ob->short()[0..<3];
    called_from_ip = country(ob);   // noe
    nam            = ob->name(WER);
    idle           = query_idle(ob);
    logintime=((i=ob->QueryProp(P_CREATION_DATE))>LOGINDATE &&
      (sscanf(str, "gast%d", i)!=1) ?
      "vor dem 01.08.1999." : dtime(i)+".");
    if(IS_LEARNER(ob))
      level = to_string(query_wiz_level(ob))+" (Magier)";
    else
      level = to_string(ob->QueryProp(P_LEVEL));
  }
  else {
    if(file_size("/save/"+str[0..0]+"/"+str+".o")<1)
      return 0;
    idle = -1;
    nam=capitalize(str);
    title=nam+" ist nicht anwesend.";
    logintime=dtime(file_date("/save/"+str[0..0]+"/"+str+".o"));
  }
  if(IS_LEARNER(ob))
    plan=read_file("/players/"+str+"/.plan");
  if(!stringp(plan))
    plan=read_file("/etc/"+str+".plan");
  if(stringp(plan)) plan="Plan:\n"+plan;
  return ({ nam,            // (string) visname
            title,          // (string) title
            0,              // (string) real_name
            0,              // (string) e_mail
            logintime,      // (string) loginout_time
            idle,           // (int)    idle
            called_from_ip, // (string) ip_name
            level,          // (string) level
            plan            // (string) extra
         });
}

void receive_finger_request(mixed data) {
  mixed *ret;
  if(!(ret=finger(data[6])))
    INTERMUD3->send_tcp(({ "error", 5, MUDNAME, 0, data[2], data[3],
      "unk-user","Kein Spieler dieses Namens bekannt.", data }));
  else
    INTERMUD3->send_tcp(({ "finger-reply", 5, MUDNAME, 0, data[2], 
      data[3]}) + ret);
}

void receive_finger_reply(mixed data) {
  object ob;
  if (!(ob = find_player(lower_case(data[5])))) return;
  tell_object(ob, "Finger Information fuer " + data[6] + " vom " + 
    data[2]+":\n");
  if(data[7] && data[8])
    tell_object(ob, data[7] + " (" + data[8] + ")\n");
  else if (data[8])
    tell_object(ob, data[6] + " (" + data[8] + ")\n");
  else if (data[7])
    tell_object(ob, data[7] + "\n");
  else tell_object(ob, data[6] + "\n");
  if (data[9])
    tell_object(ob, "Email: " + data[9] + "\n");
  if (data[11] == -1)
    tell_object(ob, "Last logged in: " + data[10] + "\n");
  else
    tell_object(ob, "On since: " + data[10] + " (idle " + data[11] +
      " seconds).\n");
  if(data[12])
    tell_object(ob, "From: " + data[12] + "\n");
  if(data[14])
    tell_object(ob, data[14]);
}

void send_finger_request(string who, string where) {
  INTERMUD3->send_tcp(({ "finger-req", 5, MUDNAME,
    getuid(this_player()), where, 0, who }));
}
