/*******************
** Eldarea MUDLib **
********************
**
** global/daemon/intermud3/finger_d.c - collect imud3 finger-data
**
** CVS DATA
** $Date: 2001/02/06 08:59:00 $
** $Revision: 1.3 $
**
** created by Skylight and friends.
**
** CVS History
**
** $Log: finger_d.c,v $
** Revision 1.3  2001/02/06 08:59:00  elatar
** applied strong_types requirements
**
** Revision 1.2  2000/12/01 15:24:41  elatar
** debug message implemented
**
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")

string name, title, al_title, mailaddr, called_from_ip;

mixed * finger(string str)
{
    object ob;
    int idle;
    
    idle = -1;
    if ((ob = find_player(str)) && (title = ob -> short()))
    {
	called_from_ip = query_ip_name(ob);
	if (!called_from_ip) restore_object("players/" + str);
	if (sscanf(title, "%s %s (%s)", name, title, al_title) != 3)
	    sscanf(title, "%s %s", name, title);
	name = ob -> query_real_name();
	mailaddr = ob -> query_mailaddr();
	if (interactive(ob)) idle = query_idle(ob);
    }
    else
	if (!restore_object("players/" + str))
	    return 0;
    return ({ capitalize(name), capitalize(name) + " " + title, al_title,
      mailaddr, "unavailable", idle, called_from_ip, 0, 0 });
}
