/*******************
** Eldarea MUDLib **
********************
**
** global/daemon/intermud3/locate.c - locate service
**
** CVS DATA
** $Date: 2001/02/06 08:59:00 $
** $Revision: 1.2 $
**
** created by Skylight and friends.
**
** CVS History
**
** $Log: locate.c,v $
** Revision 1.2  2001/02/06 08:59:00  elatar
** applied strong_types requirements
**
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/

// #define SERVICE_LOCATE // wolln mer nich

static void receive_locate_request(mixed *data)
{
    object ob;
    if ((ob = find_player(data[6])) && ob -> short())
    {
	string state;
	int idle;
	if (interactive(ob))
	{
	    if (query_editing(ob)) state = "editing";
	    else
		if (query_input_pending(ob)) state = "input mode";
	    idle = query_idle(ob);
	}
	else
	{
	    state = "linkdead";
	    idle = -1;
	}
	send_tcp(({ "locate-reply", 5, MUDNAME, 0, data[2], data[3], MUDNAME,
	  ob -> query_name(), idle, state }));
    }
}

static void receive_locate_reply(mixed *data)
{
    object ob;
    if (stringp(data[5]) && (ob = find_player(lower_case(data[5]))))
    {
	string msg;
	msg = data[7];
	if (data[8] > 0) msg += " (idle " + data[8] + " seconds)";
	if (data[9] && data[9] != "") msg += " (" + data[9] + ")";
	tell_object(ob, msg + " was just located on " + data[6] + ".\n");
    }
}

void send_locate_request(string who)
{
    send_tcp(({ "locate-req", 5, MUDNAME, this_player() -> query_real_name(),
      0, 0, who }));
}
