/*******************
** Eldarea MUDLib **
********************
**
** global/daemon/intermud3/mail.c - mail service
**
** CVS DATA
** $Date: 2001/02/06 08:59:00 $
** $Revision: 1.2 $
**
** created by Skylight and friends.
**
** CVS History
**
** $Log: mail.c,v $
** Revision 1.2  2001/02/06 08:59:00  elatar
** applied strong_types requirements
**
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/

// #define SERVICE_MAIL // funktioniert eh noch nich

static mapping mail_id = ([]);

void send_mail(string * bcc_list, string where, string * to, string * cc, 
               string subject, string contents)
{
    mapping to_list, cc_list;
    string mud;
    int i, new_id;
    to_list = ([]);
    i = sizeof(to);
    while (i--)
    {
	if (sscanf(to[i], "%s@%s", to[i], mud) == 2)
	    if (!(mud = get_mud_name(mud))) continue;
	else
	    mud = MUDNAME;
	if (to_list[mud]) to_list[mud] += ({ to[i] });
        else to_list[mud] = ({ to[i] });
    }
    cc_list = ([]);
    i = sizeof(cc);
    while (i--)
    {
	if (sscanf(cc[i], "%s@%s", cc[i], mud) == 2)
	    if (!(mud = get_mud_name(mud))) continue;
	else
	    mud = MUDNAME;
	if (cc_list[mud]) cc_list[mud] += ({ cc[i] });
	else cc_list[mud] = ({ cc[i] });
    }
    new_id = time();
    while (mail_id[new_id]) ++new_id;
    mail_id[new_id] = this_player();
    send_oob_tcp(where, ({ "mail", new_id, this_player() -> query_name(),
      to_list, cc_list, bcc_list, time(), subject, contents }));
}

void receive_mail(mixed *data, string mud)
{
    int i, j;
    string *list, *names, *indices;
    mapping map;
    mixed *values;
    list = data[5];
    "obj/monster" -> reset(); /* set this_player() */
    "obj/monster" -> set_name(capitalize(data[2]) + "@" + mud);
    map = data[3];
    map += data[4];
    indices = m_indices(map);
    values = m_values(map);
    i = sizeof(indices);
    names = ({});
    while (i--)
    {
	j = sizeof(values[i]);
	while (j--)
	    names += ({ values[i][j] + "@" + indices[i] });
    }
    i = 0;
    while (i < sizeof(list))
    {
	"obj/mail_reader" -> send_mail(list[i], data[7], data[8],
	  implode(names - ({ list[i] + "@" + MUDNAME }), " "));
	++i;
    }
    send_oob_tcp(mud, ({ "mail-ack", ([ data[1] : ({}) ]) }));
/* "mail-ack" should contain acknowledgements of multiple mail sendings.
 * but that's to do under this system so currently each mail acknowledgement
 * is sent seperately.
 */
}

void receive_mail_acknowledge(mixed *data, string mud)
{
    int i, *indices;
    mixed *values;
    
    indices = m_indices(data[1]);
    values = m_values(data[1]);
    while (i < sizeof(indices))
    {
	    object ob;
	    if (sizeof(values[i]) && ob = mail_id[indices[i]])
	      tell_object(ob, mud + " failed to deliver mail to: " +
	        implode(values[i], " ") + "\n");
	    efun::m_delete(mail_id, indices[i]);
	    ++i;
    }
}
