/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:43 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: player.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/
/* Okay this file is meant to just be a documentation of how the intermud 3
 * commands could look like on a 2.4.5 mud.  But if you'd like to install
 * these commands quickly, add the line:
 *
 * #include "intermud3/player.c"
 *
 * to the end of /obj/player.c
 *
 * At the end of add_standard_commands(), write the lines:
 *
 *     add_action("muds", "muds");
 *     add_action("intermud3_tell", "tell");
 *     add_action("intermud3_who", "who");
 *     add_action("intermud3_finger", "finger");
 *
 * Then at the end of wiz_commands(), write the lines:
 *
 *     add_action("locate", "locate");
 *     add_intermud3_channels();
 *
 * Then at the end of wiz_commands2(), write the lines:
 *
 *     add_action("intermud3_ls", "ls");
 *     add_action("intermud3_cp", "cp");
 */

#define INTERMUD3 IMUD3_BASE"intermud3"

mapping channels;

muds(arg)
{
    mixed *info;
    mapping muds;
    string *names;
    int i;
    if (arg)
    {
	it = INTERMUD3 -> get_mud_name(arg);
	if (!it)
	    return write("Unknown mud: " + arg + "\n"), 1;
	info = INTERMUD3 -> query_mud_info(it);
	printf("Mud type: %-10s Driver: %-20s Mudlib: %s\n",
	  info[8], info[7], info[5]);
	write("Status: " + info[9] + "\n");
	write("Services: " + implode(m_indices(info[11]), " ") + "\n");
	write("Address: " + info[1] + " " + info[2] + "\n");
	return 1;
    }
    names = m_indices(muds = INTERMUD3 -> query_muds());
    info = m_values(muds);
    while (i < sizeof(names))
    {
	if (info[i][0])
	    printf("%:-15s %:-10s %:-15s %:-15s %s %d\n", names[i], info[i][8],
	      info[i][7], info[i][5], info[i][1], info[i][2]);
	++i;
    }
    return 1;
}

/* intermud tells don't cost spell points!  might want to fix that. */
static intermud3_tell(str)
{
    string mud, real_mud;
    if (!str || sscanf(str, "%s@%s %s", it, mud, str) != 3)
	return 0;
    real_mud = INTERMUD3 -> get_mud_name(mud);
    if (!real_mud)
	return write("Unknown mud: " + mud + "\n");
    if (!INTERMUD3 -> query_mud_info(real_mud)[11]["tell"])
	return write(real_mud + " does not support intermud tells.\n"), 1;
    INTERMUD3 -> send_tell(it, real_mud, str);
    write("Ok.\n");
    return 1;
}

intermud3_who(str)
{
    if (!str || !sscanf(str, "@%s", str)) return 0;
    it = INTERMUD3 -> get_mud_name(str);
    if (!it)
	return write("Unknown mud: " + str + "\n");
    if (!INTERMUD3 -> query_mud_info(it)[11]["who"])
	return write(it + " does not support rwho.\n"), 1;
    INTERMUD3 -> send_who_request(it);
    write("Request transmitted.\n");
    return 1;
}

/* An unaltered 2.4.5 mudlib has no finger command! */
intermud3_finger(str)
{
    string who;
    if (!str || sscanf(str, "%s@%s", who, str) != 2) return 0;
    it = INTERMUD3 -> get_mud_name(str);
    if (!it)
	return write("Unknown mud: " + str + "\n");
    if (!INTERMUD3 -> query_mud_info(it)[11]["finger"])
	return write(str + " does not support intermud finger.\n"), 1;
    INTERMUD3 -> send_finger_request(who, it);
    write("Request transmitted.\n");
    return 1;
}

static locate(str)
{
    if (!str) return 0;
    INTERMUD3 -> send_locate_request(str);
    write("Request transmitted.\n");
    return 1;
}

static add_intermud3_channels()
{
    mapping x;
    string *a, *b;
    int i;
    i = sizeof(a = m_indices(x = INTERMUD3 -> query_channels()));
    b = m_values(x);
    while (i--)
	if (b[i][0] == "*")
	    add_action("intermud3_channel", INTERMUD3 -> local_channel_name
	      (a[i]));
}

static intermud3_channel(str)
{
    string verb;
    status emote;
    if (!str) return 0;
    verb = query_verb();
    if (!channels) channels = ([]);
    if (str == "/off")
    {
	efun::m_delete(channels, verb);
	write(verb + " off.\n");
	return 1;
    }
    if (str == "/on")
    {
	channels[verb] = 1;
	write(verb + " on.\n");
	return 1;
    }
    if (sscanf(str, "/who @%s", str))
    {
	it = INTERMUD3 -> get_mud_name(str);
	if (!it)
	    return write("Unknown mud: " + str + "\n"), 1;
	if (!INTERMUD3 -> query_mud_info(it)[11]["channel"])
	    return write(it + " does not support intermud channels.\n"), 1;
	INTERMUD3 -> send_channel_who_request(verb, it);
	write("Request transmitted.\n");
	return 1;
    }
    emote = sscanf(str, ":%s", str);
    if (emote)
	INTERMUD3 -> send_channel_emote(cap_name, verb, "$N " + str);
    else
	INTERMUD3 -> send_channel_message(cap_name, verb, str);
    return 1;
}

receive_message(class, msg)
{
    if (channels && channels[class])
	tell_object(this_object(), msg);
}

static ucache_update()
{
    if (level >= 20)
	INTERMUD3 -> send_ucache_update(this_object());
}

set_gender(g) { ::set_gender(g); ucache_update(); }

set_neuter() { ::set_neuter(); ucache_update(); }

set_male() { ::set_male(); ucache_update(); }

set_female() { ::set_female(); ucache_update(); }

static intermud3_ls(path)
{
    string str;
    if (sscanf(path, "%s@%s", it, path) != 2) return 0;
    str = INTERMUD3 -> get_mud_name(it);
    if (!str)
	return write("Unknown mud: " + it + "\n"), 1;
    if (!INTERMUD3 -> query_mud_info(str)[11]["file"])
	return write(str + " does not support the intermud file service.\n"), 1;
    INTERMUD3 -> send_file_list_request(str, path);
    write("Request transmitted.\n");
    return 1;
}

static intermud3_cp(str)
{
    string local_fname, remote_fname, text;
    if (!str) return 0;
    if (sscanf(str, "%s %s@%s", local_fname, remote_fname, str) == 3)
    {
	if (!(it = INTERMUD3 -> get_mud_name(str)))
	    return write("Unknown mud: " + str + "\n"), 1;
	if (!INTERMUD3 -> query_mud_info(it)[11]["file"])
	    return write(it + " does not support the intermud file service.\n"),
	      1;
	if (!(text = read_file(local_fname)))
	    return 1;
	INTERMUD3 -> send_file_put_request(it, remote_fname, text,
	  local_fname);
	write("Request transmitted.\n");
	return 1;
    }
    if (sscanf(str, "%s@%s %s", remote_fname, str, local_fname) == 3)
    {
	it = INTERMUD3 -> get_mud_name(str);
	if (!(it = INTERMUD3 -> get_mud_name(str)))
	    return write("Unknown mud: " + str + "\n"), 1;
	if (!INTERMUD3 -> query_mud_info(it)[11]["file"])
	    return write(it + " does not support the intermud file service.\n"),
	      1;
	INTERMUD3 -> send_file_get_request(it, remote_fname, local_fname);
	write("Request transmitted.\n");
	return 1;
    }
}
