/*******************
** Eldarea MUDLib **
********************
**
** global/daemon/intermud3/tell.c - tell service
**
** CVS DATA
** $Date: 2001/02/06 08:59:00 $
** $Revision: 1.2 $
**
** created by Skylight and friends.
**
** CVS History
**
** $Log: tell.c,v $
** Revision 1.2  2001/02/06 08:59:00  elatar
** applied strong_types requirements
**
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/

#include <daemon/intermud3.h>
#include <properties.h>
#include <defines.h>

#define SORRY_NAME "Root"

void receive_tell(mixed data) {
  object ob;
  string name;
  name = lower_case(data[5]);
  if(name==lower_case(SORRY_NAME)) {
    INTERMUD3->send_tcp(({ "error", 5, MUDNAME, 0, data[2], data[3],
      "unk-user", SORRY_NAME"@"MUDNAME": Ich bin der Erschaffer des "
      MUDNAME"es. Anfragen zum Intermud3-Protokoll oder zum "MUDNAME
      " an: "ADMIN_EMAIL}));
    return;
  }
  if(ob = find_player(name)) {
    if(ob->QueryProp(P_INVIS))
      INTERMUD3->send_tcp(({ "error", 5, MUDNAME, 0, data[2], data[3],
        "unk-user", SORRY_NAME"@"MUDNAME": "+
        capitalize(data[5]) +" ist leider nicht hier.", data }));
    tell_object(ob, break_string(data[7], BS_STDLEN, 
      data[6] + "@" + data[2] + " teilt Dir mit: ",BS_FOR_COMM));
  }
  else {
    INTERMUD3->send_tcp(({ "error", 5, MUDNAME, 0, data[2], data[3],
      "unk-user", SORRY_NAME"@"MUDNAME": " +
      capitalize(data[5])+" ist leider nicht hier.", data }));
  }
}

void send_tell(string who, string where, string msg) {
  INTERMUD3->send_tcp(({ "tell", 5, MUDNAME, getuid(this_player()), where,
    lower_case(who), this_player()->name(WER), msg }));
}
