/*******************
** Eldarea MUDLib **
********************
**
** global/daemon/intermud3/who.c - wholist service
**
** CVS DATA
** $Date: 2001/02/06 08:59:00 $
** $Revision: 1.2 $
**
** created by Skylight and friends.
**
** CVS History
**
** $Log: who.c,v $
** Revision 1.2  2001/02/06 08:59:00  elatar
** applied strong_types requirements
**
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/

#include <properties.h>
#include <wizlevels.h>
#include <daemon/intermud3.h>
#include <ansi.h>

void receive_who_reply(mixed data) {
  object ob;
  // string *list;
  mixed *list;
  int i, k, max, stu, min, ansi;

  if(!(ob = find_player(lower_case(data[5])))) return;
  tell_object(ob, "Intermud3 Spielerliste vom " + data[2] + ":\n" );
  list = data[6];
  for(i=sizeof(list);i--;)
    max=(max<(k=strlen(list[i][0]||"Jemand"))?k:max);
  i=0;
  if((ob->QueryProp(P_TTY))=="ansi")
    ansi=1;
  while(i < sizeof(list)) {
    stu=list[i][1]/60/60;
    min=(list[i][1]-(stu*60*60))/60;
    if(ansi) {
      if(stringp(list[i][0]))
        list[i][0]=terminal_colour(list[i][0], TERMCOL_2_ANSI);
      if(stringp(list[i][2]))
        list[i][2]=terminal_colour(list[i][2], TERMCOL_2_ANSI);
    }
    else {
      if(stringp(list[i][0]))
        list[i][0]=terminal_colour(list[i][0], TERMCOL_2_DUMB);
      if(stringp(list[i][2]))
        list[i][2]=terminal_colour(list[i][2], TERMCOL_2_DUMB);
    }
    tell_object(ob, sprintf("%*s (%:02d:%:02d idle): %s\n", max,
      list[i][0] || "Jemand", stu, min, list[i][2] || ""));
    ++i;
  }
}

private mixed who_data(object ob) {
  return ({ ob->name(), query_idle(ob), ob->short()[0..<3] });
}

private static int is_greater(object a,object b) {
  int a1,b1;
  if ((a1=query_wiz_level(a))==(b1=query_wiz_level(b)))
    if (a1>1 && b1>1)
      return getuid(a)>getuid(b);
    else
      if ((a1=a->QueryProp(P_LEVEL))==(b1=b->QueryProp(P_LEVEL)))
        return getuid(a)>getuid(b);
    else
      return a1>b1;
  else
    return a1>b1;
}

void receive_who_request(mixed data) {
  object *dumm;
  dumm=users()-filter_objects(users(), "QueryProp",P_INVIS);
  dumm=sort_array(dumm,#'is_greater);
  INTERMUD3->send_tcp(({ "who-reply", 5, MUDNAME, 0, data[2], data[3],
    map_array(dumm, #'who_data) }));
}

void send_who_request(string where) {
  INTERMUD3->send_tcp(({ "who-req", 5, MUDNAME, getuid(this_player()),
    where, 0 }));
}

