/*******************
** Eldarea MUDLib **
********************
**
** global/daemon/landscape/landscape.c - virtual landscape room object
**
** CVS DATA
** $Date: 1999/11/12 08:27:26 $
** $Revision: 1.1 $
**
** this object will be virtually created for each 
** landscaped room
**
** CVS History
**
** $Log: landscape.c,v $
** Revision 1.1  1999/11/12 08:27:26  elatar
** Initial revision, still to be optimzed
**
**
*/

#include <moving.h>
#include <properties.h>
#include <wizlevels.h>
#include <defines.h>
#include <clock.h>
#include "./landscaped.h"

inherit "/std/room";

void create()
{
  ::create();
  if(!clonep(this_object())) 
    return;
  
  SetProp(P_LIGHT,1);
  DB("Now customizing "+file_name()+" ...\n");
  previous_object()->CustomizeObject();
  DB("done\n");
}

varargs string GetExits(object viewer, int short)
{
  return "";
}

void init()
{
  int map_x,x,map_y,y;
  string file;

  if ( sscanf(file_name(),"%s#%3d:%2d|%3d:%2d",file,map_x,x,map_y,y)!=5 )
    this_player()->move(LANDSCAPED_DIR"/landscape#500:04|500:04",M_NOCHECK|M_SILENT);
  else 
    ::init();
}

string _query_int_long()
{
  int map_x,x,map_y,y;
  string file;

  sscanf(file_name(),"%s#%3d:%2d|%3d:%2d",file,map_x,x,map_y,y);
  
  return LANDSCAPED->QueryLongDesc(map_x,map_y,x,y,6);
}

string _query_int_long_night()
{
  int map_x,x,map_y,y;
  string file;

  sscanf(file_name(),"%s#%3d:%2d|%3d:%2d",file,map_x,x,map_y,y);
  
  return LANDSCAPED->QueryLongDesc(map_x,map_y,x,y,4);
}

string int_long(mixed viewer,mixed viewpoint) 
{
  string descr, x_descr;
  int i, l;

  if(l=IS_LEARNING(viewer))
    descr = (string)viewer->in_color("pfade", "[" + object_name(ME) + "]\n");
  else
    descr = "";

  x_descr = 0;

  if(UHR->IsNight()) 
  {
    if(set_light(0)>QueryProp(P_LIGHT))
      x_descr = QueryProp(P_INT_LONG_ILUM);
    if(!x_descr)
      x_descr = QueryProp(P_INT_LONG_NIGHT);
  }

  if(!x_descr)
     x_descr = QueryProp(P_INT_LONG);

  if(x_descr)
    descr += x_descr;

  // Zusatz fuer die wirklich neuen Tueren in std/room/doors.c
  else 
  {
    if(stringp(x_descr=(string)ME->QueryAllDoorLong())) 
    {
      if(descr[<1] && (descr[<1] != '\n'))
        descr += "\n";
      descr += x_descr;
    }
  }

  if(!l)
    x_descr = (string) make_invlist(viewer,
      sort_array(all_inventory()-({ viewpoint }), lambda( ({ 'x, 'y }),
        ({ #'-, ({ #'living, 'y }), ({ #'living, 'x }) }) )));
  else
    x_descr = (string) make_invlist(viewer, all_inventory()-({ viewpoint }));

  if ( x_descr != "" )
    descr += x_descr;

  return descr;
}
