/*******************
** Eldarea MUDLib **
********************
**
** global/daemon/landscape/landscaped.c  - landscape daemon
**
** CVS DATA
** $Date: 1999/11/12 08:28:50 $
** $Revision: 1.1 $
**
** the landscaped serves all data for the virtual landscape
** generation
**
** (c) 1999 by Elatar@Eldarea
**
** CVS History
**
** $Log: virtual_compiler.c,v $
** Revision 1.1  1999/11/12 08:28:50  elatar
** Initial revision, still to be optimized
**
**
*/

#include "landscaped.h"
#include <ansi.h>

static string * adesc;
// mapping with maps.
// ([key:array;priority,...])
static mapping maps;

void create()
{  // needed for presets
  adesc=allocate(MAX_LINES);
  maps=([]);
}

// checking for maps to unload
void reset()
{
  string * ind;
  int i;
  
  ind=m_indices(maps);
  for (i=sizeof(ind);i-->0;)
  {
    if ( maps[ind[i],1] < 0 )
    { // maps with priority <0 are swapped out
      m_delete(maps,ind[i]);
    }
    else
    { // all others are reduced by 1, so they would be swapped out next time 
      // if not needed
      maps[ind[i],1]--;
    }
  }
}

/////////////////////////////////
//
// load one map into cache. maps with priority -1 will be swapped out next 
// time, maps with priority 0 will stay one reset 
//
static varargs int load_map(int x, int y, int prio)
{
  string * file,filename;
  int i,j;
  string * field;
  
  filename=LANDSCAPED_DIR+sprintf("/maps/map#%3'0'd:%3'0'd.map",x,y);  
  if (file_size(filename)<1)
  {
    filename=CLEAR_MAP;
    if (file_size(filename)<1)
      return 0;
  }
  file=explode(read_file(filename),"\n");
  field=allocate(25);
  for (i=0;i<25;i++)
  {
    field[i]=file[i];
  }
  maps+=([sprintf("%3'0'd|%3'0'd",x,y):field;prio]);
  return 1;
}

///////////////////////////////////////////////////////
//
// if map is not already loaded, it will be loaded with low priority
//
static int load_map_low(int x, int y)
{
  if (!member(maps,sprintf("%3'0'd|%3'0'd",x,y)))
  {
    return load_map(x,y,-1);  
  }
  return -1;
}

int load_needed_maps(int map_x, int map_y, int x_pos, int y_pos, int r)
{
  // maps are loaded with priority 0
  if (!member(maps,sprintf("%3'0'd|%3'0'd",map_x,map_y)))
  {
    if (!load_map(map_x,map_y))
      raise_error("map with index "+
        sprintf("%3'0'd|%3'0'd",map_x,map_y)+" could not be loaded");
  }
  else
  { // if already loaded, the central map priority will be set to 0 
    // (so it is not swapped out next reset)
    maps[sprintf("%3'0'd|%3'0'd",map_x,map_y),1]=0;
  }
  if (y_pos-r<0)
  {
    if (!member(maps,sprintf("%3'0'd|%3'0'd",map_x,map_y-1)))
    {
      if (!load_map(map_x,map_y-1))
        raise_error("map with index "
          +sprintf("%3'0'd|%3'0'd",map_x,map_y-1)+" could not be loaded");
    }
    if (x_pos-r<0)
    {
      if (!member(maps,sprintf("%3'0'd|%3'0'd",map_x-1,map_y)))
      {
        if (!load_map(map_x-1,map_y))
          raise_error("map with index "
            +sprintf("%3'0'd|%3'0'd",map_x-1,map_y)+" could not be loaded");
      }
      if (!member(maps,sprintf("%3'0'd|%3'0'd",map_x-1,map_y-1)))
      {
        if (!load_map(map_x-1,map_y-1))
          raise_error("map with index "
            +sprintf("%3'0'd|%3'0'd",map_x-1,map_y-1)+" could not be loaded");
      }      
    }  
  }
  else if (x_pos-r<0)
  {
    if (!member(maps,sprintf("%3'0'd|%3'0'd",map_x-1,map_y)))
    {
      if (!load_map(map_x-1,map_y))
        raise_error("map with index "
          +sprintf("%3'0'd|%3'0'd",map_x-1,map_y)+" could not be loaded");
    }
  }  
  else if (y_pos+r>24)
  {
    if (!member(maps,sprintf("%3'0'd|%3'0'd",map_x,map_y+1)))
    {
      if (!load_map(map_x,map_y+1))
        raise_error("map with index "
          +sprintf("%3'0'd|%3'0'd",map_x,map_y+1)+" could not be loaded");
    }
    if (x_pos+r>24)
    {
      if (!member(maps,sprintf("%3'0'd|%3'0'd",map_x+1,map_y)))
      {
        if (!load_map(map_x+1,map_y))
          raise_error("map with index "
            +sprintf("%3'0'd|%3'0'd",map_x+1,map_y)+" could not be loaded");
      }
      if (!member(maps,sprintf("%3'0'd|%3'0'd",map_x+1,map_y+1)))
      {
        if (!load_map(map_x+1,map_y+1))
          raise_error("map with index "
            +sprintf("%3'0'd|%3'0'd",map_x+1,map_y+1)+" could not be loaded");
      }      
    }      
  }
  else if (x_pos+r>24)
  {
    if (!member(maps,sprintf("%3'0'd|%3'0'd",map_x+1,map_y)))
    {
      if (!load_map(map_x+1,map_y))
        raise_error("map with index "
          +sprintf("%3'0'd|%3'0'd",map_x+1,map_y)+" could not be loaded");
    }
  }
}

string get_descr(int map_x, int map_y, int x, int y, int col)
{
  string desc;
  
  if (x<0)
  {
    map_x--;
    x+=25;  
  }
  else if (x>24)
  {
    map_x++;
    x-=25;
  }
  if (y<0)
  {
    map_y--;
    y+=25;  
  }
  else if (y>24)
  {
    map_y++;
    y-=25;  
  }
  switch(maps[sprintf("%3'0'd|%3'0'd",map_x,map_y),0][y][x])
  {
    case 'a': // Ebene mit Grasland und Fluss
    case 'b': // Ebene mit Grasland und See
    case 'c': // Ebene mit Strauchland und Fluss
    case 'd': // Ebene mit Strauchland und See
    case 'e': // Ebene mit Laubwald und Fluss
    case 'f': // Ebene mit Laubwald und See
    case 'g': // Ebene mit Nadelwald und Fluss
    case 'h': // Ebene mit Nadelwald und See
    case 'i': // Ebene mit Sumpf und Fluss
    case 'j': // Ebene mit Sumpf und See
    case 'l': // Ebene mit Dreck und Fluss
    case 'm': // Ebene mit Dreck und See
    case 'n': // Huegel mit Grasland und Fluss
    case 'p': // Huegel mit Grasland und See
    case 'r': // Huegel mit Strauchland und Fluss
    case 's': // Huegel mit Strauchland und See
    case 'v': // Huegel mit Laubwald und Fluss
    case 'w': // Huegel mit Laubwald und See
    case 'y': // Huegel mit Nadelwald und Fluss
    case 'z': // Huegel mit Nadelwald und See
    case 'C': // Huegel mit Sumpf und Fluss
    case 'D': // Huegel mit Sumpf und See
    case 'F': // Huegel mit Dreck und Fluss
    case 'G': // Huegel mit Dreck und See 
    case 'I': // Hochebene mit Grasland und Fluss
    case 'J': // Hochebene mit Grasland und See
    case 'L': // Hochebene mit Strauchland und Fluss
    case 'M': // Hochebene mit Strauchland und See 
    case 'O': // Hochebene mit Laubwald und Fluss
    case 'P': // Hochebene mit Laubwald und See
    case 'R': // Hochebene mit Nadelwald und Fluss
    case 'S': // Hochebene mit Nadelwald und See
    case 'U': // Hochebene mit Sumpf und Fluss
    case 'V': // Hochebene mit Sumpf und See
    case 'X': // Hochebene mit Dreck und Fluss
    case 'Y': // Hochebene mit Dreck und See 
    case ')': // Kueste
    case '=': // Kuestengewaesser
    case '?': // Offenes Meer
      desc=ANSI_BACK_BLUE+" ";
      break;
    case '"': // Ebene mit Strauchland
      desc=ANSI_BACK_GREEN+"\"";
      break;
    case 'o': // Ebene mit Laubwald
      desc=ANSI_BACK_GREEN+"o";
      break;      
    case '4': // Ebene mit Nadelwald
      desc=ANSI_BACK_GREEN+"4";
      break;      
    case 'u': // Ebene mit Sumpf 
      desc=ANSI_BACK_PURPLE+"u";
      break;      
    case '^': // Huegel mit Grasland
    case 'q': // Huegel mit Strauchland
    case 't': // Huegel mit Laubwald
    case 'x': // Huegel mit Nadelwald
    case 'B': // Huegel mit Sumpf 
    case 'E': // Huegel mit Dreck
      desc=ANSI_BACK_GREEN+"\^";
      break;      
    case '1': // Gebirge mit Grasland und Fluss
    case '2': // Gebirge mit Grasland und See
    case 'Z': // Gebirge mit Grasland
    case '3': // Gebirge mit Strauchland
    case '5': // Gebirge mit Strauchland und Fluss
    case '6': // Gebirge mit Strauchland und See
    case '7': // Gebirge mit Laubwald
    case '8': // Gebirge mit Laubwald und Fluss
    case '9': // Gebirge mit Laubwald und See
    case '0': // Gebirge mit Nadelwald
    case '!': // Gebirge mit Nadelwald und Fluss
    case '': // Gebirge mit Nadelwald und See
    case '$': // Gebirge mit Sumpf 
    case '%': // Gebirge mit Sumpf und Fluss
    case '&': // Gebirge mit Sumpf und See
    case 'A': // Gebirge mit Dreck
    case '/': // Gebirge mit Dreck und Fluss
    case '(': // Gebirge mit Dreck und See
      desc=ANSI_BACK_GREEN+"A";
      break;               
    case '+': // Gebirge mit Dreck und See
      desc=ANSI_BOLD+ANSI_BACK_BLACK+ANSI_WHITE+"H";
      break;               
    case 'k': // Ebene mit Dreck
    case '\'': // Ebene mit Grasland
    case 'H': // Hochebene mit Grasland
    case 'K': // Hochebene mit Strauchland
    case 'N': // Hochebene mit Laubwald
    case 'Q': // Hochebene mit Nadelwald
    case 'T': // Hochebene mit Sumpf 
    case 'W': // Hochebene mit Dreck 
    default:
      desc=ANSI_BACK_GREEN+" ";
      break;
  }
  return desc+ANSI_NORMAL;
}

void test_color()
{
  write(
    ANSI_BLACK+"@"+ANSI_NORMAL+"\n"
    ANSI_RED+"@"+ANSI_NORMAL+"\n"
    ANSI_GREEN+"@"+ANSI_NORMAL+"\n"
    ANSI_YELLOW+"@"+ANSI_NORMAL+"\n"
    ANSI_BLUE+"@"+ANSI_NORMAL+"\n"
    ANSI_PURPLE+"@"+ANSI_NORMAL+"\n"
    ANSI_CYAN+"@"+ANSI_NORMAL+"\n"
    ANSI_BACK_BLACK+ANSI_WHITE+"@"+ANSI_NORMAL+"\n"
    ANSI_BACK_RED+"@"+ANSI_NORMAL+"\n"
    ANSI_BACK_GREEN+"@"+ANSI_NORMAL+"\n"
    ANSI_BACK_YELLOW+"@"+ANSI_NORMAL+"\n"
    ANSI_BACK_BLUE+"@"+ANSI_NORMAL+"\n"
    ANSI_BACK_PURPLE+"@"+ANSI_NORMAL+"\n"
    ANSI_BACK_CYAN+"@"+ANSI_NORMAL+"\n"
    ANSI_BACK_WHITE+"@"+ANSI_NORMAL+"\n"
    ANSI_BOLD+ANSI_BLACK+"@"+ANSI_NORMAL+"\n"
    ANSI_BOLD+ANSI_RED+"@"+ANSI_NORMAL+"\n"
    ANSI_BOLD+ANSI_GREEN+"@"+ANSI_NORMAL+"\n"
    ANSI_BOLD+ANSI_YELLOW+"@"+ANSI_NORMAL+"\n"
    ANSI_BOLD+ANSI_BLUE+"@"+ANSI_NORMAL+"\n"
    ANSI_BOLD+ANSI_PURPLE+"@"+ANSI_NORMAL+"\n"
    ANSI_BOLD+ANSI_CYAN+"@"+ANSI_NORMAL+"\n"
    ANSI_BOLD+ANSI_BACK_BLACK+ANSI_WHITE+"@"+ANSI_NORMAL+"\n"
    ANSI_BOLD+ANSI_BACK_RED+"@"+ANSI_NORMAL+"\n"
    ANSI_BOLD+ANSI_BACK_GREEN+"@"+ANSI_NORMAL+"\n"
    ANSI_BOLD+ANSI_BACK_YELLOW+"@"+ANSI_NORMAL+"\n"
    ANSI_BOLD+ANSI_BACK_BLUE+"@"+ANSI_NORMAL+"\n"
    ANSI_BOLD+ANSI_BACK_PURPLE+"@"+ANSI_NORMAL+"\n"
    ANSI_BOLD+ANSI_BACK_CYAN+"@"+ANSI_NORMAL+"\n"
    ANSI_BOLD+ANSI_BACK_WHITE+"@"+ANSI_NORMAL+"\n"
    );
}

string get_long_descr(int map_x, int map_y, int x, int y)
{
  string desc;
  
  switch(maps[sprintf("%3'0'd|%3'0'd",map_x,map_y),0][y][x])
    {
    case 'a': // Ebene mit Grasland und Fluss
      desc="Auf einem Fluss durchs flache Grasland.";
      break;
    case 'b': // Ebene mit Grasland und See
      desc="Auf einem See im flachen Grasland.";
      break;
    case 'c': // Ebene mit Strauchland und Fluss
      desc="Auf einem Fluss durchs flache Strauchland";
      break;
    case 'd': // Ebene mit Strauchland und See
      desc="Auf einem See im flachen Strauchland";
      break;
    case 'e': // Ebene mit Laubwald und Fluss
      desc="Auf einem Fluss im Laubwald";
      break;
    case 'f': // Ebene mit Laubwald und See
      desc="Auf einem See im Laubwald";
      break;
    case 'g': // Ebene mit Nadelwald und Fluss
      desc="An einem Fluss im Nadelwald";
      break;
    case 'h': // Ebene mit Nadelwald und See
      desc="Auf einem See im Nadelwald";
      break;
    case 'i': // Ebene mit Sumpf und Fluss
      desc="Auf einem See durch den Sumpf";
      break;
    case 'j': // Ebene mit Sumpf und See
      desc="Auf einem See durch den Sumpf";
      break;
    case 'l': // Ebene mit Dreck und Fluss
      desc="Auf einem Fluss durch die Oednis";
      break;
    case 'm': // Ebene mit Dreck und See
      desc="Auf einem See durch die Oednis";
      break;
    case 'n': // Huegel mit Grasland und Fluss
      desc="Auf einem Fluss durch grasbewachsene Huegel";
      break;
    case 'p': // Huegel mit Grasland und See
      desc="Auf einem See in grasbewachsenen Huegeln";
      break;
    case 'r': // Huegel mit Strauchland und Fluss
      desc="Auf einem Fluss durch strauchbewachsene Huegel";
      break;
    case 's': // Huegel mit Strauchland und See
      desc="Auf einem See in strauchbewachsene Huegeln";
      break;
    case 'v': // Huegel mit Laubwald und Fluss
      desc="Auf einem Fluss durch laubwaldbewachsene Huegel";
      break;
    case 'w': // Huegel mit Laubwald und See
      desc="Auf einem See in laubwaldbewachsenen Huegeln";
      break;
    case 'y': // Huegel mit Nadelwald und Fluss
      desc="Auf einem Fluss durch nadelwaldbewachsene Huegel";
      break;
    case 'z': // Huegel mit Nadelwald und See
      desc="Auf einem See in nadelwaldbewachsenen Huegeln";
      break;
    case 'C': // Huegel mit Sumpf und Fluss
      desc="Auf einem Fluss durch sumpfige Huegel";
      break;
    case 'D': // Huegel mit Sumpf und See
      desc="Auf einem See in sumpfigen Huegeln";
      break;
    case 'F': // Huegel mit Dreck und Fluss
      desc="Auf einem Fluss durch oede Huegel";
      break;
    case 'G': // Huegel mit Dreck und See 
      desc="Auf einem See in oeden Huegeln";
      break;
    case 'I': // Hochebene mit Grasland und Fluss
      desc="Auf einem Fluss durchs grasbewachsene Hochland";
      break;
    case 'J': // Hochebene mit Grasland und See
      desc="Auf einem See im grasbewachsenen Hochland";
      break;
    case 'L': // Hochebene mit Strauchland und Fluss
      desc="Auf einem Fluss durchs strauchbewachsene Hochland";
      break;
    case 'M': // Hochebene mit Strauchland und See 
      desc="Auf einem See im strauchbewachsenen Hochland";
      break;
    case 'O': // Hochebene mit Laubwald und Fluss
      desc="Auf einem Fluss durch den Hochlandlaubwald";
      break;
    case 'P': // Hochebene mit Laubwald und See
      desc="Auf einem See im Hochlandlaubwald";
      break;
    case 'R': // Hochebene mit Nadelwald und Fluss
      desc="Auf einem Fluss durch den Hochlandnadelwald";
      break;
    case 'S': // Hochebene mit Nadelwald und See
      desc="Auf einem See im Hochlandnadelwald";
      break;
    case 'U': // Hochebene mit Sumpf und Fluss
      desc="Auf einem Fluss durchs sumpfige Hochland";
      break;
    case 'V': // Hochebene mit Sumpf und See
      desc="Auf einem See im sumpfigen Hochland";
      break;
    case 'X': // Hochebene mit Dreck und Fluss
      desc="Auf einem Fluss durchs oede Hochland";
      break;
    case 'Y': // Hochebene mit Dreck und See 
      desc="Auf einem See im oeden Hochland";
      break;
    case ')': // Kueste
      desc="An der Meereskueste";
      break;
    case '=': // Kuestengewaesser
      desc="Im Kuestengewaesser des Meeres";
      break;
    case '?': // Offenes Meer
      desc="Auf dem offenen Meer";
      break;
    case '"': // Ebene mit Strauchland
      desc="Im flachen Strauchland";
      break;
    case 'o': // Ebene mit Laubwald
      desc="Im Laubwald";
      break;
    case '4': // Ebene mit Nadelwald
      desc="Im Nadelwald";
      break;
    case 'u': // Ebene mit Sumpf 
      desc="Im Sumpf";
      break;
    case '^': // Huegel mit Grasland
      desc="In huegeligen Grasland";
      break;
    case 'q': // Huegel mit Strauchland
      desc="In huegeligen Strauchland";
      break;
    case 't': // Huegel mit Laubwald
      desc="Im huegeligen Laubwald";
      break;
    case 'x': // Huegel mit Nadelwald
      desc="Im huegeligen Nadelwald";
      break;
    case 'B': // Huegel mit Sumpf 
      desc="In sumpfigen Huegeln";
      break;
    case 'E': // Huegel mit Dreck
      desc="In oeden Huegeln";
      break;
    case '1': // Gebirge mit Grasland und Fluss
      desc="Auf einem Fluss durchs grasbewachsene Gebirgsland";
      break;
    case '2': // Gebirge mit Grasland und See
      desc="Auf einem See im grasbewachsenen Gebirgsland";
      break;
    case 'Z': // Gebirge mit Grasland
      desc="Im grasbewachsenen Gebirgsland";
      break;
    case '3': // Gebirge mit Strauchland
      desc="Im strauchbewachsenen Gebirgsland";
      break;
    case '5': // Gebirge mit Strauchland und Fluss
      desc="Auf einem Fluss durchs strauchbewachsene Gebirgsland";
      break;
    case '6': // Gebirge mit Strauchland und See
      desc="Auf einem See im strauchbewachsenen Gebirgsland";
      break;
    case '7': // Gebirge mit Laubwald
      desc="Im gebirgigen Laubwald";
      break;
    case '8': // Gebirge mit Laubwald und Fluss
      desc="Auf einem Fluss durch den gebirgigen Laubwald";
      break;
    case '9': // Gebirge mit Laubwald und See
      desc="Auf einem See im gebirgigen Laubwald";
      break;
    case '0': // Gebirge mit Nadelwald
      desc="Im gebirgigen Nadelwald";
      break;
    case '!': // Gebirge mit Nadelwald und Fluss
      desc="Auf einem Fluss durch den gebirgigen Nadelwald";
      break;
    case '': // Gebirge mit Nadelwald und See
      desc="Auf einem See im gebirgigen Nadelwald";
      break;
    case '$': // Gebirge mit Sumpf 
      desc="Im sumpfigen Gebirgsland";
      break;
    case '%': // Gebirge mit Sumpf und Fluss
      desc="Auf einem Fluss durchs sumpfige Gebirgsland";
      break;
    case '&': // Gebirge mit Sumpf und See
      desc="Auf einem See im sumpfigen Gebirgsland";
      break;
    case 'A': // Gebirge mit Dreck
      desc="Im oeden Gebirgsland";
      break;
    case '/': // Gebirge mit Dreck und Fluss
      desc="Auf einem Fluss durchs oede Gebirgsland";
      break;
    case '(': // Gebirge mit Dreck und See
      desc="Auf einem See im oeden Gebirgsland";
      break;
    case '+': // Stadt
      desc="In einer Stadt";
      break;
    case 'k': // Ebene mit Dreck
      desc="In einer oeden Ebene";
      break;
    case '\'': // Ebene mit Grasland
      desc="Im ebenen Grasland";
      break;
    case 'H': // Hochebene mit Grasland
      desc="Im grasbewachsenen Hochland";
      break;
    case 'K': // Hochebene mit Strauchland
      desc="Im strauchbewachsenen Hochland";
      break;
    case 'N': // Hochebene mit Laubwald
      desc="Im Hochlandlaubwald";
      break;
    case 'Q': // Hochebene mit Nadelwald
      desc="Im Hochlandnadelwald";
      break;
    case 'T': // Hochebene mit Sumpf 
      desc="Im sumpfigen Hochland";
      break;
    case 'W': // Hochebene mit Dreck 
      desc="Im oeden Hochland";
      break;
    default:
      desc="An einem seltsamen Ort.";
      break;
  }
  return desc;
}

string QueryLongDesc(int map_x, int map_y, int x_pos, int y_pos, int r, int col)
{
  int x,y;
  string desc;
  
  desc=get_long_descr(map_x,map_y,x_pos,y_pos)+"\n";
  for (y=0;y<2*r+1;y++)
  {
    adesc[y]=CLEAR_LINE[0..M_X-r];
    for (x=M_X-r;x<=M_X+r;x++)
    {
      if (y==r && x==M_X)
        adesc[y]+="X";
      else if ( sqrt(to_float((M_X-x)*(M_X-x)+(r-y)*(r-y))) <= to_float(r) )
        adesc[y]+=get_descr(map_x,map_y,x_pos-(M_X-x),y_pos-(r-y),col);
      else
        adesc[y]+=" ";
    }
  }
  return implode(adesc[0..2*r],"\n")+"\n"+desc;
}

string QueryShortDesc(int map_x, int map_y, int x, int y)
{
  load_needed_maps(map_x,map_y,x,y,8);
  
  return get_long_descr(map_x,map_y,x,y);
}

varargs string QueryMap(int col, int map_x,int map_y,int x,int y,int width,int length)
{
  string desc;
  int i,j,act_map_x,act_map_y,act_x,act_y;
  
  if (!width)
    width=23;
  if (!length)
    length=width;
            
  DB("Try loading maps (low)...");  
  // low loading of (possibly) needed maps
  for (i=0;i<3;i++)
  {
    for (j=0;j<3;j++)
    {
      load_map_low((map_x-1)+i,(map_y-1)+j);  
    }  
  }
  DB("done\nBuilding map ");
  desc="";
  for (i=y-length/2;i<=(y-length/2)+length;i++)
  {
    act_map_y=map_y;
    act_y=i;
    while(y<0)
    {
      act_map_y--;
      act_y+=25;
    }
    while(y>24)
    {
      act_map_y++;
      act_y-=25;  
    }
    for (j=x-width/2;j<=(x-width/2)+width;j++)
    {
      act_map_x=map_x;
      act_x=j;
    while(x<0)
    {
      act_map_x--;
      act_x+=25;
    }
    while(x>24)
    {
      act_map_x++;
      act_x-=25;  
    }
      desc+=get_descr(act_map_x,act_map_y,act_x,act_y,col);
    }  
    desc+="\n";
    DB("#");
  }
  DB(" done\n");
  return desc;
}