/*******************
** Eldarea MUDLib **
********************
**
** global/daemon/landscape/maps/map.c  - map server basic object
**
** CVS DATA
** $Date: 1999/11/12 08:30:11 $
** $Revision: 1.1 $
**
** this object will be virtually created und servers the map of 
** one tile of the landscape
**
** CVS History
**
** $Log: map.c,v $
** Revision 1.1  1999/11/12 08:30:11  elatar
** Initial revision.
**
**
*/

#include "./map.h"

mixed *map;
int map_x,map_y;

mixed * query_map_tile(int x1, int y1, int x2, int y2);
mixed * query_map_col(int x, int y1, int y2);
void SetCoords(int x, int y);

create()
{
  if (!clonep(this_object())) return;
  
  previous_object()->CustomizeObject();
}

void SetCoords(int x, int y)
{
  string line,filename;
  int i,j;
  
  map_x=x;
  map_y=y;
  
  map=allocate(25);
  filename=LANDSCAPED_DIR+sprintf("/maps/map#%3'0'd:%3'0'd.map",map_x,map_y);
  if (1>file_size(filename)) filename=CLEAR_MAP;
  
  for(i=1;i<26;i++)
  {
    map[i-1]=allocate(25);
    line=read_file(filename,i,1);
    if (!line) return 0;
    for (j=0;j<25;j++)
    {
      map[i-1][j]=line[j..j];
    }
  }
}

mixed * query_map_tile(int x1, int y1, int x2, int y2)
{
  mixed *maptile;
  int i;

  maptile=allocate(x2-x1+1);
  for (i=x1;i<=x2;i++)
  {
    maptile[i-x1]=allocate(y2-y1+1);
    maptile[i-x1]=query_map_col(i,y1,y2); 
  }
  return maptile;
}

mixed * query_map_col(int x, int y1, int y2)
{
  mixed *mapcol;
  
  mapcol=allocate(y2-y1+1);
  if (x<0)
  {
    return call_other(sprintf(LANDSCAPED_DIR"/maps/map#%3'0'd|%3'0'd",map_x-1,map_y),"query_map_col",25+x,y1,y2);
  }
  if (x>24)
  {
    return call_other(sprintf(LANDSCAPED_DIR"/maps/map#%3d|%3d",map_x+1,map_y),"query_map_col",x-25,y1,y2);
  }
  if (y1<0)
  {
    mapcol[0..-1-y1]=call_other(sprintf(LANDSCAPED_DIR"/maps/map#%3d|%3d",map_x,map_y-1),"query_map_col",x,25+y1,24);
    mapcol[0-y1..y2-y1]=map[x][0..y2];
    return mapcol;
  }
  if (y2>25)
  {
    mapcol[0..24-y1]=map[x][y1..24];
    mapcol[25-y1..y2-y1]=call_other(sprintf(LANDSCAPED_DIR"/maps/map#%3d|%3d",map_x,map_y+1),"query_map_col",x,0,y2-25);
    return mapcol;
  }
  mapcol[0..y2-y1]=map[x][y1..y2];
  return mapcol;
}
