/*******************
** Eldarea MUDLib **
********************
**
** global/daemon/landscape/maps/virtual_compiler.c  - landscape server virtual compiler
**
** CVS DATA
** $Date: 1999/11/12 08:30:53 $
** $Revision: 1.1 $
**
** this virtual compiler will compile the map tile daemons
**
** (c) 1999 by Elatar@Eldarea
**
** CVS History
**
** $Log: virtual_compiler.c,v $
** Revision 1.1  1999/11/12 08:30:53  elatar
** Initial revision.
**
**
*/

#include "./map.h"

inherit "/std/virtual/v_compiler";

create()
{
  ::create();
  SetProp(P_COMPILER_PATH,LANDSCAPED_DIR"/maps");
  SetProp(P_STD_OBJECT,LANDSCAPED_DIR"/maps/map"); 

}

int CustomizeObject()
{
  string name,file;
  int map_x,map_y;
  
  if (!(name = ::CustomizeObject()) || sscanf(name,"%s#%3d|%3d",file,map_x,map_y)!=3)
    return 0;
  
  previous_object()->SetCoords(map_x,map_y);
  return 1;
}

string Validate(string file)
{
  string path,name;
  int map_x,map_y;
 
  file = ::Validate(file);
  if ( ( sscanf(file,"%s#%3d|%3d",name,map_x,map_y)==3 ) &&
       ( "map"==name) 
       )
  {
    SetProp(P_STD_OBJECT, LANDSCAPED_DIR"/maps/"+name);
    return file;
  }
  return 0;
}
