/*******************
** Eldarea MUDLib **
********************
**
** global/daemon/landscape/virtual_compiler.c  - landscape virtual compiler
**
** CVS DATA
** $Date: 1999/11/12 08:28:50 $
** $Revision: 1.1 $
**
** the landscape v_compiler serves the virtual rooms for overland
** and inner city travelling. it will read the files from 
** the global/daemon/landscape directory und transform the data
** given into the view of the surrounding environment.
**
** (c) 1999 by Elatar@Eldarea
**
** CVS History
**
** $Log: virtual_compiler.c,v $
** Revision 1.1  1999/11/12 08:28:50  elatar
** Initial revision, still to be optimized
**
**
*/

#include "./landscaped.h"

#ifdef DB
#undef DB
#define DB
#endif

inherit "/std/virtual/v_compiler";

void create()
{
  ::create();
  SetProp(P_COMPILER_PATH,LANDSCAPED_DIR);
  SetProp(P_STD_OBJECT,LANDSCAPED_DIR"/landscape"); 

}

int CustomizeObject()
{
  string name;
  int map_x,x,map_y,y;
  object o;
  mixed *map;

  DB("#customizing started\n");
  if (!(name = ::CustomizeObject()) || sscanf(name,"landscape#%3d:%2d|%3d:%2d",map_x,x,map_y,y)!=4)
    return 0;
  DB("#file ok, adding exits\n");
  o=previous_object();
  /*
  //Umgebungskarte erzeugen
  map=call_other(sprintf(LANDSCAPED_DIR"/maps/map#%3'0'd|%3'0'd",map_x,map_y),"query_map_tile",x-3,y-3,x+3,y+3);

  o->SetProp(P_INT_LONG,sprintf(
    "                %s\n"
    "               %s\n"
    "              %s\n"
    "              %s\n"
    "              %s\n"
    "               %s\n"
    "                %s\n\n"
    ,implode(map[0][2..4],"")
    ,implode(map[1][1..5],"")
    ,implode(map[2][0..6],"")
    ,implode(map[3][0..6],"")
    ,implode(map[4][0..6],"")
    ,implode(map[5][1..5],"")
    ,implode(map[6][2..4],"")));
  */
  o->AddExit("westen",sprintf(LANDSCAPED_DIR"/landscape#%3'0'd:%2'0'd|%3'0'd:%2'0'd",x>0?map_x:map_x-1,x>0?x-1:24,map_y,y));
  o->AddExit("osten",sprintf(LANDSCAPED_DIR"/landscape#%3'0'd:%2'0'd|%3'0'd:%2'0'd",x<24?map_x:map_x+1,x<24?x+1:0,map_y,y));
  o->AddExit("norden",sprintf(LANDSCAPED_DIR"/landscape#%3'0'd:%2'0'd|%3'0'd:%2'0'd",map_x,x,y>0?map_y:map_y-1,y>0?y-1:24));
  o->AddExit("sueden", sprintf(LANDSCAPED_DIR"/landscape#%3'0'd:%2'0'd|%3'0'd:%2'0'd",map_x,x,y<24?map_y:map_y+1,y<24?y+1:0));
  DB("#exits ok, adding short description\n");
  o->SetProp(P_INT_SHORT,LANDSCAPED->QueryShortDesc(map_x,map_y,x,y));
  DB("#ok\n");
  return 1;
  
}

string Validate(string file)
{
  int map_x,x,map_y,y;
 
  file = ::Validate(file);
  if ( sscanf(file,"landscape#%3d:%2d|%3d:%2d",map_x,x,map_y,y)==4 )
  {
    SetProp(P_STD_OBJECT, LANDSCAPED_DIR"/landscape");
    return file;
  }
  return 0;
}
