/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:43 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: objectd.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland Mudliblib
//
// OBD/DAEMON/OBJECTD.C -- object daemon
//
// Based on Morgengrauen Mudlib
//
// $Revision: 1.1.1.1 $
//
// $Log: objectd.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:43  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:09  en
// MUDLib CVS Preperation
//
// Revision 1.4  1999/07/28 22:04:19  Gum
// objecte werden mit REFRESH_NONE statt _DESTRUCT erzeugt
// removeobject loescht die objekte aus P_ITEMS im raum
//
// Revision 1.3  1999/05/06 20:55:17  Holger
// Kleiner Fix in QueryObject() (Fuer Elric)
// bissl modernisiert
//
// Revision 1.2  1998/03/13 12:53:43  Holger
// Reintented ;)
//
// Revision 1.1  1996/09/19 10:04:49  Bongo
// Initial revision
//
// Revision 1.2  1995/04/03  14:47:02  Wargon
// QueryObject() verwendet bei BluePrints jetzt auch AddItem.
//
// Revision 1.1  1995/03/31  13:30:33  Hate
// Initial revision

#pragma strong_types

#include <properties.h>
#include <defines.h>
#include <daemon.h>

mapping objects;

#define CLASS   0
#define DATA    1

void create()
{
  if (clonep())
    destruct(ME);
  seteuid(getuid(ME));
  objects = ([]);
  restore_object(OBJECTD_SAVE);
}

mixed AddObject(object obj, string env)
{
  if (!objectp(obj) || !stringp(env)) return 0;
  // save information
  if (!member(objects, env))
    objects[env] = ({ ({  file_name(obj), obj->QueryProp(P_AUTOLOAD) }) });
  else
    objects[env] += ({ ({ file_name(obj), obj->QueryProp(P_AUTOLOAD) }) });
  save_object(OBJECTD_SAVE);

  return env;
}

mixed RemoveObject(object obj, string env)
{
  if (!objectp(obj) || !stringp(env)) return 0;
  // save information
  if (member(objects, env))
  { 
    int i;
    i = sizeof(objects[env]);
    while (i && (objects[env][i-1][CLASS] != file_name(obj))) --i;
    if (i > 0)
    {
      call_other(env, "RemoveItem", obj);
      objects[env] -= ({ objects[env][i-1] });
    }
  }
  if (!sizeof(objects[env]))
    objects = m_delete(objects, env);
  save_object(OBJECTD_SAVE);
}

varargs void QueryObject(mixed env)
{
  mixed obj, oenv;
  int i;

  // take the caller as the questioning object
  if (!stringp(env))
    env = previous_object();
  else
    env = find_object(env);

  // target must be a blueprint
  if (clonep(env))
    return 0;

  if (i = pointerp(obj = objects[env = file_name(oenv = env)]) ? sizeof(obj) : 0)
  {
    while (i--)
    {
      object o;
      string file;

      file = efun::explode(objects[env][i][CLASS], "#")[0];
      o = oenv->AddItem(file, REFRESH_NONE, ([ P_AUTOLOAD : objects[env][i][DATA] ]) );
      objects[env][i][CLASS] = file_name(o);
    }
    save_object(OBJECTD_SAVE);
  }
}

mixed QueryObjects(mixed env)
{
  mixed obj;

  // take the caller as the questioning object
  if (!stringp(env))
    env = previous_object();
  else
    env = find_object(env);

  // target must be a blueprint
  if (clonep(env))
    return 0;

  if (obj = objects[file_name(env)])
    obj = map_array(obj, #'[, 0);

  return obj;
}

int clean_up(int arg)
{
  if (arg>1)
    return 1;
  save_object(OBJECTD_SAVE);
  destruct(ME);
}

