/*******************
** Eldarea MUDLib **
********************
**
** global/daemon/wwwd.c - www daemon
**
** CVS DATA
** $Date: 2001/06/18 18:20:58 $
** $Revision: 1.1 $
**
** CVS History
**
** $Log: wwwd.c,v $
** Revision 1.1  2001/06/18 18:20:58  elatar
** initial revision
**
**
**
*/

#include "./wwwd.h"
#include <config.h>

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")

#pragma strong_types

static void update_htaccess(string dir, int wizlvl, string uid, string new)
{
  string * file, fuid, pass;  
  int i;

  if (MASTER->privilege_violation("update_htpassword",previous_object())!=1)
    return;

  if (query_wiz_level(uid)<wizlvl)
    return;

  if (file_size(HTDOCS+dir+HTPASSWDFILE)<1)
  {
    write_file(HTDOCS+dir+HTPASSWDFILE,sprintf("%s:%s\n",uid,crypt(new,0)));
  }
  else
  {
    file=explode(read_file(HTDOCS+dir+HTPASSWDFILE),"\n");
    
    for(i=sizeof(file);i-->0;)
    {
      if (sscanf(file[i],"%s:%s",fuid,pass)==2 && fuid==uid)
        file[i]=0;
    }
    file-=({0});
    file+=({sprintf("%s:%s",uid,crypt(new,0))});
    rm(HTDOCS+dir+HTPASSWDFILE);
    write_file(HTDOCS+dir+HTPASSWDFILE,implode(file,"\n")+"\n");
  }
}

nomask void update_htpassword(string uid, string new)
{
  if (MASTER->privilege_violation("update_htpassword",previous_object())!=1)
    return;
  
  walk_mapping(HTACCESS,#'update_htaccess,uid,new);
  
  return;
}

void create()
{
  if (clonep())
  {
    destruct(this_object());
    return;  
  }
    
  seteuid(getuid());  
}