/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:43 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: wwwguestd.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland Mudlib
//
// WWWGUESTD.C -- UDP - WWW connection daemon
//
// Based on Morgegrauen Mudlib
//
// $Date: 1999/11/05 12:30:43 $
// $Revision: 1.1.1.1 $
/*
 * $Log: wwwguestd.c,v $
 * Revision 1.1.1.1  1999/11/05 12:30:43  elatar
 * Preparing mudlib for cvs control
 *
 * Revision 1.1.1.1  1999/11/04 12:48:09  en
 * MUDLib CVS Preperation
 *
 * Revision 1.3  1998/03/13 12:56:04  Holger
 * Pfad von html.h bzw daemon.h eingefuegt bzw gewechselt?!? ;)))
 *
 * Revision 1.2  1997/02/26 11:17:25  Bongo
 * /room/gilde durch Define ersetzt
 *
 * Revision 1.1  1996/09/19 10:05:16  Bongo
 * Initial revision
 *
 *
 */

// WWWGUESTD.C -- UDP - WWW connection daemon

#include <properties.h>
#include <daemon.h>
#include <homes.h>

private mapping user;
private int lastID;

#define ROOM  0   // room where user currently resides
#define EXITS 1   // room exits
#define IP    2   // ip address of user
#define TIME  3   // last checkin time

void create()
{
  // ([ userid : ROOM; EXITS; IP; TIME, ... ])
  user = allocate_mapping(0,3);
}

private string AddUser(string ip, string start)
{
  string id;
  if(!stringp(ip)) return 0;
  id = (++lastID)+"@"+ip;
  user[id, ROOM] = start ? start : DEFAULT_HOME;
  user[id, IP] = ip;
  user[id, TIME] = ctime();
  return id;
}

private int RemoveUser(string id)
{
  if(member(user, id)) m_delete(user, id);
  else return 0;
  return 1;
}

private string MakeHREF(string item, int i)
{
  return "<A HREF=\"/cgi-bin/mudguest?EXIT@"+i+"\""+item+"</A>";
}

int WWWMessage(string msg, string ip, string id)
{
  string *cmd, rmsg;
  if(!(previous_object() == find_object("/secure/udp"))) return -1;
  if(!ip) return -1;
  if(!sizeof(cmd = explode(msg, "@"))) return 0;
  if(cmd[0] == "BEGIN")
  {
    string tmp_to;
    if(id = AddUser(ip, tmp_to = sizeof(cmd)>1 ? cmd[1] : 0))
      cmd = ({ "MOVE", tmp_to });
    else return -1;
  }

  if(!member(user, id))
  {
    rmsg = "<TITLE>Wunderland WWW Gast: Time Out</TITLE>"
         + "Es tut uns leid, aber diese Identifikation ist nicht l&auml;"
	 + "nger g&uuml;ltig.<P>"
         + "<A HREF=\"~mud/mudguest.html\">Zur&uuml;ck zum Anfang!</A>";
  }
  switch(cmd)
  {
  case "MOVE": 
    if(sizeof(cmd)>1) 
    {
      rmsg = "<TITLE>"+cmd[1]->QueryProp(P_INT_SHORT)+"</TITLE>"
           + cmd[1]->QueryProp(P_INT_LONG) + "<P>"
           + implode(map_array(m_indices(cmd[1]->QueryProp(P_EXITS))));
    }    
  }
}
