/*******************
** Eldarea MUDLib **
********************
**
** global/handler/combat.c - global combat event handler
**
** CVS DATA
** $Date$
** $Revision$
**
** handled events:
**
** ET_HIT       livings beeing hit
** ET_DAMAGE    livings taking damage
** ET_ATTACK    livings attacking
** ET_DEFEND    livings defending
**
** CVS History
**
** $Log: life.c,v $
** Revision 1.3  2000/12/18 14:53:19  elatar
** ET_DEATH event now provides messages
** ET_EXHAUS event implemented
**
** Revision 1.2  2000/12/15 15:33:09  elatar
** P_VICTIM_DIE_FLAGS inserted
**
** Revision 1.1  2000/12/15 15:26:01  elatar
** initial revision of life event handler
** handled event: ET_DEATH
**
*/

#pragma strict_types

#define DEBUG

#include <events.h>
#include <combat.h>

void receive_event(mixed data, string type, int prio, int mode);

void create() 
{
  if(clonep()) 
  { 
    destruct(this_object()); 
    return; 
  }

  seteuid(getuid());
  listen_event(ET_HIT,       EPRIO_DEF_HANDLE, #'receive_event);
  listen_event(ET_DAMAGE,    EPRIO_DEF_HANDLE, #'receive_event);
  listen_event(ET_ATTACK,    EPRIO_DEF_HANDLE, #'receive_event);
  listen_event(ET_DEFEND,    EPRIO_DEF_HANDLE, #'receive_event);
  set_global_listener(ET_HIT, 1);
  set_global_listener(ET_DAMAGE, 1);
  set_global_listener(ET_ATTACK, 1);
  set_global_listener(ET_DEFEND, 1);  
}

static void Hit(mapping data)
{
    
}

static void Damage(mapping data)
{
    
}

static void Attack(mapping data)
{
    
}

static void Defend(mapping data)
{
    
}

void receive_event(mixed data, string type, int prio, int mode)
{
  mixed snd;
  
#ifdef DEBUG
  if(this_player() && this_player()->QueryProp("debug_events"))
    printf("EVENT_HANDLER: %s <%s>\nMODE: %d\nDATA: %O\n",
      load_name() ,type, mode, data);
#endif

  if(load_name(previous_object())!=EVENTD)
    raise_error(
      sprintf("EVENT_HANDLER %s: illegal call from %s\n", 
        load_name(), load_name(previous_object())));

  if(!mappingp(data))
    raise_error(
      sprintf("EVENT_HANDLER %s: data mapping empty\n", load_name()));

  if(data[E_HANDLED]) 
    return; 

  if(!objectp(snd=data[E_SENDER]))
    raise_error(
      sprintf("EVENT_HANDLER %s: no event sender specified\n", load_name()));

  switch (type)
  {
    case ET_HIT:
        Hit(data);
      break;
    case ET_DAMAGE:
        Damage(data);
      break;
    case ET_ATTACK:
        Attack(data);
      break;
    case ET_DEFEND:
        Defend(data);
      break;
    default:
      raise_error(
        sprintf("EVENT_HANDLER %s: unexpected event type %s from %s",
          load_name(),type,load_name(previous_object())));
      break;
  }
}
