//
// Wunderland Mudlib
//
// GLOBAL/HANDLERS/COMBAT.C -- Globaler Handler fuer die Kampf-Events
//
// Verarbeitete Events: ET_WIELD, ET_UNWIELD, ET_WEAR, ET_UNWEAR, ET_ATTACK, ET_DAMAGE
//
// Elric@Wunderland 10/99 - 03/00
//
// $Log:$


#pragma strict_types
#pragma no_clone
#pragma no_inherit

inherit "/std/restrictor";

#include <events.h>
#include <properties.h>
#include <combat.h>
#include <armour.h>
#include <living/body.h>

#define DEBUG

#define DEFAULT_ZONES ([ \
    AT_ARMOUR   : ({ ([ BZ_TRUNK : 1 ]), ([ BZ_ARM : 2 ]) }), \
    AT_HELMET   : ({ ([ BZ_HEAD : 1 ]),  0 }), \
    AT_GLOVE    : ({ ([ BZ_HAND : 1 ]),  0 }), \
    AT_BOOT     : ({ ([ BZ_FOOT ]),      0 }), \
    AT_TROUSERS : ({ ([ BZ_LEG : 2 ]),   ([ BZ_LEG : 2 ]) }), \
    AT_SHIELD   : ({ 0, 0 }), \
    AT_RING     : ({ 0, 0 }), \
    AT_CLOAK    : ({ 0, 0 }), \
    AT_GIRDLE   : ({ 0, 0 }), \
    AT_AMULET   : ({ 0, 0 }), \
    AT_TIARA    : ({ 0, 0 }), \
    AT_GLASSES  : ({ 0, 0 }), \
    AT_MISC     : ({ 0, 0 }) ])


public void receive_event(mixed data, string type, int prio, int mode);

private mapping default_zones = DEFAULT_ZONES;


public void create()
{
//  listen_event(ET_ATTACK, EPRIO_DEF_HANDLE, #'receive_event);
//  listen_event(ET_DAMAGE, EPRIO_DEF_HANDLE, #'receive_event);
  listen_event(ET_WIELD, EPRIO_DEF_HANDLE, #'receive_event);
  listen_event(ET_UNWIELD, EPRIO_DEF_HANDLE, #'receive_event);
  listen_event(ET_WEAR, EPRIO_DEF_HANDLE, #'receive_event);
  listen_event(ET_UNWEAR, EPRIO_DEF_HANDLE, #'receive_event);

//  set_global_listener(ET_ATTACK, 1);
//  set_global_listener(ET_DAMAGE, 1);
  set_global_listener(ET_WIELD, 1);
  set_global_listener(ET_UNWIELD, 1);
  set_global_listener(ET_WEAR, 1);
  set_global_listener(ET_UNWEAR, 1);
}


//
// Hilfsfunktion
//
private int GuildAllow(object user, object ding, int type)
{
  mixed *info;
  string *allowed;

  info = (mixed*)load_object("/secure/guildmaster")->QueryGuild(user->QueryProp(P_GUILD), 1);

  if (!sizeof(info)) return 1;

  if (!type) allowed = (string*)load_object(info[0])->QueryProp(P_WEAPONS_ALLOWED);
  else allowed = (string*)load_object(info[0])->QueryProp(P_ARMOURS_ALLOWED);

  if (!sizeof(allowed)) return 1;
  if (sizeof(allowed & (string*)ding->QueryProp(P_IDS))) return 1;

  return 0;
}


//
// Handling von ET_WIELD
//
private void WieldEvent(mapping data)
{
  object waffe, user;
  mapping restrictions;
  string text;
  int max_wc, ret;

  user = data[E_ACTOR];
  waffe = data[E_WIELD_WEAPON];

  if (!objectp(user) || !living(user)) raise_error("[ET_WIELD] Actor kein Living!");
  if (!objectp(waffe)) raise_error("[ET_WIELD] Waffe ist kein Objekt!");
  if (!waffe->IsWeapon()) raise_error("[ET_WIELD] Waffe ist keine Waffe!");

  if ((int)waffe->QueryProp(P_MAX_LIFETIME) > 0 &&
     !(int)waffe->QueryProp(P_LIFETIME))
    return (void)cancel_event(sprintf("%s ist doch kaputt!\n",
      waffe->name(WER, NAME_DEF | NAME_CAP)));

  if (!GuildAllow(user, waffe, 0))
    return (void)cancel_event(break_string(sprintf("Mitglieder Deiner Gilde duerfen %s"
      " nicht zuecken!", waffe->name(WEN, NAME_DEF))));

  max_wc = (int)waffe->QueryMaxWC(1);
  if ((max_wc == -1) || (max_wc > MAX_WEAPON_CLASS))
    return (void)cancel_event("Ungueltige Waffenklasse, bitte Erzmagier verstaendigen!\n");

  restrictions = (mapping)(waffe->QueryProp(P_WEAPON_RESTRICTIONS) || ([ A_DEX : max_wc / 7 - 6 ]));
  text = check_restrictions(user, restrictions, 0);
  if (stringp(text) && strlen(text))
    return (void)cancel_event(break_string(text));

  ret = (int)user->AddWeapon(waffe, data[E_SILENT]);
  switch (ret)
  {
    case  0: return (void)cancel_event("Mit der Waffe stimmt etwas nicht!\n");
    case -1: return (void)cancel_event("Du hast nicht genuegend Haende frei!\n");
    default: return (void)handle_event(1);
  }
}


//
// Handling von ET_UNWIELD
//
private void UnwieldEvent(mapping data)
{
  object waffe, user;
  mixed curse;

  user = data[E_ACTOR];
  waffe = data[E_UNWIELD_WEAPON];

  if (!objectp(user)) user = (object)waffe->QueryProp(P_WIELDED);
  if (!objectp(user) || !living(user)) raise_error("[ET_UNWIELD] Actor kein Living!");
  if (!objectp(waffe)) raise_error("[ET_UNWIELD] Waffe ist kein Objekt!");
  if (!waffe->IsWeapon()) raise_error("[ET_UNWIELD] Waffe ist keine Waffe!");

  curse = (mixed)waffe->QueryProp(P_CURSED);
  if (curse)
  {
    if (!stringp(curse))
      curse = sprintf("Du kannst %s nicht mehr wegstecken.", waffe->name(WEN, NAME_DEF));
    return (void)cancel_event(break_string(curse));
  }

  if (!(int)user->RemoveWeapon(waffe, data[E_SILENT])) return
    (void)cancel_event("Da ging irgendwas mit Deinen Haenden schief!\n");

  return (void)handle_event(1);
}


//
// Handling von ET_WEAR
//
private void WearEvent(mapping data)
{
  object ruestung, user;
  mapping restrictions, attribute;
  string text, stext, *rzonen, *hzonen, type;
  int max_life, life, max_ac, hands;
  mixed *zonen;

  user = data[E_ACTOR];
  ruestung = data[E_WEAR_ARMOUR];

  if (!objectp(user) || !living(user)) raise_error("[ET_WEAR] Actor kein Living!");
  if (!objectp(ruestung)) raise_error("[ET_WEAR] Ruestung ist kein Objekt!");
  if (!ruestung->IsArmour()) raise_error("[ET_WEAR] Ruestung keine Ruestung!");

  max_life = (int)ruestung->QueryProp(P_MAX_LIFETIME);
  if (max_life > 0)
  {
    life = (int)ruestung->QueryProp(P_LIFETIME);
    if (!to_int(100 * (float)life / (float)max_life + 0.5))
      return (void)cancel_event(sprintf("%s ist doch kaputt!\n",
        ruestung->name(WER, NAME_DEF|NAME_CAP)));
  }

  if (!GuildAllow(user, ruestung, 1))
    return (void)cancel_event(break_string(sprintf("Mitglieder Deiner Gilde duerfen %s nicht tragen!",
      ruestung->name(WEN, NAME_DEF))));

  max_ac = (int)ruestung->QueryMaxAC(1);
  type = (string)ruestung->QueryProp(P_ARMOUR_TYPE);
  if ((max_ac == -1) || (max_ac > VALID_ARMOUR_CLASS[type]))
    return (void)cancel_event("Ungueltige Ruestungsklasse, bitte Erzmagier verstaendigen!\n");

  restrictions = (mapping)ruestung->QueryProp(P_ARMOUR_RESTRICTIONS);

  if (mappingp(restrictions))
  {
    text = check_restrictions(user, restrictions, 1);
    if (stringp(text) && strlen(text))
      return (void)cancel_event(break_string(text));
  }

  if (type == AT_SHIELD)
  {
    hands = (int)user->AddWeapon(ruestung, data[E_SILENT]);
    switch (hands)
    {
      case  0: return (void)cancel_event("Mit dem Schild stimmt etwas nicht!\n");
      case -1: return (void)cancel_event("Du hast nicht genuegend Haende frei!\n");
      default: return (void)handle_event(1);
    }
  }

  hands = (int)user->AddArmour(ruestung, data[E_SILENT], &text);
  if (stringp(text) && strlen(text) && text[<2..<1] != "\n")
    text += "\n";

  switch (hands)
  {
    case  0:
      if (stringp(text) && strlen(text)) return (void)cancel_event(text);
      return (void)cancel_event("Mit der Ruestung stimmt etwas nicht!\n");

    case -1:
      if (stringp(text) && strlen(text)) return (void)cancel_event(text);
      return (void)cancel_event("Von dieser Sorte Ruestung kannst Du keine mehr anziehen!\n");

    case -2:
      if (stringp(text) && strlen(text)) return (void)cancel_event(text);
      return (void)cancel_event("Diese Ruestung kannst Du nicht mehr anziehen!\n");

    default: return (void)handle_event(1);
  }
}


//
// Handling von ET_UNWEAR
//
private void UnwearEvent(mapping data)
{
  object ruestung, user;
  mapping statmod;
  mixed curse;
  string text, type;

  user  = data[E_ACTOR];
  ruestung = data[E_UNWEAR_ARMOUR];

  if (!objectp(user)) user = (object)ruestung->QueryProp(P_WORN);
  if (!objectp(user) || !living(user)) raise_error("[ET_UNWEAR] Actor kein Living!");
  if (!objectp(ruestung)) raise_error("[ET_UNWEAR] Ruestung ist kein Objekt!");
  if (!ruestung->IsArmour()) raise_error("[ET_UNWEAR] Ruestung keine Waffe!");

  curse = (mixed)funcall(ruestung->QueryProp(P_CURSED));
  if (curse)
  {
    if (!stringp(curse))
      curse = sprintf("Du kannst %s nicht mehr wegstecken.", ruestung->name(WEN, NAME_DEF));
    return (void)cancel_event(break_string(curse));
  }

  type = (string)ruestung->QueryProp(P_ARMOUR_TYPE);
  if (type == AT_SHIELD)
  {
    if (!(int)user->RemoveWeapon(ruestung, data[E_SILENT]))
      return (void)cancel_event("Da ging irgendwas mit Deinen Haenden schief!\n");
  }
  else
  {
    if (!(int)user->RemoveArmour(ruestung, data[E_SILENT]))
    return (void)cancel_event("Da ging irgendwas mit Deinen Koerperzonen schief!\n");
  }

/*
	user->SetProp(P_ARMOURS, (object*)user->QueryProp(P_ARMOURS) - ({ruestung, 0}));
	user->SetActiveSkill();
	ruestung->SetProp(P_WORN, 0);
	
	statmod = (mapping)ruestung->QueryProp(P_STATMOD);
	text    = "";

	if (mappingp(statmod))
	{
		user->RemoveStatMod(ruestung);
		walk_mapping(statmod, (: $2 *= -1 :));
		text = sprintf(" und fuehlst Dich ploetzlich %s", GetStatModStr(statmod));
	}
	
	if (!data[E_SILENT])
	{
		string ut, ot;

		GetUnwearTexts(type, &ut, &ot);

		tell_object(user, break_string(sprintf(ut, ruestung->name(WEN, NAME_DEF), text)));
	
		if (!(int)user->QueryProp(P_INVIS))
			tell_room(environment(user), break_string(sprintf(ot,
				user->name(WER, NAME_CAP | NAME_AUTO),
				ruestung->name(WEN, NAME_INDEF))), ({user}));
  }
*/
  return (void)handle_event(1);
}


/*
//
// Handling von ET_ATTACK
//
private void AttackEvent(mapping data)
{
	int modifikator, zonemod, schaden, realschaden, slevel, *zone;
	object angreifer, opfer, *ausnahmen;
	string *msgs, *genesis, skill;
	mapping typen, result, hzone;
	mixed waffe;

	angreifer   = data[E_ACTOR];
	opfer       = data[E_COMBAT_TARGET];
	waffe       = data[E_COMBAT_WEAPON];
	modifikator = data[E_COMBAT_HIT_MOD];
	zone        = data[E_COMBAT_HIT_ZONE];
	zonemod     = data[E_COMBAT_HIT_ZONE_MOD];

	if (!objectp(angreifer)) raise_error("[ET_ATTACK] Angreifer kein Objekt!");
	if (!objectp(opfer)) raise_error("[ET_ATTACK] Opfer kein Objekt!");
	if (!intp(modifikator)) raise_error("[ET_ATTACK] Treffermodifikator kein Integer!");

	if (zone)
	{
		if (!pointerp(zone) && !intp(zone)) raise_error("[ET_ATTACK] Falscher Typ fuer Zone!");
		if (!pointerp(zone)) zone = ({zone});

		zone = filter(zone, #'intp) & VALID_BODYZONES;

		if (!sizeof(zone)) raise_error("[ET_ATTACK] Ungueltige Zone!");

		hzone = (mapping)opfer->GetHitZone(zone, zonemod);
	}
	else hzone = (mapping)opfer->GetHitZone();

	if (objectp(waffe)) waffe->QueryDamage(opfer, &schaden, &typen, &genesis, &msgs);
	else angreifer->QueryDamage(opfer, &schaden, &typen, &genesis, &msgs, &waffe);

	ausnahmen  = filter(all_inventory(environment(angreifer)), lambda(({'x}), ({#'call_other, 'x, "QueryProp", P_NO_FIGHT_TEXT})));
	ausnahmen += ({angreifer, opfer});

	if (!angreifer->QueryProp(P_NO_FIGHT_TEXT))
		tell_object(angreifer, sprintf("  Du greifst %s%s an.\n",
			opfer->name(WEN, NAME_DEF), msgs[0]));

	if (!opfer->QueryProp(P_NO_FIGHT_TEXT))
		tell_object(opfer, sprintf("    %s greift Dich%s an.\n",
			(string)angreifer->name(WER, NAME_AUTO | NAME_CAP), msgs[1]));

	tell_room(environment(angreifer), sprintf("  %s greift %s%s an.\n",
			(string)angreifer->name(WER, NAME_AUTO | NAME_CAP),
			opfer->name(WEN, NAME_AUTO), msgs[1]), ausnahmen);

	if (!opfer->IsEnemy(angreifer)) opfer->InsertEnemy(angreifer);

	if (objectp(waffe)) skill = (string)waffe->QueryProp(P_WEAPON_TYPE);
	else skill = WT_HANDS;

	if ((int)angreifer->QueryProp(P_ALCOHOL) * 100 / (int)angreifer->QueryProp(P_MAX_ALCOHOL) > 90) modifikator -= 10;
	if (angreifer->CannotSee(1)) modifikator -= 30;

	slevel = (int)angreifer->CheckAbility(skill, modifikator, 1);

	switch (slevel)
	{
		case -2 :
		case -1 :
		{
			if ((int)angreifer->QueryProp(P_NO_FIGHT_TEXT) != 1)
				tell_object(angreifer, sprintf("  Du verfehlst %s.\n",
					opfer->name(WEN, NAME_DEF)));

			if ((int)opfer->QueryProp(P_NO_FIGHT_TEXT) != 1)
				tell_object(opfer, sprintf("    %s verfehlt Dich.\n",
					(string)angreifer->name(WER, NAME_DEF | NAME_CAP)));

			ausnahmen  = filter(ausnahmen, lambda(({'x}), ({#'==, 1,
					({#'call_other, 'x, "QueryProp", P_NO_FIGHT_TEXT})})));
			ausnahmen += ({angreifer, opfer});

			tell_room(environment(angreifer), sprintf("  %s verfehlt %s.\n",
				(string)angreifer->name(WER, NAME_DEF | NAME_CAP),
				opfer->name(WEN, NAME_DEF)), ausnahmen);

			break;
		}
		case  1 :
		case  2 :
		{
			result = send_event(ET_DAMAGE, ([
				E_ACTOR            : angreifer,
				E_COMBAT_TARGET    : opfer,
				E_COMBAT_WEAPON    : waffe,
				E_COMBAT_DAMAGE    : schaden,
				E_COMBAT_DAM_TYPES : typen,
				E_COMBAT_GENESIS   : genesis,
				E_COMBAT_HIT_ZONE  : zone,
				E_COMBAT_MSG       : msgs[2]]),
				all_environment(angreifer)[<1]);

			if (mappingp(result)) realschaden = result[E_HANDLED];

			break;
		}
		default : raise_error("FEHLER! Fehler bei Skillauswertung!\n");
	}

	handle_event(realschaden);
}
*/


/*
//
// Handling von ET_DAMAGE
//
private void DamageEvent(mapping data)
{
	object angreifer, opfer, waffe;
	mapping typen;
	string msgs, *genesis;
	int schaden, realschaden, *zone;

	angreifer = data[E_ACTOR];
	opfer     = data[E_COMBAT_TARGET];
	waffe     = data[E_COMBAT_WEAPON];
	schaden   = data[E_COMBAT_DAMAGE];
	typen     = data[E_COMBAT_DAM_TYPES];
	genesis   = data[E_COMBAT_GENESIS];
	zone      = data[E_COMBAT_HIT_ZONE];
	msgs      = data[E_COMBAT_MSG];

	if (angreifer && !objectp(angreifer)) raise_error("[ET_DAMAGE] Angreifer kein Objekt!");
	if (!objectp(opfer)) raise_error("[ET_DAMAGE] Opfer kein Objekt!");
	if (!mappingp(typen)) raise_error("[ET_DAMAGE] Typen kein Mapping!");
	if (!intp(schaden)) raise_error("[ET_DAMAGE] Schaden kein Integer!");
	if (genesis && !stringp(genesis) && !pointerp(genesis)) raise_error("[ET_DAMAGE] Falscher Typ fuer Genesis!");
	if (!stringp(msgs)) raise_error("[ET_DAMAGE] Message kein String!");
	if (zone && !pointerp(zone)) raise_error("[ET_ATTACK] Falscher Typ fuer Zone!");

	schaden = to_int((float)schaden * 0.67 + 0.5) + random(to_int((float)schaden * 0.33 + 0.5));

	realschaden = (int)opfer->Defend(schaden, zone, typen, genesis, msgs, angreifer, waffe);

	handle_event(realschaden);
}
*/


//
// Hier kommen alle Events erstmal an
//
public void receive_event(mixed data, string type, int prio, int mode)
{
#ifdef DEBUG
  if(this_player() && this_player()->QueryProp("debug_events"))
    printf("COMBAT-HANDLER <%s>\nMODE: %d\nDATA: %O\n",type, mode, data);
#endif

  if (load_name(previous_object()) != EVENTD)
    raise_error(sprintf("ILLEGAL! Unerlaubte Benutzung des Combat-Handlers durch %O!", previous_object()));

  if (!mappingp(data))
    raise_error("FEHLER im Combat-Handler! Kein Datenmapping vorhanden!");

  if (data[E_HANDLED]) return;

  switch (type)
  {
//    case ET_ATTACK  : AttackEvent(data); break;
//    case ET_DAMAGE  : DamageEvent(data); break;
    case ET_WIELD   : WieldEvent(data); break;
    case ET_UNWIELD : UnwieldEvent(data); break;
    case ET_WEAR    : WearEvent(data); break;
    case ET_UNWEAR  : UnwearEvent(data); break;
    default : raise_error("FEHLER im Combat-Handler! Unerwarteter Event-Typ!");
  }
}
