/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:43 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: door.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/
// Wunderland Mudlib
//
// GLOBAL/HANDLERS/DOOR.C -- Globaler Handler fuer Event-Tueren
//
// Verarbeitete Events: ET_DOOR_OPEN, ET_DOOR_CLOSE
//
// Holger@Wunderland 7/99
//
// $Revision: 1.1.1.1 $
//
// $Log: door.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:43  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:09  en
// MUDLib CVS Preperation
//

#pragma strict_types

#include <events.h>
#include <properties.h>
#include <doors.h>

// Defines mit std/room/doors.c abgleichen!
#define DDEST  0 // Tuerpfad als String
#define DSTATE 1 // Status als Int
#define DFLAGS 2 // Flags als Int
#define DPROPS 3 // Tuer-Properties als Mapping
#define DDIR   4 // Exitrichtung (zur Ausgabe) als String
#define DEMSGS 5 // Exit-Messages als Array
#define DAMSGS 6 // Actor-Messages als Mapping ([Event-Typ: *Msgs])

#define DEBUG

void receive_event(mixed data, string type, int prio, int mode);

void create() {
  if(clonep()) { destruct(this_object()); return; }

  listen_event(ET_DOOR_OPEN,     EPRIO_DEF_HANDLE, #'receive_event);
  listen_event(ET_DOOR_CLOSE,    EPRIO_DEF_HANDLE, #'receive_event);
  listen_event(ET_DOOR_LOCK,     EPRIO_DEF_HANDLE, #'receive_event);
  listen_event(ET_DOOR_UNLOCK,   EPRIO_DEF_HANDLE, #'receive_event);
/*
  listen_event(ET_DOOR_BREAK,    EPRIO_DEF_HANDLE, #'receive_event);
  listen_event(ET_DOOR_REPAIR,   EPRIO_DEF_HANDLE, #'receive_event);
  listen_event(ET_DOOR_DESTRUCT, EPRIO_DEF_HANDLE, #'receive_event);
  listen_event(ET_DOOR_RENEW,    EPRIO_DEF_HANDLE, #'receive_event);
*/

  set_global_listener(ET_DOOR_OPEN,     1);
  set_global_listener(ET_DOOR_CLOSE,    1);
  set_global_listener(ET_DOOR_LOCK,     1);
  set_global_listener(ET_DOOR_UNLOCK,   1);
/*
  set_global_listener(ET_DOOR_BREAK,    1);
  set_global_listener(ET_DOOR_REPAIR,   1);
  set_global_listener(ET_DOOR_DESTRUCT, 1);
  set_global_listener(ET_DOOR_RENEW,    1);
*/
}

// Passt ein Schluessel?
private int check_door_key(object key, object room, object dest) {
  mixed comb;
  string r, d;
  int i;
  if(!pointerp(comb=(mixed)key->QueryDoorKey()))
    comb=({comb});
  r=object_name(room);
  d=object_name(dest);
  for(i=sizeof(comb);i--;) {
    if(!stringp(comb[i])) continue;
    if(!sizeof( ({r,d})-efun::explode(comb[i], "::")))
      return 1;
  }
  return 0;
}

// Hier kommt alles an
void receive_event(mixed data, string type, int prio, int mode) {
  mixed snd, dest, room, act, mess, lmsg, rmsg, omsg, key, comb;
  string door, nam, richt, gstueck;
  mapping ds, ds2, ret;
  int ri, di, k;

#ifdef DEBUG
  if(this_player() && this_player()->QueryProp("debug_events"))
    printf("DOOR-HANDLER <%s>\nMODE: %d\nDATA: %O\n",type, mode, data);
#endif

  if(load_name(previous_object())!=EVENTD)
    raise_error("ILLEGAL! Unerlaubte Benutzung des Door-Handlers!\n");

  if(!mappingp(data))
    raise_error("FEHLER! Kein Datenmapping vorhanden!\n");

  if(data[E_HANDLED]) return; // sollte eigentlich nie vorkommen...

  snd   = data[E_SENDER];
  act   = data[E_DOOR_ACTOR];
  door  = data[E_DOOR];
  room  = data[E_DOOR_ROOM];
  dest  = data[E_DOOR_DEST];
  mess  = data[E_DOOR_MSGS];
  
  if(!objectp(snd))
    raise_error("ILLEGAL! Kein Event-Sender spezifiziert!\n");

  if(!stringp(door))
    raise_error("FEHLER! Keine Tuer spezifiziert!\n");

  if(!objectp(room))
    raise_error("FEHLER! Kein Tuerraum angegeben!\n");

  if(dest && !objectp(dest))
    raise_error("FEHLER! Ziel nicht vom Typ (objectp)!\n");

  if(act && !objectp(act))
    raise_error("FEHLER! Akteur nicht vom Typ (objectp)!\n");
  
  if(mess && (!pointerp(mess) || sizeof(mess)!=3))
    raise_error("FEHLER! Groesse Messages-Array ist nicht 3!\n");

  // Tuer weg?
  if(!mappingp(ds=(mapping)room->QueryProp(P_DOORS)) || !member(ds, door)) 
    raise_error("FEHLER! Event auf nicht vorhandene Tuer!\n");

  if(pointerp(mess)) {
    lmsg=(pointerp(mess[0])?mess[0][!objectp(act)]:mess[0]);
    rmsg=(pointerp(mess[1])?mess[1][!objectp(act)]:mess[1]);
    omsg=(pointerp(mess[2])?mess[2][!objectp(act)]:mess[2]);
  }
  else {
    lmsg=0;
    rmsg=0;
    omsg=0;
  }

  switch(type) {

    case ET_DOOR_OPEN:
      if(ds[door, DSTATE]&DS_OPEN) {
        if(act) notify_fail(capitalize(
          room->QueryDoorName(door, WER, NAME_DEF|NAME_DESCR)+
          " ist doch schon offen.\n"));
        cancel_event();
        return;
      }
      if(ds[door, DSTATE]&DS_DESTRUCTED) {
        if(act) notify_fail(capitalize(
          room->QueryDoorName(door, WER, NAME_DEF|NAME_DESCR)+
          " ist voellig demoliert.\n"));
        cancel_event();
        return;
      }
      if(ds[door, DSTATE]&DS_LOCKED && !(ds[door, DSTATE]&DS_BROKEN)) {
        if(act) notify_fail(capitalize(
          room->QueryDoorName(door, WER, NAME_DEF|NAME_DESCR)+
          " ist abgeschlossen.\n"));
        cancel_event();
        return;
      }
      if(dest && mappingp(ds2=(mapping)dest->QueryProp(P_DOORS)) && 
        (k=member(m_values(ds2,DDEST),object_name(room)))!=-1) {
        gstueck=m_indices(ds2)[k];
        if(!omsg) {
          if(act) {
            switch(door) {
              case "oben": richt="unten"; break;
              case "unten": richt="oben"; break;
              default:
                ri=(int)room->QueryProp(P_INDOORS);
                di=(int)dest->QueryProp(P_INDOORS);
                if(ri && !di) richt="drinnen";
                else if(!ri && di) richt="draussen";
                else richt="der anderen Seite";
            }
            omsg=capitalize((string)dest->QueryDoorName(gstueck, WER, 
              NAME_DEF|NAME_DESCR))+" wird von "+richt+" geoeffnet.";
          }
          else {
            omsg=capitalize((string)dest->QueryDoorName(gstueck, WER, 
              NAME_DEF|NAME_DESCR))+" oeffnet sich.";
          }
        }
        else if(member(omsg, '&')!=-1) {
          omsg=implode(efun::explode(omsg, "&Name"),
            capitalize((string)act->name(WER, NAME_AUTO)));
          omsg=implode(efun::explode(omsg, "&name"),
            (string)act->name(WER, NAME_AUTO));
        }
        tell_room(dest, break_string(omsg));
        // Tuerstatus des Gegenstuecks aendern
        di=((int)dest->QueryDoorStatus(gstueck))|DS_OPEN;  // Open-Bit setzen
        if(di&DS_LOCKED) di^=DS_LOCKED;
        dest->SetDoorStatus(gstueck, di);
        dest->AddExit(gstueck,ds2[gstueck, DDEST], ds2[door, DDIR], 
          ds2[door, DEMSGS]);
      }
      if(act) {
        if(!stringp(rmsg) || !stringp(lmsg))
          nam=(string)room->QueryDoorName(door, WEN, NAME_DEF|NAME_DESCR);
        if(!rmsg)
          rmsg=capitalize((string)act->name(WER,NAME_AUTO))+" oeffnet "+nam+".";
        else if(member(rmsg, '&')!=-1) {
          rmsg=implode(efun::explode(rmsg, "&Name"),
            capitalize((string)act->name(WER, NAME_AUTO)));
          rmsg=implode(efun::explode(rmsg, "&name"),
            (string)act->name(WER, NAME_AUTO));
        }
        tell_room(room, break_string(rmsg), ({ act }) );
        if(!lmsg)
          lmsg="Du oeffnest "+nam+".";
        tell_object(act, break_string(lmsg));
      }
      else {
        if(!rmsg)
          rmsg=capitalize((string)room->QueryDoorName(door, WER, 
            NAME_DEF|NAME_DESCR))+" oeffnet sich.";
        tell_room(room, break_string(rmsg));
      }
      // Tuer-Status aendern
      ri=((int)room->QueryDoorStatus(door))|DS_OPEN;      // Open-Bit setzen
      room->SetDoorStatus(door, ri);
      room->AddExit(door,ds[door, DDEST], ds[door, DDIR], ds[door, DEMSGS]);
      break;

    case ET_DOOR_CLOSE:
      if(!(ds[door, DSTATE]&DS_OPEN)) {
        if(act) notify_fail(capitalize(
          room->QueryDoorName(door, WER, NAME_DEF|NAME_DESCR)+
          " ist doch schon geschlossen.\n"));
        cancel_event();
        return;
      }
      if(ds[door, DSTATE]&DS_DESTRUCTED) {
        if(act) notify_fail(capitalize(
          room->QueryDoorName(door, WER, NAME_DEF|NAME_DESCR)+
          " ist voellig demoliert.\n"));
        cancel_event();
        return;
      }
      if(dest && mappingp(ds2=(mapping)dest->QueryProp(P_DOORS)) && 
        (k=member(m_values(ds2,DDEST),object_name(room)))!=-1) {
        gstueck=m_indices(ds2)[k];
        if(!omsg) {
          if(act) {
            switch(door) {
              case "oben": richt="unten"; break;
              case "unten": richt="oben"; break;
              default:
                ri=(int)room->QueryProp(P_INDOORS);
                di=(int)dest->QueryProp(P_INDOORS);
                if(ri && !di) richt="drinnen";
                else if(!ri && di) richt="draussen";
                else richt="der anderen Seite";
            }
            omsg=capitalize((string)dest->QueryDoorName(gstueck, WER, 
              NAME_DEF|NAME_DESCR))+" wird von "+richt+" geoeffnet.";
          }
          else {
            omsg=capitalize((string)dest->QueryDoorName(gstueck, WER, 
              NAME_DEF|NAME_DESCR))+" schliesst sich.";
          }
        }
        else if(member(omsg, '&')!=-1) {
          omsg=implode(efun::explode(omsg, "&Name"),
            capitalize((string)act->name(WER, NAME_AUTO)));
          omsg=implode(efun::explode(omsg, "&name"),
            (string)act->name(WER, NAME_AUTO));
        }
        tell_room(dest, break_string(omsg));
        // Tuerstatus des Gegenstuecks aendern
        di=(int)dest->QueryDoorStatus(gstueck);
        if(di&DS_OPEN) {
          di^=DS_OPEN;   // Open-Bit weg
          dest->SetDoorStatus(gstueck, di);
        }
        dest->RemoveExit(gstueck);
      }
      if(act) {
        if(!stringp(rmsg) || !stringp(lmsg))
          nam=(string)room->QueryDoorName(door, WEN, NAME_DEF|NAME_DESCR);
        if(!rmsg)
          rmsg=capitalize((string)act->name(WER,NAME_AUTO))+" schliesst "+nam+".";
        else if(member(rmsg, '&')!=-1) {
          rmsg=implode(efun::explode(rmsg, "&Name"),
            capitalize((string)act->name(WER, NAME_AUTO)));
          rmsg=implode(efun::explode(rmsg, "&name"),
            (string)act->name(WER, NAME_AUTO));
        }
        tell_room(room, break_string(rmsg), ({ act }) );
        if(!lmsg)
          lmsg="Du schliesst "+nam+".";
        tell_object(act, break_string(lmsg));
      }
      else {
        if(!rmsg)
          rmsg=capitalize((string)room->QueryDoorName(door, WER, 
            NAME_DEF|NAME_DESCR))+" schliesst sich.";
        tell_room(room, break_string(rmsg));
      }
      // Tuer-Status aendern
      ri=(((int)room->QueryDoorStatus(door))^DS_OPEN);        // Open-Bit weg
      room->SetDoorStatus(door, ri);
      room->RemoveExit(door);
      if(ds[door, DFLAGS]&DF_LOCK_ALWAYS) {
        nam=capitalize((string)room->QueryDoorName(door, WER, NAME_DEF));
        send_event(ET_DOOR_LOCK, ([
          E_DOOR      : door,
          E_DOOR_ROOM : room,
          E_DOOR_DEST : dest,
          E_DOOR_ACTOR: 0,
          E_DOOR_MSGS : ({0,
            nam+" faellt ins Schloss.",
            nam+" faellt ins Schloss."})]),
          ({room, dest}), EM_SIMPLE);
      }
      break;

    case ET_DOOR_LOCK:
      if(act && !objectp(key=data[E_DOOR_KEY]))
        raise_error("FEHLER! Interactive ET_DOOR_LOCK braucht ein E_DOOR_KEY-Object!\n");
      if(ds[door, DSTATE]&DS_LOCKED) {
        if(act) notify_fail(capitalize(
          room->QueryDoorName(door, WER, NAME_DEF|NAME_DESCR)+
          " ist schon abgeschlossen.\n"));
        cancel_event();
        return;
      }
      if(ds[door, DSTATE]&DS_OPEN) {
        if(act) notify_fail("Du musst "+
          room->QueryDoorName(door, WEN, NAME_DEF)+
          " ersteinmal schliessen.\n");
        cancel_event();
        return;
      }
      if(ds[door, DSTATE]&DS_DESTRUCTED) {
        if(act) notify_fail(capitalize((string)
          room->QueryDoorName(door, WER, NAME_DEF))+
          " ist voellig demoliert.\n");
        cancel_event();
        return;
      }
      if(!(ds[door, DFLAGS]&DF_LOCKABLE)) {
        if(act) notify_fail(capitalize((string)
          room->QueryDoorName(door, WEN, NAME_DEF))+
          " kann man nicht abschliessen.\n");
        cancel_event();
        return;
      }
      if(ds[door, DSTATE]&DS_BROKEN) {
        if(act) notify_fail("Das Schloss "+
          room->QueryDoorName(door, WESSEN, NAME_DEF)+
          " ist kaputt.\n");
        cancel_event();
        return;
      }
      if(act && !check_door_key(key, room, dest)) {
        if(act) notify_fail(capitalize((string)
          key->name(WER,NAME_DEF|NAME_DESCR))+" passt hier nicht.\n");
        cancel_event();
        return;
      }
      if(dest && mappingp(ds2=(mapping)dest->QueryProp(P_DOORS)) && 
        (k=member(m_values(ds2,DDEST),object_name(room)))!=-1) {
        gstueck=m_indices(ds2)[k];
        if((int)dest->QueryDoorFLAGS(gstueck)&DF_LOCKABLE) {
          if(!omsg) {
            if(act) {
              switch(door) {
                case "oben": richt="unten"; break;
                case "unten": richt="oben"; break;
                default:
                  ri=(int)room->QueryProp(P_INDOORS);
                  di=(int)dest->QueryProp(P_INDOORS);
                  if(ri && !di) richt="drinnen";
                  else if(!ri && di) richt="draussen";
                  else richt="der anderen Seite";
              }
              omsg=capitalize((string)dest->QueryDoorName(gstueck, WER, 
                NAME_DEF|NAME_DESCR))+" wird von "+richt+" abgeschlossen.";
            }
            else {
              omsg="Das Schloss "+(string)dest->QueryDoorName(gstueck, WESSEN, 
                NAME_DEF|NAME_DESCR)+" macht: <KLACK>";
            }
          }
          else if(member(omsg, '&')!=-1) {
            omsg=implode(efun::explode(omsg, "&Name"),
              capitalize((string)act->name(WER, NAME_AUTO)));
            omsg=implode(efun::explode(omsg, "&name"),
              (string)act->name(WER, NAME_AUTO));
          }
          tell_room(dest, break_string(omsg));
          // Tuerstatus des Gegenstuecks aendern
          di=((int)dest->QueryDoorStatus(gstueck))|DS_LOCKED;  // Locked-Bit setzen
          dest->SetDoorStatus(gstueck, di);
        }
      }
      if(act) {
        if(!stringp(rmsg) || !stringp(lmsg))
          nam=(string)room->QueryDoorName(door, WEN, NAME_DEF|NAME_DESCR);
        if(!rmsg)
          rmsg=capitalize((string)act->name(WER,NAME_AUTO))+" schliesst "+nam+
            " ab.";
        else if(member(rmsg, '&')!=-1) {
          rmsg=implode(efun::explode(rmsg, "&Name"),
            capitalize((string)act->name(WER, NAME_AUTO)));
          rmsg=implode(efun::explode(rmsg, "&name"),
            (string)act->name(WER, NAME_AUTO));
        }
        tell_room(room, break_string(rmsg), ({ act }) );
        if(!lmsg)
          lmsg="Du schliesst "+nam+" ab.";
        tell_object(act, break_string(lmsg));
      }
      else {
        if(!rmsg)
          rmsg="Das Schloss "+(string)room->QueryDoorName(door, WESSEN, 
            NAME_DEF|NAME_DESCR)+" macht: <KLACK>";
        tell_room(room, break_string(rmsg));
      }
      // Tuer-Status aendern
      ri=((int)room->QueryDoorStatus(door))|DS_LOCKED;      // Locked-Bit setzen
      room->SetDoorStatus(door, ri);
      break;

    case ET_DOOR_UNLOCK:
      if(act && !objectp(key=data[E_DOOR_KEY]))
        raise_error("FEHLER! ET_DOOR_UNLOCK braucht ein E_DOOR_KEY-Object!\n");
      if(!(ds[door, DSTATE]&DS_LOCKED)) {
        if(act) notify_fail(capitalize(
          room->QueryDoorName(door, WER, NAME_DEF|NAME_DESCR)+
          " ist nicht abgeschlossen.\n"));
        cancel_event();
        return;
      }
      if(ds[door, DSTATE]&DS_DESTRUCTED) {
        if(act) notify_fail(capitalize((string)
          room->QueryDoorName(door, WER, NAME_DEF))+
          " ist voellig demoliert.\n");
        cancel_event();
        return;
      }
      if(ds[door, DSTATE]&DS_BROKEN) {
        if(act) notify_fail("Das Schloss "+
          room->QueryDoorName(door, WESSEN, NAME_DEF)+
          " ist kaputt.\n");
        cancel_event();
        return;
      }
      if(act && !check_door_key(key, room, dest)) {
        if(act) notify_fail(capitalize((string)
          key->name(WER,NAME_DEF|NAME_DESCR))+" passt hier nicht.\n");
        cancel_event();
        return;
      }
      if(dest && mappingp(ds2=(mapping)dest->QueryProp(P_DOORS)) && 
        (k=member(m_values(ds2,DDEST),object_name(room)))!=-1) {
        gstueck=m_indices(ds2)[k];
        if(!omsg) {
          if(act) {
            switch(door) {
              case "oben": richt="unten"; break;
              case "unten": richt="oben"; break;
              default:
                ri=(int)room->QueryProp(P_INDOORS);
                di=(int)dest->QueryProp(P_INDOORS);
                if(ri && !di) richt="drinnen";
                else if(!ri && di) richt="draussen";
                else richt="der anderen Seite";
            }
            omsg=capitalize((string)dest->QueryDoorName(gstueck, WER, 
              NAME_DEF|NAME_DESCR))+" wird von "+richt+" aufgeschlossen.";
          }
          else {
            omsg="Das Schloss "+(string)dest->QueryDoorName(gstueck, WESSEN, 
              NAME_DEF|NAME_DESCR)+" macht: <KLICK>";
          }
        }
        else if(member(omsg, '&')!=-1) {
          omsg=implode(efun::explode(omsg, "&Name"),
            capitalize((string)act->name(WER, NAME_AUTO)));
          omsg=implode(efun::explode(omsg, "&name"),
            (string)act->name(WER, NAME_AUTO));
        }
        tell_room(dest, break_string(omsg));
        // Tuerstatus des Gegenstuecks aendern
        di=(int)dest->QueryDoorStatus(gstueck);
        if(di&DS_LOCKED) {
          di^=DS_LOCKED;  // Locked-Bit setzen
          dest->SetDoorStatus(gstueck, di);
        }
      }
      if(act) {
        if(!stringp(rmsg) || !stringp(lmsg))
          nam=(string)room->QueryDoorName(door, WEN, NAME_DEF|NAME_DESCR);
        if(!rmsg)
          rmsg=capitalize((string)act->name(WER,NAME_AUTO))+" schliesst "+nam+
            " auf.";
        else if(member(rmsg, '&')!=-1) {
          rmsg=implode(efun::explode(rmsg, "&Name"),
            capitalize((string)act->name(WER, NAME_AUTO)));
          rmsg=implode(efun::explode(rmsg, "&name"),
            (string)act->name(WER, NAME_AUTO));
        }
        tell_room(room, break_string(rmsg), ({ act }) );
        if(!lmsg)
          lmsg="Du schliesst "+nam+" auf.";
        tell_object(act, break_string(lmsg));
      }
      else {
        if(!rmsg)
          rmsg="Das Schloss "+(string)room->QueryDoorName(door, WESSEN, 
            NAME_DEF|NAME_DESCR)+" macht: <KLICK>";
        tell_room(room, break_string(rmsg));
      }
      // Tuer-Status aendern
      ri=((int)room->QueryDoorStatus(door))^DS_LOCKED;  // Locked-Bit loeschen
      room->SetDoorStatus(door, ri);
      break;

    default:
      raise_error("FEHLER! Unerwarteter Event-Typ!\n");
  }
  handle_event(1);
}

