/*******************
** Eldarea MUDLib **
********************
**
** /global/handler/moving - moving handler
**
** CVS DATA
** $Date: 2001/02/01 09:02:18 $
** $Revision: 1.3 $
**
** this handler handles complete moving events
**
** CVS History
**
** $Log: moving.c,v $
** Revision 1.3  2001/02/01 09:02:18  elatar
** handling slightly changed, moving moved back to object
**
** Revision 1.2  2000/12/01 15:27:59  elatar
** new moving behaviour implemented
**
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strict_types

#include <events.h>
#include <moving.h>
#include <wizlevels.h>

#define DEBUG

void receive_event(mixed data, string type, int prio, int mode);

void create() {
  if(clonep()) { destruct(this_object()); return; }

  listen_event(ET_GO,    EPRIO_DEF_HANDLE, #'receive_event);
  listen_event(ET_TPORT, EPRIO_DEF_HANDLE, #'receive_event);

  set_global_listener(ET_GO, 1);
  set_global_listener(ET_TPORT, 1);
}

// Hier kommt alles an
void receive_event(mixed data, string type, int prio, int mode) {
  mixed ob, snd, dest;
  int method, ret;

#ifdef DEBUG
  if(this_player() && this_player()->QueryProp("debug_events"))
    printf("MOVING-HANDLER <%s>\nMODE: %d\nDATA: %O\n",type, mode, data);
#endif

  if(load_name(previous_object())!=EVENTD)
    raise_error("ILLEGAL! Unerlaubte Benutzung des Move-Handlers!\n");

  if(!mappingp(data))
    raise_error("FEHLER! Kein Datenmapping vorhanden!\n");

  if(data[E_HANDLED]) return; // sollte eigentlich nie vorkommen...

  if(!objectp(snd=data[E_SENDER]))
    raise_error("ILLEGAL! Kein Event-Sender spezifiziert!\n");

  if(!objectp(ob=data[E_MOVE_OBJ]))
    raise_error("FEHLER! Kein Objekt spezifiziert!\n");

  if(!objectp(dest=data[E_MOVE_DEST]) && !objectp(dest=load_object(dest)))
    raise_error("FEHLER! Kein Zielobjekt angegeben!\n");

  if(type==ET_GO)
    method=(M_GO|data[E_MOVE_METHOD]);
  else if(type==ET_TPORT)
  {
    method=(M_TPORT|data[E_MOVE_METHOD]);
    data[E_MOVE_EXHAUST]=-1;
  }
  else
    raise_error("FEHLER! Unerwarteter Event-Typ!\n");

  ret=(int)ob->move(dest, method|M_NOEVENT, data[E_MOVE_DIRS], data[E_MOVE_VERBS]);
   
  handle_event(ret);
}

