/*******************
** Eldarea MUDLib **
********************
**
** global/handler/put_and_get.c - global put&get event handler
**
** CVS DATA
** $Date: 1999/11/05 12:30:43 $
** $Revision: 1.1.1.1 $
**
** handled events: 
**
** ET_GET
** ET_PUT
** ET_GIVE
** ET_DROP
**
** CVS History
**
** $Log: put_and_get.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
*/

#pragma strict_types

#include <events.h>
#include <moving.h>

#define DEBUG

void receive_event(mixed data, string type, int prio, int mode);

void create() {
  if(clonep()) { destruct(this_object()); return; }

  listen_event(ET_GET,   EPRIO_DEF_HANDLE, #'receive_event);
  listen_event(ET_PUT,   EPRIO_DEF_HANDLE, #'receive_event);
  listen_event(ET_GIVE,  EPRIO_DEF_HANDLE, #'receive_event);
  listen_event(ET_DROP,  EPRIO_DEF_HANDLE, #'receive_event);

  set_global_listener(ET_GET, 1);
  set_global_listener(ET_PUT, 1);
  set_global_listener(ET_GIVE, 1);
  set_global_listener(ET_DROP, 1);
}

// Hier kommt alles an
void receive_event(mixed data, string type, int prio, int mode) {
  mixed ob, snd, dest;
  int method, ret;
  string inmsg, dirmsg, outmsg;

#ifdef DEBUG
  if(this_player() && this_player()->QueryProp("debug_events"))
    printf("PUT_AND_GET-HANDLER <%s>\nMODE: %d\nDATA: %O\n",type, mode, data);
#endif

  if(load_name(previous_object())!=EVENTD)
    raise_error("ILLEGAL! Unerlaubte Benutzung des Move-Handlers!\n");

  if(!mappingp(data))
    raise_error("FEHLER! Kein Datenmapping vorhanden!\n");

  if(data[E_HANDLED]) return; // sollte eigentlich nie vorkommen...

  if(!objectp(snd=data[E_SENDER]))
    raise_error("ILLEGAL! Kein Event-Sender spezifiziert!\n");

  if(!objectp(ob=data[E_MOVE_OBJ]))
    raise_error("FEHLER! Kein Objekt spezifiziert!\n");

  if(!objectp(dest=data[E_MOVE_DEST]) && !objectp(dest=load_object(dest)))
    raise_error("FEHLER! Kein Zielobjekt angegeben!\n");

  switch(type) {
    case ET_GET:
      ret=(int)ob->move(dest, (M_GET|data[E_MOVE_METHOD]));
      break;
    case ET_PUT:
      ret=(int)ob->move(dest, (M_PUT|data[E_MOVE_METHOD]));
      break;
    case ET_GIVE:
      ret=(int)ob->move(dest, (M_GIVE|data[E_MOVE_METHOD]));
      break;
    case ET_DROP:
      ret=(int)ob->move(dest, (M_DROP|data[E_MOVE_METHOD]));
      break;
    default:
      raise_error("FEHLER! Unerwarteter Event-Typ!\n");
  }

  handle_event(ret);
}

