/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:43 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: doormaster.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. MUDlib
// Basierend auf Wunderland Mudlib
//
// GLOBAL/SERVICE/DOORMASTER.C --- Main-Object for all NewDoors
//
// $Revision: 1.1.1.1 $
//
// $Log: doormaster.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:43  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:09  en
// MUDLib CVS Preperation
//
// Revision 1.1  1999/08/05 12:45:18  Largo
// Initial revision
//

#include <properties.h>
#include <defines.h>
#include <moving.h>
#include <doorroom.h>
#include <events.h>

inherit "std/thing";

#pragma strong_types

private mapping door_status;
// Format: "filename1:filename2":status

mapping QueryAllDoors() {
  return door_status;
}

int QueryDoorStatus(string dest) {
  string source;
  object env;

  if(!dest||!objectp(env=previous_object())) return 0;
  return door_status[((string)(((source=file_name(env))<dest)?
			       (source+":"+dest):
			       (dest+":"+source)))];
}

void SetDoorStatus(string dest, int x)
{
  string source;
  object env;

  if(!dest||!objectp(env=previous_object())) return;
  door_status[((string)(((source=file_name(env))<dest)?
			(source+":"+dest):
			(dest+":"+source)))]=x;
}

void create()
{
  door_status=([]);
  if(clonep()) destruct(this_object());
}

int remove(){}

private static string *make_dadj(int gen, string *adj)
{
  int i;
  string *ret;
  if(!adj||!pointerp(adj)||!sizeof(adj)) return ({});
  for(i=0,ret=({});i<sizeof(adj);i++)
    if(lower_case(adj[i])[<1]!='e')
      ret+=({
	({ adj[i]+"es", adj[i]+"en", adj[i]+"em", adj[i]+"e" }),
	({ adj[i]+"er", adj[i]+"en", adj[i]+"em", adj[i]+"e" }),
	({ adj[i]+"e",  adj[i]+"en", adj[i]+"er" }) })[gen%3];
    else
      ret+=({
	({ adj[i]+"s", adj[i]+"n", adj[i]+"m", adj[i] }),
	({ adj[i]+"r", adj[i]+"n", adj[i]+"m", adj[i] }),
	({ adj[i],     adj[i]+"n", adj[i]+"r" }) })[gen%3];
  return ret;
}

varargs int NewDoor(mixed cmds, string dest, mixed ids, mixed *props)
{
  object env;
  string source,dkey;
  mixed *info2;
  mapping info;
  int i;

  if(!objectp(env=previous_object())||
     !cmds||!dest) return 0;
  if(!ids) ids=({"tuer"});
  if(stringp(cmds)) cmds=({cmds});
  if(stringp(ids)) ids=({ids});
  if(!pointerp(cmds)||!pointerp(ids)) return 0;
  if(dest[0..0]!="/") dest="/"+dest;

  info=([
       D_DEST:dest,
       D_CMDS:cmds,
       D_IDS:ids,
       D_FLAGS:(DOOR_CLOSED|DOOR_RESET_CL),
       D_LONG:"Eine Tuer.\n",
       D_SHORT:"Eine %se Tuer. ",
       D_NAME:"Tuer",
       D_GENDER:FEMALE,
       D_ADJECTIVES:({}),
       D_PICKLOCK: 0,
	 ]);

  if(pointerp(props))
    for(i=0;i<sizeof(props)-1;i+=2)
      if(intp(props[i])&&props[i]>=D_MINPROPS&&props[i]<=D_MAXPROPS)
        info[props[i]]=props[i+1];

  // Nur initialisieren, wenn Tuer noch nicht existiert.
  if(!door_status[(dkey=((string)(((source=file_name(env))<dest)?
				   (source+":"+dest):
				   (dest+":"+source))))])
    {
      if(info[D_FLAGS] & DOOR_OPEN)
	door_status[dkey]=1;
      if(info[D_FLAGS] & DOOR_CLOSED)
        door_status[dkey]=((info[D_FLAGS] & DOOR_NEEDKEY) ? -2 : -1);
    }
  if(!pointerp((info2=env->QueryProp(P_DOOR_INFOS))))
    info2=({info});
  else
    info2+=({info});
  env->SetProp(P_DOOR_INFOS,info2);
  env->AddDoorDetail(ids,make_dadj(info[D_GENDER],info[D_ADJECTIVES]),
		     info[D_LONG]);

  return 1;
}

void init_doors()
{
  object env;
  mixed *info;
  string source,dest;
  int i;

  if(!objectp(env=previous_object())||
     !pointerp((info=env->QueryProp(P_DOOR_INFOS)))) return;

  for(source=file_name(env),i=sizeof(info)-1;i>=0;i--)
    {
      if(!mappingp(info[i])) continue;
      dest=info[i][D_DEST];
      env->set_doors(info[i][D_CMDS],
		     (door_status[((string)((source<dest)?
					    (source+":"+dest):
					    (dest+":"+source)))]>0));
    }
}

string look_doors()
{
  object env;
  mixed *info;
  string source,dkey,dest,res,r;
  int i;

  if(!objectp(env=previous_object())||
     !pointerp((info=env->QueryProp(P_DOOR_INFOS)))) return "";
  init_doors(); // Aktueller Zustand soll auch bei den Exits angezeigt werden

  for(source=file_name(env),res="",i=sizeof(info)-1;i>=0;i--)
    {
      if(!mappingp(info[i])) continue;
      dkey=((string)((source<(dest=info[i][D_DEST]))?
		     (source+":"+dest):
		     (dest+":"+source)));
      if(stringp(info[i][D_SHORT]))
      {
	  r = "";
	  switch (door_status[dkey])
	  {
	    case 1: r += "geoeffnet"; break;
	    case 2: r += "aufgebrochen"; break;
	    case -2: r += "ab"; // kein break!!
	    default: r += "geschlossen";
	  }
	  res += sprintf(info[i][D_SHORT], r);
	  if (strlen(res) && res[<1]!='\n') res+=" ";
      }
    }
  if(res&&res!="")
  {
    if (res[<1]=='\n') res=res[0..<2];
    return res;
  }
  return res;
}

static void door_message(object room, string dname, int dgender, string msg,
			 string *adj)
{
  object ob;

  if(!room||!dname||!msg) return;
  (ob=this_object())->SetProp(P_NAME,dname);
  ob->SetProp(P_GENDER,dgender);
  ob->SetProp(P_ARTICLE,1);
  if(adj&&sizeof(adj))
    ob->SetProp(P_NAME_ADJ,adj);
  else
    ob->SetProp(P_NAME_ADJ,0);
  tell_room(room,capitalize(ob->name(WER))+msg+"\n");
}

static void door_message_other(string source, string dest, string msg,
			       string *adj)
{
  mixed info;
  object env;
  int i;

  if(!source||!dest||!msg||
     !objectp(env=find_object(dest))||
     !pointerp(info=env->QueryProp(P_DOOR_INFOS))) return;
  for(i=sizeof(info)-1;i>=0;i--)
    {
      if(!mappingp(info[i])||
	 info[i][D_DEST]!=source) continue; // Andere Tuer zu diesem Raum
      door_message(env,info[i][D_NAME],info[i][D_GENDER],msg,adj);
    }
}

void reset_doors()
{
  object env;
  mixed *info;
  string source,dest,dkey;
  int i,j;

  if(!objectp(env=previous_object())||
     !pointerp((info=env->QueryProp(P_DOOR_INFOS)))) return;

  for(source=file_name(env),i=sizeof(info)-1;i>=0;i--)
    {
      if(!mappingp(info[i])) continue;
      dkey=((string)((source<(dest=info[i][D_DEST]))?
		     (source+":"+dest):
		     (dest+":"+source)));

      // Tuer muss bei Reset geschlossen werden
      if(info[i][D_FLAGS]&DOOR_RESET_CL)
	{
	  if(door_status[dkey]>0)
	    {
	      door_message(env,info[i][D_NAME],info[i][D_GENDER],
			   " schliesst sich.",info[i][D_ADJECTIVES]);
	      door_message_other(source,dest," schliesst sich.",
				 info[i][D_ADJECTIVES]);
	    }
	  if(door_status[dkey]!=-2)
	    door_status[dkey]=((info[i][D_FLAGS]&DOOR_NEEDKEY)?-2:-1);
	}
      // Tuer muss bei Reset geoeffnet werden
      if(info[i][D_FLAGS]&DOOR_RESET_OP)
	{
	  if(door_status[dkey]<=0)
	    {
	      door_message(env,info[i][D_NAME],info[i][D_GENDER],
			   " oeffnet sich.",info[i][D_ADJECTIVES]);
	      door_message_other(source,dest," oeffnet sich.",
				 info[i][D_ADJECTIVES]);
	    }
	  door_status[dkey]=1;
	}
    }
  init_doors();
}

static varargs int exec_func2(string dest, mixed func)
{
  if(!stringp(dest)||!stringp(func)) return 1;
  call_other(dest,func);
  return 1;
}

varargs int go_door(string str)
{
  object env,pl,ob, ziel;
  mixed *info,msg;
  string source,dest,dkey,*adj;
  int i, k;
  mapping ret;

  if(!str||
     !objectp(env=previous_object())||
     !objectp(pl=this_player())||
     !pointerp((info=env->QueryProp(P_DOOR_INFOS)))) return 0;

  for(source=file_name(env),
      (ob=this_object())->SetProp(P_ARTICLE,1),i=sizeof(info)-1;i>=0;i--)
    {
      if(!mappingp(info[i])||
	 member_array(str,info[i][D_CMDS])<0) continue;
      dkey=((string)((source<(dest=info[i][D_DEST]))?
		     (source+":"+dest):
		     (dest+":"+source)));
      ob->SetProp(P_NAME,info[i][D_NAME]);
      ob->SetProp(P_GENDER,info[i][D_GENDER]);
      if((adj=info[i][D_ADJECTIVES])&&sizeof(adj))
	ob->SetProp(P_NAME_ADJ,adj);
      else
        ob->SetProp(P_NAME_ADJ,0);
      notify_fail(capitalize(ob->name(WER,1))+" ist geschlossen.\n");
      if(door_status[dkey]<=0) continue; // Tuer geschlossen
      if(stringp(info[i][D_TESTFUNC])&&
	 (int)call_other(env,info[i][D_TESTFUNC]))
	return 1; // Durchgang von der Tuer nicht erlaubt.
      if(stringp(info[i][D_FUNC]))
	call_other(env,info[i][D_FUNC]);
      if(stringp((msg=info[i][D_MSGS])))
	msg=({ msg });

      ziel=load_object(dest);   
      if(!pointerp(msg)) {
        ret=EVENTD->send(ET_GO, ([
              E_MOVE_OBJ:pl,
              E_MOVE_DEST:ziel,
              E_MOVE_MSGDIR:"nach "+capitalize(str) ]),
              ({env, ziel}) );
        if(mappingp(ret) && ret[E_HANDLED]>0)
          return exec_func2(dest,info[i][D_FUNC2]);
        return 0;
      }
      else {
        k=sizeof(msg);
        ret=EVENTD->send(ET_GO, ([
              E_MOVE_OBJ:pl,
              E_MOVE_DEST:ziel,
              E_MOVE_MSGDIR:(k>0?msg[0]:0),
              E_MOVE_MSGOUT:(k>1?msg[1]:0),
              E_MOVE_MSGIN: (k>2?msg[2]:0) ]),
              ({env, ziel}) );
        if(mappingp(ret) && ret[E_HANDLED]>0)
	  return exec_func2(dest,info[i][D_FUNC2]);
        return 0;
      }
    }
  return 0;
}

int check_adjectives(string *to_check,string *templ)
{
  int i;
  if(sizeof(to_check)&&!sizeof(templ))
    return 0;
  if(!to_check||!sizeof(to_check))
    return 1;
  for(i=0;i<sizeof(to_check);i++)
    if(member_array(to_check[i],templ)<0)
      return 0;
  return 1;
}

int oeffnen(string str, int silent)
{
  object env,schl,ob;
  mixed *info,s2;
  string source,dkey,dest,s1,*adj,*ladj;
  int i;

  notify_fail("WAS willst Du oeffnen?\n");
  if(!str||!this_player()) return 0;
  notify_fail("Das kannst Du nicht oeffnen.\n");
  if(sscanf((str=lower_case(str)),"%s mit %s",s1,s2)!=2)
    {
      s1=str;
      s2=0;
    }
  if(s2)
    if(!(schl=present(lower_case(s2),this_player())))
      {
	notify_fail("So einen Schluessel hast Du nicht.\n");
	return 0;
      }
    else
      {
	s2=schl->QueryDoorKey();
	if(stringp(s2)) s2=({s2});
      }
  if(!objectp(env=previous_object())||
     !pointerp((info=env->QueryProp(P_DOOR_INFOS)))) return 0;
  if(sizeof((ladj=efun::explode(s1," ")-({""})))>1)
    {
      s1=ladj[<1];
      ladj=ladj[0..<2];
    }
  else
    ladj=0;

  for(source=file_name(env),(ob=this_object())->SetProp(P_ARTICLE,1),
      i=sizeof(info)-1;i>=0;i--)
    {
      if(!mappingp(info[i])||
	 member_array(s1,info[i][D_IDS])<0||
	 !check_adjectives(ladj,
			   make_dadj(info[i][D_GENDER],
				     info[i][D_ADJECTIVES])))
	 continue; // Falsche Tuer
      ob->SetProp(P_NAME,info[i][D_NAME]);
      ob->SetProp(P_GENDER,info[i][D_GENDER]);
      if((adj=info[i][D_ADJECTIVES])&&sizeof(adj))
	ob->SetProp(P_NAME_ADJ,adj);
      else
        ob->SetProp(P_NAME_ADJ,0);
      dkey=((string)((source<(dest=info[i][D_DEST]))?
		     (source+":"+dest):
		     (dest+":"+source)));
      notify_fail(capitalize(ob->name(WER,1))+" ist doch schon geoeffnet!\n");
      if(door_status[dkey]>0)
	continue; // Eine andere Tuer koennte gemeint sein.
      if((info[i][D_FLAGS]&DOOR_NEEDKEY)&&
	 door_status[dkey]!=-1)
	{ // abgeschlossen
	  notify_fail("Du brauchst einen Schluessel um "+ob->name(WEN,1)+
		      " zu oeffnen.\n");
	  if(!schl) continue; // Eine andere Tuer koennte gemeint sein.
	  notify_fail(capitalize(schl->name(WER))+" passt nicht!\n");
	  if(!pointerp(s2)) continue;
	  if(member(s2,dkey)<0) continue; // Koennte an einer anderen passen.
	}
      door_status[dkey]=1;
      init_doors();
      if(!silent)
	{
          write("Du oeffnest " + ob->name(WEN, 2) + ".\n");
          say(capitalize(ob->name(WER,2))+" wird von "+this_player()->name(WEM)+
	      " geoeffnet.\n");
	  door_message_other(source,dest,
			     " wird von der anderen Seite geoeffnet.",adj);
	}
      return 1;
    }
  return 0;
}

int schliessen(string str,int silent)
{
  object env,schl,ob;
  mixed *info,s2;
  string source,dkey,dest,s1,*adj,*ladj;
  int i,abg;

  notify_fail("WAS willst Du schliessen?\n");
  if(!str||!this_player()) return 0;
  notify_fail("Das kannst Du nicht schliessen.\n");
  if(sscanf((str=lower_case(str)),"%s mit %s",s1,s2)!=2)
    {
      s1=str;
      s2=0;
    }
  if(s2)
    if(!(schl=present(lower_case(s2),this_player())))
      {
	notify_fail("So einen Schluessel hast Du nicht.\n");
	return 0;
      }
    else
      {
	s2=schl->QueryDoorKey();
	if(stringp(s2)) s2=({s2});
      }

  if(!objectp(env=previous_object())||
     !pointerp((info=env->QueryProp(P_DOOR_INFOS)))) return 0;

  if(sizeof((ladj=efun::explode(s1," ")-({""})))>1)
    {
      s1=ladj[<1];
      ladj=ladj[0..<2];
    }
  else
    ladj=0;

  for(source=file_name(env),(ob=this_object())->SetProp(P_ARTICLE,1),
      abg=0,i=sizeof(info)-1;i>=0;i--)
    {
      if(!mappingp(info[i])||
	 member_array(s1,info[i][D_IDS])<0||
	 !check_adjectives(ladj,
			   make_dadj(info[i][D_GENDER],
				     info[i][D_ADJECTIVES])))
	 continue; // Falsche Tuer
      ob->SetProp(P_NAME,info[i][D_NAME]);
      ob->SetProp(P_GENDER,info[i][D_GENDER]);
      if((adj=info[i][D_ADJECTIVES])&&sizeof(adj))
	ob->SetProp(P_NAME_ADJ,adj);
      else
        ob->SetProp(P_NAME_ADJ,0);
      dkey=((string)((source<(dest=info[i][D_DEST]))?
		     (source+":"+dest):
		     (dest+":"+source)));
      if(schl)
	{
	  notify_fail(capitalize(ob->name(WER,1))+
		      " ist doch schon abgeschlossen!\n");
	  if(door_status[dkey]<=0 && door_status[dkey]!=-1)
	    continue; // Eine andere Tuer koennte gemeint sein.
	  if(info[i][D_FLAGS]&DOOR_CLOSEKEY)
	    { // Schluessel noetig?
	      notify_fail(capitalize(schl->name(WER))+" passt nicht!\n");
	      if(!pointerp(s2)) continue;
	      if(member(s2,dkey)<0) continue; // Koennte an einer anderen passen.
	      door_status[dkey]=-2;
	      abg=1;  // Tuer wird richtig abgeschlossen
	    }
	  else // ohne Schluessel abschliessbar
	    door_status[dkey]=((info[i][D_FLAGS]&DOOR_NEEDKEY)?-2:-1);
	}
      else
	{
	  notify_fail(capitalize(ob->name(WER,1))+
		      " ist doch schon geschlossen!\n");
	  if(door_status[dkey]<=0)
	    continue; // Eine andere Tuer koennte gemeint sein.
	  if((info[i][D_FLAGS] & DOOR_NEEDKEY) &&
	     !(info[i][D_FLAGS] & DOOR_CLOSEKEY))
	    door_status[dkey]=-2; // Abschliessbar, aber dazu schluessel unnoetig
	  else
	    door_status[dkey]=-1;
	}
      init_doors();
      if(!silent)
	{
          write("Du schliesst " + ob->name(WEN, 2) +
		((string)(abg?" ab":""))+".\n");
          say(capitalize(ob->name(WER,2))+" wird von "+this_player()->name(WEM)+
	      ((string)(abg?" ab":" "))+"geschlossen.\n");
	  door_message_other(source,dest," wird von der anderen Seite "+
			     ((string)(abg?"ab":""))+"geschlossen.",adj);
	}
      return 1;
    }
  return 0;
}
