/*******************
** Eldarea MUDLib **
********************
**
** global/service/elib.c - etool library
**
** CVS DATA
** $Date$
** $Revision$
**
** CVS History
**
** $Log$
**
*/

#include "./elib/elib.h"

#pragma strong_types

inherit ENAME;
inherit EPROF;

nomask private int security()
{
  if ( !this_player()
    || !(this_player()==this_interactive())
    || !IS_LEARNER(this_player())
     )
    return 0;
  return 1;
}

nomask static int evalcmd(string cmd)
{
  int retval;

  if (!security())
    return 0;
  
  cmd=query_verb()+(cmd?" "+cmd:"");
  if (strlen(cmd)<2)
    return 0;
  if (-1==member(ALL_CMDS,cmd[1..1]))
    return 0;
  if (strlen(cmd)<3)
    retval=call_other(this_object(),EVAL_CMD(cmd[1..1]),"");
  else
    retval=call_other(this_object(),EVAL_CMD(cmd[1..1]),cmd[2..<1]);
  return retval;
} 

nomask void init()
{
  add_action("evalcmd","e",1);
}           
