/*******************
** Eldarea MUDLib **
********************
**
** global/service/elib/e_name.c - elib names module
**
** CVS DATA
** $Date$
** $Revision$
**
** Verwaltung der namedb
**
** CVS History
**
** $Log$
**
*/

#include "./elib.h"

#pragma strict_types

static mapping newname;

nomask static void cmd_name_list(string args)
{
  string *arg,*vr;
  string start,race;
  int gender,i,j,len;
  
  arg=explode(lower_case(args)," ")-({""});
  for (i=0;i<sizeof(arg);i++)
  {
    if ( !stringp(arg[i]) || !strlen(arg[i]) ); 
    else if ( strlen(arg[i])==1 )
    {
      start=arg[i][0..0];
    }
    else if ( arg[i][0..0] == "g"
           && -1 != member(({"m","f","w","a","b"}),arg[i][1..1])
            ) 
    {
      gender=(["m":1,"f":2,"w":2,"a":0,"b":0])[arg[i][1..1]];
    }
    else
    {
      vr=VALID_RACES;
      len=strlen(arg[i]);
      for (j=sizeof(vr);j-->0;) 
      {
        if (len<=strlen(vr[j])&&arg[i]==vr[j][0..len-1])
          race=vr[j];
      }
      if (!race)
      {
        printf("Der Parameter %O ist nicht eindeutig.\n%s",arg[i],USAGE("enl"));
        return;  
      }
    } 
  }
  arg=(string *)NAMEDB->QueryNames(start,race,gender);
  start=sprintf("Liste der%s Namen%s%s:\n",
          ({""," maennlichen"," weiblichen"})[gender],
          start?" mit dem Anfangsbuchstaben '"+start+"'":"",
          race?" der Rasse "+capitalize(race):"");
  for (i=0;i<sizeof(arg)/5+1;i++)
  {
    for (j=0;(j<5)&&(i*5+j<sizeof(arg));j++)
      start+=sprintf("%11-s    ",capitalize(arg[i*5+j]));
    start+="\n";
  }
  this_player()->More(start);
}

nomask static void cmd_name_info(string name)
{
  mixed *nameinfo;

  if (!stringp(name)||1!=sscanf(name,"%t%s",name))
    printf(USAGE("eni"));
  else
  {
    nameinfo=(mixed *)NAMEDB->name_info(name);
    if (!pointerp(nameinfo))
      printf("Der Name '"+capitalize(name)+"' ist nicht eingetragen.\n");
    else
      write(break_string(sprintf(
             "Name:       %s\n"
             "Geschlecht: %s\n"
             "Rasse(n):   %s\n"
             "Flag(s):    %d\n",
             capitalize(name),
             ({"neutral","maennlich","weiblich"})[nameinfo[2]],
             pointerp(nameinfo[0])?implode(nameinfo[0],", "):"keine",
             nameinfo[1])));
  }
} 

nomask static void cmd_name_change(string args)
{

}
  
nomask static void cmd_name_add3(string char,string *valid_races)
{
  
}

nomask static void cmd_name_add2(string name)
{
  if (name[0]!='w'&&name[0]!='m')
  {
    write("Bitte als Geschlecht nur 'w' oder 'm' angeben: ");
    input_to("cmd_name_add2"); 
    return;
  }
  newname+=([P_GENDER:(['w':2,'m':1])[ name[0] ] ]);
  newname+=([P_RACE:({})]);
  cmd_name_add3(0,(string *) RMASTER->valid_races());
}


nomask static void cmd_name_add(string args)
{
  if (!stringp(args)||args=="")
  {
    write("Name: ");
    input_to("cmd_name_add");
    return;
  }
  if (strlen(args)<3)
  {
    write("Der Name '"+capitalize(args)+"' ist zu kurz.\n");
    return;
  }
  if (NAMEDB->name_exists(args))
  {
    write("Der Name '"+capitalize(args)+"'ist bereits eingetragen.\n");
    return;
  }
  newname=([P_NAME:args]);
  write("Geschlecht (m/w): ");
  input_to("cmd_name_add2");
  return;
}
  
nomask static void cmd_name_delete(string name)
{
  mixed * nameinfo;

  if (!stringp(name)||1!=sscanf(name,"%t%s",name))
    printf(USAGE("end"));
  else
  {
    nameinfo=(mixed *)NAMEDB->name_info(name);
    if (!pointerp(nameinfo))
      printf("Der Name '"+capitalize(name)+"' ist nicht eingetragen.\n");
    else
      write(break_string(sprintf(
             "Name:       %s\n"
             "Geschlecht: %s\n"
             "Rasse(n):   %s\n"
             "Flag(s):    %d\n",
             capitalize(name),
             ({"neutral","maennlich","weiblich"})[nameinfo[2]],
             pointerp(nameinfo[0])?implode(nameinfo[0],", "):"keine",
             nameinfo[1])));
      write("Soll dieser Name wirklich geloescht werden (j/n)?\n>");
      input_to("cmd_name_delete2",0,name);
  }
  return; 
}
  
nomask static void cmd_name_delete2(string str,string name)
{
  if (stringp(str)&&lower_case(str[0..0])=="j")
    if (NAMEDB->remove_name(name))
      write("Der Name '"+capitalize(name)+"' wurde geloescht.\n");
    else
      write("Der Name '"+capitalize(name)+"' konnte nicht geloescht werden.\n");
  else
    write("Der Name '"+capitalize(name)+"' wird nicht geloescht.\n");
  return;
}

nomask static int eval_n_cmd(string cmd)
{
  if (!stringp(cmd)||strlen(cmd)==0)
  {
    notify_fail(USAGE("en"));
    return 0;
  }
  switch(cmd[0..0])
  {
    case "l": /* Namesliste */
      cmd_name_list(strlen(cmd)>1?cmd[1..<1]:"");
      break;
    case "c": /* Eintrag aendern */
      if (!NAME_TRUSTED(getuid(this_player())))
        return 0; /* Nur NAME_TRUSTEES */
      cmd_name_change(strlen(cmd)>1?cmd[1..<1]:"");
      break;
    case "a": /* Eintrag hinzufuegen */
      if (!NAME_TRUSTED(getuid(this_player())))
        return 0; /* Nur NAME_TRUSTEES */
      cmd_name_add(strlen(cmd)>1?cmd[1..<1]:"");
      break;
    case "d": /* Eintrag loeschen */ 
      if (!NAME_TRUSTED(getuid(this_player())))
        return 0; /* Nur NAME_TRUSTEES */
      cmd_name_delete(strlen(cmd)>1?cmd[1..<1]:"");
      break;
    case "i": /* Eintrag anzeigen */
      cmd_name_info(strlen(cmd)>1?cmd[1..<1]:"");
      break;
    default:
      return 0;
      break; 
  }
  return 1;
}

nomask static int help_n(string cmd)
{
  return 0;
}
