/*******************
** Eldarea MUDLib **
********************
**
** global/service/elib/e_profession - etool professions module
**
** CVS DATA
** $Date$
** $Revision$
**
** CVS History
**
** $Log$
**
*/

#include "./elib.h"
#include "/sys/living/attributes.h"
#include <channeling.h>

#pragma strict_types

static mixed * newprofession;
static string newprofname;

nomask static int help_p(string cmd)
{
  return 0;
}       

nomask static void cmd_profession_add_finalize(string str)
{
  if (!stringp(str)||str=="")
  {
    write(sprintf(
      "Neuer Beruf:\n\n"
      "Kurzname          : %s\n"
      "Langname          : %s\n"
      "Berufsklasse      : %s\n"
      "Hauptattribute    : %s,%s\n"
      "Zulaessige Rassen : %s\n"
      "Aspekt notwendig  : %s\n"
      "Zulaessige Aspekte: %s\n"
      "Soll die Eintragung abgeschlossen werden? (j/n)\n>",
      newprofname,
      newprofession[PM_NAME],
      ({"Magieunkundiger","Teilmagiekudiger","Magierkundiger"})[newprofession[PM_TYPE]],
      ATTR_DESC[newprofession[PM_ATTR][0]],
      ATTR_DESC[newprofession[PM_ATTR][1]],
      list_words(newprofession[PM_RACE]),
      newprofession[PM_ASPC][0]?"Ja":"Nein",
      sizeof(newprofession[PM_ASPC])>1?list_words(newprofession[PM_ASPC][1..]):""
         ));
    input_to("cmd_profession_add_finalize");
    return;
  }
  if (str[0..0]=="n")
    write("Eintragung abgebrochen.\n");
  else if (str[0..0]=="j")
    if (!PMASTER->AddProfession(([newprofname:newprofession[0];
                                              newprofession[1];
                                              newprofession[2];
                                              newprofession[3];
                                              newprofession[4]
                                              ])))
      write(
        "Eintragung wurde von /secure/pmaster abgelehnt.\n"
        "Wendet Euch bitte an "+capitalize(E_ADM)+".\n");
    else
      write("Eintragung abgeschlossen.\n");
  else
  {
    write("Ungueltige Eingabe. Bitte nur j(a) oder n(ein) eingeben.\n");
    input_to("cmd_profession_add_finalize");
  }
  return;
}                    

nomask static void cmd_profession_add7(string aspect)
{
  string txt;
  int i,num;
  
  txt="Auswahl der gueltigen Aspekte:\n\n";
  
  for (i=0;i<sizeof(ALL_ASPECTS);i++)
  {
    if (-1==member(newprofession[PM_ASPC],ALL_ASPECTS[i]))
      txt+=sprintf("  [%:2d]  %s\n",i+1,ASP_DESCR[ALL_ASPECTS[i]][4]);
  }
  txt+="\nGebt bitte nacheinander die zulaessigen Aspekte fuer den Beruf an.\n"
       "Wenn Ihr fertig seid, gebt 'w' ein.\n> ";
  write(txt);
  if (!aspect | aspect=="")
    input_to("cmd_profession_add7");
  else if (aspect=="w")
  {
    cmd_profession_add_finalize("");
  }
  else if (sscanf(aspect,"%d",num)!=1 || num<1 || num>sizeof(ALL_ASPECTS))
  {
    cmd_profession_add7("");
  }
  else
  {
    num--;
    if (-1!=member(newprofession[PM_ASPC],ALL_ASPECTS[num]))
    {
      write("Dieser Aspekt ist bereits fuer den Beruf eingetragen.\n");	
      cmd_profession_add7("");
    }
    newprofession[PM_ASPC]+=({ALL_ASPECTS[num]});
    write("Ok, "+ASP_DESCR[ALL_ASPECTS[num]][4]+" zum Beruf hinzugefuegt.\n");
    cmd_profession_add7("");
  }	
}

nomask static void cmd_profession_add6(string required)
{
  if (!stringp(required) || required=="")
  {
    write("Soll fuer diesen Beruf ein Aspekt notwendig sein? (j/n)\n>");
    input_to("cmd_profession_add6");
    return;
  }
  if (required=="j")
  {
    newprofession[PM_ASPC]=({1});
    cmd_profession_add7("");
    return;
  }
  else if (required=="n")
  {
    newprofession[PM_ASPC]=({1});
    cmd_profession_add7("");
    return;
  }
  else
  {
    write("Bitte nur 'j' oder 'n' angeben.\n");
    input_to("new_profession_add6");
    return;
  }
}

nomask static void cmd_profession_add5(string race)
{
  string * valid_races,txt;
  mapping offs;
  int i,num;

  // rassen sammeln und ausgeben
  valid_races=(string *)RMASTER->valid_races();
  offs=(mapping)RMASTER->QueryOffset(P_RACE_NAME,0);
  txt="Auswahl der gueltigen Voelker:\n\n";

  for (i=0;i<sizeof(valid_races);i++)
  {
    if (-1==member(newprofession[PM_RACE],valid_races[i]))
      txt+=sprintf("  [%:2d]  %s\n",i+1,offs[valid_races[i]][1]);
  }
  txt+="\nGebt bitte nacheinander die zulaessigen Voelker fuer den Beruf an.\n"
       "Wenn Ihr fertig seid, gebt 'w' ein.\n> ";
  write(txt);
  if (!race | race=="")
    input_to("cmd_profession_add5");
  else if (race=="w")
  {
    cmd_profession_add6("");
  }
  else if (sscanf(race,"%d",num)!=1 || num<1 || num>sizeof(valid_races))
  {
    cmd_profession_add5("");
  }
  else
  {
    num--;
    if (-1!=member(newprofession[PM_RACE],valid_races[num]))
    {
      write("Dieses Volk ist bereits fuer den Beruf eingetragen.\n");	
      cmd_profession_add5("");
    }
    newprofession[PM_RACE]+=({valid_races[num]});
    write("Ok, "+capitalize(valid_races[num])+" zum Beruf hinzugefuegt.\n");
    cmd_profession_add5("");
  }	
}

nomask static void cmd_profession_add4(string type)
{
  int t;

  if (!stringp(type)||type=="")
  {
    write(
      "Auswahl der Berufsklasse:\n"
      "  [1]  Magieunkundiger\n"
      "  [2]  Teilmagiekundiger\n"
      "  [3]  Vollmagiekundiger\n\n>");
    input_to("cmd_profession_add4");
    return;
  } 
  if (1!=sscanf(type,"%d",t)||t<1||t>3)
  {
    cmd_profession_add4("");
    return;
  }
  newprofession[PM_TYPE]=t-1;
  cmd_profession_add5("");
}

nomask static void cmd_profession_add3(string attr)
{
  int a,b,c;

  if (!stringp(attr)||attr=="")
  {
    write(
      "Auswahl der Hauptattribute:\n"
      "  [1]  Staerke\n"
      "  [2]  Geschicklichkeit\n"
      "  [3]  Reaktion\n"
      "  [4]  Konstitution\n"
      "  [5]  Selbstdisziplin\n"
      "  [6]  Intelligenz\n"
      "  [7]  Intuition\n"
      "  [8]  Mana\n"
      "  [9]  Charisma\n"
      "Gebt 2 Zahlen an:\n>");
    input_to("cmd_profession_add3");
    return;
  }
  if (2!=sscanf(attr,"%d %d",a,b)||a==b||1>a||9<a||1>b||9<b)
  {
    cmd_profession_add3("");
    return;
  }
  if (b<a)
  {
    c=a;
    a=b;
    b=c;
  }
  newprofession[PM_ATTR]=({ALL_ATTRIBUTES[a-1],ALL_ATTRIBUTES[b-1]});
  cmd_profession_add4("");
}                          

nomask static void cmd_profession_add2(string langname)
{
  if (!stringp(langname)||langname=="")
  {
    write("Langname:\n>");
    input_to("cmd_profession_add2");
    return;
  }
  newprofession[PM_NAME]=langname;
  cmd_profession_add3("");
}
            
nomask static void cmd_profession_add(string profession)
{
  if (!stringp(profession)||profession=="")
  {
    write("Kurzname:\n>");
    input_to("cmd_profession_add");
    return;
  }
  if (-1!=strstr(profession," "))
  {
    write("Der Kurzname darf keine Leerzeichen enthalten.\nKurzname:\n>");
    input_to("cmd_profession_add");
    return;
  }
  if (-1!=member((string *)PMASTER->QueryProfessions(),profession))
  {
    write("Den Beruf '"+profession+"' gibt es bereits.\nVorgang abgebrochen.\n");
    return;
  }
  newprofname=lower_case(profession);
  newprofession=({0,({}),0,0,0});
  cmd_profession_add2("");
}
                         
nomask static int eval_p_cmd(string cmd)
{
  if (!stringp(cmd)||strlen(cmd)==0)
  {
    notify_fail(USAGE("ep"));
    return 0;
  }
  switch(cmd[0..0])
  {
    case "a": /* Neuen Beruf hinzufuegen */
      if (!IS_ARCH(getuid(this_player())))
        return 0;
      write("Ok, neuen Beruf hinzufuegen.\n");
      cmd_profession_add(strlen(cmd)>1?cmd[1..<1]:"");
      break;
    default:
      return 0;
      break;
  }
  return 1;
}                          
