/*******************
** Eldarea MUDLib **
********************
**
** global/service/finger.c  - finger object
**
** CVS DATA
** $Date: 2001/01/24 15:24:11 $
** $Revision: 1.8 $
**
** longdesc
**
** CVS History
**
** $Log: finger.c,v $
** Revision 1.8  2001/01/24 15:24:11  elatar
** ip owners are now shown to wizards
**
** Revision 1.7  2001/01/19 21:49:01  elatar
** sponsors and apprentices are now shown
**
** Revision 1.6  2000/12/11 13:07:24  elatar
** changes due to namedb move
**
** Revision 1.5  2000/12/01 15:30:29  elatar
** implemented new finger layout
**
** Revision 1.4  2000/08/02 10:40:49  eldarea
** Small bugfixes and alias/info handling improved/invented
**
** Revision 1.3  2000/08/02 08:20:28  eldarea
** New finger object implemented. Old version stays in CVS
**
** Revision 1.2  1999/11/17 10:21:12  elatar
** Corrected login screen finger handling (TP uid root)
**
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/

#include <properties.h>
#include <config.h>
#include <wizlevels.h>
#include <defines.h>
#include <guilds.h>
#include <service.h>
#include <daemon/namedb.h>
#include <rmaster.h>
#include <ansi.h>
#include <userinfo.h>

#define BS break_string

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")

#define LOGINDATE 936136801
#define HEARTBEAT 2
#define FILE_MAX_SIZE 2500
// HTML-Markierungen
#define HTML1 "<B>"
#define HTML2 "</B>"

// Optionen
#define OPT_PLAN       "p"     // Plan wird mit angezeigt
#define OPT_MORE       "m"     // Es wird ein More gemacht
#define OPT_FING_SHORT "s"     // Kurze Finger-Ausgabe
#define OPT_HTML       "h"     // Text wird fuer HTML zurueckgegeben
#define OPT_SPONSOR    "S"     // Sponsor wird mit angezeigt
#define OPT_EXACT      "e"     // es werden exakte Zeiten angezeigt (auf Sekunden)

#pragma strong_types

public varargs string finger(string str, string options);
public void read_init_file();
// data
static mapping aliases,infoa;
// save file variables
mapping properties;
int age;
mixed* age_m;

void create()
{
  if (clonep())
  {
    destruct(this_object());
    return;
  }
  read_init_file();
  seteuid(getuid());
}

public void read_init_file()
{
  string * file,alias,who;
  int i,wiz;

  wiz=(previous_object() && IS_LEARNER(previous_object()));

  if (file_size(FINGERINIT)<1 && wiz)
    return;
  if (wiz)
    write("Reading "FINGERINIT"...\n");
  aliases=([]);
  infoa=([]);
  file=explode(read_file(FINGERINIT),"\n");
  file-=({""});
  for (i=0;i<sizeof(file);i++)
  {
    if (file[i][0]!='#' && file[i][0]!=' ')
    {
      if (sscanf(file[i],"alias %s %s",alias,who)==2)
      {
        aliases[alias]=who;
      }
      else if (sscanf(file[i],"info %s %s",alias,who)==2)
      {
        infoa[alias]=who;
      }
      else
      {
        if (wiz)
          write("  Parse error in line "+i+"\n");
      }
    }
  }
  if (wiz)
    write("done.\n"+break_string("Read "+sizeof(aliases)+" aliases, "
                                        +sizeof(infoa)+" info aliases."));
}

public varargs string finger(string str, string options)
{
  string text, b_text, tmp, ipnum, pronoun,b1,b2,b3, *sa_var;
  object player, pl;
  mixed info, *nameinfo;
  int wiz,see_wiz,short,date,i,html,exact;

  if (!str || !stringp(str))
    return "";

  str = lower_case(str);

  pl=this_player();
  if ( pl && getuid(pl)==ROOTID )
    pl=0;

  // Ist der Name gesperrt?
  str=explode(str,".")[0];
  if(b_text=MASTER->QueryBanished(str))
  {
    return BS("Dieser Name ist gesperrt. ( "+b_text+
      " )");
  }

  info=MASTER->get_userinfo(str);
  player=find_player(str);

  // alias and info handling
  if (!info && !player)
  {
    if (member(aliases,str))
    {
      str=aliases[str];
      info=MASTER->get_userinfo(str);
      player=find_player(str);
    }
    else if (member(infoa,str))
    {
      return break_string(infoa[str]);
    }
  }

  // Gibt es den Spieler im Mud?
  if (!info && !player)
  {
    if (!nameinfo=NAMEDB->name_info(str))
      return "Diesen Namen gibt es im "MUDNAME" nicht.\n";
    else
    {
      switch(nameinfo[1])
      {
        case 1:
          if (pointerp(nameinfo[0])&&sizeof(nameinfo[0]))
            return BS(sprintf("Der Name %s ist frei verfuegbar fuer %s %s."
                     ,capitalize(str)
                     ,({"neutrale","maennliche","weibliche"})[nameinfo[2]]
                     ,list_words(map_array(nameinfo[0],
                        lambda(({'x,}),
                          ({#'capitalize,
                            ({#'+,
                              ({#'[,
                                ({#'call_other,RMASTER,"QueryOffset",P_RACE_NAME,'x})
                                ,0})
                              ,"en"})
                            }))))));
          else
            return BS(sprintf("Der Name %s ist zwar frei verfuegbar fuer %s "
                      "Spieler, allerdings noch fuer kein Volk eingetragen."
                      ,capitalize(str)
                      ,({"neutrale","maennliche","weibliche"})[nameinfo[2]]));
          break;
        case 4:
          return sprintf("Der Name %s ist gesperrt.",capitalize(str));
          break;
        default:
          if (pointerp(nameinfo[0])&&sizeof(nameinfo[0]))
            return BS(sprintf("Der Name %s eingetragen fuer %s %s, allerdings "
                     "ist der Status nicht eindeutig festgelegt."
                     ,capitalize(str)
                     ,({"neutrale","maennliche","weibliche"})[nameinfo[2]]
                     ,list_words(map_array(nameinfo[0],
                        lambda(({'x}),
                          ({#'capitalize,
                            ({#'+,
                              ({#'[,
                                ({#'call_other,RMASTER,"QueryOffset",P_RACE_NAME,'x})
                                ,0})
                              ,"en"})
                            }))))));
          else
            return BS(sprintf("Der Name %s ist eingetragen fuer %s Spieler, "
                     "allerdings ist der Status nicht eindeutig festgelegt."
                      ,capitalize(str)
                      ,({"neutrale","maennliche","weibliche"})[nameinfo[2]]));
          break;
      }
    }
  }

  if (!options || !stringp(options) || strstr(options, OPT_EXACT)==-1)
    exact=0;
  else
    exact=1;

  // Spielerdaten beschaffen
  if (!player)
  {
    age=age_m=properties=0;
    if (!restore_object("/save/" + str[0..0] + "/" + str) ||
        !properties || !m_sizeof(properties))
      return "Irgendetwas ist schiefgegangen.\n";
  }
  else
    if (!(properties=player->QueryProperties()) ||
        !(age=player->QueryProp(P_AGE)) ||
        (age_m=player->QueryProp(P_AGE_MONTHLY),0)) // age_m Fehler ignorieren
      return "Irgendetwas ist schiefgegangen.\n";

  wiz = query_wiz_level(str);

  b1=b2=b3="";
  if (pl)
  {
    see_wiz = IS_LEARNER(pl);
    if (pl->QueryProp(P_TTY)!="dumb")
    {
      b1=ANSI_BOLD;
      b2=ANSI_NORMAL;
      b3="    ";
    }
  }

  // Lange Fingermeldung oder kurze Fingermeldung ?
  if (!options || !stringp(options) || strstr(options, OPT_FING_SHORT)==-1)
    short=0;
  else
    short=1;

  if (options && stringp(options) && strstr(options, OPT_HTML)>0)
  {
    b1 = HTML1;
    b2 = HTML2;
    html=1;
  }

  pronoun=({"Es","Er","Sie"})[properties[P_GENDER]];

  ipnum=properties[P_CALLED_FROM_IP];
  text=sprintf(
    "+--- %'-':69-s---+\n"
    "|                                                                            |\n"
    ,(properties[P_PRESAY]?properties[P_PRESAY]+" ":"")
    +properties[P_NAME]
    +((properties[P_TITLE]&&properties[P_TITLE]!="")?" "+properties[P_TITLE]+" ":" "));

  // nicht da oder unsichtbar
  if (!player || (wiz && properties[P_INVIS] && !see_wiz))
  {
    if (player)
      date=properties[P_NETDEAD_TIME];
    else
      date=file_date("/save/"+str[0..0]+"/"+str+".o");
    text+=sprintf(
    "| %:74-s |\n"
    "| %:74-s |\n"
    ,properties[P_NAME]+" ist nicht anwesend."
    ,sprintf("%s war zuletzt da %s aus %s%s"
      ,pronoun
      ,exact?
         (date<time()-86400?
           "am "+dtime(date):
           "um "+dtime(date)[19..]+" Uhr"):
         (date<time()-86400?
           "am "+dtime(date)[..16]:
           "um "+dtime(date)[19..]+" Uhr")
      ,country(ipnum)
      ,exact?
        (time()-date)>3600?
          (time()-date)>86400?
            time2string(" (vor %d %D, %h:%m:%s %H)",time()-date)
           :time2string(" (vor %h:%m:%s %H)",time()-date)
         :time2string(" (vor %m:%s %M)",time()-date)
       :time2string(" (vor %x %0X)",time()-date)));
    if (see_wiz)
    {
      text+=sprintf(
        "| %:74-s |\n"
        ,"("+(player?query_ip_name(ipnum=query_ip_number(player))
              :query_ip_name(ipnum))+", IP: "+ipnum+")");
      if (stringp(ipnum=ip_owner(ipnum)))
        text+=sprintf("|   Organisation: %:58-s |\n",ipnum);
    }
    if (player && query_idle(player)>120)
    {
      date=query_idle(player);
      text+=sprintf(
        "| %:74-s |\n"
        ,pronoun+" ist passiv seit: "+((date>3600 && !exact)?
          time2string("%h %H, %m %M und %s %S",date):
          time2string("%m %M und %s %S",date)));
    }
    if (player && properties[P_AWAY])
    {
      text+=sprintf(
        "| %:74-s |\n"
        ,pronoun+" ist weg, Grund: "+properties[P_AWAY]);
    }
  }
  else if (interactive(player) && wiz && properties[P_INVIS] && see_wiz)
  { // unsichtbar aber sichtbar :)
    text+=sprintf(
    "| %:74-s "+b3+b3+"|\n"
    "| %:74-s |\n"
    ,properties[P_NAME]+" ist seit "+
    ((time()-object_time(player)<86400)?
      dtime(object_time(player))[<8..<1]+" Uhr"
     :"dem "+dtime(object_time(player))[5..])
    +" "+b1+"unsichtbar"+b2+" anwesend aus "+country(ipnum)+"."
      ,"("+(player?query_ip_name(ipnum=query_ip_number(player))
                  :query_ip_name(ipnum))+", IP: "+ipnum+")"
      ,""
    );
    if (stringp(ipnum=ip_owner(ipnum)))
      text+=sprintf("|   Organisation: %:58-s |\n",ipnum);
    date=query_idle(player);
    if (date>120)
      text+=sprintf(
        "| %:74-s |\n"
        ,pronoun+" ist passiv seit: "+((date>3600 && !exact)?
          time2string("%h %H, %m %M und %s %S",date):
          time2string("%m %M und %s %S",date)));
    if (properties[P_AWAY])
    {
      text+=sprintf(
        "| %:74-s |\n"
        ,pronoun+" ist weg, Grund: "+properties[P_AWAY]);
    }
  }
  else if (!query_ip_number(player))
  { // netztot
    date=properties[P_NETDEAD_TIME];
    text+=sprintf(
    "| %:74-s |\n"
    "| %:74-s |\n"
    ,properties[P_NAME]+" ist netztot."
    ,sprintf("%s war zuletzt da %s aus %s %s"
      ,pronoun
      ,exact?
         (date<time()-86400?
           "am "+dtime(date):
           "um "+dtime(date)[19..]+" Uhr"):
         (date<time()-86400?
           "am "+dtime(date)[..16]:
           "um "+dtime(date)[19..]+" Uhr")
      ,country(ipnum)
      ,time2string("(vor %x %0X)",time()-date)));
    if (see_wiz)
    {
      text+=sprintf(
        "| %:74-s |\n"
        ,"("+query_ip_name(ipnum)+", IP: "+ipnum+")");
      if (stringp(ipnum=ip_owner(ipnum)))
        text+=sprintf("|   Organisation: %:58-s |\n",ipnum);
    }
  }
  else
  { // anwesend
    text+=sprintf(
    "| %:74-s |\n"
    ,properties[P_NAME]+" ist seit "+
    ((time()-object_time(player)<86400)?
      dtime(object_time(player))[<8..<1]+" Uhr"
     :"dem "+dtime(object_time(player))[5..])
    +" anwesend aus "+country(ipnum)+"."
      ,"("+(player?query_ip_name(ipnum=query_ip_number(player))
                  :query_ip_name(ipnum))+", IP: "+ipnum+")"
    );
    if (see_wiz)
    {
      text+=sprintf(
        "| %:74-s |\n"
        ,"("+(player?query_ip_name(ipnum=query_ip_number(player))
                    :query_ip_name(ipnum))+", IP: "+ipnum+")");
      if (stringp(ipnum=ip_owner(ipnum)))
        text+=sprintf("|   Organisation: %:58-s |\n",ipnum);
    }
    date=query_idle(player);
    if (date>120)
      text+=sprintf(
        "| %:74-s |\n"
        ,pronoun+" ist passiv seit: "+((date>3600 && !exact)?
          time2string("%h %H, %m %M und %s %S",date):
          time2string("%m %M und %s %S",date)));
    if (properties[P_AWAY])
    {
      text+=sprintf(
        "| %:74-s |\n"
        ,pronoun+" ist weg, Grund: "+properties[P_AWAY]);
    }
  }

  if (!short)
  {
    if (wiz)
    {
      text+=sprintf(
        "|                                                                            |\n"
        "| %:74-s |\n"
        ,pronoun+" ist "+
         RMASTER->QueryOffset(P_RACE_NAME,"avatar")[properties[P_GENDER]]+
         " des "+(11-wiz)+". Kreises. "+(properties[P_TASKS]?"("+properties[P_TASKS]+")":""));

    }
    else
    {
      if (see_wiz)
      {
        text+=sprintf(
         "|                                                                            |\n"
         "| %:74-s |\n"
          ,pronoun+" ist "+
           RMASTER->QueryOffset(P_RACE_NAME,properties[P_RACE])[properties[P_GENDER]]+
           " der "+properties[P_LEVEL]+". Stufe.");
      }
      else
        text+="|                                                                            |\n";
    }

    text+=sprintf(
      "| %:74-s |\n"
      "| %:74-s |\n"
      ,"Erstlogin: "+(properties[P_CREATION_DATE]<LOGINDATE?
                      "Der Anbeginn der Zeit":
                      dtime(properties[P_CREATION_DATE]))
      ,"Alter: "+(age>43200?
                    (exact?
                      time2string("%d %D, %h %H, %m %M und %s %S",age*HEARTBEAT):
                      time2string("%d %D, %h %H und %m %M",age*HEARTBEAT)):
                      age>1800?
                        (exact?
                          time2string("%h %H, %m %M und %s %S",age*HEARTBEAT):
                          time2string("%h %H und %m %M",age*HEARTBEAT)):
                        time2string("%m %M und %s %S",age*HEARTBEAT))
                        );
    // Monthly Age berechnen
    if (!pointerp(age_m) || sizeof(age_m)!=3 || age_m[2] && intp(age_m[2]))
      tmp="";
    else if (stringp(age_m[2]))
      tmp=age_m[2];
    else
    { // Auswerten erlaubt
      if (age_m[0]!=ctime()[4..6]+ctime()[22..])
        tmp="";
      else
      {
        date=(age*HEARTBEAT-age_m[1]*HEARTBEAT)/2;
        if (date<0) date=0;
        tmp=(date>43200?
               (exact?
                 time2string("%d %D, %h %H, %m %M und %s %S",date*HEARTBEAT):
                 time2string("%d %D, %h %H und %m %M",date*HEARTBEAT)):
               date>1800?
                 (exact?
                   time2string("%h %H, %m %M und %s %S",date*HEARTBEAT):
                   time2string("%h %H und %m %M",date*HEARTBEAT)):
                 time2string("%m %M und %s %S",date*HEARTBEAT));
      }
    }
    if (strlen(tmp))
      text+=sprintf(
        "| %:74-s |\n"
        ,"Davon in diesem Monat: "+tmp);

  }

  if (date=MASTER->QueryTBanished(str, 1))
  {
    text+=sprintf("| %:74-s |\n"
      ,pronoun+" moechte "+(date==-1?
        "nie mehr":
        "am "+dtime(date)[0..16]+" wieder")+" ins Eldarea kommen.");
  }
  if ("/secure/mailer"->FingerMail(str))
  {
    text+=sprintf("| %:74-s |\n"
      ,pronoun+" hat ungelesene Mail.");
  }

  if (!short)
  {
    if (properties[P_MAILADDR] || properties[P_ICQ] || properties[P_HOMEPAGE])
    {
      text+="|                                                                            |\n";
      if (properties[P_MAILADDR] || properties[P_ICQ])
        text+=sprintf(
          "| %:74-s |\n"
          ,(properties[P_MAILADDR]?"EMail: "+properties[P_MAILADDR]+" ":"")+
           (properties[P_ICQ]?"ICQ-Nummer: "+properties[P_ICQ]:""));
      if (properties[P_HOMEPAGE])
        text+=sprintf(
          "| %:74-s |\n"
          ,"Homepage: "+properties[P_HOMEPAGE]);
    }

    if (properties[P_SECOND] || properties[P_TESTPLAYER])
    {
      text+=sprintf(
        "|                                                                            |\n"
        "| %:74-s |\n"
        ,(properties[P_TESTPLAYER]?
          pronoun+" ist ein Testcharakter von "+properties[P_TESTPLAYER]+".":
          pronoun+" ist ein Zweitcharakter von "+properties[P_SECOND]+".")
      );
    }
  }
  text+="|                                                                            |\n";
  tmp="";
  if (!short && wiz)
  {
    if (info && stringp(info[USER_SPONSOR]))
    {
      tmp+=break_string(
        properties[P_NAME]+" ist Schueler"+
        ({"","","in"})[properties[P_GENDER]]+" von "+
        capitalize(info[USER_SPONSOR])+".");
    }
    else
    {
      tmp+=break_string(
        properties[P_NAME]+" wurde von den Aspekten selbst berufen.");
    }
    if (info && sizeof(sa_var=info[USER_APPRENTICES]))
    {
      tmp+=break_string(
        pronoun+" ist Meister"+({"","","in"})[properties[P_GENDER]]+
        " folgender Schueler: "+
        list_words(map_array(sa_var, #'capitalize)),74);
    }
    if (info && sizeof(sa_var=info[3]))
    {
      tmp+=break_string(
        properties[P_NAME]+" unterstehen folgende Regionen: "+
        list_words(map_array(sa_var, #'capitalize)),74);
    }
    if (sizeof((sa_var=MASTER->get_domain_homes(str))))
    {
      tmp+=break_string(
        pronoun+" ist Regionsmitarbeiter in: "+
        list_words(map_array(sa_var, #'capitalize)),74);
    }
  }


  if (options && stringp(options) && strstr(options, OPT_PLAN)!=-1)
  {
    ipnum = "/"+WIZARDDIR+"/"+str+"/.plan";

    if (strlen(tmp))
      tmp+=" \n";
    if ((i=file_size(ipnum))>=0 && i<=FILE_MAX_SIZE)
      tmp+="Plan: \n"
          +break_string(read_file(ipnum),74);
  }

  sa_var=explode(tmp,"\n")-({""});
  for (i=0;i<sizeof(sa_var);i++)
    text+=sprintf("| %:74-s |\n",sa_var[i]);
  if (sizeof(sa_var))
    text+="|                                                                            |\n";

  // Speicher wieder freigeben
  age = 0;
  properties = ([]);

  text+="+----------------------------------------------------------------------------+\n";

  return text;
}
