/*******************
** Eldarea MUDLib **
********************
**
** gloval/service/ipnets.c - ip nets resolution
**
** CVS DATA
** $Date: 2001/02/02 14:25:22 $
** $Revision: 1.2 $
**
** By Fiona@Wunderland. Thank You :)
**
** CVS History
**
** $Log: ipnets.c,v $
** Revision 1.2  2001/02/02 14:25:22  elatar
** new classless ipnet resolution
**
** Revision 1.1  2001/01/25 12:18:56  elatar
** initial revision
**
**
*/

#pragma strict_types
#pragma no_clone;
#pragma no_inherit;

#include <service/ipnets.h>

#if 0
#define iexp(x,y) funcall(lambda(({'b,'e}),\
                    ({#',,\
                      ({#'=,'r,1}),\
                      ({#'while,'e,'r,\
                        ({#',,\
                          ({#'*=,'r,'b}),\
                          ({#'-=,'e,1})\
                        })\
                      })\
                    })),x,y)
#endif

private int add_data(mapping pdata, mapping result);
private int match_netmask(mapping pdata, int * ip, mapping result);
private int match_netid(mapping pdata, int * ip, mapping result);

mixed * data;

private string strip_line(string line)
{
  line = trim(line);

  if (!line[0] || line[0]=='#')
    return 0;

  return line;
}

int check_netid(int * ip, int prefix)
{
  int i, exp;

  for (i=4;i-->0 && (exp=(i+1)*8-prefix)>0;)
  {
    if (exp>8 && ip[i]!=0)
      return 0;
    if (ip[i]&(1<<exp)-1)
      return 0;
  }

  return 1;
}

private void load_data()
{
  mapping idx, pdata;
  int state, curr_line, *ip, prefix, i, maskid, exp;
  string line, * lines, town, country, owner, tmp, *strs;

  idx = IPNETS_IDX;
  i = 5;
  data = allocate(i);
  for (; i--;)
    data[i] = ([]);
  data[IPNET_PREFIXES] = ({});
  data[IPNET_CITY_TRANSLATE] = allocate_mapping(1, 3);
  state = -1;
  curr_line = 1;
  lines = ({});
  while (line = read_file(IPNETS_DATA,curr_line,500))
  {
    lines += explode(line,"\n");
    curr_line+=500;
  }
  curr_line = -1;
  while (++curr_line < sizeof(lines))
  {
    line = lines[curr_line];
    if (!line = strip_line(line))
      continue;

    if (member(idx, line))
    {
      state = idx[line];
      continue;
    }

    switch (state)
    {
      case -1:
        printf("Data without key word line "+(curr_line+1)+".\n");
        break;

      default:
        printf("Wrong status "+state+".\n");
        break;

      case IPNET_PREFIXES:
        data[state] += ({line});
        break;

      case IPNET_NETS:
        tmp = trim(line[0..17]);
        town = trim(line[20..35]);
        country = trim(line[38..40]);
        owner = trim(line[43..<1]);
        ip = allocate(4);
        sscanf(tmp,"%d.%d.%d.%d/%d",ip[0],ip[1],ip[2],ip[3],prefix);
        if (!check_netid(ip, prefix))
        {
          printf("Error: wrong/missing network identifier line "+(curr_line+1)+": "+line+".\n");
          break;
        }

        pdata = data[IPNET_NETS];
        for (i=0;i<(prefix+7)/8;i++)
        {
          exp = prefix-i*8;
          if (exp>8)
            exp = 0;
          maskid = 1<<(exp-1);
          if (!pdata[ip[i]])
          {
            pdata[ip[i]]=([maskid:([])]);
          }
          else if (!pdata[ip[i]][maskid])
          {
            pdata[ip[i]][maskid]=([]);
          }
          pdata = pdata[ip[i]][maskid];
        }
        if (sizeof(pdata))
        {
          printf("Error: duplicate network identifier line "+(curr_line+1)+": "+line+".\n");
          break;
        }
        if (town && town!="--")
          pdata[IPDATA_TOWN] = town;
        if (country && country!="--")
          pdata[IPDATA_COUNTRY] = country;
        if (owner && owner!="--")
          pdata[IPDATA_OWNER] = owner;
        break;

      case IPNET_COUNTRIES:
        tmp = trim(line[0..13]);
        country = trim(line[15..<1]);
        if (!strlen(tmp))
        {
          printf("Error (IP_COUNTRIES) line "+(curr_line+1)+": "+line+".\n");
          break;
        }
        if (!strlen(country) || country=="--")
          country = 0;
        data[state][tmp] = country;
        break;

      case IPNET_CITY_TRANSLATE:
        tmp = trim(line[0..17]);
        town = trim(line[20..36]);
        country = trim(line[38..40]);
        owner = trim(line[42..<1]);
        if (!strlen(tmp))
        {
          printf("Error: missing adress line "+(curr_line+1)+": "+line+".\n");
          break;
        }
        strs = explode(tmp,".");
        pdata = data[IPNET_CITY_TRANSLATE];

        for (i=sizeof(strs);i-->0;)
        {
          if (!pdata[strs[i]])
            pdata[strs[i]] = ([]);
          pdata = pdata[strs[i]];
        }
        if (town && town!="--")
          pdata[IPDATA_TOWN] = town;
        if (country && country!="--")
          pdata[IPDATA_COUNTRY] = country;
        if (owner && owner!="--")
          pdata[IPDATA_OWNER] = owner;
        break;
    }
  }
}

private int add_data(mapping pdata, mapping result)
{
  int i;

  for (i=0;i<4;i++)
  {
    if (!result[i] && pdata[i] && !mappingp(pdata[i]))
      result[i] = pdata[i];
  }

  if (sizeof(result)==3)
    return 1;
  return 0;
}

private int match_netmask(mapping pdata, int * ip, mapping result)
{
  int low_bit, netmask;

  low_bit = 1;
  netmask = 128;

  do
  {
    if ( pdata[netmask]
      && ( !( netmask==128
           ||  !match_netid(pdata[netmask],ip[1..],result))
        || add_data(pdata[netmask],result)))
      return 1;
    low_bit<<=1;
    netmask>>=1;
  }
  while (netmask>0 && !(ip[0]&low_bit));

  if ( pdata[0]
    && ( match_netid(pdata[0],ip[1..],result)
      || add_data(pdata[0],result)))
    return 1;

  return 0;
}

private int match_netid(mapping pdata, int * ip, mapping result)
{
  int low_bit, netid;

  if (!sizeof(ip) || !mappingp(pdata))
    return 0;
  netid = ip[0];

  low_bit = 1;
  do
  {
    if ( pdata[netid]
      && match_netmask(pdata[netid],ip,result))
      return 1;
    while(!((netid+256)&low_bit))
    {
      low_bit<<=1;
    }
    netid-=low_bit;
  }
  while ( netid>=0 );

  return 0;
}

private int special_ip_resolve(string name, mapping result)
{
  string twn;

  if (sscanf(name, "%s-%~s.pool.mediaways.net", twn) != 2)
    return 0;
  switch (twn)
  {
    case "mnch":
      result[IPDATA_TOWN]="Muenchen";
    case "pdbn":
      result[IPDATA_TOWN]="Paderborn";
    case "cmnz":
      result[IPDATA_TOWN]="Chemnitz";
    case "essn":
      result[IPDATA_TOWN]="Essen";
    case "lpz2":
      result[IPDATA_TOWN]="Leipzig";
    case "nbra":
      result[IPDATA_TOWN]="Neubrandenburg";
    case "krlh":
      result[IPDATA_TOWN]="Karlsruhe";
    case "wall": /* mijo, algo, abigail */
  }
  result[IPDATA_OWNER]="mediaWays GmbH";
  result[IPDATA_COUNTRY]="de";
  return 1;
}

private int match_subdomain(mapping pdata, string * dnsname, mapping result)
{
  if (!sizeof(dnsname) || !pdata[dnsname[<1]])
    return 0;
  if ( !match_subdomain(pdata[dnsname[<1]],dnsname[0..<2],result)
    && !add_data(pdata[dnsname[<1]],result))
    return 0;
  return 1;
}

public string CountryName(string country)
{
  return data[IPNET_COUNTRIES][country];
}

public varargs mapping resolve(int * ip, string dnsname)
{
  mapping result;
  string *strs;
  int i;

  result = ([]);

  if (match_netid(data[IPNET_NETS], ip, result))
    return result;

  if (!stringp(dnsname))
    dnsname=query_ip_name(sprintf("%d.%d.%d.%d",ip[0],ip[1],ip[2],ip[3]));

  dnsname = lower_case(dnsname);

  if (special_ip_resolve(dnsname,result))
    return result;

  strs = explode(dnsname,".");

  if (match_subdomain(data[IPNET_CITY_TRANSLATE],strs,result))
      return result;

  if (!result[IPDATA_COUNTRY] && data[IPNET_COUNTRIES][strs[<1]])
    result[IPDATA_COUNTRY] = strs[<1];

  if (!result[IPDATA_TOWN])
  {
    for (i=sizeof(data[IPNET_PREFIXES])-1;i>=0;i--)
      if (!strstr(strs[<2], data[IPNET_PREFIXES][i]))
        result[IPDATA_TOWN] = capitalize(strs[<2][strlen(data[IPNET_PREFIXES][i])..]);
  }
 
  if (!sizeof(result))
    log_file("UNRESOLVED",
      sprintf("%d.%d.%d.%d:%s\n",ip[0],ip[1],ip[2],ip[3],dnsname));
  else if (sizeof(result)<3)
    log_file("UNRESOLVED",
      sprintf("%d.%d.%d.%d:%s (partially)\n",
              ip[0],ip[1],ip[2],ip[3],dnsname));
  return result;
}

void create()
{
  seteuid(getuid(this_object()));
  load_data();
}
