/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:43 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: mailcabin.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. Mudlib
// Basierend auf Wunderland Mudlib
//
// OBJ/SERVICE/MAILCABIN.C -- Mailkabine zum aufstellen
//
// based on Morgengrauen Mudlib
//
// Autor: Loco@Morgengrauen 1993/1994
//
// $Log: mailcabin.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:43  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:09  en
// MUDLib CVS Preperation
//
// Revision 1.2  1999/08/05 12:53:00  Largo
// hatte noch ein is_clone() vergessen
//
// Revision 1.1  1999/08/05 12:48:05  Largo
// Initial revision
//

#include "/mail/post.h"
#include <config.h>
#include <properties.h>
#include <moving.h>

inherit STDPOST;
inherit "std/thing/moving";
inherit "std/thing/commands";

#pragma strong_types

int besetzt();

void create() {
  if(!clonep()) return;
  post::create();
  commands::create();
  SetProp(P_NAME,"Schreibkabine");
  SetProp(P_GENDER,FEMALE);
  SetProp(P_PLURAL,"Schreibkabinen");
  SetProp(P_INT_LONG,"In dieser Kabine kannst Du ungestoert Post lesen und "
    "schreiben. Niemand anders kann hier rein, solange Du drin bist, dafuer "
    "waere die Kabine auch viel zu eng. Tippe einfach 'post' oder 'mail', "
    "bzw. 'mail <spieler>' zum Schreiben. Mit 'raus' kommst Du wieder raus.");
  SetProp(P_NOGET,"Versuch mal, eine festmontierte Kabine auszubauen!\n");
  AddId( ({"kabine", "schreibkabine", "postkabine"}),
    ({"kabinen", "schreibkabinen", "postkabinen"}) );
  AddDetail("ausgang", "Genau. Dort gehts wieder raus!");
}

string long() {
  return "Eine kleine Ein-Personen-Kabine, in der Du ungestoert Deine Post "
    "lesen und schreiben kannst. Du kannst sie betreten."+
    (besetzt()?" Diese Kabine ist allerdings besetzt.":"");
}

string int_short(mixed a, mixed b) {
  return (environment()->QueryProp(P_INT_SHORT))+" (Kabine)\n";
}

int besetzt() {
  mixed in, i;
  in=all_inventory(this_object());
  for(i=sizeof(in);i--;)
    if(living(in[i]) && in[i]!=this_player()) 
      return 1;
  return 0;
}

int move(mixed a, mixed b) {
  int r;
  r=::move(a, b);
  AddExit("raus",file_name(environment(this_object())));
  return r;
}

void init() {
  if (!clonep()) {
    write("*** Blueprint nicht betretbar ***\n");
    this_player()->move("/room/void", M_NOCHECK|M_NO_SHOW);
    return;
  }
  commands::init();
  if(environment(this_player())==environment(this_object())) {
    add_action("rein","betrete");
    add_action("rein","betritt");
    return;
  }
  if(besetzt()) {
    this_player()->move(environment(this_object()),M_GO,0,
      "passt hier nicht mehr rein",
      "macht die Tuer einer Kabine auf, aber die ist schon besetzt");
    return;
  }
  if(environment(this_player())==this_object()) {
    post::init();
    add_action("do_mail","mail");
    add_action("do_mail","post");
    return;
  } 
}

int rein(string str) {
  if (!str || !id(str)) {
    notify_fail("Wo willst Du denn rein?\n");
    return 0;
  }
  if (besetzt()) {
    notify_fail("BESETZT!\n");
    return 0;
  }
  this_player()->move(this_object(),M_GO,0,"betritt eine Schreibkabine","betritt die Kabine");
  return 1;
}

int clean_up(int arg) {
  return 1;
}
