/*******************
** Eldarea MUDLib **
********************
**
** global/service/manbuf.c - manual buffer
**
** CVS DATA
** $Date: 2000/08/02 09:28:49 $
** $Revision: 1.2 $
**
** Ein gepufferter Manual-Client, der die Seiten auch als String zurueck-
** liefern und nach Teilschluesseln suchen kann.
**
** Autor: Fiona@Wunderland
**
** CVS History
**
** $Log: manbuf.c,v $
** Revision 1.2  2000/08/02 09:28:49  eldarea
** manpage aliases implemented
**
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
*/

#define START "/doc"
#pragma strong_types

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")

static mapping cache;
static mapping aliases;

static void fill_cache(string path, string key);
static void old_search(string path, string* key);
static void _complete_fill(string file, string path);
public string* grep_man(string key);
public void read_aliases();
static string * add_aliased_keys(string * key);

// Diese Funktion fuegt moegliche Aliase zu den gesuchten keys hinzu
static string * add_aliased_keys(string * key)
{
  int i;
  
  for(i=sizeof(key);i-->0;)
  {
    if (member(aliases,key[i]))
      key[i]=aliases[key[i]];
  }
  return key;
}
/* Diese Funktion durchsucht den Cache nach einer bereits gefundenen Seite,
** sonst wird sie gesucht und im Cache eingetragen. Ist indirekt gesetzt, so
** wird die Seite als Funktionswert zurueckgeliefert, ansonsten wird sie direkt
** an this_player() ausgegeben.
** Liegt path im Standardpfad wird bei Misserfolg ein Teilmatch des Schluessels
** probiert und moegliche korrekte Schluessel geliefert.
** Wenn path nicht im Standardpfad liegt, wird indirect ignoriert und der
** Cache bleibt aussen vor.
** Wenn fn gesetzt ist, wird der Filename der Hilfeseite mit angezeigt.
*/
public varargs string query_man(string path, string* key, int indirect, int fn) 
{
  string dummy, ret, *filenames, *tmp;
  int i, num, dump;
  
  if (!path) 
    path=START;
  if (path[0..strlen(START)]!=(START+"/")[0..strlen(path)-1]) 
  {
    old_search(path, &key);
    return 0;
  }
  //key=add_aliased_keys(key);
  ret="";
  filenames=({});
  for (i=0; i<sizeof(key); i++) 
  {
    if (!member(cache, key[i]))
    {
      fill_cache(path, key[i]);
      if (!member(cache, key[i]) && member(aliases,key[i]))
      {
        dummy=key[i];
        key[i]=aliases[key[i]];
        if (!member(cache, key[i]))
        {
          fill_cache(path, key[i]);
          if (!member(cache, key[i]))
            key[i]=dummy;
        } 
      }
    }
    if (member(cache, key[i])) 
    {
      tmp=map_array(cache[key[i]], #'+, key[i]);
      if (sizeof(filter_array(tmp, lambda( ({ 'x }),
	    ({ #'==, ({ #'file_size, 'x }), -1 }) )))) 
      {
	    // gecachtes file ist verschwunden ?!!
        efun::m_delete(cache, key[i]);
        fill_cache(path, key[i]);
        if (member(cache, key[i]))
          tmp=map_array(cache[key[i]], #'+, key[i]);
        else tmp=0;
      }
      if (tmp) 
      {
         filenames+=tmp;
         key[i]=0;
      }
    }
    else 
    {
      tmp=grep_man(key[i]);
      if (sizeof(tmp)) 
      {
        filenames+=({key[i]+"/"+implode(tmp,", ")});
        key[i]=0;
      }
    }
  }
  key-=({0});
  num=sizeof(filenames);
  if (num>1) 
  { // More kann nicht mehrere Files hintereinander ausgeben
    dump=1;
  }
  for (i=0; i<num; i++) 
  {
    if (i>0) 
      ret+=sprintf("%'-'|78s\n", "-");
    if (filenames[i][0]!='/') 
    {
      tmp=efun::explode(filenames[i], "/");
        // Seufz, schauen ob nur ein Treffer, ob da nur die Grossschreibung
        // falsch ist, dann das ausgeben
      if ( member(tmp[1], ',')==-1 
        && lower_case(tmp[1])==lower_case(tmp[0])) 
      {
        ret+="Nichts fuer '"+tmp[0]+"' gefunden, Ihr meintet bestimmt '"+tmp[1]+"':\n";
        ret+=(fn?"Manpage-File: "+filenames[i]+"\n":"")+read_file(cache[tmp[1]][0]+tmp[1]);
      } 
      else 
      {
        ret+="Nichts fuer '"+tmp[0]+"' gefunden.\nVersucht doch: "+tmp[1]+".\n";
      }
      if (!indirect && !dump) 
      {
        this_player()->More(ret);
        ret="";
      }
    } 
    else if (file_size(filenames[i])==-2) 
    {
      ret+="Themen der Rubrik "+efun::explode(filenames[i],"/")[<1]+":\n"+
	   break_string(implode(get_dir(filenames[i]+"/*")-({".",".."}), ", "), 78);
      if (!indirect && !dump) 
      {
        this_player()->More(ret);
        ret="";
      }
    } 
    else 
    {
      if (!indirect && !dump) 
      {
        if (fn) write("Manpage-File: "+filenames[i]+"\n");
        this_player()->More(filenames[i], 1);
      } 
      else 
      {
        ret+=(fn?"Manpage-File: "+filenames[i]+"\n":"")+read_file(filenames[i]);
      }
    }
  }
  if (dump && !indirect) 
  {
    this_player()->More(ret);
    return 0;
  }
  if (indirect) 
    return ret;
  return 0;
}

// Durchsuchen des Caches mit Teilstring
public string* grep_man(string key) {
	string* all, *ret;
	int i;
	ret=({});
	key=lower_case(key);
	all=m_indices(cache);
	for (i=sizeof(all); i--;) {
		if (strstr(lower_case(all[i]), key)==-1) continue;
		ret+=({all[i]});
	}
	return sort_array(ret, #'>);
}

// Fuellt den Cache mit allen verfuegbaren Manpages
// Dauert ca. 3,5 Sekunden bei 1000 Seiten -> Lag
public void complete_fill() 
{
  printf("Neueinlesen des Manpage-Caches...\n");
  cache=([]);
  _complete_fill(START[1..],"/");
  printf("%d Seiten eingetragen.\n", sizeof(cache));
}

// Liest alle Aliases ein...das geht schneller
public void read_aliases()
{
  string file, * lines,alias,page;
  int i;
  
  printf("Neueinlesen der Manpage/Hilfe-Aliase...\n");

  aliases=([]);
  file=read_file("/doc/.aliases");
  
  if (stringp(file))
  {
    lines=explode(file,"\n");
    for (i=0;i<sizeof(lines);i++)
    {
      if (sscanf(" "+lines[i],"%t%s %s",alias,page)==2 && alias[0]!='#')
      { // obviously correct format and no comment...
        aliases[alias]=page;
      }
      else if (strlen(alias) && alias[0]!='#')
      { // wrong format and no comment...
        printf("Ungueltige Alias-Zeile: %s\n",lines[i]);
      }
      // else: comment
    }
    printf("%d Aliases eingetragen.\n",sizeof(aliases));  
  }
  else
    printf("Kein Aliasfile gefunden.\n");
}

// static Funktionen

static void _complete_fill(string file, string path) {
	string* dateien, here;
	int i;
	here=path+file+"/";
	dateien=get_dir(here+"*");
	if (!dateien) return; // War kein Dir
	dateien-=({".", ".."});
	for (i=sizeof(dateien); i--;) {
		if (!member(cache, dateien[i])) cache[dateien[i]]=({here});
		else cache[dateien[i]]+=({here});
		_complete_fill(dateien[i], here);
	}
}

static string add(string s1, string s2) { return s2+"/"+s1; }

static void fill_cache(string path, string key) {
	string* dateien;
	dateien=get_dir(path+"/*");
	dateien=filter_array(dateien, lambda( ({'x}),
		({#'!=, ({ #'[, 'x, 0 }), '.' }) ));
	if (member(dateien, key)!=-1) {
		if (member(cache, key)) cache[key]+=({path+"/"});
		else cache+=([ key: ({path+"/"}) ]);
	}
	dateien=map_array(dateien, #'add, path);
	dateien=filter_array(dateien, lambda( ({'x}),
		({#'==, ({ #'file_size, 'x }), -2 }) ));
	map_array(dateien, #'fill_cache, key);
}

static void old_print(string file) {
	this_player()->More(file, 1);
}

static void old_search(string path, string* key) {
	string* dateien,* treffer;
	dateien=get_dir(path+"/*")-({".", ".."});
	treffer=dateien&key;
	key-=treffer;
	if (sizeof(treffer)) {
		treffer=map_array(treffer, #'add, path);
		map_array(treffer, #'old_print);
	}
	dateien=map_array(dateien, #'add, path);
	map_array(dateien, #'old_search, &key);
}

void create() 
{
  if (clonep()) 
    raise_error("manbuf must not be cloned");
  complete_fill();
  read_aliases();
}

int remove() 
{
  printf("Mancache wird geloescht.\n");
  destruct(this_object());
  return 1;
}
