/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:43 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: manhelp.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. Mudlib
// Basierend auf Wunderland Mudlib
//
// GLOBAL/SERVICE/MANBUF.C
//
// Auf diesem Zettel werden die Ergebnisse vom intermud-man gesammelt
// (Nach dem note von Alfe@Tubmud)
//
// Author: Fiona@Wunderland
//
// $Log: manhelp.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:43  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:09  en
// MUDLib CVS Preperation
//
// Revision 1.1  1999/08/05 12:54:40  Largo
// Initial revision
//

inherit "std/thing";

#include <properties.h>
#include <wizlevels.h>
#include <udp.h>

#pragma strong_types

static string txt;
static string thema;
string liestxt();

void create()
{
    if (!clonep()) return;
    ::create();
    SetProp(P_LONG, "Dies ist ein leerer Zettel.\n");
    SetProp(P_PLURAL, "Zettel");
    SetProp(P_NAME, "Zettel");
    SetProp(P_GENDER, MALE);
    AddId("zettel");
    SetProp(P_WEIGHT, 0);
    SetProp(P_VALUE, 0);
    SetProp(P_READ_MSG, #'liestxt);
    txt="";
    seteuid(getuid());
    AddCmd("saveman", "speichern");
}

public void SetKey(string key) {
    thema=key;
    SetProp(P_LONG, break_string("Auf diesem Zettel sammelt der Internet-"
        "Daemon die Ergebnisse Deiner Manual-Anfrage nach \'"+key+
        "\'. Wenn etwas angekommen ist, kannst Du es hierauf lesen. "
        "Mit 'saveman [nummer] [pfad]' speicherst Du den Zettel [nummer] "
        "in einem beliebigen Verzeichnis unter dem Namen der Anfrage." ,78));
    SetProp(P_DESCR, "ueber '"+key+"'");
}

public void udp_reply(mapping data) {
    if (data[SYSTEM]) {
        if (data[SYSTEM]==TIME_OUT) {
            txt+="Manualanfrage nach "+data[NAME]+" 'timed out'.\n";
        }
    } else {
        txt+=sprintf("%'-'|78s\n", " "+data[NAME]+" ")+data[DATA];
    }
}

string liestxt() {
    if (!strlen(txt)) return "Auf dem Zettel steht noch nichts...\n";
    // dummer trick, weil eingebautes lesen kein more hat...
    this_player()->More(txt);
    return "";
}

int move(mixed dest, int meth) {
    if (environment()) call_out("zerfall",5);
    return ::move(dest, meth);
}

void zerfall() {
    object env;
    env=environment();
    if (!IS_WIZARD(env)) {
        if (living(env)) tell_object(env, "Der Zettel zerbroeselt.\n");
        else tell_room(env, "Der Zettel zerbroeselt.\n");
        remove();
    }
}

int remove() {
    destruct(this_object());
    return 1;
}

int speichern(string str) {
    object pl, ob;
    string* worte;
    int n;
    if (!IS_WIZARD(pl=this_player())) return 0;
    if (!str) str=pl->QueryProp(P_CURRENTDIR);
    worte=explode(str," ");
    n=sizeof(worte);
    if (n>2) {
        write("Usage: saveman [nummer] [pfad]\n");
        return 1;
    }
    if (n==1) { // entscheiden, ob nummer oder pfad angegeben wurde
        if (to_int(worte[0])) { // aha, wahrscheinlich nummer
            worte+=({ pl->QueryProp(P_CURRENTDIR) });
        } else {
            worte=({ "1" })+worte;
        }
    }
    n=to_int(worte[0]);
    if (n<1) {
        write("Zettelnummer '"+worte[0]+"' ist irgendwie unsinnig.\n");
        return 1;
    }
    ob=first_inventory(pl);
    while (1) {
        if (function_exists("_save_manpage", ob)) n--;
        if (!n) break;
        ob=next_inventory(ob);
        if (!ob) {
            write("Soviele Man-Zettel hast Du gar nicht.\n");
            return 1;
        }
    }
    call_other(ob, "_save_manpage", worte[1]);
    return 1;
}

public void _save_manpage(string path) {
    string* globed;
    int n;
    globed=this_player()->glob(path);
    if (sizeof(globed)!=1) {
        write("Fehler beim Auswerten (globben) von '"+path+".\n");
        return;
    }
    if (globed[0][<1]=='/') globed[0][<1]='\0'; // trailing '/' entfernen
    n=file_size(globed[0]);
    if (n==-1) {
        write("Verzeichnis '"+globed[0]+"' nicht vorhanden.\n");
        return;
    }
    if (n!=-2) {
        write("'"+globed[0]+"' ist kein Verzeichnis.\n");
        return;
    }
    if (txt=="") {
        write("Der Zettel ist noch leer.\n");
        return;
    }
    if (!write_file(globed[0]+"/"+thema, txt)) {
        write("Konnte Datei '"+globed[0]+"/"+thema+"' nicht anlegen.\n");
        return;
    }
    write("Seite unter '"+globed[0]+"/"+thema+"' abgespeichert.\n");
}
