/*******************
** Eldarea MUDLib **
********************
**
** global/service/mtaerialdb.c
**
** CVS DATA
** $Date: 2001/01/30 08:31:26 $
** $Revision: 1.1 $
**
** material database
**
** CVS History
**
** $Log: materialdb.c,v $
** Revision 1.1  2001/01/30 08:31:26  elatar
** initial revision, already implemented some months ago
**
**
**
*/

#include <material.h>
#include <wizlevels.h>
#include <magic.h>
#include <config.h>

#pragma strict_types

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")

mapping materials;

void create()
{
  object po;
  
  if ( objectp(po=previous_object())
    && ( !IS_ARCH(geteuid(po)) 
      || geteuid(po)==ROOTID 
      || geteuid(po)==geteuid()))
    return;
    
  if (clonep())
  {
    destruct(this_object());
    return;  
  } 
  
  seteuid(getuid());
  printf("Loading MaterialDB...");
  restore_object(MATERIALDB);
  if (mappingp(materials))
    printf("done.\n");
  else
  {
    printf("\nERROR: Database inconsistent. Clearing and saving...");
    materials=([]);
    save_object(MATERIALDB);
    printf("done\n");
  }
}

// Add a material to the db
// All data field must be given
// Return values:
//  1  - OK
//  0  - entry aready exists
// -x  - argument x invalid
int AddMaterial(string id, mixed name, int gender, float weight, 
                int aggregate_state, int hardness, int wearout, 
                int reflectance, int transparence, int flammability,
                int volatility, int freezability, string color, int value,
                string magic_sphere, int magic_resistance, int usability,
                int magical_bonus, int transcendence, int knowledgelevel,
                mixed material_classes, string description, mixed knowledge)
{
  if (!stringp(id))
    return -1;
  
  if (member(materials,id))  
    return 0;
  
  if (!pointerp(name))
    name=({name});
  if (sizeof(name)<1)
    return -2;
  if (sizeof(name)<2)
    name+=({name[0]+"s"});
  if (sizeof(name)<3)
    name+=({name[0]});
  if (sizeof(name)<4)
    name+=({name[0]});
  
  if (!intp(gender) || gender < 0 || gender > 2)
    return -3;
  
  if (!floatp(weight) || weight < 0.0)
    return -4;
  
  if (!intp(aggregate_state) || aggregate_state < -1 || aggregate_state > 1)
    return -5;
  
  if (!intp(hardness) || hardness < 1 || hardness > 100)    
    return -6;
  
  if (!intp(wearout) || wearout < 0 || wearout > 100)
    return -7;
  
  if (!intp(reflectance) || reflectance < 0 || reflectance > 100)
    return -8;
  
  if (!intp(transparence) || transparence < 0 || transparence > 100)
    return -9;
  
  if (!intp(flammability) || flammability < 0 || flammability > 100)
    return -10;
  
  if (!intp(volatility) || volatility < 0 || volatility > 100)
    return -11;
  
  if (!intp(freezability) || freezability < 0 || freezability > 100)
    return -12;
  
  if (!stringp(color))
    return -13;
  
  if (!intp(value) || value < 0)
    return -14;
  
  if (!stringp(magic_sphere) || !VALID_SPHERE(magic_sphere))
    return -15;
  
  if (!intp(magic_resistance))
    return -16;
  
  if (!intp(usability) || usability < 1)
    return -17;
  
  if (!intp(magical_bonus))
    return -18;
  
  if (!intp(transcendence) || transcendence < 0)
    return -19;
  
  if (!intp(knowledgelevel) || knowledgelevel < 1)
    return -20;
  
  if (!stringp(description))
    return -22;
    
  materials+=([id:name;
                  gender;
                  weight;
                  aggregate_state;
                  hardness;
                  wearout;
                  reflectance;
                  transparence;
                  transparence;
                  flammability;
                  volatility;
                  freezability;
                  color;
                  value;
                  magic_sphere;
                  magic_resistance;
                  usability;
                  magical_bonus;
                  transcendence;
                  knowledgelevel;
                  material_classes;
                  description;knowledge
               ]);
  save_object(MATERIALDB);
  return 1;
}                

static mapping _QueryMaterialInfo(string material, mixed info)
{
  mapping ret;
    
  if (intp(info))
    info=({info});
  ret=mkmapping(info,info);
  walk_mapping(ret,lambda(
    ({'ind,'val}),
      ({#'=,'val,({#'[,materials,material,'ind})})));
  return ret;
}

varargs mixed QueryMaterialInfo(mixed material, mixed info)
{
  int i;
  mapping infos,ret;
  string * mind;
  
  if (!stringp(material))  
    return 0;
  if (!intp(info) && !pointerp(info))
    return 0;
      
  // simple Materialabfrage...
  if (!info)
    return member(materials,material);
  if (!member(materials,material))
    return -1;
  if (intp(info))
    return _QueryMaterialInfo(material,info)[info];
  return _QueryMaterialInfo(material,info);
  
  // Legierungsanfrage...schon was komplizierter...
  // Die einzelnen Legierungen werden gemittelt, Zusatzinfo ist allerdings 
  // dann nicht mehr verfuegbar, daher wurde das Konzept verworfen
  // sprich: das hier ist toter Code
  
  infos=([]);
  walk_mapping(material,lambda(
    ({'mat,'perc}),
      ({#'=,({#'[,infos,'mat}),({#'_QueryMaterialInfo,'mat,info})})));
  ret=mkmapping(pointerp(info)?info:({info}),
                allocate(pointerp(info)?sizeof(info):1));

  for (i=sizeof(mind=m_indices(infos));i-->0;)
  {
    walk_mapping(ret,lambda(
      ({'ind,'val}),
        ({#'+=,
          'val,
          ({#'?,
            ({#'||,
              ({#'intp,
                ({#'[,
                  infos[mind[i]],
                  'ind
                })
              }),
              ({#'floatp,
                ({#'[,
                  infos[mind[i]],
                  'ind
                })
              })
            }),
            ({#'*, 
              material[mind[i]]/100.0,
              ({#'[,
                infos[mind[i]],
                'ind
              })
            }),
            0
          })
        })
      ));
    DB(mind[i]);
  }
  return ret;
}

void DumpMaterialList()
{
  if (this_player())
  {
    this_player()->More(ListMaterials()); 
  }
}

string ListMaterials()
{
  string ret, *ind;
  int i;
    
  ret="No. Material\n\n";
  for (i=0;i<sizeof(ind=m_indices(materials));i++)
  {
    ret+=sprintf("%:3d %:20-s\n",i+1,materials[ind[i],MATI_NAME][0]);
  }  
  return ret;
}

int valid_material(string str)
{
  return member(materials,str);  
}
