/*******************
** Eldarea MUDLib **
********************
**
** global/service/namedb.c - name database handling
**
** CVS DATA
** $Date: 2000/12/11 12:52:44 $
** $Revision: 1.5 $
**
** Die Namendatenbank sorgt fuer die korrekte Verwaltung der Namenslisten.
**
** CVS History
**
** $Log: namedb.c,v $
** Revision 1.5  2000/12/11 12:52:44  elatar
** moved global/handler/namehandler to global/service/namedb
**
** Revision 1.4  2000/12/01 15:29:56  elatar
** FreeName() now doesnt need a gender argument, it checks all genders
**
** Revision 1.3  2000/02/01 10:29:15  elatar
** small bugfixing
**
** Revision 1.2  2000/01/14 12:44:54  elatar
** namehandler access secured
**
** Revision 1.1  1999/11/23 17:41:56  elatar
** namehandler first release
**
**
*/

#pragma strict_types

#define NEED_NAME_PROTO
#include <daemon.h>
#include <mail.h>
#include <language.h> // MALE und FEMALE
#include <wizlevels.h>

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),"DEBUG: "+x)
#define ALPHA "abcdefghijklmnopqrstuvwxyz"

private mapping names;
// For Requests:
// ([name:gender;({mailadresses});])

void create()
{
  seteuid(getuid(this_object()));
}

private mixed free_maps(mixed ret)
{
  names=0;
  return ret;
}

int NameRequest(string name, int gender, string mail)
{
  int i;
  string * mailaddr;

  if (!stringp(name))
    return 0;
  if (secure_level(1)<ARCH_LVL) 
    return 0;

  if (file_size(REQUESTS))
    restore_object(REQUESTS);

  if (!names||!mappingp(names))
    names=([]);  

  if (member(names,name))
  {
    if (stringp(mail))
      names[name,1]=names[name,1]+({mail});
    save_object(REQUESTS);  
    return 1; 
  }
  names+=([name:gender;({mail})]);

  //Request saven
  save_object(REQUESTS);

  //Direct online request to trustees
  for (i=sizeof(NAME_TRUSTEES)-1;i-->0;)
  {
    if (find_player(NAME_TRUSTEES[i]))
      tell_object(find_player(NAME_TRUSTEES[i]),
        "\aNAMEHANDLER: Namensanfrage\n"
          "Name       : "+capitalize(name)+"\n"
          "Geschlecht : "+({"keines","maennlich","weiblich"})[gender]+"\n");
  }
  
  //Mail request
  call_other("/secure/mailer","DeliverMail",({
    "NAMEHANDLER",
    "NAMEHANDLER",
    NAME_TRUSTEES[0], 
    NAME_TRUSTEES[1..<1], 
    ({}), 
    "Namensanfrage", 
    dtime(time()), 
    geteuid(), 
    "Angefragter Name:           "+capitalize(name)+"\n"
    "Vorgeschlagenes Geschlecht: "+({"keines","maennlich","weiblich"})[gender]+"\n", 
    }));
  return 1;
}

private int search_name(string name, int gender, int flag)
{
  if ( (!name)
    || (strlen(name)<3)
    || (!gender)
    || (!flag)
      )
    return 0;
  if (!file_size(NAME_SAVE(name,gender))) 
    return 0;

  restore_object(NAME_SAVE(name,gender));
  if ( !mappingp(names))
    return free_maps(0);
  name=lower_case(name);
  if (member(names,name))
  {
    return free_maps((flag&names[name,1])>0);
  }
  return free_maps(0);
}

int free_name(string name, int gender)
{
  return search_name(name,gender,FN_FREE);
}

int used_name(string name, int gender)
{
  return search_name(name,gender,FN_USED);
}

int rest_name(string name, int gender)
{
  return search_name(name,gender,FN_REST);
}

int name_exists(string name, int gender)
{
  return search_name(name,gender,FN_ALL); 
} 

private mixed _name_info(string name, int gender)
{
  if (!file_size(NAME_SAVE(name,gender)))
    return 0;
  restore_object(NAME_SAVE(name,gender));
  if ( !mappingp(names))
    return free_maps(0);

  name=lower_case(name);
  if (member(names,name))
  {
    return free_maps( ({names[name,0],names[name,1],gender}) );
  }
  return free_maps(0);   
}

varargs mixed name_info(string name, int gender)
{
  mixed ret;
  
  if (!strlen(name))
    return 0;
  if(!gender)
  {
    ret=_name_info(name,MALE);
    if (!ret)
      return _name_info(name,FEMALE);
    return ret;
  }
  return _name_info(name,gender);
}

int add_name(string name,mixed race, int gender)
{
  if ( (!name)
    || (strlen(name)<3)
    || (!race)
    || (!gender)
     )
    return 0;

 if (secure_level(1)<ARCH_LVL)
    return 0;

 //Check if requested and mail if so
 if (file_size(REQUESTS))
 {
   restore_object(REQUESTS);
   if (member(names,name)&&sizeof(names[name,1]))
   { 
     //mail verschicken 
     call_other("/secure/mailer","DeliverMail",({
       "Namehandler@Eldarea",
       "Namehandler@Eldarea",
       names[name,1][0],
       (1<sizeof(names[name,1]))?names[name,1][1..<1]:({}),
       ({}),
       "Namensanfrage im Eldarea LPMud",
       dtime(time()),
       geteuid(),
       "Seid gegruesst!\n\n"
          "Der von Euch angefragte Name "+capitalize(name)+" wurde soeben\n"
          "eingetragen. Somit steht er nun zur freien Verfuegung, bis Ihr\n"
          "oder jemand anders einen Charakter mit diesem Namen erstellt.\n\n"
          "Wir hoffen also, Euch bald als Spieler im Eldarea begruessen zu\n"
          "duerfen.\n\n"
          "Hochachtungsvoll\n\n"
          "Die Avatare von Eldarea\n\n",
       }));                          
     names-=([name]);
     save_object(REQUESTS);
   }
 }

 if (!file_size(NAME_SAVE(name,gender)))
    names=([]); 
  else
    restore_object(NAME_SAVE(name,gender));
  if (!mappingp(names))
    names=([]);
  if (!pointerp(race))
    race=({race});

  name=lower_case(name);
  if (member(names,name))
  {
    race-=names[name,0];
    names[name,0]+=race;
    efun::save_object(NAME_SAVE(name,gender));
    return free_maps(1);
  }
  else 
  {
    names+=([name:race;FN_FREE]);
    efun::save_object(NAME_SAVE(name,gender));
    return free_maps(1);
  }
}

varargs int remove_name(string name, mixed race)
{
  int i,ret;
  string *races;
 
  if ( (!name)
    || (strlen(name)<3)
     )
    return 0;
  if (secure_level(1)<ARCH_LVL)
    return 0;

  if (race&&!pointerp(race))
    race=({race});

  name=lower_case(name);
  for (i=1;(i<3)&&(ret==0);i++)
  {
    if (!file_size(NAME_SAVE(name,i)))
      continue;
    else
      restore_object(NAME_SAVE(name,i));
    if (!mappingp(names))
      continue;

    if (member(names,name))
    {
      if (!race)
        names=m_delete(names,name);
      else 
      {
        races=names[name,0]-race;
        if (sizeof(races))
          names=m_delete(names,name);
      }
      save_object(NAME_SAVE(name,i));  
      ret=1;
    }
  }
  return free_maps(ret);
}

private int contains_val(string key, string *ar,int flag,string va)
{
  return ((-1!=member(ar,va))&&(flag==FN_FREE));
}

private int is_free(string key, string *ar,int flag, string va)
{
  return (flag==FN_FREE);
}

private string * _QueryNames(string start, string race, int gender)
{
  int i;
  string *keys,*ret;

  if (!file_size(NAME_SAVE(start,gender)))
    return ({});
  else
    restore_object(NAME_SAVE(start,gender));
  if (!mappingp(names)) 
    return ({});
  
  ret=({});
  if (stringp(race)&&strlen(race))
  {
    race=lower_case(race);
    keys=m_indices(names);
    for(i=sizeof(keys);i-->0;)
    {
      if ((names[keys[i],1]==FN_FREE)&&(-1!=member(names[keys[i],0],race)))
        ret+=({keys[i]});
    }
    return free_maps(ret);
  }
  else
  {
    keys=m_indices(names);
    for(i=sizeof(keys);i-->0;)
    {
      if (names[keys[i],1]==FN_FREE)
        ret+=({keys[i]});
    }
    return free_maps(ret);
  }

/* This would be a lambda solution (but it doesnt work)  
  if (strlen(race))
    return free_maps(m_indices(filter(names,"contains_val",this_object(),race)));
  race="Avatar";
  return filter(names,  lambda(({ 'key,'value,'val2, 'wunsch }), ({ #'?, ({ #'>, ({ #'member,'value, 'wunsch }), -1 }), ({ #'return, 'key }), })),race);
  return free_maps(m_indices(filter(names,"is_free",this_object(),race)));
*/

}

private string *__QueryNames(string start,string race,int gender)
{
  int i;
  string *names;

  names=({});
  if (!stringp(start)||!strlen(start))
  {
    for (i=0;i<strlen(ALPHA);i++)
      names+=_QueryNames(ALPHA[i..i],race,gender);
    return names;
  }
  return _QueryNames(start,race,gender);
}

varargs string *QueryNames(string start, string race, int gender)
{
  if (!gender)
    return __QueryNames(start, race, MALE)+__QueryNames(start, race, FEMALE);
  else
   return __QueryNames(start, race, gender);
}

int RegisterName(string name, int gender)
{
  string files;

  if (!name || !gender) return 0;
  if (secure_level(1)<ARCH_LVL)
    return 0;

  if (!file_size(NAME_SAVE(name,gender)))
    return 0;
  else
    restore_object(NAME_SAVE(name,gender));
  if (!mappingp(names)) 
    return free_maps(0);
  name=lower_case(name);
  if (!member(names,name))
    return free_maps(0);
  if (names[name,1]!=FN_FREE)
    return free_maps(0);
  names[name,1]=FN_USED;
  save_object(NAME_SAVE(name,gender));
  return free_maps(1);
}

int RestrictName(string name)
{
  string files;
  int i;

  if (!name) return 0;
  if (secure_level(1)<ARCH_LVL)
    return 0;

  for (i=1;i<3;i++)
  {
    if (!file_size(NAME_SAVE(name,i)))
      continue;
    else
      restore_object(NAME_SAVE(name,i));
    if (!mappingp(names)) 
       continue;
    name=lower_case(name);
    if (!member(names,name))
      continue;
    names[name,1]|=FN_REST;
    save_object(NAME_SAVE(name,i)); 
    return free_maps(1);
  }  
  return free_maps(0);
}

int FreeName(string name)
{
  string files;
  int i;

  if (!name) 
    return 0;
  if (secure_level(1)<ARCH_LVL)
    return 0;

  for (i=1;i<3;i++)
  {
    if (!file_size(NAME_SAVE(name,i)))
      continue;
    else
      restore_object(NAME_SAVE(name,i));
    if (!mappingp(names)) 
       continue;
    name=lower_case(name);
    if (!member(names,name))
      continue;
    names[name,1]=FN_FREE;
    save_object(NAME_SAVE(name,i)); 
    return free_maps(1);
  }  
  return free_maps(0);
}
