/*******************
** Eldarea MUDLib **
********************
**
** global/service/finger.c - finger object
**
** CVS DATA
** $Date$
** $Revision$
**
** Liest die Daten eines Spielers ein und gibt sie in lesbarer
** Form zurueck.
**
** CVS History
**
** $Log$
**
*/

#include <properties.h>
#include <config.h>
#include <wizlevels.h>
#include <defines.h>
#include <guilds.h>
#include <service.h> 
       
//Soviel kann man immer verlangen
#pragma strong_types 

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")

// Ein Herzschlag
#define HEART_BEAT 2

// Ab wann gilt man als idle
#define MINIDLE 90

// Wann war der allererste Login (1. September 1999)
#define LOGINDATE 936136800

// Optionen
#define OPT_NO_PROJECT "p"     // Projekt wird nicht angezeigt
#define OPT_FING_SHORT "s"     // Kurze Finger-Ausgabe
#define OPT_HTML       "h"     // Text wird fuer HTML zurueckgegeben

// Farbname in P_COLORS
#define COL1 "finger"

// HTML-Markierungen
#define HTML1 "<B>"
#define HTML2 "</B>" 

// Nun soll fuer Html umgebrochen werden *shrug*
#define BS break_it

// Wie gross darf die .project Datei sein?
#define FILE_MAX_SIZE 5000

// Indizes fuer data-mapping
#define NAME           0
#define FULLNAME       1
#define GENDER         2
#define STATUS_ID      3
#define STATUS_TEXT    4
#define STATUS_IP      5
#define STATUS_ORIGIN  6
#define IDLE           7
#define RACE           8
#define LEVEL          9
#define GUILD         10 //obs, dafuer prof
#define AGE           11
#define GHOST         12 //obs
#define EMAIL         13
#define MARRIED       14
#define CREATION      15
#define DEATH         16
#define AWAY          17
#define TESTPLAYER    18
#define DOMAINLORD    19
#define DOMAIN        20
#define PRONOUN       21
#define HOMEPAGE      22
#define TBANISHED     23
#define SECOND        24
#define CHARACTER     25
#define GUILDLEVEL    26 //obs
#define MAIL          27
#define SPONSOR       28
#define SPONSORED     29
#define MONTHLY_AGE   30
#define STATUS_LOGGED 31                                                                                                                
#define NETDEAD_TIME  32
#define WIZ_LEVEL     33
#define PROFESSION    34
#define VISUAL_AGE    35

// Globale Variablen mit den Daten des Spielers
mapping properties;
int age;
mixed* age_m; 

//Html-Version gewuenscht?
int html;

void create() 
{
  if (clonep())
  {
    destruct(this_object());
    return;
  }

  seteuid(getuid());
}

string timediff(int time)
{
  string ret;
  int h,m,s;

  ret="";
  if(time>=86400) 
  {
    ret+=time/86400+"d ";
    time%=86400;
  }
  h=time/3600;
  time%=3600;
  m=time/60;
  s=time%60;
  return ret+sprintf("%'0'2d\"%'0'2d'%'0'2d",h,m,s);
}                                                        

// aus std/player/description geholt...
static string al_to_title(int a, int is_wiz) {
  string s;
  if(is_wiz>SEER_LVL)
    if(s=(string)properties[P_CHARACTER]) return s;
    else return "magisch";
  if(a > 924)
    return "heilig";
  if(a > 749)
    return "gut";
  if(a > 449)
    return "nett";
  if(a > 124)
    return "freundlich";
  if(a > - 125)
    return "neutral";
  if(a > - 450)
    return "mies";
  if(a > - 750)
    return "teuflisch";
  if(a > - 925)
    return "daemonisch";
  return "satanisch";
}                                                                  

static varargs string break_it(string str, int width, mixed indent, int flag)
{
  string ret;

  ret=break_string(str, width, indent, flag);
  if (stringp(indent)) 
  {
    if (this_player())
      ret=this_player()->in_color(COL1, indent)+ret[strlen(indent)..];
    else if (html) 
      ret=HTML1+indent+HTML2+ret[strlen(indent)..];
  }
  return ret;                   
}
static mapping get_finger_data(string str,object player,int player_is_wiz,mixed info)
{
  mixed m_var;
  mapping data;
  string * pronoun,*sa_var,ipnum,s_var;
  int i_var,invis;

  //Pronomen und Geschlecht 
  pronoun = ({ "", "", "", "" });
  if (properties[P_GENDER]==NEUTER)
  {
    pronoun[WER]    = "es";
    pronoun[WESSEN] = "es";
    pronoun[WEM]    = "ihm";
    pronoun[WEN]    = "es";
    data = ([ GENDER : "neutral" ]);
  }
  else if (properties[P_GENDER]==MALE)
  {
    pronoun[WER]    = "er";
    pronoun[WESSEN] = "ihn";
    pronoun[WEM]    = "ihm";
    pronoun[WEN]    = "ihn";
    data = ([ GENDER : "maennlich" ]);
  }
  else
  {
    pronoun[WER]    = "sie";
    pronoun[WESSEN] = "sie";
    pronoun[WEM]    = "ihr";
    pronoun[WEN]    = "sie";
    data = ([ GENDER : "weiblich" ]);
  }

  data += ([ PRONOUN : pronoun ]);                                                                                   

  //Login-Status
  if (player) //player eingeloggt oder netztot
  {
    invis=player->QueryProp(P_INVIS);
    ipnum=query_ip_number(player);
    if (ipnum) //player aktiv
    {
      data+=([STATUS_ID     : 1 
             ,STATUS_TEXT   : ({invis?"nicht anwesend":"anwesend"
                               ,invis?"unsichtbar anwesend":"anwesend"})
             ,STATUS_LOGGED : dtime(object_time(player))
             ,STATUS_IP     : ({ipnum,query_ip_name(ipnum)})
             ,STATUS_ORIGIN : country(ipnum)
             ,IDLE          : ((i_var=query_idle(player))<MINIDLE ?0:i_var)
             ,NETDEAD_TIME  : properties[P_NETDEAD_TIME]
             ,AGE           : age * HEART_BEAT
             ,VISUAL_AGE    : (age*HEART_BEAT)-(time()-properties[P_NETDEAD_TIME])
              ]);
    }
    else //player netztot
    {
      ipnum=properties[P_CALLED_FROM_IP];
      data+=([STATUS_ID     : 2
             ,STATUS_TEXT   : ({"netztot","netztot"})
             ,STATUS_IP     : ({query_ip_name(ipnum),ipnum})
             ,STATUS_ORIGIN : country(ipnum)
             ,NETDEAD_TIME  : properties[P_NETDEAD_TIME]
             ,AGE           : age * HEART_BEAT
             ,VISUAL_AGE    : age * HEART_BEAT
              ]);
    }
  }
  else //player nicht eingeloggt
  {
    ipnum=properties[P_CALLED_FROM_IP];

    data+=([STATUS_ID     : 3 
           ,STATUS_IP     : ({ query_ip_name(ipnum), ipnum }) 
           ,STATUS_TEXT   : ({"nicht anwesend","nicht anwesend"})
           ,STATUS_ORIGIN : country(ipnum)
           ,NETDEAD_TIME  : file_date("/save/"+str[0..0]+"/"+str+".o")
           ,AGE           : age * HEART_BEAT
           ,VISUAL_AGE    : age * HEART_BEAT
           ]);               
  }

  // name und fullname
  data += ([ NAME : ((s_var=properties[P_NAME]) && s_var!="") ?
     s_var : capitalize (str) ]);

  s_var = (((s_var=properties[P_PRESAY]) && s_var!="") ? s_var+" " : "")
   +data[NAME] + (properties[P_TITLE] ? " "+properties[P_TITLE] : "");

  data += ([ FULLNAME  : s_var ]); 

  // Rasse
  if (!(s_var=properties[P_RACE]) || s_var=="")
  {
    /* Rasse aus obname lesen...hm, mal sehn
    if (info && pointerp(info) && strstr(info[4],"/")>=0)
    {
      s_var2 = efun::explode(info[4], "/")[3];
      s_var = (s_var2=="human" ? "Mensch" : (s_var2=="dwarf" ? "Zwerg" :
         capitalize(s_var2)));
    }
    else
    */
      s_var = "<keine>";
  }

  // ... und so weiter
  data += ([RACE       : s_var 
           ,LEVEL      : properties[P_LEVEL]
           ,WIZ_LEVEL  : player_is_wiz 
           ,PROFESSION : s_var=properties[P_PROFESSION]?s_var:"<keiner>"
           ,EMAIL      : s_var=properties[P_MAILADDR]?s_var:"<keine>"
           ,HOMEPAGE   : s_var=properties[P_HOMEPAGE]?s_var:"<keine>"
           ,CREATION   : ((i_var=properties[P_CREATION_DATE])<LOGINDATE &&
                          (strstr(str, "gast", 0)==-1) ?
                          "Anbeginn der Zeit" : dtime(i_var)) 
           ,MARRIED    : s_var=properties[P_MARRIED]?s_var:0
           ,DEATH      : i_var=properties[P_DEATH]?i_var:0
           ,AWAY       : s_var=properties[P_AWAY]?s_var:0
           ]);                                 

  //monthly age
  if (!pointerp(age_m) || sizeof(age_m)!=3 || age_m[2] && intp(age_m[2]))
    /* nixtun, Wert bleibt auf 0 */ ;
  else if (stringp(age_m[2])) 
    data += ([ MONTHLY_AGE : age_m[2] ]);
  else 
  { // Auswerten erlaubt
    if (age_m[0]!=ctime()[4..6]+ctime()[22..]) 
      i_var=0;
    else 
    {
      i_var=data[AGE]-age_m[1]*HEART_BEAT;
      if (i_var<0) i_var=0;
    }
    data += ([ MONTHLY_AGE : timediff(i_var)[0..<4] ]);
  }                                                            
 
  // another various items
  data+=([TESTPLAYER : s_var=properties[P_TESTPLAYER]?stringp(s_var)?s_var:1:0
         ,SECOND     : s_var=properties[P_SECOND]?stringp(s_var)?s_var:1:0
         ,DOMAINLORD : (info && sizeof(sa_var=info[3]))?
                       efun::implode(map_array(sa_var, #'capitalize), ", "):0
         ,DOMAIN     : (sizeof((sa_var=MASTER->get_domain_homes(str))))?
                       efun::implode(map_array(sa_var, #'capitalize), ", "):0
         ,TBANISHED  : (i_var=MASTER->QueryTBanished(str, 1))?
                       (i_var==-1)?"St. Nimmerleinstag":dtime(i_var)[0..16]:0
         ,CHARACTER  : al_to_title(properties[P_ALIGN], player_is_wiz)
         ,MAIL       : "secure/mailer"->FingerMail(str) 
           ]);

  //nu noch den sponsor
  if (player_is_wiz) {
    m_var=SERVICE->QuerySponsor(str);
    if (pointerp(m_var)) 
      data+=([ SPONSOR : ({ capitalize(m_var[0]),
                            dtime(m_var[1])[5..16] }) 
              ]);
    m_var=SERVICE->QuerySponsored(str);
    if (pointerp(m_var) && sizeof(m_var))
      data+=([ SPONSORED : map_array(m_var, #'capitalize) ]);
  }                                 
 
  return data;
}

static string finger_long(string str,object player,int player_is_wiz
                         ,int viewer_is_wiz,string info)
{
  object pl;
  string p,q,text,s_var;
  mapping data;
  int invis,i_var;

  if (player) 
    invis=player->QueryProp(P_INVIS);

  if (html)
  {
    q=HTML1;
    p=HTML2;
  }
  else
  {
    q="";
    p="";
  }
  pl=this_player();  

  data = get_finger_data(str, player, player_is_wiz, info);

  if (data[IDLE]&&(viewer_is_wiz|| !player_is_wiz))
    s_var=data[IDLE];
  else
    s_var="";
  text=sprintf(
      "+--- %s%'-':71-s%s-+\n"
      "|                                                                            |\n"
      ,q,data[FULLNAME]+" ",p);
  switch(data[STATUS_ID])
  {
  case 1:
    if (!invis || viewer_is_wiz)
      s_var=sprintf("%s ist %sanwesend seit %s von %s."
        ,data[PRONOUN][WER],invis?"unsichtbar ":"",data[STATUS_LOGGED],data[STATUS_ORIGIN]);
    else
      s_var=sprintf("%s ist nicht anwesend.",data[PRONOUN][WER]);
    break;
  case 2:
      s_var=sprintf("%s ist netztot.",data[PRONOUN][WER]);
    break;
  case 3:
      s_var=sprintf("%s ist nicht anwesend.",data[PRONOUN][WER]);
    break;
  }
  text+=sprintf("| %:74-s |\n",capitalize(s_var));
  if (data[STATUS_ID]>1 || (!viewer_is_wiz&&invis))
    text+=sprintf(
      "| %:74-s |\n"
      ,sprintf("%s war %s zuletzt eingeloggt aus %s."
        ,capitalize(data[PRONOUN][WER])
        ,((i_var=time()-data[NETDEAD_TIME])>86400)?
           "am "+dtime(data[NETDEAD_TIME])
          :"vor "+timediff(i_var),data[STATUS_ORIGIN]));
  if (viewer_is_wiz)
  {
    text+=sprintf("| %:74-s |\n",sprintf("( %s / %s )",
      data[STATUS_IP][0],data[STATUS_IP][1]));
  } 
  text+=sprintf("| %:74s |\n","");
  
  return text;
}

public varargs string finger(string str, string options)
{
  string q,p,pfile,text;
  object pl,player;
  int player_is_wiz,viewer_is_wiz,pfile_size;
  mixed info;

  if (!str || !stringp(str))
    return "";

  str = lower_case(str);

  // Kann es den Namen ueberhaupt geben?
  if(str[0]<'a' || str[0]>'z')
    return sprintf("'%s' heisst hier sicher niemand.\n",
      capitalize(str));

  pl = this_player();

  str=explode(str,".")[0];
  if((info = MASTER->QueryBanished(str)) && strstr(str, "gast")==-1) 
  {
    return break_string(sprintf("Der Name %s ist gebannt. (Grund: %s)"
                          ,capitalize(str),info));
  }

  info = MASTER->get_userinfo(str);
  player = find_player(str);

  if (!info && !player)
    return "Diesen Namen gibt es im "MUDNAME" nicht.\n";

  //Hier koennte noch ein namehandler-request hin

  if (!player)
  {
    age=age_m=properties=0;
    if (!restore_object("/save/" + str[0..0] + "/" + str) ||
        !properties || !m_sizeof(properties))
    {
      if (0 > file_size("/save/" + str[0..0] + "/" + str))
        return sprintf("Der Spieler von %s hat noch keinen Charakter erschaffen.\n"
                         ,capitalize(str));
      return "Mist!!! Das Einlesen der Daten klappt nicht wie es soll :-(\n";
    }
  }
  else
    if (!(properties=player->QueryProperties()) ||
        !(age=player->QueryProp(P_AGE)) ||
        (age_m=player->QueryProp(P_AGE_MONTHLY),0)) 
      return "Mist!!! Das Einlesen der Daten klappt nicht wie es soll :-(\n";

  player_is_wiz = query_wiz_level(str);
  viewer_is_wiz = (pl && IS_LEARNER(pl));                                       

  // Kurz- oder Langfinger?
  if (!options || !stringp(options) || strstr(options, OPT_FING_SHORT)==-1)
    //Langfinger
    text = finger_long(str,player,player_is_wiz,viewer_is_wiz,info); 
  else
    //Kurzfinger
    text = "Kurfinger ist momentan nicht implementiert.";

  // Html?
  if (options && stringp(options) && strstr(options, OPT_HTML)>0)
  {
    q = HTML1;
    p = HTML2;
    html=1;
  }
  else
  {
    q = "";
    p = "";
    html=0;
  }                

  //Projekt?                                                    
  if (!options || !stringp(options) || strstr(options, OPT_NO_PROJECT)==-1)
  {
    pfile = "/"+WIZARDDIR+"/"+str+"/.project";

    if ((pfile_size=file_size(pfile))>=0 && pfile_size<=FILE_MAX_SIZE)
      text += BS(read_file(pfile), BS_STDLEN,
              "Projekt: ");
    else
    {
      pfile = FSAVE_DIR+str+".project";

      if ((pfile_size=file_size(pfile))>=0 && pfile_size<=FILE_MAX_SIZE)
        text += BS(read_file(pfile), BS_STDLEN,
                "Projekt: ");
    }
  }

  // Speicher wieder freigeben
  age = age_m = 0;
  properties = ([]);

  return text;                    
}      
