/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:43 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: pollbox.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. MUDlib
// Basierend auf Wunderland Mudlib
//
// GLOBAL/SERVICE/POLLBOX.C -- Object for a pollbox
//
// Author: Troy@Wunderland
//
// $Log: pollbox.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:43  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:09  en
// MUDLib CVS Preperation
//
// Revision 1.1  1999/08/05 12:55:43  Largo
// Initial revision
//

#include <properties.h>
#include <pollbox.h>

inherit "std/thing";

void create() {
  if(!clonep()) return;
  ::create();
  SetProp(P_PLURAL, "Wahlurnen");
  SetProp(P_LONG, "Du stehst hier vor einer roten, wuerfelfoermigen Wahlurne. Diese Urne "
    "dient der Erhebung von statistischen Fragen im Wunderland. Ab Level 5 darfst Du "
    "hier abstimmen, ab Level 10 darfst Du hier selbst Fragen zur Abstimmung "
    "stellen. Eine Hilfe ueber die Kommandos erhaeltst Du mit 'hilfe urne'.");
  SetProp(P_NAME,"Wahlurne");
  SetProp(P_GENDER,FEMALE);
  SetProp(P_NOGET,"Nix da!\n");
  SetProp(P_WEIGHT,200000000);
  SetProp(P_VALUE,0);
  SetProp(P_NOBUY,1);
  SetProp(P_VOTE_MIN_LEVEL,5);
  SetProp(P_VOTE_INIT_MIN_LEVEL,10);
  SetProp(P_VOTE_EXPIRE,7);
  AddId(({"urne","wahlurne"}),({"urnen","wahlurnen"}));
  AddAdjective(({"rote","roten","roter"}));
  SetProp(P_NAME_ADJ,"rot");
  AddCmd(({"hilf","hilfe","help"}),"hilfe");
  AddCmd(({"zeig","zeige"}),"zeige");
  AddCmd(({"waehl","waehle"}),"waehle");
  AddCmd(({"erheb","erhebe"}),"erhebe");
  AddCmd(({"entfern","entferne"}),"entferne");
  AddCmd("antworten","antworten");
}

int zeige(string str)
{
  string s;
  notify_fail("WAS soll ich Dir zeigen?\n");
  if(!str || !stringp(str) || (str=lower_case(str))=="" ||
     member_array(str,({"f","fragen","e","ergebnisse","l","liste"}))<0) return 0;
  this_player()->More(POLLMASTER->zeige(str));
  return 1;
}

int waehle(string str)
{
  int q;
  string wie;
  notify_fail("WAS willst Du waehlen?\n");
  if(!str || !stringp(str) || (str=lower_case(str))=="" ||
     sscanf(str,"%d %s",q,wie)!=2) return 0;
  switch(POLLMASTER->waehle(q-1,wie,this_player(),QueryProp(P_VOTE_MIN_LEVEL)))
    {
    case 0:
      return 0;
    case -1:
      write("Du hast zu dieser Frage schon Deine Meinung gesagt.\n");
      return 1;
    case -2:
      write(break_string("Du bist zur Abstimmung noch nicht zugelassen. Du musst mindestens "+
			 QueryProp(P_VOTE_MIN_LEVEL)+". Level sein.",78));
      return 1;
    case -3:
      write("Die Antwort gibt es zu dieser Frage nicht.\n");
      return 1;
    }
  write("Du waehlst zur Frage Nr. "+q+" die Antwort \""+wie+"\".\n");
  say(this_player()->name(WER,1)+" waehlt.\n",this_player());
  return 1;
}

int erhebe(string str)
{
  int l;
  notify_fail("WELCHE FRAGE willst Du erheben?\n");
  if(!str || !stringp(str) || str=="") return 0;
  if(POLLMASTER->erhebe(str,this_player(),QueryProp(P_VOTE_INIT_MIN_LEVEL),QueryProp(P_VOTE_EXPIRE))<0)
    {
      write("Du benoetigst mindestens Level "+QueryProp(P_VOTE_INIT_MIN_LEVEL)+", um hier etwas zu erheben.\n");
      return 1;
    }
  write("Ok. Du stellst also folgende Frage zur Abstimmung:\n"+break_string(str,78));
  say(this_player()->name(WER,1)+" startet eine neue Erhebung.\n",this_player());
  return 1;
}

int entferne(string str)
{
  int l,nr;
  notify_fail("WELCHE FRAGE willst Du entfernen?\n");
  if(!str || !stringp(str) || !(nr=to_int(str))) return 0;
  if(this_player()->QueryProp(P_LEVEL)<(l=(int)QueryProp(P_VOTE_INIT_MIN_LEVEL)))
    {
      write("Du benoetigst mindestens Level "+l+", um hier etwas zu entfernen.\n");
      return 1;
    }
  if(!this_player()->QueryProp(P_VOTE_EXPIRE))
    {
      write(break_string("Bist Du Dir da auch wirklich sicher? Wenn ja, dann gib den Befehl nochmal ein.",78));
      this_player()->SetProp(P_VOTE_EXPIRE,1);
      return 1;
    }
  this_player()->SetProp(P_VOTE_EXPIRE,0);
  switch(POLLMASTER->entferne(--nr,this_player()))
    {
    case 0:
      return 0;
    case -1:
      write("Diese Erhebung stammt nicht von Dir. Du kannst sie nicht entfernen.\n");
      return 1;
    }
  write("Du entfernst die Frage. Wenn das ein Fehler war, dann hast Du jetzt Pech gehabt.\n");
  say(this_player()->name(WER,1)+" loescht eine Erhebung vom Brett.\n");
  return 1;
}

int hilfe(string str)
{
  notify_fail("Zu diesem Thema ist keine Hilfe verfuegbar.\n");
  if(!str || !stringp(str) || (str=lower_case(str))=="" || !id(str)) return 0;
  this_player()->More(POLLMASTER->hilfe(QueryProp(P_VOTE_MIN_LEVEL),QueryProp(P_VOTE_INIT_MIN_LEVEL),QueryProp(P_VOTE_EXPIRE)));
  return 1;
}

int antworten(string str)
{
  int nr;
  string ans;
  notify_fail("Fuer WELCHE FRAGE soll ich WELCHE ANTWORTEN vorsehen?\n");
  if(!str || !stringp(str) || (str=lower_case(str))=="" ||
     sscanf(str,"%d %s",nr,ans)!=2) return 0;
  switch(POLLMASTER->antworten(--nr,ans,this_player()))
    {
    case -1:
      write("Diese Frage stammt nicht von Dir.\n");
      return 1;
    case -2:
      write("Mindestens eine moegliche Antwort musst Du schon angeben.\n");
      return 1;
    case -3:
      write(break_string("Es hat schon jemand auf diese Frage geantwortet. Wenn Du die "+
			 "moeglichen Antworten aendern willst, dann musst Du die Frage "+
			 "erst loeschen.",78));
      return 1;
    case 0:
      return 0;
    }
  write("Du aenderst die moeglichen Antworten zu Frage Nr. "+(nr+1)+".\n");
  say(this_player()->name(WER,1)+" aendert eine Frage.\n",this_player());
  return 1;
}
