/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:43 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: pollmaster.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/
// M.D. MUDlib
// Basierend auf Wunderland Mudlib
//
// GLOBAL/SERVICE/POLLMASTER.C -- Master-Object for the pollbox
//
// Author: Troy@Wunderland
//
// $Log: pollmaster.c,v $
// Revision 1.1.1.1  1999/11/05 12:30:43  elatar
// Preparing mudlib for cvs control
//
// Revision 1.1.1.1  1999/11/04 12:48:09  en
// MUDLib CVS Preperation
//
// Revision 1.1  1999/08/05 12:57:06  Largo
// Initial revision
//

#pragma strong_types

#define NEED_PROTOTYPES

#include <properties.h>
#include <pollbox.h>
#include <wizlevels.h>
#include <defines.h>
#include <news.h>

#define SAVES "/global/service/save/polls"
#define LOGS  "POLLS"
#define EXPDAYS  7

private varargs void write_result(mixed *res,object del);

mixed *polls;

private void save_info() {
  save_object( SAVES );
}

private void evaluate_polls() {
  int i;
  mixed *old;
  old = polls;
  polls = ({});
  for (i=0; i<sizeof(old); i++) {
    if ((int)old[i][VOTE_EXPIRE]<time())
      write_result(old[i]);
    else
      polls += ({ old[i] });
  }
  save_info();
}

static void security() {
  evaluate_polls();
  if (find_call_out("security")<0)
    call_out("security", 21600); // check every 6 hours.
}

void create() {
  if (clonep()) destruct(this_object());
  seteuid(getuid(this_object()));
  if (!restore_object( SAVES ))
    polls = ({});
  security();
}

public mixed *QueryPolls() {
  return deep_copy(polls);
}

private string question(mixed *poll) {
  if (sizeof(poll)<4) return "FEHLER!\n";
  return capitalize(break_string((string)poll[VOTE_QUESTION],BS_STDLEN,
    4, BS_IND_FIRST));
}

private string answer(mixed *poll) {
  int i;
  string *s;
  if (sizeof(poll)<4) return "FEHLER!\n";
  for (s=({}),i=0;i<sizeof(poll[VOTE_ANSWERS]);i++) {
    s+=({ ((string)poll[VOTE_ANSWERS][i][0])+": "+
	 to_string((int)poll[VOTE_ANSWERS][i][1]) });
  }
  if (!sizeof(s)) return "Keine Antworten moeglich!\n";
  return break_string("Antworten: "+("/std/player/soul"->CountUp(s)),
    BS_STDLEN, 7, BS_IND_FIRST);
}

private string all(mixed *poll) {
  if (sizeof(poll)<4) return "FEHLER!\n";
  return question(poll)+answer(poll);
}

private string make_list(closure func) {
  int i;
  string s;
  if (!sizeof(polls)) return "*** keine ***\n";
  for (s="",i=0;i<sizeof(polls);i++) {
    s+=sprintf("%d.) %:-15s %57s\n%s", i+1,
      capitalize(polls[i][VOTE_INITIATOR])+":",
      dtime(polls[i][VOTE_EXPIRE]-EXPDAYS*86400)[5..16],
      funcall(func, polls[i]));
  }
  return s;
}

public string zeige(string str) {
  string s;
  s="";
  switch(str[0]) {
    case 'f':
      s="Liste der Fragen:\n-------------------------------------------"
        "----------------------------------\n"+make_list(#'question)+
        "--------------------------------------------------------------"
        "---------------\n";
      break;
    case 'e':
      s="Liste der Antworten:\n-------------------------------------------"
        "----------------------------------\n"+make_list(#'answer)+
        "--------------------------------------------------------------"
        "---------------\n";
      break;
    case 'l':
      s="Liste der Erhebungen:\n-------------------------------------------"
        "----------------------------------\n"+make_list(#'all)+
        "--------------------------------------------------------------"
        "---------------\n";
      break;
  }
  return s;
}

public int waehle(int q,string a,object who,int l) {
  int i;
  if (q<0 || q>=sizeof(polls)) return 0;
  if (member_array(getuid(who),(string*)polls[q][VOTE_VOTED])>-1)
    return -1;
  if ((int)who->QueryProp(P_LEVEL)<l)
    return -2;
  for (i=0; i<sizeof(polls[q][VOTE_ANSWERS]); i++)
    if (lower_case(a)==lower_case((string)polls[q][VOTE_ANSWERS][i][0])) break;
  if (i>=sizeof(polls[q][VOTE_ANSWERS])) return -3;
  polls[q][VOTE_ANSWERS][i][1]++;
  polls[q][VOTE_VOTED]+=({ getuid(who) });
  save_info();
  return 1;
}

public int erhebe(string str,object who,int l,int dummy) {
  mixed* mess;
  if ((int)who->QueryProp(P_LEVEL)<l)
    return -1;
  polls += ({ ({ getuid(who),
		 (EXPDAYS*86400)+time(),
		 str,
		 ({ ({ "JA", 0 }),
		  ({ "NEIN", 0 }),
		  ({ "ENT", 0 }) }),
		 ({}) }) });
  save_info();
  mess=allocate(7);
  mess[M_BOARD]="bekanntmachungen";
  mess[M_REFERENCE]="";
  mess[M_WRITER]="Statistisches Amt";
  mess[M_TITLE]="Neue Umfrage";
  mess[M_MESSAGE]=break_string("Das Statistische Amt des Wunderlands gibt"
    " bekannt:\n\nEs steht eine neue Umfrage zur Beteiligung an. "+
    capitalize(polls[<1][VOTE_INITIATOR])+" hat diese Form der "
    "Mitbeteiligung gewaehlt, um ein unrepraesentatives Meinungsbild zu "
    "der Fragestellung\n\n"+polls[<1][VOTE_QUESTION]+"\n\nzu erhalten.");
  "/secure/news"->WriteNote(mess);
  return 1;
}

public int antworten(int q, string ant, object who) {
  string *a;
  mixed *ans;
  if (q<0 || q>=sizeof(polls)) return 0;
  if ((string)polls[q][VOTE_INITIATOR]!=getuid(who) && !this_interactive() &&
     !IS_ARCH(this_interactive()))
    return -1;
  if (!sizeof((a=efun::explode(upper_case(ant)," ")))) return -2;
  if (sizeof(polls[q][VOTE_VOTED])) return -3;
  for(ans=({});sizeof(a);a=a[1..])
    ans += ({ ({ a[0], 0 }) });
  polls[q][VOTE_ANSWERS]=ans;
  save_info();
  return 1;
}

public int entferne(int q,object who) {
  if (q<0 || q>=sizeof(polls)) return 0;
  if ((string)polls[q][VOTE_INITIATOR]!=getuid(who) && !this_interactive() &&
     !IS_ARCH(this_interactive()))
    return -1;
  write_result(polls[q],who);
  polls -= ({ polls[q] });
  save_info();
  return 1;
}

public string hilfe(int l1, int l2, int dummy) {
  return "Statistisches Amt des Wunderlands, Meinungserhebung\n"+
    "---------------------------------------------------\n\n"+
    "Diese Wahlurne kennt folgende Befehle:\n"+
    "zeige ( f[ragen] | e[rgebnisse] | l[iste] )\n"+
    "  Zeigt entweder die gestellten Fragen, die vorlaeufigen Ergebnisse,\n"+
    "  oder beides (liste) an.\n"+
    "waehle <nr> ( ja | nein | ent )\n"+
    "  Waehlt die entsprechende Angabe fuer die Frage Nr. <nr>. Dieser Befehl\n"+
    "  funktioniert erst ab Level "+l1+".\n"+
    "erhebe <fragetext>\n"+
    "  Stellt die im Fragetext enthaltene Frage (als neue Erhebung). Diese\n"+
    "  Erhebung bleibt "+EXPDAYS+" Tage zur Antwort freigegeben.\n"+
    "  Dieser Befehl funktioniert erst ab Level "+l2+".\n"+
    "antworten <nr> <antwort> [{ <antwort> }]\n"+
    "  Sieht die als String angegebenen Antworten anstelle der Standard-\n"+
    "  antworten JA, NEIN und ENT vor. Beispiel: \"antworten 1 gruen rot blau\"\n"+
    "  stellt die moeglichen Antworten GRUEN, ROT und BLAU zur Verfuegung.\n"+
    "  Dieser Befehl kann nur von einem Erzmagier oder dem Fragesteller\n"+
    "  ausgefuehrt werden.\n"+
    "entferne <nr>\n"+
    "  Entfernt die Frage mit der Nr. <nr> aus der Abstimmung. Dies kann nur\n"+
    "  ein Erzmagier oder der Fragesteller tun.\n"+
    "hilfe urne\n"+
    "  Zeigt diesen Text an.\n\n"+
    "Die endgueltigen Abstimmungsergebnisse werden getrennt veroeffentlicht.\n"+
    "     Der Beirat des Instituts.\n";
}

private string answerstring(mixed *res) {
  int i;
  string *s;
  for (s=({}),i=0;i<sizeof(res[VOTE_ANSWERS]);i++) {
    s+=({ ((string)res[VOTE_ANSWERS][i][0])+": "+
	    to_string((int)res[VOTE_ANSWERS][i][1]) });
  }
  return "/std/player/soul"->CountUp(s);
}

private varargs void write_result(mixed *res,object del) {
  if(!res || !pointerp(res) || sizeof(res)<4) return;
  log_file(LOGS,
	   dtime(time())+" "+capitalize((string)res[VOTE_INITIATOR])+": "+
	   ((string)res[VOTE_QUESTION])+"\n   "+answerstring(res)+
	   (del ? " GELOESCHT von "+capitalize(getuid(del))+".\n" : ".\n"));
  if (!del) {
    mixed* mess;
    mess=allocate(7);
    mess[M_BOARD]="bekanntmachungen";
    mess[M_REFERENCE]="";
    mess[M_WRITER]="Statistisches Amt";
    mess[M_TITLE]="Wahlergebnis";
    mess[M_MESSAGE]=break_string("Das Statistische Amt des Wunderlands gibt"
      " bekannt:\n\nDie von "+capitalize(res[VOTE_INITIATOR])+" am "+
      dtime(res[VOTE_EXPIRE]-EXPDAYS*86400)[5..16]+" zur Abstimmung "
      "gestellte Frage mit dem Wortlaut\n'"+capitalize(res[VOTE_QUESTION])+
      "'\nerlangte nach "+EXPDAYS+" Abstimmungstagen das Ergebnis:\n\n"+
      answer(res));
    "/secure/news"->WriteNote(mess);
  }
}
