/*******************
** Eldarea MUDLib **
********************
**
** global/service/sound.c
**
** CVS DATA
** $Date: 2000/08/04 10:55:45 $
** $Revision: 1.1 $
**
** mud sound protocol
** sound control module
**
** CVS History
**
** $Log: sound.c,v $
** Revision 1.1  2000/08/04 10:55:45  eldarea
** mud sound protocol implemented
**
**
**
*/

#define NEED_SOUND_PROTO
#include <sound.h>
#include <wizlevels.h>

#pragma strict_types

static string * sounddb, * musicdb;

void create()
{
  if (clonep(this_object()))  
  {
    destruct(this_object());
    return;
  }
  UpdateSoundDB();
}

int UpdateSoundDB()
{
  int i,j,a;
  string * lista, *listb;
  
  if (!previous_object() || !IS_LORD(previous_object()))
    return 0;
  
  sounddb=({});  
  musicdb=({});
  write("Updating Sound Database...\n");
  if (file_size(DATADIR)!=-2)
  {
    write("*** ERROR: datadir "+DATADIR+" not found.\n");  
    return 0;
  }
  if (file_size(SOUNDDIR)!=-2)
  {
    write("*** ERROR: sounddir "+SOUNDDIR+" not found.\n");  
  }
  else
  {
    write("Reading sound directory...\n");
    a=0;
    for (i=sizeof(lista=get_dir(SOUNDDIR"/*")-({".",".."}));i-->0;)
    {
      switch (file_size(SOUNDDIR"/"+lista[i]))
      {
        case -2:
          write("Reading sound subdirectory "+lista[i]+"...\n");
          for (j=sizeof(listb=get_dir(SOUNDDIR"/"+lista[i]+"/*")-({".",".."}));j-->0;)
          {
            if (file_size(SOUNDDIR"/"+lista[i]+"/"+listb[i])<1)
              write("*** ERROR: invalid file in "+SOUNDDIR"/"
                    +lista[i]+": "+listb[i]+".\n");
            else
             if (lista[i][0]!='.')
             {
               sounddb+=({lista[i]+"/"+listb[i]});
               a++;
             }
          }
        case -1..0:
          write("*** ERROR: invalid file in "+SOUNDDIR+": "+lista[i]+".\n");
          break;
        default:  
          if (lista[i][0]!='.')
          {
            sounddb+=({lista[i]});
            a++;
          }
      }  
    }
    write(a+" sound files added to db.\n");
  }
  if (file_size(MUSICDIR)!=-2)
  {
    write("*** ERROR: musicdir "+MUSICDIR+" not found.\n");
  }
  else
  {
    write("Reading music directory...\n");
    a=0;
    for (i=sizeof(lista=get_dir(MUSICDIR"/*")-({".",".."}));i-->0;)
    {
      switch (file_size(MUSICDIR"/"+lista[i]))
      {
        case -2:
          write("Reading music subdirectory "+lista[i]+"...\n");
          for (j=sizeof(listb=get_dir(MUSICDIR"/"+lista[i]+"/*")-({".",".."}));j-->0;)
          {
            if (file_size(MUSICDIR"/"+lista[i]+"/"+listb[i])<1)
              write("*** ERROR: invalid file in "+MUSICDIR"/"
                    +lista[i]+": "+listb[i]+".\n");
            else
             if (lista[i][0]!='.')
             {
               musicdb+=({lista[i]+"/"+listb[i]});
               a++;
             }
          }
        case -1..0:
          write("*** ERROR: invalid file in "+MUSICDIR+": "+lista[i]+".\n");
          break;
        default:  
          if (lista[i][0]!='.')
          {
            musicdb+=({lista[i]});
            a++;
          }
      }  
    }
    write(a+" music files added to db.\n");    
  }
  write("...updated. Sound Database ready.\n");
  return 1;
}

string valid_sound(string file)
{
  string * efile;
  
  if (!file || file="")
    return 0;
    
  if (file[0]=='/')
    file=file[1..];
    
  if (sizeof(efile=explode(file,"/"))>2)
    file=implode(efile[<2..<1],"/");
    
  if (member(sounddb,file)==member(musicdb,file)==-1)
    return 0;
    
  return file;
}

string QuerySendStats(string file)
{
  return "";  
}