/*******************
** Eldarea MUDLib **
********************
**
** global/service/werliste.c  - erstellt die Anwesenheitsliste
**
** CVS DATA
** $Date: 2001/05/06 13:16:22 $
** $Revision: 1.6 $
**
** longdesc
**
** CVS History
**
** $Log: werliste.c,v $
** Revision 1.6  2001/05/06 13:16:22  elatar
** changed statistics path
**
** Revision 1.5  2001/02/06 08:55:34  elatar
** applied strong_types requirements
**
** Revision 1.4  2000/12/01 15:32:04  elatar
** adapted to new statistics files/format, changed output format slightly
**
** Revision 1.3  2000/01/17 18:08:09  elatar
** new layout and behaviour change
**
** Revision 1.2  1999/11/25 11:38:35  elatar
** who request ascii in /etc/welcome/who
**
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/

#include <properties.h>
#include <wizlevels.h>
#include <ansi.h>
#include <udp.h>
#include <defines.h>
#include <config.h>

// Interne Flags
#define SHORT    1
#define HELP     2
#define ALPHA    4

#define STROKE_LINE "--------------------------------------------------------------------"
#define CONNECT_INFO sprintf("%s Port %d %s",MUD_IP,MUD_PORT,STROKE_LINE)

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")

static int no_city_name;

private static string MudHead(int intermud);
private static string MudFoot(int num, int intermud);
private static int is_greater(object a,object b);
private static int is_a_greater(object a,object b);
private static string where(object ob);
private static string level_char(object ob);
private static string query_uinfo(object pl, int ist_magier);
private static string QueryView(object ob,int ist_magier);
varargs string QueryWhoListe(int ist_magier,int intermud, int arg);
string QueryShortWhoListe(int ist_magier, int arg, int inter);
mixed QueryWWWListe(int ist_magier);

// Folgende Funktion wertet die Argumente aus und gibt entsprechende
// Listen zurueck. Bei Bedarf wird eine UDP-Anfrage abgesandt.
public string QueryListe(int mag, int inter, string str) {
  string* flags, *unknown;
  int i, j, k, flag, hashflag, tested;
  if (!str || str=="") return QueryWhoListe(mag, inter);
  flags=explode(lower_case(str), " ");
  hashflag=1;
  unknown=({});
  j=sizeof(flags);
  for (i=0; i<j; i++) {
    while (flags[i][0]==' ') flags[i]=flags[i][1..];
    if (flags[i]=="") continue;
    if (hashflag && flags[i][0]=='-') {
      switch (flags[i][1..]) {

        // Hier Langformen der Switches:
        case "kurz": flag|=SHORT; break;
        case "alpha": flag|=ALPHA; break;

        // Hier Kurzformen:
        default:
          k=0;
          if (member(flags[i], 'k')>-1) { flag|=SHORT; k=1; }
          if (member(flags[i], 'l')>-1) { flag|=HELP; k=1; }
          if (member(flags[i], 'a')>-1) { flag|=ALPHA; k=1; }
          if (!k) unknown+=({ flags[i] });
      }
    } else {
      switch (flags[i]) {

        // Hier '-'lose Argumente:
        case "kurz":
        case "short":        flag|=SHORT; break;
        case "alphabetisch":
        case "alpha":        flag|=ALPHA; break;
        case "legende":      flag|=HELP; break;

        // Hier Abfrage auf UDP-who
        default: if (!inter && !tested) {
            hashflag=0; // Argument ohne '-' beendet Switch-Scan
            tested=1;
            if (sizeof("/secure/inetd"->expand_mud_name(flags[i]))) {
              str=INETD->send_udp(flags[i],
                ([ REQUEST: "who", SENDER: getuid(this_interactive()),
                   DATA: implode(flags[0..i-1]+flags[i+1..], " ") ]), 1);
              if (str) return str;
              return "Anfrage abgeschickt.\n";
            }
            return "'"+capitalize(flags[i])+"' ist kein bekanntes Mud.\n";
          } else unknown+=({ flags[i] });
      }
    }
  }
  if (sizeof(unknown))
    str="Folgende Flags wurden ignoriert: "+implode(unknown," ")+"\n";
  else str="";
  if (flag&1) return QueryShortWhoListe(mag, flag, inter)+str;
  return QueryWhoListe(mag, inter, flag)+str;
}

/****************************************************************************
 * Funktion: varargs string QueryWhoListe(int ist_magier, int intermud);    *
 * Argumente: ist_magier: 0 Spieler ist kein Magier, sonst <>0              *
 *            intermud: 0 wer-Liste innerhalb des WL, sonst <>0             *
 * Beschreibung: Die Funktion liefert die (ausfuehrliche) Anwesenheitsliste *
 *               der Spieler. Dabei erhalten Magier, durch den Wert von     *
 *               'ist_magier' == 1 auch unsichtbare Magier. Der Wert von    *
 *               'intermud' liefert das Aussehen der Liste innerhalb des    *
 *               WL (==0) oder die des Intermud-Who (<>0).                  *
 ****************************************************************************/
varargs string QueryWhoListe(int ist_magier,int intermud, int arg) {
  int num, i;
  object *pl;
  string pls,*spieler;

  pl=users();
  if(arg&ALPHA)
    pl=sort_array(pl, #'is_a_greater);
  else
    pl=sort_array(pl,#'is_greater);
  spieler = map_array(pl,#'QueryView,ist_magier)-({""});
  num=sizeof(spieler);
  pls = MudHead(intermud);
  pls+= (num?implode(spieler,"\n"):"|                Zur Zeit ist niemand sichtbares anwesend.                |")+"\n";
  pls+= MudFoot(num, intermud);
  return pls;
}

/******************************************************************************
 * Funktion: string QueryShortWhoListe(int ist_magier, string arg);           *
 * Argument: ist_magier: 0 Spieler ist kein Magier, sonst <>0.                *
 *           arg: Angegebene Switches                                         *
 *           inter: 1 bei intermud anfrage                                    *
 * Beschreibung: Die Funktion liefert die (kurze) Anwesenheitsliste der       *
 *               Spieler. Dabei bekommen Magier durch den Wert 'ist_magier'   *
 *               von <>0 auch unsichtbare Magier angezeigt.                   *
 ******************************************************************************/
string QueryShortWhoListe(int ist_magier, int arg, int inter) {
  object *pl;
  string ret;
  int i,j,size;

  pl = users();
  if (arg&ALPHA) pl = sort_array(pl,#'is_a_greater);
  else pl = sort_array(pl,#'is_greater);
  size = sizeof(pl);
  j = 0;
  ret="";
  for (i=0;i<size;i++) {
    ret += query_uinfo(pl[i], ist_magier);
    j++;
    if ((j%3==0 && i!=size-1) || (j%3!=0 && i==size-1) || (j%3==0))
      ret += "\n"+(inter?"":" ");
  }
  if (inter)
  {
    ret=sprintf(
         "\n+-- Eldarea LPMud -- %52:52s-+\n\n"
         "%s"
         "\n+-------------------------------------------------------------------------+\n"
         ,CONNECT_INFO,ret);
    if (!j) ret+="Zur Zeit ist gerade niemand sichtbares anwesend.\n";
  }
  else
  {
    if (j)
      ret = sprintf(
              " Anwesenheitsliste von %s (%d Anwesende%s)\n\n %s"
              ,dtime(time()),j,(j==1)?"r":"",ret);
    else
      ret = sprintf(" Anwesenheitsliste von %s\n\n %s"
                   ,dtime(time()),ret);
  }
  if (arg&HELP)
    ret += "----------------------------------------------------------------------------\n"
      " Stufe: s    .. Spieler\n"
      "        t    .. Testspieler\n"
      "        1..9 .. Avatar des entsprechenden Kreises\n"
      " Flags: ' .. leicht idle      p .. Mail schreibend  e .. editierend\n"
      "        i .. idle             w .. weg              k .. m/e mit Kobold\n"
      "        I .. lange idle       z .. Zeitung lesend   m .. lesend\n";
  return ret;
}

/*************************************************************************
 * Funktion: mixed QueryWWWListe(int ist_magier);                        *
 * Argumente: ist_magier: 0 Spieler ist kein Magier, sonst <>0           *
 * Beschreibung: Die Funktion liefert die (ausfuehrliche)                *
 *     Anwesenheitsliste der Spieler fuer /secure/udp/www.who.c, jedoch  *
 *     ohne Kopf und Fusszeile.                                          *
 *     Durch Angabe von ist_magier ist theorethisch auch die Anzeige     *
 *     von unsichtbaren Magiern moeglich.                                *
 *     Format des Arrays:                                                *
 *     ({ ({ object spieler1, string ( [Rang] short [Stadt] ) }),        *
 *        ({ object spieler2, string ( [Rang] short [Stadt] ) }),        *
 *        ({ ... }), usw...})                                            *
 *************************************************************************/		       
mixed QueryWWWListe(int ist_magier) {
    int i;
    string spieler, s2;
    object *usr;
    mixed *who;

    who = ({});
    usr = users();
    usr = sort_array(usr,#'is_greater);
    for(i=0;i<sizeof(usr);i++) {
        if((spieler=QueryView(usr[i], ist_magier))!="")
	    who += ({({usr[i],spieler[2..<3]})});
    }
    return who;
}
		       
		       
		       
		       
		       
// Hilfsfunktionen

private static string QueryView(object ob,int ist_magier)
{
  string woher, wer, *tmpliste, sh;
  int i, j, laenge;

  if (no_city_name) woher = " |";
  else woher = "["+where(ob)+"] |";
  if (ob->QueryProp(P_INVIS)) {
    if (ist_magier) wer = "("+capitalize(getuid(ob))+")";
    else return "";
  } else {
    wer=capitalize(stringp(sh = ob->short()) ? sh : "<Einloggender Teilnehmer>  ");
    if (!wer) wer="("+capitalize(getuid(ob))+": short() returnd NULL)   ";
    else wer=sprintf("%s", wer[0..<3]);
  }
  // '\n' entfernen
  wer=regreplace(wer,"\n","",1);
  // '\b' und das Zeichen davor aus String entfernen
  tmpliste = regexplode(wer,"\b\b*");
  i=sizeof(tmpliste);
  wer=tmpliste[0];
  for (j=1; j<i; j+=2) wer=wer[0..<strlen(tmpliste[j]+1)]+tmpliste[j+1];
  // Stringlaenge anpassen
  laenge=BS_STDLEN-9-strlen(wer)-strlen(woher);
  if (laenge<0) {
    wer=wer[0..<(-laenge+1)];
    laenge=0;
  }
  laenge+=strlen(woher);
  return sprintf("| [%s] %s %*s",level_char(ob),wer,laenge,woher);
}

private static string query_uinfo(object pl, int ist_magier) {
  int edit, idles,away, invis;
  object ob;
  string str;

  if ((invis = (pl->QueryProp(P_INVIS))) && !ist_magier) return "";

  if (query_editing(pl)) 
  {
    if (pl->QueryProp(P_BUFFER)) 
      edit='k';
    else 
      edit='e';
  } 
  else if (ob=query_input_pending(pl)) 
  {
    if (ob->id("zeitung"))
      edit='z';
    else if (ob->id("mailer"))
      edit='p';
    else if (pl->QueryProp(P_BUFFER)) 
      edit='k';
    else if (ob->query_nedit_user()==pl) 
      edit='e';
    else 
      edit='m';
  } 
  else 
    edit='.';

  if (pl->QueryProp(P_AWAY)) 
    away = 'w';
  else 
    away = '.';

  if (query_idle(pl)>60) 
    idles = query_idle(pl)>600 ? 
      query_idle(pl)>1800 ? 'I' : 'i' : ''';
  else 
    idles='.';

  str=pl->QueryProp(P_NAME);
  if (!str) 
    str="(Login)";
  else if (lower_case(str)!=getuid(pl)) 
    str=capitalize(getuid(pl));
  return sprintf("%'.'-17s.%c%c%c[%s]  ",
    invis ? "("+str+")" : str,idles,away,edit, level_char(pl)); }

private static int is_greater(object a,object b)
{
  int a1,b1;
  if ((a1=query_wiz_level(a))==(b1=query_wiz_level(b)))
    if (a1>1 && b1>1)
      return getuid(a)>getuid(b);
    else
      if ((a1=a->QueryProp(P_LEVEL))==(b1=b->QueryProp(P_LEVEL)))
        return getuid(a)>getuid(b);
    else
      return a1>b1;
  else
    return a1>b1;
}

private static int is_a_greater(object a, object b)
{
  return getuid(a)>getuid(b);
}

private static string where(object ob)
{
  if (objectp(ob))
    return country(ob);
}

private static string level_char(object ob) {
  if (ob->QueryProp(P_TESTPLAYER))
    return "t";
  if (IS_LEARNER(ob))
    return sprintf("%1d",11-query_wiz_level(ob));
  return "s";
}


// Liefert den Kopf der Spielerliste, in Abhaengigkeit von 'inter'
// Bei 'inter' zusaetzlicher Kopf ueber der Liste
private static string MudHead(int inter) {
  string s1, s2, term, liste, *files;
  mixed ftmp;
  int t, tmp, maxlen;
  s1 = s2 = liste = "";

  if (inter) {
    files = get_dir("/etc/welcome/who/*")-({".", "..", "", 0});
    if (sizeof(files))
    {
      ftmp = efun::explode(
        read_file("/etc/welcome/"+files[random(sizeof(files))]), "\n");
      maxlen = strlen(sort_array(ftmp-({""}), lambda(({'x, 'y}),
         ({#'?, ({#'>, ({#'strlen, 'x}), ({#'strlen, 'y}) }),
           'x, 'y})))[0]);

      liste += efun::implode(map_array(ftmp, lambda(({'x, 'len}),
        ({#'sprintf, "%' '*s%s", 'len, "", 'x})), (BS_STDLEN-maxlen)/2),
        "\n")+"\n";
    }
  }
  if(this_player()) {
    term = this_player()->QueryProp(P_TTY);
    if(term == "vt100" || term == "ansi") {
      s1 = ANSI_BOLD; s2 = ANSI_NORMAL; 
    }
  }
  if (inter)
    liste+= sprintf(
      "\n"
      "+-- Eldarea LPMud -- %52:52s-+\n"
      "| Uptime: %60-s    |\n"
      "|                                                                         |\n"
      ,CONNECT_INFO,implode(explode(uptime(),", ")[0..1]," und ") );
   else
    liste+=sprintf(
      "\n"
      "+-- Liste der Anwesenden vom %20s -----------------+\n"
      "|                                                                         |\n"
      ,dtime(time()));
  return liste;
}

// Liefert den Fuss der Spielerliste
// 'intermud' macht keinen Unterschied mehr (alles gleich)
private static string MudFoot(int num, int intermud) 
{
  int chars, * stats;
  string tmp;

  stats = SERVICE->QueryStatistics();
  
  chars=(num<100)+(num<10)+(stats[3]<100)+(stats[3]<10)+(stats[4]<100)+(stats[4]<10); 

  return sprintf(
    "|                                                                         |\n"
    "+--------------------%s%s %d Anwesende%s, heutiges Maximum %d, Rekord: %d --+\n"
    ,num==1?"":"-","------"[0..chars-1], num,num==1?"r":"", stats[3], stats[4]);
}

int SetCityName(int i) { return no_city_name=i; }
