/*******************
** Eldarea MUDLib **
********************
**
** /mail/mailer.c - das Mail-Objekt
**
** CVS DATA
** $Date: 2001/02/05 23:27:21 $
** $Revision: 1.3 $
**
** Author: Loco. Unter Verwendung des std/post-codes von Jof
**
** CVS History
**
** $Log: mailer.c,v $
** Revision 1.3  2001/02/05 23:27:21  elatar
** applied strong_types requirements
**
** Revision 1.2  2000/08/02 09:17:14  eldarea
** mail system revision
**
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/

inherit "std/thing";

#include "post.h"
inherit NEDIT;

#include <properties.h>
#include <config.h>
#include <mail.h>
#include <wizlevels.h>
#include <moving.h>

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),x+"\n")
#define SAVE_OPEN(x) "/open/mail/"+getuid(x)+".mail"

static mixed process_names(mixed s);
static int input();
static varargs string * send_mail(mixed back);
varargs int do_mail(mixed str);
static void update();
static mapping Read_mailrc(string file);
static void ListContent();
static void ChangeFolder(mixed x);
static void ListFolders();
static string MakeFolder(string s);
static int RemoveFolder(mixed x);
static int DeleteMessage(int x);
static int MoveMessage(int msg,string fol);
static varargs int Reply(int nr,int group);
static varargs int Forward(mixed to,int nr,int appendflag);
static int ReadMessage(int nr);
static int SaveMessage(int nr);
static void ListAliases();
static string Message2string(int nr);

static string subject, message, receiver, sender, * carbon;
static string name, message, office_name;
static int done, akt_folder, i, akt_nr, directflag, filesize;
static mapping aliases;

mixed *folders;


void create() {
  (::create());
  seteuid(getuid());
  SetProp(P_IDS,({"mailer"}));
  SetProp(P_NAME,"mailer");
  office_name="Mailmenue";
  akt_folder=-1;
  SetProp(P_NODROP,1);
} 


void init() {
  (::init());
  init_rescue();
}


void reset() {
  object pl;
  (::reset());
  if (!name) {remove(); return;}
  pl=find_player(name);
  if (!pl || environment()!=pl) {remove(); return;}
  if (nedittext && !query_input_pending(pl)) {
    tell_object(pl,
      "*** Ihr habt einen noch nicht fertiggeschriebenen Brief!\n"
      "*** Mit ~r koennt Ihr weiterschreiben.\n");
    return;
  }
  if (query_input_pending(pl)!=this_object())
    remove();
    return;
}


string SetOfficeName(string n) {
  return office_name=n;
}


static varargs int write_mail(mixed str, string std_subject) {
  string str2;
  
  carbon=process_names(str);
  if (!sizeof(carbon)) {
    write("Kein Empfaenger angegeben!\n");
    return input();
  }
  write("Empfaenger: "+implode(carbon,",")+"\n");
  str=carbon[0];
  if (sizeof(carbon)>=2) carbon=carbon[1..<1];
  else carbon=0;
  if ((str2=str) && str2!="" && str2[0]=='\\') str2=str2[1..];
  if (!str || (file_size("/"+SAVEPATH+str2[0..0]+"/"+str2+".o")<=0 
	              && member(str2,'@')==-1)) {
    write("WEM wollt Ihr schreiben ?\n");
    return input();
  }
  receiver=str;
  write("Titel");
  if (std_subject) write(" ("+std_subject+")");
  write(": ");
  subject=std_subject;
  input_to("get_subject");
  return 1;
}


static varargs int get_subject(string str,string pretext) {
  if (str && str!="") subject=str;
  write("Bitte gebt jetzt Eure Nachricht an:\n\
** oder . wenn fertig, ~q fuer Abbruch, ~h fuer eine Hilfsseite\n");
  nedit("SendMail",pretext);
  return 1;
}


static int SendMail(string text) {
  if (!text) {
    write("Abbruch !\n");
    return input();
  }
  message=text;
  write("Cc: ");
  input_to("get_carbon_copy");
  return 1;
}


static int get_carbon_copy(string str) {	
  int i;
  object p;
  string *oldcarbons;
  
  oldcarbons=carbon;
  if(!str || str=="") carbon=0;
  else carbon=process_names(str);

  // Q Sonderbehandlung... (Danke Bongo!!)
  if(pointerp(carbon) &&
    (member_array("q",carbon)>-1 || member_array("Q",carbon)>-1)) {
    write("Der Spieler 'Q' darf nicht bei Cc: angegeben werden!\n"); 
    carbon-=({"q","Q"});
  }

  carbon=(oldcarbons ? oldcarbons : ({}))+(carbon ? carbon : ({}));
  /*  if (!sizeof(carbon)) carbon=0; */
  oldcarbons=({receiver})+carbon;
  carbon=send_mail();
  if (!pointerp(carbon) || !sizeof(carbon)){
    write("Brief NICHT verschickt !\n");
  } else {
    for (i=0;i<sizeof(carbon);i++){
      /* evtl. abfragen nach query_editing und/oder query_input_to */
      if (p=find_player(carbon[i])) 
	tell_object(p,"Ihr habt soeben eine neue Mail erhalten.\n");
    }
    write("Abgesandt an: "+implode(map_array(carbon,#'capitalize),", ")+"\n");
    for (i=sizeof(oldcarbons)-1;i>=0;i--)
      if (oldcarbons[i][0]=='\\')
        oldcarbons[i]=oldcarbons[i][1..];
    oldcarbons=oldcarbons-carbon;
    if (sizeof(oldcarbons)) {
      write("Empfaenger unbekannt: "+implode(map_array(oldcarbons,#'capitalize),", ")+"\nMail zurueckgeschickt.\n");
      send_mail(oldcarbons);
    }
  }
  message=receiver=carbon=subject=0;
  if (directflag) {
    remove();
    return 1;
  }
  update();
  return input();
}

static varargs string * send_mail(mixed back) {
  mixed *mail;
  
  mail=allocate(9);

#ifdef DEBUG
  DEBUGVAR(receiver);
  DEBUGVAR(carbon);
#endif

  if (!pointerp(carbon) || !sizeof(carbon)) carbon=0;
  mail[MSG_FROM]=getuid(this_player());
  mail[MSG_SENDER]=office_name;
  mail[MSG_RECIPIENT]=(back ? mail[MSG_FROM] : receiver);
  mail[MSG_CC]=(back ? 0 : carbon);
  mail[MSG_BCC]=0;
  mail[MSG_SUBJECT]=(back ? "Zurueck! Empfaenger unbekannt: "+implode(back,", ") : subject);
  mail[MSG_DATE]=ctime(time());
  mail[MSG_ID]=MUDNAME+time();
  mail[MSG_BODY]=message;
  return "/secure/mailer"->DeliverMail(mail,1);
}

varargs int do_mail(mixed str) 
{
  if (name) 
    return 0; /* security flag ;-) */
  if (!this_interactive()) 
    return 0;
  name=geteuid(this_interactive());
  move(this_interactive());
  aliases=Read_mailrc(ALIASFILE(name))+Read_mailrc(SYSALIAS);
  if (!name) 
    remove();
  update();
//  akt_folder=member_array("newmail",folders[0]);
//  if (akt_folder==-1) akt_folder=0;
  if (str) {
    directflag=1;
    return write_mail(str);
  }
  if (!pointerp(folders) || sizeof(folders)!=2 || sizeof(folders[0])==0) {
    write("Ihr habt momentan keine Mail.\n");
    folders=({({}),({})});
  }
  ListFolders();
  ListContent();
  return input();
}


static int MediumHelpPage() {
  if (sizeof(folders[0])) 
    write("Aktueller Ordner:\t"+folders[0][akt_folder]+"\n");
  write("\n\
Mail <nr> lesen                     '<nr>'              (lies <nr>)\n\
Aktuelle (->) / naechste Mail       '.' / '+'\n\
Mail schreiben                      'm <name>'          (schreibe)\n\
Mail beantworten                    'r [nr]'            (beantworte)\n\
Gruppenantwort                      'g [nr]'            (gruppe)\n\
Mail loeschen                       'd [nr]'            (loesche)\n\
Mail weitersenden                   'f [nr] <name>'     (weiter)\n\
Weitersenden plus eigenen Text      'F [nr] <name>'     (Weiter)\n\
Mail in anderen Ordner verschieben  'v [nr] <ordner>'   (verschiebe)\n\
Mails in diesem Ordner listen       'l' (oder nix)      (anzeigen)\n\
Aktuellen Ordner wechseln           'c <ordner>'        (oeffne)\n\
Neuen Ordner anlegen                'n <ordner>'        (erzeuge)\n\
Leeren Ordner loeschen              'e <ordner>'        (entferne)\n\
Alle Ordner anzeigen                'i'                 (ordner)\n\
"+ (IS_WIZARD(this_player()) ? "\
Mail speichern in Datei             's [nr]'            (speichere)\n\
  "+SAVEFILENAME+"\n" : "")+ "\
Mailaliase anzeigen                 'a'                 (aliase)\n\
Verfuegbare Kommandos zeigen        '?' oder 'h'\n\
Mailmenue verlassen                 'q'\n\
Kommando <cmd> ausfuehren           '!<cmd>'\n\
Bei der Langform reicht es, die ersten 4 Zeichen eines Kommandos anzugeben.\n\
\n");
  return input();
}


static void update() {
  int i,j,newletters;
  mixed *ignored;

  if (akt_nr<1) akt_nr=1;
  if (!restore_object("/"+MAILPATH+name[0..0]+"/"+name)) folders=({({}),({})});
  filesize = file_size("/"+MAILPATH+name[0..0]+"/"+name+".o");
  if (!pointerp(folders) || sizeof(folders)!=2) folders=({({}),({})});

//DEBUGVAR(folders[0]);

  if (akt_folder>=sizeof(folders[0]) || akt_folder<0) {
    akt_folder=member_array("newmail",folders[0]);
    if (member_array("newmail",folders[0])==-1) {
      "/secure/mailer"->MakeFolder("newmail",name);
      if (!restore_object("/"+MAILPATH+name[0..0]+"/"+name)) folders=({({}),({})});
      filesize = file_size("/"+MAILPATH+name[0..0]+"/"+name+".o");
      akt_folder=member_array("newmail",folders[0]);
    }
    if (akt_folder!=-1) write("Ordner 'newmail' aufgeschlagen.\n");
  }

//  if (!pointerp(folders)) return write("ERROR: folders no array in update\n"); // Kann eigentlich nicht vorkommen
  if (sizeof(folders[0]) && akt_nr>sizeof(folders[1][akt_folder]))
    akt_nr=sizeof(folders[1][akt_folder]);
  j=member_array("unread",folders[0]);
  if (j==-1) return;
  newletters=0;
  while (j != -1 && pointerp(folders[1][j]) && sizeof(folders[1][j])>0) {
    if (pointerp(ignored=this_player()->QueryProp(P_IGNORE)) &&
		member(ignored, lower_case(folders[1][j][0][MSG_FROM]+".mail"))>=0) {
      mixed msg;
      msg=folders[1][j][0];
      write("Du laesst einen Brief von "+capitalize(msg[MSG_FROM])+
	    " unbesehen zurueckgehen.\n");
      msg[MSG_BODY]=this_player()->name()+" hat diesen Brief ungeoeffnet an Dich zurueckgehen lassen\n\
und moechte nicht mehr von Deinen Briefen belaestigt werden.\n\
------ Inhalt: ------------------------\n"+
  msg[MSG_BODY];
      msg[MSG_RECIPIENT]=msg[MSG_FROM];
      msg[MSG_SUBJECT]="Annahme verweigert - zurueck an Absender";
      msg[MSG_CC]=0;
      msg[MSG_BCC]=0;
      MAILDEMON->DeliverMail(msg,1);
      if (find_player(msg[MSG_RECIPIENT]))
	tell_object(find_player(msg[MSG_RECIPIENT]),
		    "Ein Postreiter ruft Dir aus einiger Entfernung leicht sauer zu, dass er einen\nzurueckgekommenen Brief fuer Dich hat.\n");
      MAILDEMON->RemoveMsg(0,j,name);
    } else {
      "/secure/mailer"->MoveMsg(0, j, "newmail", name);
      newletters++;
    }
    if (!restore_object("/"+MAILPATH+name[0..0]+"/"+name)) folders=({({}),({})});
    filesize = file_size("/"+MAILPATH+name[0..0]+"/"+name+".o");
    j=member_array("unread",folders[0]);
  }
  "/secure/mailer"->RemoveFolder("unread",name);
  if (newletters) {
    write("Ihr habt "+
   ((newletters==1) ? "eine neue Mail" : newletters+" neue Mails")
   +".\n");
  }
//  if (!restore_object("/"+MAILPATH+name[0..0]+"/"+name)) folders=({({}),({})}); // kann nicht vorkommen
}

static void ListContent() {
  int i;
  if (!pointerp(folders)||sizeof(folders)!=2||
      !pointerp(folders[0])||!sizeof(folders[0])) {
    write("Keine Ordner !\n");
    return;
  }
  if (!pointerp(folders[1]) || akt_folder>=sizeof(folders[1]) || 
      !pointerp(folders[1][akt_folder])) {
    write("Keine Mails in diesem Ordner !\n");
    return;
  }
  write(folders[0][akt_folder]+": "+sizeof(folders[1][akt_folder])+" Mail");
  if (sizeof(folders[1][akt_folder])!=1)
    write("s\n");
  else
    write("\n");

  for (i=0;i<sizeof(folders[1][akt_folder]);i++){
    write(((i+1==akt_nr) ? "->" : "  ")+
	  sprintf("%3d: (%12s, %s) ",i+1,capitalize(
		folders[1][akt_folder][i][MSG_FROM] ? 
		folders[1][akt_folder][i][MSG_FROM] : "Unbekannt"),
		  folders[1][akt_folder][i][MSG_DATE][5..11])+
	  folders[1][akt_folder][i][MSG_SUBJECT]+"\n");
  }
  if (filesize>=0)
    printf("Euer Postfach hat eine Groesse von %O KBytes.\n",
       (filesize/100)/10.);
  return;
}

static void ChangeFolder(mixed x) {
  if (stringp(x)) x=member_array(x,folders[0]);
  if (x<0 || x>=sizeof(folders[0])) {
    write("Kein solcher Ordner.\n");
    return;
  }
  akt_folder=x;
  write("Ihr oeffnet den Ordner '"+folders[0][x]+"'.\n");
}

static void ListFolders() {
  int i;
  write(sizeof(folders[0])+" Ordner:\n");
  for (i=0;i<sizeof(folders[0]);i++)
    write(sprintf("%2d: %-20s(%3d Mails)\n",i+1,folders[0][i],sizeof(folders[1][i])));
}

static string MakeFolder(string s) {
  int ret;
  ret="/secure/mailer"->MakeFolder(s, name);
  if (ret==1) write("Ok.\n");
  else write("Ordner existiert bereits.\n");
  return s;
}

static int RemoveFolder(mixed x) {
  int ret;
  if (intp(x)) x=folders[0][x];
  ret="/secure/mailer"->RemoveFolder(x, name);
  switch (ret) {
  case 1: write("Ok.\n"); break;
  case -1: write("Kein solcher Ordner.\n"); break;
  case 0: write("Ordner nicht leer.\n"); break;
  default: write("Fehler Nummer "+ret+"!\n"); break;
  }
  update();
  return ret;
}

static int DeleteMessage(int x) {
  int ret;
  if (x<0) {
    write("Bitte Nummer der zu loeschenden Mail angeben!\n");
    return 0;
  }
  ret="/secure/mailer"->RemoveMsg(x, akt_folder, name);
  switch(ret) {
  case 1: write("Ok.\n"); break;
  case 0: write("Keine solche Mail im aktuellen Ordner.\n"); break;
  case -1:write("Kein aktueller Ordner.\n"); break;
  default: write("Fehler Nummer "+ret+"!\n"); break;
  }
  update();
  return ret;
}

static int MoveMessage(int msg,string fol) {
  int ret;
  ret="/secure/mailer"->MoveMsg(msg, akt_folder, fol, name);
  if (!ret) {
    write("So viele Mails sind nicht im aktuellen Ordner.\n");
    return ret;
  }
  if (ret==-1) {
    write("Kein aktueller Ordner.\n");
    return ret;
  }
  if (ret==-3){
    write("Zielordner nicht gefunden!\n");
    return ret;
  }
  write((msg+1)+" -> "+fol+": Ok.\n");
  while (akt_nr>=sizeof(folders[1][akt_folder])) akt_nr--;
  return ret;
}

static varargs int Reply(int nr,int group) {
  mixed to;
  if (!pointerp(folders)||!pointerp(folders[0])||
      sizeof(folders[0])<=akt_folder) {
    write("Kein aktueller Ordner !\n");
    return 0;
  }
  if (nr<0 || !pointerp(folders[1][akt_folder]) ||
      sizeof(folders[1][akt_folder])<=nr){
    write("Nicht so viele Mails in diesem Ordner !\n");
    return 0;
  }
  if (group) 
    to=({folders[1][akt_folder][nr][MSG_FROM],
        folders[1][akt_folder][nr][MSG_RECIPIENT]})+
       (folders[1][akt_folder][nr][MSG_CC] ? folders[1][akt_folder][nr][MSG_CC] : ({}))
       -({name});
  else to=folders[1][akt_folder][nr][MSG_FROM];
#ifdef DEBUG
     DEBUGVAR(name);
     DEBUGVAR(to);
#endif
  write_mail(to,"Re: "+folders[1][akt_folder][nr][MSG_SUBJECT]);
  return 1;
}

static varargs int Forward(mixed to,int nr,int appendflag) {
  mixed msg;
  if (!pointerp(folders)||!pointerp(folders[0])||
      sizeof(folders[0])<=akt_folder) {
    write("Kein aktueller Ordner !\n");
    return 0;
  }
  if (nr<0 || !pointerp(folders[1][akt_folder]) ||
      sizeof(folders[1][akt_folder])<=nr){
    write("Nicht so viele Mails in diesem Ordner !\n");
    return 0;
  }
  to=process_names(to);
  receiver=to[0];
  carbon=to[1..];
  subject="Fw: "+folders[1][akt_folder][nr][MSG_SUBJECT];
  message="Weitergesendete Mail, urspruenglich von: "+
       folders[1][akt_folder][nr][MSG_FROM]+"\n\
-----------------------------\n\
"+folders[1][akt_folder][nr][MSG_BODY]+"\
-----------------------------\n";
  if (!appendflag) {
    write("Cc: ");
    input_to("get_carbon_copy");
  }
  else {
    write("Text kann angehaengt werden\n");
    get_subject(subject,message);
  }
  return 1;
}

static int ReadMessage(int nr) {
  if (nr<sizeof(folders[1][akt_folder]) && nr>=0)
    akt_nr=nr+1;
  message=Message2string(nr);
  if (!message) return 0;
  this_player()->More(message,0,#'input);
  return 1;
}


static string Message2string(int nr) {
  mixed letter;
  string message;
  int x;
  if (!pointerp(folders)||!pointerp(folders[0])||
      sizeof(folders[0])<=akt_folder){
    write("Kein aktueller Ordner !\n");
    return 0;
  }
  if (!pointerp(folders[1][akt_folder]) ||
      sizeof(folders[1][akt_folder])<=nr ||
      nr<0) {
    write("Diese Nummer gibt es in diesem Ordner nicht!\n");
    return 0;
  }
  letter=folders[1][akt_folder][nr];
  message=
       "Absender: "+capitalize(letter[MSG_FROM] ?
		letter[MSG_FROM] : "Unbekannt")+"\n"+
       ((letter[MSG_FROM]==letter[MSG_SENDER]) ? "" :
	"Abgesandt aber von: "+capitalize(letter[MSG_SENDER])+"\n") +
       "An: "+capitalize(letter[MSG_RECIPIENT])+"\n"+
       "Cc: ";
  if (letter[MSG_CC] && letter[MSG_CC]!="") {
    if (!pointerp(letter[MSG_CC])) message+=capitalize(letter[MSG_CC]);    
    else message+=implode(map_array(letter[MSG_CC],#'capitalize),", ");
  }
  message+="\nDatum: "+letter[MSG_DATE]+"\n"+
/* Sinnlos, oder? "Id: "+letter[MSG_ID]+"\n"+ */
      "Titel: "+letter[MSG_SUBJECT]+"\n"+
	letter[MSG_BODY]+"\n\n";
  return message;
}

static int SaveMessage(int nr) {
  int x;
  string filename,msg;
  mixed letter;

  letter=Message2string(nr);
  if (!letter) {
    write("Speichern unmoeglich.\n");
    return 0;
  }
  if (!IS_LEARNER(this_player()) || file_size("/players/"+getuid(this_player()))!=-2)
  {
    filename=SAVE_OPEN(this_player());
    msg="Die Mail wurde nach " + SAVE_OPEN(this_player()) + " gespeichert.\n"+
      break_string("Bitte denkt daran, diese Datei kann von jedem per ftp "
                   "eingesehen werden und sollte bald wieder geloescht werden.");
  }
  else
  {
    if (file_size("/players/"+getuid(this_player())+"/mail")!=-2)
    {
      filename="/players/"+getuid(this_player())+"/mail";
      msg="Die Mail wurde nach ~/mail gespeichert.\n";
    }
    else
    {
      filename="/players/"+getuid(this_player())+"/mail/mail."
                 +akt_folder+"."+nr, letter;
      msg="Die Mail wurde nach ~/mail/"+getuid(this_player())+"/mail/mail."
            +akt_folder+"."+nr+" gespeichert.\n";
    }
  }
  
  if (!write_file(filename, letter))
    write("Brief zu lang !\n");
  else
    write(msg);
  return 1;
}

static void ListAliases() {
  mixed a;
  int i;
  string s;
  a=sort_array(m_indices(aliases),#'>); // ');
  s="Definierte Aliase:\nd.xyz      = Alle Mitarbeiter der Domain xyz\n";
  for (i=0;i<sizeof(a);i++) 
    s+=sprintf("%-10s = %s\n",a[i],aliases[a[i]]);
  write(s);
}

static int mail_cmds(string str) {

  string *strargs;
  int *intargs,i,nrargs;
  
  update();
//  if (sizeof(folders[0]) && akt_nr>sizeof(folders[1][akt_folder]))
//    akt_nr=sizeof(folders[1][akt_folder]);
//  if (akt_nr<=0) akt_nr=1;
  if (!str || str=="" || !(nrargs=sizeof(strargs=explode(str," ")))) {
    ListContent();
    return input();
  }
  intargs=allocate(nrargs);
  for (i=0; i<nrargs; ++i) sscanf(strargs[i],"%d",intargs[i]);
  strargs[0]=strargs[0][0..3];
  if (intargs[0]) {
    strargs[0]="lies";
    intargs=({0,intargs[0]});
    nrargs++;
  }  // dummer hack ... ;
  switch (strargs[0]) {
  case "q":
  case "quit": 
    remove(); return 1;
  case "?":
  case "hilf":
  case "h":
    MediumHelpPage();
    return 1;
  case "oeff":
  case "c": 
    if (nrargs<2) {
      write("Welchen Ordner ?\n");
      break;
    }
    if (intargs[1]) ChangeFolder(intargs[1]-1);
    else ChangeFolder(strargs[1]);
    break;
  case "ordn":
  case "i": 
    ListFolders();
    break;
  case "anze":
  case "l":
    ListContent();
    break;
  case "alia":
  case "a":
    ListAliases();
    break;
  case "erze":
  case "n": 
    if (nrargs<2) {
      write("Bitte einen Namen fuer den neuen Ordner angeben!\n");
      break;
    }
    MakeFolder(strargs[1]);
    break;
  case "entf":
  case "e": 
    if (nrargs<2) {
      write("Welchen Ordner ?\n");
      break;
    }
    if (intargs[1]) RemoveFolder(intargs[1]-1);
    else RemoveFolder(strargs[1]);
    break;
  case "loes":
  case "d":
    if (nrargs<2) DeleteMessage(akt_nr-1);
    else DeleteMessage(intargs[1]-1);
    break;
  case "schr":
  case "m": 
    if (nrargs<2) {
      write("Bitte Namen als Argument angeben!\n");
      break;
    }
    write_mail(strargs[1..]);
    return 1;
  case "vers":
  case "v":
    if (nrargs<2 || (nrargs>2 && !intargs[1])) {
      write("Syntax: v [msgnummer] <ordnername>\n");
      break;
    }
    if (nrargs==2) MoveMessage(akt_nr-1,strargs[1]);
    else MoveMessage(intargs[1]-1,strargs[2]);
    break;
  case "bean":
  case "r":
    if (nrargs<2) { 
      if (Reply(akt_nr-1)) return 1;
    }
    else if (Reply(intargs[1]-1)) return 1;
    break;
  case "grup":
  case "g":
    if (nrargs<2) { 
      if (Reply(akt_nr-1,1)) return 1;
    }
    else if (Reply(intargs[1]-1,1)) return 1;
    break;
  case "weit":
  case "f":
    if (nrargs<2 || (nrargs==2 && intargs[1])) {
      write("Haeh? Bitte so: f [nr] spieler\n");
      break;
    }
    if (!intargs[1]) {
      if (Forward(strargs[1..],akt_nr-1)) return 1;
    }
    else if (Forward(strargs[2..],intargs[1]-1)) return 1;
    break;
  case "Weit":
  case "F":
    if (nrargs<2 || (nrargs==2 && intargs[1])) {
      write("Haeh? Bitte so: F [nr] spieler\n");
      break;
    }
    if (!intargs[1]) {
      if (Forward(strargs[1..],akt_nr-1,1)) return 1;
    }
    else if (Forward(strargs[2..],intargs[1]-1,1)) return 1;
    break;
  case "lies":
    if (nrargs<2) { if (ReadMessage(akt_nr-1)) return 1; } else
    if (ReadMessage(intargs[1]-1)) return 1;
    break;
  case ".":
    if (ReadMessage(akt_nr-1)) return 1;
    break;
  case "+":
    if (akt_nr==sizeof(folders[1][akt_folder]))
      write("Noch weiter vorwaerts gehts nicht!\n");
    else if (ReadMessage(akt_nr)) return 1;
    break;
  case "spei":
  case "s":
    if ((nrargs==2 && !intargs[1]) || nrargs>2) {
      write("Syntax: s [nummer]\n");
      break;
    }
    if (nrargs==1) (SaveMessage(akt_nr-1));
    else (SaveMessage(intargs[1]-1));
    break;
  default:
    write("Kommando nicht verstanden.\n");
    break;
  }
  return input();
}

static void prompt() {
  string path;
  
  if (!pointerp(folders)||!pointerp(folders[0])||
     sizeof(folders[0])<=akt_folder)
    path="(kein Ordner)";
  else
    path= "(" + folders[0][akt_folder] + ":" +
      ( sizeof(folders[1][akt_folder]) ?
       akt_nr + "/" + sizeof(folders[1][akt_folder]) :
       "leer") + ")";
  write(path + " [Hilfe mit h] => ");
}

static int input() {
  prompt();
  input_to("mail_cmds");
  return 1;
}

static mixed GetAlias(mixed a);

static mixed process_names(mixed s) {
  mixed a1,a2,h;
  int i;
  string domain;
  if (stringp(s)) a1=new_explode(lower_case(s)," ");
  else a1=map_array(s,#'lower_case);
  a2=({});
  for (i=0;i<sizeof(a1);i++) a2+=new_explode(a1[i],",");
//  a2=filter_array(a2,lambda(({'x}),({#'!=, 'x, ""})));
  a1=({});
  for (i=0;i<sizeof(a2);i++) {
    if (sscanf(a2[i],"d.%s",domain))
      a1+=((sizeof(h=filter_array(((h=get_dir("/d/"+domain+"/*")-({".",".."})) ? h : ({})),#'query_wiz_level))) ? h : ({"d."+domain}));
	else if (a2[i][0]=='!') a1+=({ a2[i][1..] }); // Aliase umgehen
    else if (aliases[a2[i]]) a1+=GetAlias(a2[i]);
    else if ((a2[i][0]>='a' && a2[i][0]<='z')||a2[i][0]=='\\') a1+=({a2[i]});
  }
  return a1;
} 

static mixed GetAlias(mixed a) { return process_names(aliases[a]); }


static mapping Read_mailrc(string file) {
  mapping al;
  int i;
  mixed ar;
  string s1,s2;

  if (!(ar=read_file(file))) {
//   write(file+" not readable\n");
    return ([]);
  }
  al=([]);
  ar=new_explode(ar,"\n");
  for (i=sizeof(ar)-1;i>=0;i--)
    if (sscanf(ar[i],"%s %s",s1,s2)==2) 
      al+=([s1:s2]);
//  printf("Got aliases %O",al);
  return al;
}
