/*******************
** Eldarea MUDLib **
********************
**
** /mail/receive.c - receive mail from internet
**
** CVS DATA
** $Date: 2000/08/02 09:18:03 $
** $Revision: 1.2 $
**
** Mail will be delivered to the /var/spool/mail directory of the mud owner
** A cronjob will copy the spool directory to the /mail/Inbound/spool file.
** In turns of CYCLE seconds, we will clear the spool directory, deliver the
** mails to the mud users or send delivery failures.
**
** CVS History
**
** $Log: receive.c,v $
** Revision 1.2  2000/08/02 09:18:03  eldarea
** mail system revision
**
** Revision 1.1.1.1  1999/11/05 12:30:43  elatar
** Preparing mudlib for cvs control
**
**
*/

#pragma strict_types

#include <mail.h>
#include <config.h>

#define DB(x) if (find_player("elatar")) tell_object(find_player("elatar"),"DB RCV: "+x+"\n")
//#define DB(X)
#define SPOOL "/mail/InBound/spool"
#define CYCLE 300 // 5 minutes

// prototyping
static void check_spool();
static void check_mails(string spool);
static string GetHeaderVal(string format,string header);
static void TryDeliveryFailure(string reason, string to, string from, string subject, string header, string body);
static void MailPostmaster(string subject, string txt);

void create() 
{
  seteuid(getuid());  
  call_out("check_spool",10);
}

static void check_spool()
{
  string spool;

  while(remove_call_out("check_spool")!=-1);

  if (file_size(SPOOL)>0)
  {
    spool=read_file(SPOOL);
    rm(SPOOL);
    check_mails(spool);
  }

  call_out("check_spool",CYCLE);
}

static void MailPostmaster(string subject, string txt)
{
  mixed * message;

  message=allocate(9);
  message[MSG_FROM]="Internet Mailrelais";
  message[MSG_RECIPIENT]="postmaster";
  message[MSG_SENDER]="Internet Mailrelais";
  message[MSG_SUBJECT]=subject;
  message[MSG_DATE]=ctime();
  message[MSG_ID]=MUDNAME"IMR_PM:"+time();
  message[MSG_BODY]=txt;

  "/secure/mailer"->DeliverMail(message, 0);
}

static void TryDeliveryFailure(string reason, string to, string from, string subject, string header, string body)
{
  mixed ret, * message;

  if (from)
  {
    message=allocate(9);
    message[MSG_FROM]="postmaster.mud";
    message[MSG_RECIPIENT]=from;
    message[MSG_SENDER]="Eldarea Internet Mailrelais";
    message[MSG_SUBJECT]="DELIVERY FAILURE: "+reason;
    message[MSG_DATE]=ctime();
    message[MSG_ID]=MUDNAME"IMR_DF:"+time();
    message[MSG_BODY]=
      "Your message\n"
      "\n"
      "  Subject: "+subject+"\n"
      "\n"
      "was not delivered to:\n" 
      "\n"
      "  "+to+"\n" 
      "\n"
      "  because:\n"
      "\n"
      +break_string("  "+reason)+
      "\n"
      "+- original message following -----------------------------------------+\n"
      +header+"\n\n"+body+"\n\n"
      "+----------------------------------------------------------------------+\n";
      ret=(mixed)call_other("/secure/mailer","DeliverMail",message,0);
        if (pointerp(ret) && sizeof(ret)) 
        { 
          MailPostmaster("Delivery failure, notification sent",
           "The following message could not be delivered to:\n"
           "  "+to+"\n"
           "because:\n"
           +break_string("  "+reason+".")+
           "A delivery failure notification was successfully sent to:\n"
           "  "+from+"\n"
           "+- original message following -----------------------------------------------+\n"
           +header+"\n\n"+body+"\n\n"
           "+----------------------------------------------------------------------------+\n"
           );
        } 
        else 
        {
          MailPostmaster("Delivery failure, notification failure",
            "The following message could not be delivered to:\n"
            "  "+to+"\n"
            "because:\n"
            +break_string("  "+reason+".")+
            "A delivery failure notification was unsuccessfully tried to sent to:\n"
            "  "+from+"\n"
            "+- original message following -----------------------------------------+\n"
            +header+"\n\n"+body+"\n\n"
            "+----------------------------------------------------------------------+\n"
            "+----------------------------------------------------------------------+\n"
            );
        }
  }
  else 
    MailPostmaster("Delivery failure, no sender found",
      "The following message could not be delivered to:\n"
      "  "+to+"\n"
      "because:\n"
      +break_string("  "+reason+".")+
      "A delivery failure notification could not be send because no sender adress was\n"
      "found.\n"
      "+- original message following -----------------------------------------+\n"
      +header+"\n\n"+body+"\n\n"
      "+----------------------------------------------------------------------+\n"
      );
  
}

static string GetHeaderVal(string format,string header)
{
  int a1, a2;

  a1=strstr(header, "\n"+format);
  a2=strstr(header, "\n", a1+1);

  if (a1==-1 || a2==-1) 
    return 0;
  else 
    return header[a1+strlen(format)+1..a2-1];
}

static void check_mails(string spool)
{
  int i,pos,root;
  string header,body,from,to,subject,date,d1,d2,d3,recv,*mails,*tiles;
  mixed ret,* message;
  
  if (!spool || spool=="")
    return;

  mails=explode(spool,"\n\nFrom "); // each mail starts with this
  for (i=sizeof(mails);i-->0;)
  {
    // header und body trennen, header komplettieren
    if (sizeof(tiles=explode(mails[i],"\n\n"))<2)
    {
      mails[i]=0;
      continue;
    }
    header="From "+tiles[0];
    body=implode(tiles[1..<1],"\n\n");
    
    // Nun Daten aus dem Header nehmen...
    from=GetHeaderVal("From: ",header);
    to=GetHeaderVal("To: ",header);
    subject=GetHeaderVal("Subject: ",header);
    date=GetHeaderVal("Date: ",header);
    if (!to) // Kein Empfaenger?
      TryDeliveryFailure("No recipient adress supplied",to,from,subject,header,body);
                                                           // Formate:
    else if ( sscanf(to,"%s %s.%s@%s",d1,recv,d2,d3)==4    // ..... user.mud@host
           || sscanf(to,"%s.%s@%s",recv,d2,d3)==3          // user.mud@host
           || sscanf(to,"%s.%s",recv,d2)==2                // user.mud 
           || sscanf(to,"%s %s@%s",d1,recv,d3)==3          // .... user@host
           || sscanf(to,"%s@%s",recv,d3)==2                // user@host
           || sscanf(to,"%s",recv)==1                      // user
            )
    { 
      // Da koennte noch ein < sein, ich weiss nicht
      if (recv[0]=='<')
        recv=recv[1..];
      if (recv[<1]=='>')
        recv=recv[0..<2];
      recv=lower_case(recv);
      // Mal sehn, obs den gibt...
      if ( !call_other("/secure/master","get_userinfo",recv) 
        && ({recv})==(mixed *)call_other("/secure/mailer","expand",({recv}),0) )
      { // Den haben wir wohl nicht
        TryDeliveryFailure("The user "+recv+" is not known at Eldarea",to,from,subject,header,body);
      }
      else
      {
        message=allocate(9);
        message[MSG_FROM]=from || "<unbekannt>";
        message[MSG_RECIPIENT]=recv;
        message[MSG_SENDER]="Internet Mailrelais";
        message[MSG_SUBJECT]=subject || "";
        message[MSG_DATE]=ctime();
        message[MSG_ID]=MUDNAME"IMR:"+time();
        message[MSG_BODY]=
          "+----------------------------------------------------------------------+\n"
          "|                      Eldarea Internet Mailrelais                     |\n"
          "+----------------------------------------------------------------------+\n"
          "Original From: "+from+"\n"
          "         To:   "+to+"\n"
          "         Date: "+date+"\n"
          "+----------------------------------------------------------------------+\n"
          "\n"
          +body;
        ret=(mixed)call_other("/secure/mailer","DeliverMail",message, 0);
        if (pointerp(ret) && sizeof(ret)) 
        { // Erfolg
          mails[i]=0;
        } 
        else 
          TryDeliveryFailure("Unknown error delivering mail",to,from,subject,header,body);
      }
    }
    else 
      TryDeliveryFailure("The adress "+to+" is not known at Eldarea",to,from,subject,header,body);
  }
  
}

/*
void check_all() {
  string* boxes;
  int i;
  boxes=get_dir(MBOXDIR"/mbox*");
  for (i=sizeof(boxes); i--;) check(MBOXDIR+"/"+boxes[i]);

  while (remove_call_out("check_all")!=-1);
  call_out("check_all", 60*5);
}

string get_header(string txt, string pat) {
  int a1, a2;
  a1=strstr(txt, "\n"+pat);
  a2=strstr(txt, "\n", a1+1);
  if (a1==-1 || a2==-1) return 0;
  else return txt[a1+strlen(pat)+1..a2-1];
}

// prozessieren einer Mbox
void check(string mbox) {
  string* msg;
  string* txt;
  string to, from, date, subject;
  mixed* mess, ret;
  int i, j, k, l, a1, a2;
  int root;
  if ((i=file_size(mbox))<0) return;
  if (i==0) {
    rm(mbox);
    return;
  }
  msg=explode(read_file(mbox),"\n\nFrom ");
  for (l=sizeof(msg), i=0; i<l; i++) {
    if (i>0) msg[i]="From "+msg[i];
    j=strstr(msg[i],"\n\n");
    if (!j) { // Mail ohne Inhalt
      msg[i]=0;
      continue;
    }
    txt=({msg[i][0..j-1], msg[i][j+1..]});
    to=get_header(txt[0], "To: ");
    from=get_header(txt[0],"From: ");
    date=get_header(txt[0],"Date: ");
    subject=get_header(txt[0],"Subject: ");
    if (!to || !from || !date) { // Angaben in Mail fehlen, soll EM machen
      root=1;
    } else {
      if (sscanf(to, "\"%s\"", to)!=1) { // Nicht an Spieler
       root=1;
      } else {
        to=lower_case(to);
        sscanf(to, "%s@"+lower_case(MUDNAME), to);
        if (file_size("/save/"+to[0..0]+"/"+to+".o")<1) { // Nicht Vorhanden
          root=1;
        }
      }
    }
    if (root) to="mudmail";
    mess=allocate(9);
    mess[MSG_FROM]=from || "<unbekannt>";
    mess[MSG_RECIPIENT]=to || "<unbekannt>";
    mess[MSG_SENDER]="Internet Mailrelais";
    mess[MSG_SUBJECT]=subject||"";
    mess[MSG_DATE]=ctime();
    mess[MSG_ID]=MUDNAME" IMR:"+time();
    mess[MSG_BODY]=txt[1]+"\n\n"
      "*********************************************************************\n"
      "*          MD Mailrelais      -      Originalheader folgen          *\n"
      "*********************************************************************\n"
      "\n"+txt[0];
    ret="/secure/mailer"->DeliverMail(mess, 0);
    if (pointerp(ret) && sizeof(ret)) { // Erfolg
      msg[i]=0;
    } else log_file("MAILRELAIS", sprintf("Error delivering %O\n", mess));
  }
  rm(mbox);
}
*/

