/*******************
** Eldarea MUDLib **
********************
**
** filename - short desc
**
** CVS DATA
** $Date: 1999/11/05 12:30:44 $
** $Revision: 1.1.1.1 $
**
** longdesc
**
** CVS History
**
** $Log: hund.c,v $
** Revision 1.1.1.1  1999/11/05 12:30:44  elatar
** Preparing mudlib for cvs control
**
**
*/
// Datei : /npc/bestiarium/hund.c
// Info  : Hund.

#pragma strong_types

inherit "std/npc";

#include <properties.h>
#include <language.h>
#include <combat.h>
#include <moving.h>
#include <attributes.h>
#include <description.h>

#include "/npc/haustier.h"

void create ()
{
  int level;

  level = 1;

  if (! clonep())
    return;

  ::create();

  create_default_npc(level);

  SetProp(P_GENDER,       (random(2) == 0) ? MALE : FEMALE);
  SetProp(P_NAME,         (QueryProp(P_GENDER) == MALE) ? "Hund" : "Huendin");
  SetProp(P_LONG,         "Ein knuddeliger Hund, der Dich sicher gern begleitet.");
  SetProp(P_INFO,         "Das ist das Haustier eines Spielers. Er ist sehr schlau und kann sogar bellen.");
  SetProp(P_RACE_DESCRIPTION, "Ein Hund ist der treueste Freund des Menschen.");
  SetProp(P_PLURAL,       "Hunde");
  SetProp(P_DESCR,        0);
  SetProp(P_RACE,         "Hund");
  SetProp(P_MSGIN,        "laeuft schwanzwedelnd herein");
  SetProp(P_MSGOUT,       "geht");
  SetProp(P_ALIGN,        -50 + random(101));
  SetProp(P_SIZE,         70+random(31));
  SetProp(P_WEIGHT,       5000+random(20001));  //  5-20 kg
  SetProp(P_MAX_HANDS,    0);
  SetProp(P_RESISTANCE, 
          ([DT_BLUDGEON : -20,
            DT_COLD     : -30,
            DT_FIRE     :  40,
            DT_SQUEEZE  : -20,
            DT_WHIP     : -30,
            DT_PIERCE   :  40]) );
  SetProp(P_HANDS,        ({" mit seinem kraeftigen Gebiss", 20 + (level * 5), ({DT_RIP, DT_PIERCE})}));
  SetProp(P_BODY,         1 + (level / 2));
  SetProp(P_MAX_SP,       0); 
  SetProp(P_XP,           (level * 100) * QueryProp(P_HP) / 2);                                      

  (QueryProp(P_GENDER) == MALE) ? AddId(({"hund"}), ({"hunde"})) : AddId(({"huendin", "hund"}), ({"huendinnen", "hunde"}));    

  AddInfo("\ndefault", "wedelt mit dem Schwanz.", "");
}

